/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.convert.SysPageFiledConfigConvert;
import com.elitescloud.cloudt.system.model.entity.QSysPageFieldConfigDtlDO;
import com.elitescloud.cloudt.system.model.entity.SysPageFieldConfigDO;
import com.elitescloud.cloudt.system.model.entity.SysPageFieldConfigDtlDO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlParam;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigDtlQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.SysPageFieldConfigQueryVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigDtlUpdateVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.SysPageFieldConfigUpdateVO;
import com.elitescloud.cloudt.system.provider.imports.param.PageFieldImportBO;
import com.elitescloud.cloudt.system.service.SysPageFieldConfigService;
import com.elitescloud.cloudt.system.service.repo.SysPageFieldConfigDtlRepo;
import com.elitescloud.cloudt.system.service.repo.SysPageFieldConfigDtlRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysPageFieldConfigRepo;
import com.elitescloud.cloudt.system.service.repo.SysPageFieldConfigRepoProc;
import com.elitescloud.cloudt.system.service.util.JpaPredicateBuilder;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanPath;
import com.querydsl.core.types.dsl.StringPath;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysPageFieldConfigServiceImpl
implements SysPageFieldConfigService {
    private static final Logger log = LoggerFactory.getLogger(SysPageFieldConfigServiceImpl.class);
    @Autowired
    private SysPageFieldConfigDtlRepo sysPageFieldConfigDtlRepo;
    @Autowired
    private SysPageFieldConfigRepo sysPageFieldConfigRepo;
    @Autowired
    private SysPageFieldConfigRepoProc sysPageFieldConfigRepoProc;
    @Autowired
    private SysPageFieldConfigDtlRepoProc sysPageFieldConfigDtlRepoProc;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<String> savePageFieldConfig(SysPageFieldConfigSaveVO saveVO) {
        SysPageFieldConfigDO sdo = SysPageFiledConfigConvert.INSTANCE.voTodo(saveVO);
        List<SysPageFieldConfigDO> listDO = this.sysPageFieldConfigRepo.findByConfigCode(sdo.getConfigCode());
        if (listDO != null && listDO.size() > 0) {
            return ApiResult.fail((String)"\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff0c\u5df2\u7ecf\u5b58\u5728");
        }
        this.sysPageFieldConfigRepo.save(sdo);
        List dtlDoList = saveVO.getDtlVO().stream().map(SysPageFiledConfigConvert.INSTANCE::voTodo).collect(Collectors.toList());
        this.sysPageFieldConfigDtlRepo.saveAll(dtlDoList);
        return ApiResult.ok((Object)sdo.getId().toString());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updatePageFieldConfig(Long id, SysPageFieldConfigUpdateVO updateVO) {
        this.sysPageFieldConfigRepo.findById(id).ifPresentOrElse(sysPageFieldConfigDO -> {
            sysPageFieldConfigDO.setAppCode(updateVO.getAppCode());
            sysPageFieldConfigDO.setAppName(updateVO.getAppName());
            sysPageFieldConfigDO.setConfigName(updateVO.getConfigName());
            sysPageFieldConfigDO.setRemark(updateVO.getRemark());
            sysPageFieldConfigDO.setEnabled(updateVO.getEnabled());
            this.sysPageFieldConfigRepo.save(sysPageFieldConfigDO);
            this.sysPageFieldConfigDtlRepo.deleteAllByConfigCode(sysPageFieldConfigDO.getConfigCode());
            List dtlDoList = updateVO.getDtlVO().stream().map(dtlVO -> {
                SysPageFieldConfigDtlDO dtlDo = SysPageFiledConfigConvert.INSTANCE.voTodo((SysPageFieldConfigDtlUpdateVO)dtlVO);
                dtlDo.setAppCode(sysPageFieldConfigDO.getAppCode());
                dtlDo.setAppName(sysPageFieldConfigDO.getAppName());
                dtlDo.setConfigCode(sysPageFieldConfigDO.getConfigCode());
                dtlDo.setConfigName(sysPageFieldConfigDO.getConfigName());
                return dtlDo;
            }).collect(Collectors.toList());
            this.sysPageFieldConfigDtlRepo.saveAll(dtlDoList);
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728");
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(PageFieldImportBO importBO) {
        boolean existsConfig = this.sysPageFieldConfigRepoProc.existsConfigCode(importBO.getConfigCode());
        if (!existsConfig) {
            SysPageFieldConfigDO configDO = new SysPageFieldConfigDO();
            configDO.setAppCode(importBO.getAppCode());
            configDO.setAppName(importBO.getAppName());
            configDO.setConfigName(importBO.getConfigName());
            configDO.setConfigCode(importBO.getConfigCode());
            configDO.setEnabled(true);
            this.sysPageFieldConfigRepoProc.save(configDO);
        }
        SysPageFieldConfigDtlDO configDtlDO = new SysPageFieldConfigDtlDO();
        configDtlDO.setAppCode(importBO.getAppCode());
        configDtlDO.setAppName(importBO.getAppName());
        configDtlDO.setConfigName(importBO.getConfigName());
        configDtlDO.setConfigCode(importBO.getConfigCode());
        configDtlDO.setFieldName(importBO.getFieldName());
        configDtlDO.setFieldCode(importBO.getFieldCode());
        configDtlDO.setFieldRequired(importBO.getFieldRequired());
        configDtlDO.setFieldAlias(importBO.getFieldAlias());
        configDtlDO.setFieldOrder(importBO.getFieldOrder());
        configDtlDO.setFieldHidden(importBO.getFieldHidden());
        configDtlDO.setFieldEdit(importBO.getFieldEdit());
        configDtlDO.setFieldDefaultValue(importBO.getFieldDefaultValue());
        configDtlDO.setFieldWidth(importBO.getFieldWidth());
        configDtlDO.setFieldDescription(importBO.getFieldDescription());
        configDtlDO.setLinenum(0.0);
        this.sysPageFieldConfigDtlRepoProc.save(configDtlDO);
        return ApiResult.ok((Object)configDtlDO.getId());
    }

    @Override
    public ApiResult<PagingVO<SysPageFieldConfigDtlQueryVO>> queryPageFieldConfigDtl(SysPageFieldConfigDtlParam param) {
        QSysPageFieldConfigDtlDO QDO = QSysPageFieldConfigDtlDO.sysPageFieldConfigDtlDO;
        Predicate predicate = JpaPredicateBuilder.builder().and(arg_0 -> ((StringPath)QDO.appCode).eq(arg_0), (Object)param.getAppCode()).and(arg_0 -> ((StringPath)QDO.configCode).eq(arg_0), (Object)param.getConfigCode()).and(arg_0 -> ((StringPath)QDO.fieldCode).eq(arg_0), (Object)param.getFieldCode()).and(arg_0 -> ((StringPath)QDO.fieldAlias).contains(arg_0), (Object)param.getFieldAlias()).and(arg_0 -> ((StringPath)QDO.configName).contains(arg_0), (Object)param.getConfigName()).and(arg_0 -> ((StringPath)QDO.fieldName).contains(arg_0), (Object)param.getFieldName()).and(arg_0 -> ((BooleanPath)QDO.fieldRequired).eq(arg_0), (Object)param.getFieldRequired()).getPredicate();
        Page page = this.sysPageFieldConfigDtlRepo.findAll(predicate, (Pageable)param.getPageRequest());
        PagingVO pagingVo = PagingVO.builder().total(page.getTotalElements()).setRecords(page.get().map(SysPageFiledConfigConvert.INSTANCE::doToVo).collect(Collectors.toList()));
        return ApiResult.ok((Object)pagingVo);
    }

    @Override
    public ApiResult<SysPageFieldConfigQueryVO> getPageFieldConfig(String configCode) {
        List<SysPageFieldConfigDO> pageFieldConfig = this.sysPageFieldConfigRepo.findByConfigCode(configCode);
        if (pageFieldConfig != null && pageFieldConfig.size() == 1) {
            SysPageFieldConfigQueryVO queryVo = SysPageFiledConfigConvert.INSTANCE.doToVo(pageFieldConfig.get(0));
            List<SysPageFieldConfigDtlQueryVO> dtlQueryVo = this.sysPageFieldConfigDtlRepo.findAllByConfigCode(configCode).stream().map(SysPageFiledConfigConvert.INSTANCE::doToVo).collect(Collectors.toList());
            queryVo.setDtlVO(dtlQueryVo);
            return ApiResult.ok((Object)queryVo);
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deletePageFieldConfig(Long id) {
        this.sysPageFieldConfigRepo.findById(id).ifPresentOrElse(sysPageFieldConfigDO -> {
            this.sysPageFieldConfigRepo.deleteById(id);
            this.sysPageFieldConfigDtlRepo.deleteAllByConfigCode(sysPageFieldConfigDO.getConfigCode());
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728" + id);
        });
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deletePageFieldConfigDtl(Long id) {
        this.sysPageFieldConfigDtlRepo.findById(id).ifPresentOrElse(sysPageFieldConfigDtlDO -> {
            this.sysPageFieldConfigDtlRepo.delete(sysPageFieldConfigDtlDO);
            List<SysPageFieldConfigDtlDO> list = this.sysPageFieldConfigDtlRepo.findByConfigCodeAndIdNot(sysPageFieldConfigDtlDO.getConfigCode(), id);
            if (CollectionUtils.isEmpty(list)) {
                this.sysPageFieldConfigRepo.deleteByConfigCode(sysPageFieldConfigDtlDO.getConfigCode());
            }
        }, () -> {
            throw new BusinessException("id\u4e0d\u5b58\u5728" + id);
        });
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> batchDeletePageFieldConfigDtl(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return ApiResult.ok();
        }
        List configDtlDOS = this.sysPageFieldConfigDtlRepo.findAllById(ids);
        if (CollectionUtils.isEmpty((Collection)configDtlDOS)) {
            return ApiResult.ok();
        }
        List<String> configCodeList = configDtlDOS.stream().map(v -> v.getConfigCode()).distinct().collect(Collectors.toList());
        this.sysPageFieldConfigDtlRepo.deleteAllById(ids);
        if (!CollectionUtils.isEmpty(configCodeList)) {
            List<SysPageFieldConfigDtlDO> list = this.sysPageFieldConfigDtlRepo.findByConfigCodeIn(configCodeList);
            if (CollectionUtils.isEmpty(list)) {
                this.sysPageFieldConfigRepo.deleteByConfigCodeIn(configCodeList);
            } else {
                Map<String, List<SysPageFieldConfigDtlDO>> configDtlMap = list.stream().collect(Collectors.groupingBy(v -> v.getConfigCode()));
                for (String configCode : configCodeList) {
                    if (!CollectionUtils.isEmpty((Collection)configDtlMap.get(configCode))) continue;
                    this.sysPageFieldConfigRepo.deleteByConfigCode(configCode);
                }
            }
        }
        return ApiResult.ok();
    }
}

