/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.SysVersionConvert;
import com.elitescloud.cloudt.system.model.entity.SysVersionDO;
import com.elitescloud.cloudt.system.model.vo.query.version.SysVersionPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.version.SysVersionRespVO;
import com.elitescloud.cloudt.system.model.vo.save.version.SysVersionChangeStatusVO;
import com.elitescloud.cloudt.system.model.vo.save.version.SysVersionSaveVO;
import com.elitescloud.cloudt.system.service.SysVersionService;
import com.elitescloud.cloudt.system.service.repo.SysVersionRepoProc;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class SysVersionServiceImpl
implements SysVersionService {
    private static final String VERSION_KEY = "cloudt:system:std_version";
    @Autowired
    private SysVersionRepoProc sysVersionRepoProc;
    @Autowired
    private RedisUtils redisUtils;
    private final Cache<String, String> localCache = Caffeine.newBuilder().maximumSize(5L).expireAfterWrite(Duration.ofMinutes(20L)).build();

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Object> save(SysVersionSaveVO save) {
        this.checkVersionStatus(save.getId(), save.getStatus(), save.getVersionNo());
        SysVersionDO sysVersion = this.excuteSaveVersion(save);
        this.sysVersionRepoProc.saveVersion(sysVersion);
        this.saveCacke(this.sysVersionRepoProc.getActiveVersion());
        return ApiResult.ok();
    }

    @Override
    public PagingVO<SysVersionRespVO> page(SysVersionPageQueryVO query) {
        return this.sysVersionRepoProc.page(query);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(Long id) {
        this.sysVersionRepoProc.del(id);
        this.saveCacke(this.sysVersionRepoProc.getActiveVersion());
    }

    @Override
    public void changeStatus(SysVersionChangeStatusVO changeStatusVO) {
        this.checkVersionStatus(changeStatusVO.getId(), changeStatusVO.getStatus(), null);
        SysVersionDO sysVersion = this.sysVersionRepoProc.getById(changeStatusVO.getId());
        sysVersion.setStatus(changeStatusVO.getStatus());
        this.sysVersionRepoProc.saveVersion(sysVersion);
        this.saveCacke(this.sysVersionRepoProc.getActiveVersion());
    }

    @Override
    public ApiResult<SysVersionRespVO> getCurrentVersionDetail() {
        SysVersionRespVO resp = this.sysVersionRepoProc.getActiveVersionDetail();
        return ApiResult.ok((Object)resp);
    }

    @Override
    public ApiResult<String> findActiveVersion() {
        String version = (String)this.localCache.getIfPresent((Object)VERSION_KEY);
        if (CharSequenceUtil.isNotBlank((CharSequence)version)) {
            return ApiResult.ok((Object)version);
        }
        version = (String)this.redisUtils.get(VERSION_KEY);
        if (CharSequenceUtil.isNotBlank((CharSequence)version)) {
            this.localCache.put((Object)VERSION_KEY, (Object)version);
            return ApiResult.ok((Object)version);
        }
        version = this.sysVersionRepoProc.getActiveVersion();
        if (version == null) {
            version = "0";
        }
        this.saveCacke(version);
        return ApiResult.ok((Object)version);
    }

    private void saveCacke(String version) {
        if (CharSequenceUtil.isBlank((CharSequence)version)) {
            this.redisUtils.set(VERSION_KEY, (Object)"0");
            this.localCache.put((Object)VERSION_KEY, (Object)"0");
            return;
        }
        this.redisUtils.set(VERSION_KEY, (Object)version);
        this.localCache.put((Object)VERSION_KEY, (Object)version);
    }

    private void checkVersionStatus(Long id, Boolean status, String versionNo) {
        Long versionCount;
        Long count;
        if (Boolean.TRUE.equals(status) && (count = this.sysVersionRepoProc.getStatusCount(id, status)) > 0L) {
            throw new BusinessException("\u7248\u672c\u7ba1\u7406\u53ea\u80fd\u6709\u4e00\u4e2a\u542f\u7528");
        }
        if (StringUtils.isNotBlank((CharSequence)versionNo) && (versionCount = this.sysVersionRepoProc.getVersionNoCount(id, versionNo)) > 0L) {
            throw new BusinessException("\u7248\u672c\u53f7\u5df2\u5b58\u5728");
        }
    }

    private SysVersionDO excuteSaveVersion(SysVersionSaveVO save) {
        SysVersionDO sysVersion = null;
        if (ObjectUtils.isNotEmpty((Object)save.getId())) {
            sysVersion = (SysVersionDO)((Object)this.sysVersionRepoProc.get(save.getId()));
            sysVersion.setVersionNo(save.getVersionNo());
            sysVersion.setChangeContent(save.getChangeContent());
            sysVersion.setReleaseTime(save.getReleaseTime());
            sysVersion.setStatus(save.getStatus());
            sysVersion.setDescribeMsg(save.getDescribeMsg());
        } else {
            sysVersion = SysVersionConvert.INSTANCE.saveToDo(save);
        }
        return sysVersion;
    }
}

