/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.UtilException;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ZipUtil;
import cn.hutool.poi.excel.cell.CellUtil;
import com.alibaba.fastjson.JSONObject;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.CloudtIdCreator;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.util.FileUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitescloud.cloudt.system.common.BasicRecordStateEnum;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.convert.BasicRecordConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.entity.SysBasicRecordDO;
import com.elitescloud.cloudt.system.model.vo.query.devops.BasicDataRecordPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.BasicRecordExportPageRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.devops.BasicRecordImportPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.devops.ExportBasicDataSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.devops.ImportBasicDataSaveVO;
import com.elitescloud.cloudt.system.service.SystemDataService;
import com.elitescloud.cloudt.system.service.common.constant.BasicRecordTypeEnum;
import com.elitescloud.cloudt.system.service.devops.init.AbstractBasicDataInitProvider;
import com.elitescloud.cloudt.system.service.devops.init.BasicDataInitProviderFactory;
import com.elitescloud.cloudt.system.service.repo.BasicRecordRepoProc;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StopWatch;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SystemDataServiceImpl
extends BaseServiceImpl
implements SystemDataService {
    private static final Logger log = LoggerFactory.getLogger(SystemDataServiceImpl.class);
    private static final String SUFFIX_ZIP = "zip";
    private static final String SUFFIX_XLSX = "xlsx";
    private static final String FILENAME_MANIFEST = "MANIFEST.properties";
    private static final String PROP_EXPORT_FILE = "_exportFile";
    private static final String PROP_EXPORT_TIME = "_exportTime";
    private static final String PROP_RECORD_ID = "_recordId";
    private static final String PROP_TENANT_CODE = "_tenantCode";
    private static final String PROP_ALL_VER = "_all_version";
    private static final String PROP_STD = "_std";
    private static final String PROP_VERSION = "_version";
    private static final String PROP_ALL_TYPE = "_all_type";
    private static final String PROP_APP_CODES = "_app_codes";
    private static final String PROP_TYPE = "_types";
    private static final String PROP_DESCRIPTION = "_description";
    private final List<CodeNameParam> dataTypeList = BasicDataInitProviderFactory.getExportProviderGroupList();
    @Autowired
    private BasicRecordRepoProc recordRepoProc;
    @Autowired
    private NamedParameterJdbcTemplate jdbcTemplate;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private CloudtIdCreator idCreator;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private FileService<String> fileService;

    @Override
    public ApiResult<List<CodeNameParam>> listDataType() {
        return ApiResult.ok(this.dataTypeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> exportData(ExportBasicDataSaveVO saveVO) {
        Set appCodes;
        SysBasicRecordDO recordDO = new SysBasicRecordDO();
        recordDO.setRecordType(BasicRecordTypeEnum.EXPORT);
        recordDO.setAllVersion((Boolean)ObjUtil.defaultIfNull((Object)saveVO.getAllVersion(), (Object)true));
        if (!recordDO.getAllVersion().booleanValue()) {
            recordDO.setDataVersion(saveVO.getDataVersion());
            Assert.notBlank((CharSequence)saveVO.getDataVersion(), (String)"\u8bf7\u9009\u62e9\u6570\u636e\u7248\u672c", (Object[])new Object[0]);
        }
        recordDO.setAllType(Boolean.TRUE.equals(saveVO.getAllType()));
        if (!recordDO.getAllType().booleanValue()) {
            String dataTypes = CollUtil.isEmpty(saveVO.getDataTypes()) ? null : saveVO.getDataTypes().stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
            Assert.notBlank(dataTypes, (String)"\u8bf7\u9009\u62e9\u6570\u636e\u7c7b\u578b", (Object[])new Object[0]);
            recordDO.setDataType(dataTypes);
        }
        recordDO.setTenantCode(CharSequenceUtil.blankToDefault((CharSequence)saveVO.getTenantCode(), (String)this.systemProperties.getStdProject().getTenantCode()));
        Set set = appCodes = CollUtil.isEmpty(saveVO.getAppCodes()) ? Collections.emptySet() : saveVO.getAppCodes().stream().filter(StringUtils::hasText).collect(Collectors.toSet());
        if (CollUtil.isNotEmpty(saveVO.getAppCodes())) {
            recordDO.setAppCodes(String.join((CharSequence)",", appCodes));
        }
        recordDO.setOperateTime(LocalDateTime.now());
        recordDO.setDescription(saveVO.getDescription());
        recordDO.setSuccess(false);
        recordDO.setFinished(false);
        recordDO.setState(BasicRecordStateEnum.PREPARING.name());
        recordDO.setStd(Boolean.TRUE.equals(this.systemProperties.getStdProject().getEnabled()));
        this.recordRepoProc.save((Serializable)((Object)recordDO));
        this.taskExecutor.execute(() -> this.startExport(recordDO));
        return ApiResult.ok((Object)true);
    }

    @Override
    public ApiResult<PagingVO<BasicRecordExportPageRespVO>> pageExportedRecord(BasicDataRecordPageQueryVO queryVO) {
        Map<String, String> dataTypeMap = this.dataTypeList.stream().collect(Collectors.toMap(CodeNameParam::getCode, CodeNameParam::getName, (t1, t2) -> t1));
        PagingVO pageData = this.recordRepoProc.queryByPage(queryVO, BasicRecordTypeEnum.EXPORT).map(t -> {
            BasicRecordExportPageRespVO respVO = BasicRecordConvert.INSTANCE.do2ExportPageRespVO((SysBasicRecordDO)((Object)t));
            if (Boolean.FALSE.equals(respVO.getAllType()) && StringUtils.hasText((String)t.getDataType())) {
                List<CodeNameParam> dataTypeList = Arrays.stream(t.getDataType().split(",")).filter(dataTypeMap::containsKey).map(code -> new CodeNameParam(code, (String)dataTypeMap.get(code))).collect(Collectors.toList());
                respVO.setDataTypes(dataTypeList);
            }
            return respVO;
        });
        return ApiResult.ok((Object)pageData);
    }

    @Override
    public ApiResult<PagingVO<BasicRecordImportPageRespVO>> pageImportedRecord(BasicDataRecordPageQueryVO queryVO) {
        Map<String, String> dataTypeMap = this.dataTypeList.stream().collect(Collectors.toMap(CodeNameParam::getCode, CodeNameParam::getName, (t1, t2) -> t1));
        PagingVO pageData = this.recordRepoProc.queryByPage(queryVO, BasicRecordTypeEnum.IMPORT).map(t -> {
            BasicRecordImportPageRespVO respVO = BasicRecordConvert.INSTANCE.do2ImportPageRespVO((SysBasicRecordDO)((Object)t));
            if (Boolean.FALSE.equals(respVO.getAllType()) && StringUtils.hasText((String)t.getDataType())) {
                List<CodeNameParam> dataTypeList = Arrays.stream(t.getDataType().split(",")).filter(dataTypeMap::containsKey).map(code -> new CodeNameParam(code, (String)dataTypeMap.get(code))).collect(Collectors.toList());
                respVO.setDataTypes(dataTypeList);
            }
            return respVO;
        });
        return ApiResult.ok((Object)pageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> importData(MultipartFile file, ImportBasicDataSaveVO saveVO) {
        if (file == null || file.isEmpty()) {
            return ApiResult.fail((String)"\u5bfc\u5165\u6587\u4ef6\u4e3a\u7a7a");
        }
        String importFileName = file.getOriginalFilename();
        String suffix = FileUtil.getSuffix((String)importFileName);
        boolean isSupport = SUFFIX_ZIP.equals(suffix);
        if (!isSupport) {
            return ApiResult.fail((String)"\u89e3\u6790\u5bfc\u5165\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u7684\u539f\u6587\u4ef6");
        }
        File tempFile = null;
        try {
            tempFile = FileUtil.createTempFile((String)importFileName, (String[])new String[]{UUID.fastUUID().toString(true)});
            file.transferTo(tempFile);
        }
        catch (IOException e) {
            log.error("\u8f6c\u5b58\u4e34\u65f6\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            return ApiResult.fail((String)("\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage()));
        }
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            ImportedData importData = this.analyzeImportFile(tempFile, saveVO);
            this.importFromExcel(importData, tempFile);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff1a", (Throwable)e);
            ApiResult apiResult = ApiResult.fail((String)("\u5bfc\u5165\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage()));
            return apiResult;
        }
        finally {
            tempFile.delete();
            watch.stop();
            log.info("\u5bfc\u5165\u7ed3\u675f\uff0c\u8017\u65f6\uff1a{}s", (Object)watch.getTotalTimeSeconds());
        }
        return ApiResult.ok((Object)true);
    }

    private Long queryTenantId(String tenantCode) {
        if (CharSequenceUtil.isBlank((CharSequence)tenantCode)) {
            return null;
        }
        List tenantIds = this.jdbcTemplate.queryForList("select id from sys_tenant where tenant_code = :tenant_code", Map.of("tenant_code", tenantCode), Long.class);
        if (tenantIds.size() == 1) {
            return (Long)tenantIds.get(0);
        }
        throw new BusinessException("\u67e5\u8be2\u79df\u6237\u5f02\u5e38, " + (tenantIds.isEmpty() ? "\u672a\u67e5\u8be2\u5230\u79df\u6237" + tenantCode : "\u67e5\u8be2\u5230\u591a\u4e2a\u79df\u6237" + tenantCode));
    }

    private List<Long> allTenantId() {
        List allTenants = this.tenantClientProvider.getAllTenants();
        if (allTenants.isEmpty()) {
            return Collections.emptyList();
        }
        return allTenants.stream().map(SysTenantDTO::getId).collect(Collectors.toList());
    }

    private String sheetName(AbstractBasicDataInitProvider provider) {
        return provider.tableName();
    }

    private void validateExportProvider(List<AbstractBasicDataInitProvider> providers) {
        HashSet<String> existsProviderNames = new HashSet<String>();
        for (AbstractBasicDataInitProvider provider : providers) {
            String dataTypeName = provider.typeName();
            Assert.notBlank((CharSequence)dataTypeName, () -> new IllegalArgumentException(provider.getClass().getName() + "\u7684typeName\u4e3a\u7a7a"));
            if (existsProviderNames.contains(dataTypeName)) {
                throw new IllegalArgumentException("\u5b58\u5728\u91cd\u590d\u7684\u6570\u636e\u521d\u59cb\u5316\uff1a" + dataTypeName);
            }
            existsProviderNames.add(dataTypeName);
            String sheetName = this.sheetName(provider);
            try {
                WorkbookUtil.validateSheetName((String)sheetName);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("sheet\u540d\u79f0\u4e0d\u5408\u6cd5\uff1a" + e.getMessage());
            }
            Assert.notEmpty(provider.fields(), () -> new IllegalArgumentException(provider.getClass().getName() + "\u7684fields\u4e3a\u7a7a"));
            Assert.notEmpty(provider.fieldTitles(), () -> new IllegalArgumentException(provider.getClass().getName() + "\u7684fieldTitles\u4e3a\u7a7a"));
            if (!CollUtil.isNotEmpty(provider.thenImport())) continue;
            this.validateChildren(Collections.emptySet(), provider.thenImport());
        }
    }

    private void validateChildren(Set<String> parentNames, List<AbstractBasicDataInitProvider> children) {
        for (AbstractBasicDataInitProvider child : children) {
            String childName = child.getClass().getName();
            if (parentNames.contains(childName)) {
                throw new IllegalArgumentException(childName + "\u53ef\u80fd\u51fa\u73b0\u5faa\u73af\u8c03\u7528");
            }
            if (!CollUtil.isNotEmpty(child.thenImport())) continue;
            HashSet<String> tempParentNames = new HashSet<String>(parentNames);
            tempParentNames.add(childName);
            this.validateChildren(tempParentNames, child.thenImport());
        }
    }

    private ImportedData analyzeImportFile(File importFile, ImportBasicDataSaveVO saveVO) throws Exception {
        ImportedData importedData = new ImportedData();
        importedData.setIncremental(saveVO.getAllData() == null || saveVO.getAllData() == false);
        importedData.setSyncTenant(saveVO.getSyncTenant() == null || saveVO.getSyncTenant() != false);
        File zipDir = null;
        try {
            zipDir = ZipUtil.unzip((File)importFile);
        }
        catch (UtilException e) {
            log.error("\u89e3\u538b\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            throw new IllegalArgumentException("\u89e3\u538b\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage());
        }
        Properties manifest = this.loadManifest(zipDir);
        importedData.setManifest(manifest);
        Workbook exportFile = this.loadImportFile(zipDir, manifest);
        importedData.setWorkbook(exportFile);
        importedData.setOtherFiles(new HashMap<String, File>(128));
        Set<String> excludeFiles = Set.of(FILENAME_MANIFEST, manifest.getProperty(PROP_EXPORT_FILE));
        this.loadOtherFiles(zipDir, "", excludeFiles, importedData.getOtherFiles());
        importedData.setVersion(manifest.getProperty(PROP_VERSION));
        String appCodeStr = manifest.getProperty(PROP_APP_CODES);
        Set<String> appCodes = StringUtils.hasText((String)appCodeStr) ? Arrays.stream(appCodeStr.split(",")).collect(Collectors.toSet()) : Collections.emptySet();
        importedData.setAppCodes(appCodes);
        return importedData;
    }

    private void loadOtherFiles(File dir, String keyPrefix, Set<String> excludeFileNames, Map<String, File> fileMap) {
        Object[] childFiles = dir.listFiles((dir1, name) -> excludeFileNames == null || !excludeFileNames.contains(name));
        if (ArrayUtil.isEmpty((Object[])childFiles)) {
            return;
        }
        for (Object childFile : childFiles) {
            if (((File)childFile).isDirectory()) {
                this.loadOtherFiles((File)childFile, keyPrefix + ((File)childFile).getName() + File.separator, null, fileMap);
                continue;
            }
            fileMap.put(keyPrefix + ((File)childFile).getName(), (File)childFile);
        }
    }

    private Workbook loadImportFile(File zipDir, Properties manifest) {
        String exportFileName = manifest.getProperty(PROP_EXPORT_FILE);
        if (CharSequenceUtil.isBlank((CharSequence)exportFileName)) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5f02\u5e38\uff0c\u7f3a\u5c11\u8d44\u6e90\u6e05\u5355");
        }
        File exportFile = new File(zipDir, exportFileName);
        if (!exportFile.exists()) {
            throw new IllegalArgumentException("\u6587\u4ef6\u5f02\u5e38\uff0c\u8d44\u6e90\u6e05\u5355\u4e0d\u5b58\u5728");
        }
        try {
            return new XSSFWorkbook(exportFile);
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7dexcel\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            throw new IllegalArgumentException("\u52a0\u8f7d\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38");
        }
    }

    private Properties loadManifest(File zipDir) {
        Properties properties = new Properties();
        try (FileReader fileReader = new FileReader(new File(zipDir, FILENAME_MANIFEST));){
            properties.load(fileReader);
        }
        catch (IOException e) {
            log.error("\u52a0\u8f7d\u8d44\u6e90\u6e05\u5355\u5931\u8d25\uff1a", (Throwable)e);
            throw new IllegalArgumentException("\u52a0\u8f7d\u8d44\u6e90\u6e05\u5355\u5931\u8d25");
        }
        return properties;
    }

    private SysBasicRecordDO saveImportRecord(ImportedData importData, File importFile) {
        com.el.coordinator.core.common.api.ApiResult uploadResult = this.fileService.upload(importFile);
        if (!uploadResult.isSuccess()) {
            throw new BusinessException("\u5907\u4efd\u6587\u4ef6\u5f02\u5e38\uff0c" + uploadResult.getMsg());
        }
        String fileCode = ((FileObjRespVO)uploadResult.getData()).getFileCode();
        SysBasicRecordDO recordDO = new SysBasicRecordDO();
        recordDO.setRecordType(BasicRecordTypeEnum.IMPORT);
        recordDO.setAllData(!importData.isIncremental());
        recordDO.setAllVersion(Boolean.parseBoolean(importData.getManifest().getProperty(PROP_ALL_VER, "false")));
        recordDO.setDataVersion(importData.getManifest().getProperty(PROP_VERSION));
        if (!recordDO.getAllVersion().booleanValue()) {
            Assert.notBlank((CharSequence)recordDO.getDataVersion(), (String)"\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u77e5\u5bfc\u5165\u6570\u636e\u7684\u7248\u672c", (Object[])new Object[0]);
        }
        recordDO.setAllType(Boolean.parseBoolean(importData.getManifest().getProperty(PROP_ALL_TYPE, "false")));
        recordDO.setDataType(importData.getManifest().getProperty(PROP_TYPE));
        if (!recordDO.getAllType().booleanValue()) {
            Assert.notBlank((CharSequence)recordDO.getDataType(), (String)"\u5bfc\u5165\u5931\u8d25\uff0c\u672a\u77e5\u5bfc\u5165\u6570\u636e\u7684\u7c7b\u578b", (Object[])new Object[0]);
        }
        recordDO.setTenantCode(importData.getManifest().getProperty(PROP_TENANT_CODE));
        recordDO.setAppCodes(importData.getManifest().getProperty(PROP_APP_CODES, ""));
        recordDO.setSyncTenant(importData.getSyncTenant());
        recordDO.setDataFileCode(fileCode);
        recordDO.setAttribute(JSONUtil.toJsonString((Object)importData.getManifest()));
        recordDO.setOperateTime(LocalDateTime.now());
        recordDO.setSuccess(false);
        recordDO.setFinished(false);
        recordDO.setState(BasicRecordStateEnum.PREPARING.name());
        recordDO.setStd(Boolean.parseBoolean(importData.getManifest().getProperty(PROP_STD, "false")));
        this.recordRepoProc.save((Serializable)((Object)recordDO));
        return recordDO;
    }

    private void importFromExcel(ImportedData importData, File importFile) throws Exception {
        SysBasicRecordDO recordDO = this.saveImportRecord(importData, importFile);
        ArrayList<CompletableFuture<Void>> threads = new ArrayList<CompletableFuture<Void>>();
        List<Long> tenantIdList = recordDO.getSyncTenant() != false ? this.allTenantId() : Collections.emptyList();
        List<String> dataTypeList = recordDO.getAllType() != false ? null : Arrays.asList(recordDO.getDataType().split(","));
        List<List<AbstractBasicDataInitProvider>> providerGroups = BasicDataInitProviderFactory.getImportProviderList(dataTypeList);
        Assert.notEmpty(providerGroups, (String)"\u672a\u53d1\u73b0\u6709\u6548\u7684\u6570\u636e\u7c7b\u578b", (Object[])new Object[0]);
        ArrayList<String> expList = new ArrayList<String>(providerGroups.size());
        for (List<AbstractBasicDataInitProvider> providerGroup : providerGroups) {
            CompletableFuture<Void> thread = this.createThreadToImportSheet(importData, providerGroup, tenantIdList, expList);
            threads.add(thread);
        }
        CompletableFuture.allOf((CompletableFuture[])threads.toArray(CompletableFuture[]::new)).whenComplete((v, e) -> {
            if (e != null) {
                log.error("\u5bfc\u5165\u57fa\u7840\u6570\u636e\u5f02\u5e38\uff1a", e);
                expList.add(e.getMessage());
            }
            if (!expList.isEmpty()) {
                this.recordRepoProc.updateFailResult(recordDO.getId(), String.join((CharSequence)",", expList));
                return;
            }
            log.info("\u5bfc\u5165\u57fa\u7840\u6570\u636e\u6210\u529f\uff1a{}", (Object)recordDO.getId());
            this.recordRepoProc.updateImportSuccessfully(recordDO.getId());
        });
        this.recordRepoProc.updateState(recordDO.getId(), BasicRecordStateEnum.PREPARING);
    }

    private CompletableFuture<Void> createThreadToImportSheet(ImportedData importData, List<AbstractBasicDataInitProvider> dataInitProviders, List<Long> tenantIds, List<String> expList) {
        return CompletableFuture.runAsync(() -> {
            for (AbstractBasicDataInitProvider dataInitProvider : dataInitProviders) {
                this.createImportRunner(importData, dataInitProvider, Collections.emptyList(), tenantIds);
            }
        }).whenComplete((r, e) -> {
            if (e != null) {
                log.error("\u5bfc\u5165\u5f02\u5e38\uff1a", e);
                expList.add(e.getMessage());
            }
        });
    }

    private List<Map<String, Object>> createImportRunner(ImportedData importData, AbstractBasicDataInitProvider dataInitProvider, List<Map<String, Object>> preDataList, List<Long> tenantIds) {
        log.info("\u5f00\u59cb\u5904\u7406\u5bfc\u5165\u6570\u636e\uff1a{}", (Object)dataInitProvider.typeName());
        Workbook workbook = importData.getWorkbook();
        String sheetName = this.sheetName(dataInitProvider);
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            log.info("\u4e0d\u5b58\u5728sheet\uff1a{}", (Object)sheetName);
            return Collections.emptyList();
        }
        Map<String, Integer> fieldMap = this.readFields(sheet);
        if (fieldMap.isEmpty()) {
            log.info("\u672a\u8bfb\u53d6\u5230\u5c5e\u6027\uff1a{}", (Object)sheetName);
            return Collections.emptyList();
        }
        List<Map<String, Object>> dataList = this.readDataFromSheet(sheet, fieldMap);
        if (dataList.isEmpty()) {
            log.info("\u6570\u636e\u4e3a\u7a7a\uff1a{}", (Object)sheetName);
            return Collections.emptyList();
        }
        List<String> fields = dataInitProvider.fields();
        String sqlInsert = this.generateSqlInsert(fieldMap, fields, dataInitProvider.tableName());
        String sqlUpdate = this.generateSqlUpdate(fieldMap, fields, dataInitProvider.tableName());
        if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{sqlInsert, sqlUpdate})) {
            log.info("\u672a\u751f\u6210\u6709\u6548SQL\uff1a{}\uff0c{}\uff0c{}", new Object[]{dataInitProvider.typeName(), sqlInsert, sqlUpdate});
            return dataList;
        }
        if (!dataInitProvider.isTenantData()) {
            return this.wrapImportForTenant(importData, dataInitProvider, TenantConstant.DEFAULT_TENANT_ID, tenantIds, dataList, preDataList, sqlInsert, sqlUpdate);
        }
        for (Long tenantId : tenantIds) {
            this.wrapImportForTenant(importData, dataInitProvider, tenantId, tenantIds, dataList, preDataList, sqlInsert, sqlUpdate);
        }
        return dataList;
    }

    private List<Map<String, Object>> wrapImportForTenant(ImportedData importData, AbstractBasicDataInitProvider dataInitProvider, Long tenantId, List<Long> allTenantIds, List<Map<String, Object>> importDataList, List<Map<String, Object>> preDataList, String sqlInsert, String sqlUpdate) {
        List<Map<String, Object>> currentData = this.queryCurrentData(importData.isIncremental(), dataInitProvider, tenantId, importData.getAppCodes());
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
        TransactionStatus transactionStatus = this.transactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        Throwable throwable = null;
        try {
            dataInitProvider.prepareForImport(importData, tenantId);
            this.executeImportData(importData, dataInitProvider, currentData, importDataList, preDataList, tenantId, sqlInsert, sqlUpdate);
            this.transactionManager.commit(transactionStatus);
            log.info("\u5904\u7406\u5bfc\u5165\u6570\u636e{}\u6210\u529f", (Object)dataInitProvider.typeName());
            dataInitProvider.afterExecute(false, throwable);
        }
        catch (Throwable e) {
            try {
                log.error("\u66f4\u65b0\u6570\u636e\u5f02\u5e38\uff1a", e);
                throwable = e;
                this.transactionManager.rollback(transactionStatus);
                throw ExceptionsUtil.wrapRuntime((Throwable)throwable);
            }
            catch (Throwable throwable2) {
                dataInitProvider.afterExecute(false, throwable);
                throw throwable2;
            }
        }
        List<AbstractBasicDataInitProvider> children = dataInitProvider.thenImport();
        if (CollUtil.isNotEmpty(children)) {
            for (AbstractBasicDataInitProvider child : children) {
                this.createImportRunner(importData, child, importDataList, allTenantIds);
            }
        }
        return importDataList;
    }

    private void executeImportData(ImportedData importData, AbstractBasicDataInitProvider dataInitProvider, List<Map<String, Object>> currentDataList, List<Map<String, Object>> importDataList, List<Map<String, Object>> preDataList, Long tenantId, String sqlInsert, String sqlUpdate) {
        if (!importData.isIncremental()) {
            HashMap<String, Object> sqlParams = new HashMap<String, Object>(4);
            String sqlDel = "delete from " + dataInitProvider.tableName() + " where tenant_id = :tenant_id";
            sqlParams.put("tenant_id", tenantId);
            if (CollUtil.isNotEmpty(importData.getAppCodes()) && StringUtils.hasText((String)dataInitProvider.fieldAppCode())) {
                sqlDel = sqlDel + " and " + dataInitProvider.fieldAppCode() + " in (:" + dataInitProvider.fieldAppCode() + ")";
                sqlParams.put(dataInitProvider.fieldAppCode(), importData.getAppCodes());
            }
            this.jdbcTemplate.update(sqlDel, sqlParams);
        }
        ArrayList<Map<String, Object>> sqlValuesAdd = new ArrayList<Map<String, Object>>(50);
        ArrayList<Map<String, Object>> sqlValuesUpdate = new ArrayList<Map<String, Object>>(50);
        AbstractBasicDataInitProvider.UpdateType updateType = null;
        LocalDateTime nowTime = LocalDateTime.now();
        for (Map<String, Object> data : importDataList) {
            data.put("tenant_id", tenantId);
            data.put("modify_time", nowTime);
            updateType = dataInitProvider.convertForImport(data, currentDataList, preDataList);
            if (updateType == null || updateType == AbstractBasicDataInitProvider.UpdateType.IGNORE) continue;
            if (updateType == AbstractBasicDataInitProvider.UpdateType.ADD) {
                data.put("id", this.idCreator.create());
                data.put("create_time", nowTime);
                data.put("std_version", importData.getVersion());
                sqlValuesAdd.add(dataInitProvider.normalizeSqlParams(data));
                if (sqlValuesAdd.size() != 20) continue;
                this.jdbcTemplate.batchUpdate(sqlInsert, (Map[])sqlValuesAdd.toArray(Map[]::new));
                sqlValuesAdd.clear();
                continue;
            }
            sqlValuesUpdate.add(dataInitProvider.normalizeSqlParams(data));
            if (data.get("id") == null) {
                log.info("\u66f4\u65b0\u5931\u8d25\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString(data));
                throw new IllegalStateException(dataInitProvider.typeName() + "\u66f4\u65b0\u6570\u636e\u65f6ID\u4e3a\u7a7a");
            }
            if (sqlValuesUpdate.size() != 20) continue;
            this.jdbcTemplate.batchUpdate(sqlUpdate, (Map[])sqlValuesUpdate.toArray(Map[]::new));
            sqlValuesUpdate.clear();
        }
        if (!sqlValuesAdd.isEmpty()) {
            this.jdbcTemplate.batchUpdate(sqlInsert, (Map[])sqlValuesAdd.toArray(Map[]::new));
            sqlValuesAdd.clear();
        }
        if (!sqlValuesUpdate.isEmpty()) {
            this.jdbcTemplate.batchUpdate(sqlUpdate, (Map[])sqlValuesUpdate.toArray(Map[]::new));
            sqlValuesUpdate.clear();
        }
    }

    private List<Map<String, Object>> queryCurrentData(boolean incremental, AbstractBasicDataInitProvider dataInitProvider, Long tenantId, Set<String> appCodes) {
        if (!incremental) {
            return Collections.emptyList();
        }
        return this.queryData(dataInitProvider, tenantId, null, appCodes);
    }

    private String generateSqlInsert(Map<String, Integer> fieldMap, List<String> fields, String tableName) {
        List tableColumns = fieldMap.entrySet().stream().filter(t -> fields.contains(t.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (tableColumns.isEmpty()) {
            return null;
        }
        if (!tableColumns.contains("id")) {
            tableColumns.add(0, "id");
        }
        if (!tableColumns.contains("tenant_id")) {
            tableColumns.add(1, "tenant_id");
        }
        if (!tableColumns.contains("create_time")) {
            tableColumns.add("create_time");
        }
        if (!tableColumns.contains("std_version")) {
            tableColumns.add("std_version");
        }
        String sqlValue = tableColumns.stream().map(t -> ":" + t).collect(Collectors.joining(", "));
        return "insert into " + tableName + "(" + String.join((CharSequence)", ", tableColumns) + ") values (" + sqlValue + ")";
    }

    private String generateSqlUpdate(Map<String, Integer> fieldMap, List<String> fields, String tableName) {
        List tableColumns = fieldMap.entrySet().stream().filter(t -> fields.contains(t.getKey())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (tableColumns.isEmpty()) {
            return null;
        }
        if (tableColumns.contains("create_time")) {
            tableColumns.remove("create_time");
        }
        String sqlValue = tableColumns.stream().map(t -> t + " = :" + t).collect(Collectors.joining(", "));
        return "update " + tableName + " set " + sqlValue + " where id = :id";
    }

    private List<Map<String, Object>> readDataFromSheet(Sheet sheet, Map<String, Integer> fieldMap) {
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum < 2) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(lastRowNum + 1);
        Set<Map.Entry<String, Integer>> fieldEntry = fieldMap.entrySet();
        Row row = null;
        Cell cell = null;
        Object cellValue = null;
        HashMap<String, Object> rowData = null;
        boolean hasData = false;
        for (int rowNum = 2; rowNum <= lastRowNum; ++rowNum) {
            row = sheet.getRow(rowNum);
            rowData = new HashMap<String, Object>(fieldMap.size());
            hasData = false;
            for (Map.Entry<String, Integer> entry : fieldEntry) {
                cell = row.getCell(entry.getValue().intValue());
                if (cell == null || (cellValue = this.getCellValue(cell)) == null) continue;
                rowData.put(entry.getKey(), cellValue);
                hasData = true;
            }
            if (!hasData) continue;
            dataList.add(rowData);
        }
        return dataList;
    }

    private Object getCellValue(Cell cell) {
        CellType cellType = cell.getCellTypeEnum();
        return CellUtil.getCellValue((Cell)cell, (CellType)cellType, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startExport(SysBasicRecordDO recordDO) {
        String tenantCode = recordDO.getTenantCode();
        File workDir = FileUtil.createTempDir((String[])new String[]{CharSequenceUtil.format((CharSequence)"system_{}", (Object[])new Object[]{DatetimeUtil.currentTimeLong()})});
        File zipFile = null;
        try {
            this.recordRepoProc.updateState(recordDO.getId(), BasicRecordStateEnum.PROCESSING);
            Long tenantId = this.queryTenantId(tenantCode);
            log.info("\u5bfc\u51fa\u6240\u5728\u5de5\u4f5c\u76ee\u5f55:{}", (Object)workDir.getAbsolutePath());
            Properties props = new Properties();
            props.setProperty(PROP_EXPORT_TIME, DatetimeUtil.currentTimeStr());
            props.setProperty(PROP_RECORD_ID, recordDO.getId().toString());
            props.setProperty(PROP_TENANT_CODE, (String)ObjectUtil.defaultIfNull((Object)recordDO.getTenantCode(), (Object)""));
            props.setProperty(PROP_ALL_VER, recordDO.getAllVersion().toString());
            props.setProperty(PROP_VERSION, (String)ObjectUtil.defaultIfNull((Object)recordDO.getDataVersion(), (Object)""));
            props.setProperty(PROP_STD, recordDO.getStd().toString());
            props.setProperty(PROP_ALL_TYPE, recordDO.getAllType().toString());
            props.setProperty(PROP_TYPE, (String)ObjectUtil.defaultIfNull((Object)recordDO.getDataType(), (Object)""));
            props.setProperty(PROP_APP_CODES, (String)ObjectUtil.defaultIfNull((Object)recordDO.getAppCodes(), (Object)""));
            props.setProperty(PROP_DESCRIPTION, (String)ObjectUtil.defaultIfNull((Object)recordDO.getDescription(), (Object)""));
            this.exportToExcel(workDir, tenantId, props, recordDO);
            zipFile = ZipUtil.zip((File)workDir, (Charset)StandardCharsets.UTF_8);
            com.el.coordinator.core.common.api.ApiResult uploadResult = this.fileService.upload(zipFile);
            Assert.isTrue((boolean)uploadResult.isSuccess(), (String)("\u4e0a\u4f20\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\uff0c" + uploadResult.getMsg()), (Object[])new Object[0]);
            this.recordRepoProc.updateExportSuccessfully(recordDO.getId(), ((FileObjRespVO)uploadResult.getData()).getFileCode(), props.toString());
        }
        catch (Throwable e) {
            try {
                this.recordRepoProc.updateFailResult(recordDO.getId(), ExceptionsUtil.stacktraceToString((Throwable)e));
                log.error("\u5bfc\u51fa\u7cfb\u7edf\u7684\u521d\u59cb\u5316\u6570\u636e\u5f02\u5e38\uff1a", e);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                FileUtil.del((File)workDir);
                FileUtil.del(zipFile);
            }
        }
        FileUtil.del((File)workDir);
        FileUtil.del((File)zipFile);
    }

    private void exportToExcel(File workDir, Long tenantId, Properties props, SysBasicRecordDO recordDO) throws Exception {
        File excelFile = new File(workDir, workDir.getName() + ".xlsx");
        boolean createResult = excelFile.createNewFile();
        Assert.isTrue((boolean)createResult, (String)"\u521b\u5efa\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25", (Object[])new Object[0]);
        props.setProperty(PROP_EXPORT_FILE, excelFile.getName());
        List<List<AbstractBasicDataInitProvider>> exportProviders = BasicDataInitProviderFactory.getExportProviderList(recordDO.getAllType() != false ? null : (Collection)Arrays.stream(recordDO.getDataType().split(",")).collect(Collectors.toList()));
        String version = recordDO.getAllVersion() != false ? null : recordDO.getDataVersion();
        Set<String> appCodes = StringUtils.hasText((String)recordDO.getAppCodes()) ? Arrays.stream(recordDO.getAppCodes().split(",")).collect(Collectors.toSet()) : Collections.emptySet();
        try (SXSSFWorkbook workbook = new SXSSFWorkbook();
             FileOutputStream output = new FileOutputStream(excelFile);){
            ArrayList<CompletableFuture<Void>> threads = new ArrayList<CompletableFuture<Void>>();
            for (List<AbstractBasicDataInitProvider> providers : exportProviders) {
                CompletableFuture<Void> thread = this.createThreadToExportSheet((Workbook)workbook, providers, workDir, tenantId, version, appCodes);
                threads.add(thread);
            }
            ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])threads.toArray(CompletableFuture[]::new)).exceptionally(e -> {
                log.error("\u5bfc\u51fa\u57fa\u7840\u6570\u636e\u5f02\u5e38\uff1a", e);
                return null;
            })).get();
            workbook.write((OutputStream)output);
        }
        File manifest = new File(workDir, FILENAME_MANIFEST);
        try (FileWriter fileWriter = new FileWriter(manifest);){
            props.store(fileWriter, "resource list, exported by cloudt");
        }
    }

    private CompletableFuture<Void> createThreadToExportSheet(Workbook workbook, List<AbstractBasicDataInitProvider> dataInitProviders, File workDir, Long tenantIdReal, String version, Set<String> appCodes) {
        HashMap<String, Sheet> sheetMap = new HashMap<String, Sheet>(dataInitProviders.size());
        for (AbstractBasicDataInitProvider dataInitProvider : dataInitProviders) {
            String sheetName = this.sheetName(dataInitProvider);
            Sheet sheet = workbook.createSheet(sheetName);
            sheetMap.put(dataInitProvider.typeName(), sheet);
        }
        return CompletableFuture.runAsync(() -> {
            for (AbstractBasicDataInitProvider dataInitProvider : dataInitProviders) {
                Sheet sheet = (Sheet)sheetMap.get(dataInitProvider.typeName());
                Exception exp = null;
                try {
                    this.executeExportSheet(sheet, dataInitProvider, tenantIdReal, workDir, version, appCodes);
                    log.info("\u5bfc\u51fa{}\u7ed3\u675f", (Object)dataInitProvider.typeName());
                }
                catch (Exception e) {
                    exp = e;
                    log.error("\u5bfc\u51fa{}\u5f02\u5e38\uff1a", (Object)dataInitProvider.typeName(), (Object)e);
                }
                finally {
                    dataInitProvider.afterExecute(true, exp);
                }
            }
        }).whenComplete((r, e) -> {
            if (e != null) {
                log.error("\u5bfc\u51fa\u5f02\u5e38\uff1a", e);
            }
        });
    }

    private void executeExportSheet(Sheet sheet, AbstractBasicDataInitProvider dataInitProvider, Long tenantIdReal, File workDir, String version, Set<String> appCodes) {
        String dataTypeName = sheet.getSheetName();
        Long tenantId = dataInitProvider.isTenantData() ? tenantIdReal : TenantConstant.DEFAULT_TENANT_ID;
        sheet.setDefaultColumnWidth(22);
        log.info("\u5f00\u59cb\u5bfc\u51fa{}...", (Object)dataTypeName);
        Map<String, String> fieldTitles = dataInitProvider.fieldTitles();
        this.exportRowTitle(sheet, fieldTitles);
        dataInitProvider.prepareExport(workDir);
        List<Map<String, Object>> dataList = this.queryData(dataInitProvider, tenantId, version, appCodes);
        if (!dataList.isEmpty()) {
            int rowIndex = 2;
            int cellIndex = 0;
            Row row = null;
            Cell cell = null;
            CellStyle cellStyle = this.createCommonStyle(sheet);
            Set<String> fields = fieldTitles.keySet();
            for (Map<String, Object> rowData : dataList) {
                Map<String, Object> realData = dataInitProvider.convertForExport(rowData, null);
                if (CollUtil.isEmpty(realData)) continue;
                row = sheet.createRow(rowIndex);
                cellIndex = 0;
                for (String field : fields) {
                    cell = row.createCell(cellIndex);
                    cell.setCellValue(this.convertFieldValue(realData.get(field)));
                    cell.setCellStyle(cellStyle);
                    ++cellIndex;
                }
                ++rowIndex;
            }
        }
    }

    private void exportRowTitle(Sheet sheet, Map<String, String> fieldTitles) {
        CellStyle cellStyle = this.createTitleStyle(sheet);
        Row row = sheet.createRow(0);
        int cellIndex = 0;
        Cell cell = null;
        for (String value : fieldTitles.values()) {
            cell = row.createCell(cellIndex);
            cell.setCellValue(value);
            cell.setCellStyle(cellStyle);
            ++cellIndex;
        }
        Set<String> fields = fieldTitles.keySet();
        row = sheet.createRow(1);
        cellIndex = 0;
        for (String value : fields) {
            cell = row.createCell(cellIndex);
            cell.setCellValue(value);
            cell.setCellStyle(cellStyle);
            ++cellIndex;
        }
    }

    private Map<String, Integer> readFields(Sheet sheet) {
        Row row = sheet.getRow(1);
        if (row == null) {
            return Collections.emptyMap();
        }
        int lastCellNum = row.getLastCellNum();
        HashMap<String, Integer> fieldMap = new HashMap<String, Integer>(lastCellNum + 1);
        Cell cell = null;
        String cellValue = null;
        for (int colNum = 0; colNum <= lastCellNum; ++colNum) {
            cell = row.getCell(colNum);
            if (cell == null) continue;
            cellValue = cell.getStringCellValue();
            if (cellValue != null) {
                cellValue = cellValue.trim();
            }
            if (CharSequenceUtil.isBlank((CharSequence)cellValue)) continue;
            fieldMap.put(cellValue, colNum);
        }
        return fieldMap;
    }

    private CellStyle createCommonStyle(Sheet sheet) {
        CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        Font font = sheet.getWorkbook().createFont();
        cellStyle.setFont(font);
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        return cellStyle;
    }

    private CellStyle createTitleStyle(Sheet sheet) {
        CellStyle cellStyle = sheet.getWorkbook().createCellStyle();
        Font font = sheet.getWorkbook().createFont();
        cellStyle.setFont(font);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setWrapText(true);
        font.setBold(true);
        return cellStyle;
    }

    private List<Map<String, Object>> queryData(AbstractBasicDataInitProvider dataInitProvider, Long tenantId, String version, Set<String> appCodes) {
        String order;
        ArrayList<String> fields = new ArrayList<String>(dataInitProvider.fields());
        if (!fields.contains("id")) {
            fields.add("id");
        }
        String sql = "select " + String.join((CharSequence)", ", fields) + " from " + dataInitProvider.tableName();
        HashMap<String, Object> sqlParams = new HashMap<String, Object>(8);
        ArrayList<Object> conditionList = new ArrayList<Object>(8);
        if (tenantId != null) {
            conditionList.add(dataInitProvider.tenantField() + " = :tenant_id");
            sqlParams.put("tenant_id", tenantId);
        }
        if (CollUtil.isNotEmpty(appCodes) && StringUtils.hasText((String)dataInitProvider.fieldAppCode())) {
            conditionList.add(dataInitProvider.fieldAppCode() + " in (:" + dataInitProvider.fieldAppCode() + ")");
            sqlParams.put(dataInitProvider.fieldAppCode(), appCodes);
        }
        conditionList.add("delete_flag = :delete_flag");
        sqlParams.put("delete_flag", 0);
        sql = sql + " where ";
        sql = sql + String.join((CharSequence)" and ", conditionList);
        List<OrderItem> orderFieldList = dataInitProvider.orderItems();
        if (CollUtil.isNotEmpty(orderFieldList) && CharSequenceUtil.isNotBlank((CharSequence)(order = orderFieldList.stream().filter(t -> CharSequenceUtil.isNotBlank((CharSequence)t.getColumn())).map(t -> t.getColumn() + " " + (t.isAsc() ? "asc" : "desc")).collect(Collectors.joining(", "))))) {
            sql = sql + " order by " + order;
        }
        List dataList = this.jdbcTemplate.queryForList(sql, sqlParams);
        return (List)ObjectUtil.defaultIfNull((Object)dataList, Collections.emptyList());
    }

    private String convertFieldValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof LocalDateTime) {
            return DatetimeUtil.FORMATTER_DATETIME.format((LocalDateTime)value);
        }
        if (value instanceof LocalDate) {
            return DatetimeUtil.FORMATTER_DATE.format((LocalDate)value);
        }
        if (value instanceof Date) {
            return DatetimeUtil.FORMAT_DATETIME.format((Date)value);
        }
        return value.toString();
    }

    public static class ImportedData {
        private boolean incremental;
        private boolean syncTenant;
        private String version;
        private Set<String> appCodes;
        private Properties manifest;
        private Workbook workbook;
        private Map<String, File> otherFiles;

        public boolean isIncremental() {
            return this.incremental;
        }

        public void setIncremental(boolean incremental) {
            this.incremental = incremental;
        }

        public boolean getSyncTenant() {
            return this.syncTenant;
        }

        public void setSyncTenant(boolean syncTenant) {
            this.syncTenant = syncTenant;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public boolean isSyncTenant() {
            return this.syncTenant;
        }

        public Set<String> getAppCodes() {
            return this.appCodes;
        }

        public void setAppCodes(Set<String> appCodes) {
            this.appCodes = appCodes;
        }

        public Properties getManifest() {
            return this.manifest;
        }

        public void setManifest(Properties manifest) {
            this.manifest = manifest;
        }

        public Workbook getWorkbook() {
            return this.workbook;
        }

        public void setWorkbook(Workbook workbook) {
            this.workbook = workbook;
        }

        public Map<String, File> getOtherFiles() {
            return this.otherFiles;
        }

        public void setOtherFiles(Map<String, File> otherFiles) {
            this.otherFiles = otherFiles;
        }
    }
}

