/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.CloudtContextProperties;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.base.UdcProvider;
import com.elitescloud.boot.log.LogProperties;
import com.elitescloud.boot.log.common.TraceIdProvider;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.boot.util.DatetimeUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.SysThirdApiSystem;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.convert.ThirdApiLogConvert;
import com.elitescloud.cloudt.system.dto.ThirdApiLogDTO;
import com.elitescloud.cloudt.system.dto.ThirdApiRetryParamDTO;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiBusinessDO;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiLogDO;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiRetryDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiLogPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.ThirdApiLogSaveVO;
import com.elitescloud.cloudt.system.service.SysAlertService;
import com.elitescloud.cloudt.system.service.ThirdApiLogService;
import com.elitescloud.cloudt.system.service.ThirdApiRetrySupportService;
import com.elitescloud.cloudt.system.service.impl.ThirdApiRetry;
import com.elitescloud.cloudt.system.service.impl.ThirdApiRetryTaskProvider;
import com.elitescloud.cloudt.system.service.repo.ThirdApiBusinessRepoProc;
import com.elitescloud.cloudt.system.service.repo.ThirdApiLogRepoProc;
import com.elitescloud.cloudt.system.service.repo.ThirdApiRetryRepoProc;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class ThirdApiLogRetrySupportServiceImpl
extends BaseServiceImpl
implements ThirdApiRetrySupportService {
    private static final Logger log = LoggerFactory.getLogger(ThirdApiLogRetrySupportServiceImpl.class);
    @Autowired
    private ThirdApiLogRepoProc repoProc;
    @Autowired
    private ThirdApiRetryRepoProc retryRepoProc;
    @Autowired
    private ThirdApiBusinessRepoProc businessRepoProc;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private CloudtContextProperties contextProperties;
    @Autowired(required=false)
    private ThirdApiRetry thirdApiRetry;
    @Autowired
    private LogProperties logProperties;
    @Autowired
    private List<TraceIdProvider> providers;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private UdcProvider userProvider;
    @Autowired
    private SysAlertService alertService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveLog(ThirdApiLogDTO logDTO) {
        log.info("\u4fdd\u5b58\u63a8\u9001\u65e5\u5fd7\uff1a{}", (Object)JSONUtil.toJsonString((Object)logDTO));
        if (logDTO.getOriginalRetryId() != null) {
            this.updateRetryRespResult(logDTO.getOriginalRetryId(), false, Boolean.TRUE.equals(logDTO.getRespSuccess()), CharSequenceUtil.blankToDefault((CharSequence)logDTO.getRespFailMsg(), (String)logDTO.getReqFailMsg()), logDTO.getRespBody());
            return ApiResult.ok((Object)logDTO.getOriginalRetryId());
        }
        SysThirdApiLogDO logDO = this.dto2Do(logDTO);
        this.repoProc.save((Serializable)((Object)logDO));
        this.saveBusinessInfo(logDO);
        if (!logDO.getRespSuccess().booleanValue() && logDO.getNeedRetry().booleanValue() && Boolean.TRUE.equals(logDO.getRestful())) {
            if (Boolean.TRUE.equals(this.systemProperties.getThirdApiLog().getEnabledRetry())) {
                this.addRetry(logDO);
            } else {
                this.repoProc.updateRetryFailResult(logDO.getId(), "\u672a\u542f\u7528\u81ea\u52a8\u91cd\u8bd5");
            }
        }
        if (!logDO.getRespSuccess().booleanValue()) {
            this.sendAlert(logDO, CharSequenceUtil.blankToDefault((CharSequence)logDO.getRespFailMsg(), (String)logDO.getReqFailMsg()));
        }
        return ApiResult.ok((Object)logDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveLog(ThirdApiLogSaveVO saveVO, boolean retrySend) {
        org.springframework.util.Assert.notNull((Object)saveVO.getId(), (String)"ID\u4e3a\u7a7a");
        SysThirdApiLogDO original = (SysThirdApiLogDO)((Object)this.repoProc.get(saveVO.getId()));
        if (original.getOriginalId() != null) {
            original = (SysThirdApiLogDO)((Object)this.repoProc.get(original.getOriginalId()));
        }
        org.springframework.util.Assert.notNull((Object)((Object)original), (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
        ThirdApiRetryParamDTO retryParamDTO = new ThirdApiRetryParamDTO();
        retryParamDTO.setServerAddr(saveVO.getServerAddr());
        retryParamDTO.setUri(saveVO.getUri());
        retryParamDTO.setReqMethod(saveVO.getReqMethod());
        retryParamDTO.setReqQueryParams((Map)JSONUtil.json2Obj((String)saveVO.getReqQueryParamsJson(), (boolean)true, () -> "\u67e5\u8be2\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528JSON\u683c\u5f0f"));
        retryParamDTO.setReqBody(saveVO.getReqBody());
        retryParamDTO.setReqHeaders((Map)JSONUtil.json2Obj((String)saveVO.getReqHeadersJson(), (boolean)true, () -> "\u8bf7\u6c42\u5934\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528JSON\u683c\u5f0f"));
        original.setRetryParamJson(super.obj2Json((Object)retryParamDTO));
        this.repoProc.save((Serializable)((Object)original));
        if (retrySend) {
            this.manualSaveAndRetry(saveVO, original);
        }
        return ApiResult.ok((Object)saveVO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> trySend(Long id, Integer version) {
        boolean canSend;
        Long originalId = this.repoProc.getOriginalLogId(id);
        if (originalId == null) {
            log.info("\u672a\u67e5\u8be2\u5230\u539f\u59cb\u8bb0\u5f55\uff1a{}", (Object)id);
            return ApiResult.ok((Object)false);
        }
        Integer retryVersion = this.retryRepoProc.getVersionByLastLogId(originalId);
        boolean bl = canSend = retryVersion != null && retryVersion.intValue() == ((Integer)ObjectUtil.defaultIfNull((Object)version, (Object)0)).intValue();
        if (canSend) {
            this.repoProc.updateReqTime(id, LocalDateTime.now());
        }
        return ApiResult.ok((Object)canSend);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> deleteRetry(Long id, String reason) {
        Long originalId = this.repoProc.getOriginalLogId(id);
        if (originalId == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u539f\u59cb\u8bb0\u5f55\uff1a{}", (Object)id);
            return ApiResult.fail((String)"\u672a\u67e5\u8be2\u5230\u539f\u59cb\u8bb0\u5f55");
        }
        this.retryRepoProc.deleteByLogId(originalId);
        this.repoProc.delete(id);
        this.repoProc.updateRetryFailResult(originalId, reason);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateRetryResult(Long id, boolean success, String reason) {
        if (id == null) {
            log.error("\u66f4\u65b0\u91cd\u8bd5\u7ed3\u679c\u5931\u8d25\uff0cID\u4e3a\u7a7a");
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        if (success) {
            return ApiResult.ok((Object)true);
        }
        this.repoProc.updateReqResult(id, success, reason);
        Long originalLogId = this.repoProc.getOriginalLogId(id);
        if (originalLogId == null) {
            originalLogId = id;
        }
        this.repoProc.updateRetryTimes(originalLogId);
        this.addRetry((SysThirdApiLogDO)((Object)this.repoProc.get(originalLogId)));
        this.sendAlert((SysThirdApiLogDO)((Object)this.repoProc.get(id)), reason);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> updateRetryRespResult(Long id, boolean manual, boolean success, String reason, String respBody) {
        SysThirdApiLogDO apiLog = (SysThirdApiLogDO)((Object)this.repoProc.get(id));
        if (apiLog == null) {
            return ApiResult.fail((String)"\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        Long originalId = apiLog.getOriginalId();
        if (success) {
            if (originalId != null) {
                this.retryRepoProc.deleteByLogId(originalId);
            }
            if (CharSequenceUtil.isAllNotBlank((CharSequence[])new CharSequence[]{apiLog.getBusinessType(), apiLog.getBusinessKey()})) {
                this.businessRepoProc.updateSuccess(apiLog.getBusinessType(), apiLog.getBusinessKey(), true);
            }
        }
        this.repoProc.updateRespResult(id, success, reason, respBody);
        if (originalId != null) {
            this.repoProc.updateRespResult(originalId, success, reason, respBody);
        }
        if (!success && !manual && originalId != null) {
            SysThirdApiLogDO original = (SysThirdApiLogDO)((Object)ObjUtil.defaultIfNull((Object)((Object)((SysThirdApiLogDO)((Object)this.repoProc.get(originalId)))), (Object)((Object)apiLog)));
            this.addRetry(original);
        }
        if (!success) {
            this.sendAlert(apiLog, reason);
        }
        return ApiResult.ok((Object)true);
    }

    private String convertBusinessTypeName(String businessType) {
        if (CharSequenceUtil.isBlank((CharSequence)businessType)) {
            return null;
        }
        List types = (List)((ThirdApiLogService)SpringContextHolder.getBean(ThirdApiLogService.class)).listBusinessTypes().computeData();
        for (CodeNameParam type : types) {
            if (!businessType.equals(type.getCode()) && !businessType.equals(type.getName())) continue;
            return type.getName();
        }
        return businessType;
    }

    private String convertSystemName(String thirdApp, boolean isSource) {
        if (CharSequenceUtil.isBlank((CharSequence)thirdApp)) {
            return null;
        }
        List types = isSource ? (List)((ThirdApiLogService)SpringContextHolder.getBean(ThirdApiLogService.class)).listSourceSystems().computeData() : (List)((ThirdApiLogService)SpringContextHolder.getBean(ThirdApiLogService.class)).listTargetSystems().computeData();
        for (CodeNameParam type : types) {
            if (!thirdApp.equals(type.getCode()) && !thirdApp.equals(type.getName())) continue;
            return type.getName();
        }
        return thirdApp;
    }

    private ThirdApiLogPageRespVO do2PageRespVO(SysThirdApiLogDO logDO) {
        ThirdApiLogPageRespVO respVO = new ThirdApiLogPageRespVO();
        respVO.setId(logDO.getId());
        respVO.setAppCode(logDO.getAppCode());
        if (Boolean.TRUE.equals(logDO.getServer())) {
            respVO.setSourceSystem(this.convertSystemName(logDO.getThirdApp(), true));
            respVO.setTargetSystem(SysThirdApiSystem.YST.getValue());
        } else {
            respVO.setSourceSystem(SysThirdApiSystem.YST.getValue());
            respVO.setTargetSystem(this.convertSystemName(logDO.getThirdApp(), false));
        }
        respVO.setServerAddr(logDO.getServerAddr());
        respVO.setBusinessType(this.convertBusinessTypeName(logDO.getBusinessType()));
        respVO.setBusinessKey(logDO.getBusinessKey());
        respVO.setUsername(logDO.getUsername());
        respVO.setUri(logDO.getUri());
        respVO.setReqMethod(logDO.getReqMethod());
        respVO.setReqTime(logDO.getReqTime());
        respVO.setRespTime(logDO.getRespTime());
        respVO.setRetryTimes(logDO.getRetryTimes());
        respVO.setRespSuccess(logDO.getRespSuccess());
        respVO.setFailReason(CharSequenceUtil.blankToDefault((CharSequence)logDO.getRetryFailReason(), (String)CharSequenceUtil.blankToDefault((CharSequence)logDO.getRespFailMsg(), (String)logDO.getReqFailMsg())));
        return respVO;
    }

    private void saveBusinessInfo(SysThirdApiLogDO logDO) {
        if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{logDO.getBusinessType(), logDO.getBusinessKey()})) {
            return;
        }
        boolean success = Boolean.TRUE.equals(logDO.getRespSuccess());
        Long existsId = this.businessRepoProc.getId(logDO.getBusinessType(), logDO.getBusinessKey());
        if (existsId == null) {
            SysThirdApiBusinessDO businessDO = new SysThirdApiBusinessDO();
            businessDO.setSysTenantId(logDO.getSysTenantId());
            businessDO.setBusinessType(logDO.getBusinessType());
            businessDO.setBusinessKey(logDO.getBusinessKey());
            businessDO.setSuccess(success);
            this.businessRepoProc.save((Serializable)((Object)businessDO));
            return;
        }
        this.businessRepoProc.updateSuccess(existsId, success);
    }

    private void addRetry(SysThirdApiLogDO originalLog) {
        SysThirdApiLogDO retryLog = this.addRetryLog(originalLog);
        SysThirdApiRetryDO retryInfo = this.upsertRetryRecord(retryLog);
        this.executeRetry(retryInfo, retryLog);
    }

    private void executeRetry(SysThirdApiRetryDO retryDO, SysThirdApiLogDO retryLog) {
        ThirdApiRetry.RetryParam retryParam = new ThirdApiRetry.RetryParam();
        retryParam.setTaskId(retryLog.getId().toString());
        retryParam.setVersion(retryDO.getAuditDataVersion());
        retryParam.setRetryTimes(retryDO.getRetryTimes());
        retryParam.setRetryTime(retryDO.getSendTimeNext());
        this.taskExecutor.execute(() -> this.thirdApiRetry.addRetryTask(retryParam));
    }

    private SysThirdApiRetryDO upsertRetryRecord(SysThirdApiLogDO logDO) {
        Long logId = (Long)ObjectUtil.defaultIfNull((Object)logDO.getOriginalId(), (Object)logDO.getId());
        SysThirdApiRetryDO retryDO = this.retryRepoProc.getByRecordLogId(logId);
        if (retryDO != null) {
            LocalDateTime lastReqTime = (LocalDateTime)ObjectUtil.defaultIfNull((Object)this.repoProc.getLastReqTime(logId), (Object)retryDO.getSendTimeNext());
            retryDO.setRetryTimes(retryDO.getRetryTimes() + 1);
            retryDO.setSendTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)lastReqTime, () -> LocalDateTime.now()));
            retryDO.setSendTimeNext(this.thirdApiRetry.generateNextRetryTime(retryDO.getSendTime(), retryDO.getRetryTimes()));
            retryDO.setAuditDataVersion(retryDO.getAuditDataVersion() + 1);
            this.retryRepoProc.save((Serializable)((Object)retryDO));
            return retryDO;
        }
        retryDO = new SysThirdApiRetryDO();
        retryDO.setSysTenantId(logDO.getSysTenantId());
        retryDO.setRecordLogId(logId);
        retryDO.setRetryTimes(0);
        retryDO.setSendTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)logDO.getReqTime(), () -> LocalDateTime.now()));
        retryDO.setSendTimeNext(this.thirdApiRetry.generateNextRetryTime(retryDO.getSendTime(), retryDO.getRetryTimes()));
        retryDO.setAuditDataVersion(0);
        this.retryRepoProc.save((Serializable)((Object)retryDO));
        return retryDO;
    }

    private SysThirdApiLogDO addRetryLog(SysThirdApiLogDO original) {
        SysThirdApiLogDO logDO = new SysThirdApiLogDO();
        logDO.setSysTenantId(original.getSysTenantId());
        logDO.setAppCode(original.getAppCode());
        logDO.setRestful(original.getRestful());
        logDO.setServer(original.getServer());
        logDO.setServerAddr(original.getServerAddr());
        logDO.setThirdApp(original.getThirdApp());
        logDO.setBusinessType(original.getBusinessType());
        logDO.setBusinessKey(original.getBusinessKey());
        logDO.setClientId(original.getClientId());
        logDO.setUserId(original.getUserId());
        logDO.setUsername(original.getUsername());
        logDO.setUri(original.getUri());
        logDO.setReqMethod(original.getReqMethod());
        logDO.setReqQueryParamsJson(original.getReqQueryParamsJson());
        logDO.setReqBody(original.getReqBody());
        logDO.setReqHeadersJson(original.getReqHeadersJson());
        logDO.setReqSuccess(original.getReqSuccess());
        logDO.setReqIp(CloudtAppHolder.getServerIp());
        logDO.setNeedRetry(true);
        logDO.setDetectedOperatorAuth(original.getDetectedOperatorAuth());
        logDO.setRetryTimes(0);
        logDO.setRetried(true);
        logDO.setManualRetry(false);
        logDO.setOriginalId(original.getId());
        logDO.setRetryParamJson(original.getRetryParamJson());
        this.repoProc.save((Serializable)((Object)logDO));
        this.repoProc.updateLastRetryLogId(original.getId(), logDO.getId());
        return logDO;
    }

    private SysThirdApiLogDO manualSaveAndRetry(ThirdApiLogSaveVO saveVO, SysThirdApiLogDO original) {
        org.springframework.util.Assert.isTrue((boolean)Boolean.TRUE.equals(original.getRestful()), (String)"\u4ec5Restful\u683c\u5f0f\u63a5\u53e3\u652f\u6301\u91cd\u8bd5");
        org.springframework.util.Assert.isTrue((boolean)Boolean.FALSE.equals(original.getRetried()), (String)"\u8bf7\u7f16\u8f91\u539f\u7eaa\u5f55");
        SysThirdApiLogDO logDO = new SysThirdApiLogDO();
        logDO.setSysTenantId(original.getSysTenantId());
        logDO.setAppCode(original.getAppCode());
        logDO.setRestful(original.getRestful());
        logDO.setServer(original.getServer());
        logDO.setServerAddr(saveVO.getServerAddr());
        logDO.setThirdApp(original.getThirdApp());
        logDO.setBusinessType(original.getBusinessType());
        logDO.setBusinessKey(original.getBusinessKey());
        logDO.setClientId(original.getClientId());
        GeneralUserDetails user = super.currentUser(true);
        logDO.setUserId(user.getUserId());
        logDO.setUsername(CharSequenceUtil.blankToDefault((CharSequence)user.getUser().getPrettyName(), (String)user.getUsername()));
        logDO.setUri((String)Assert.notBlank((CharSequence)saveVO.getUri(), (String)"\u8bf7\u6c42\u7684\u63a5\u53e3\u5730\u5740\u4e3a\u7a7a", (Object[])new Object[0]));
        logDO.setReqMethod((HttpMethod)Assert.notNull((Object)saveVO.getReqMethod(), (String)"\u8bf7\u6c42\u65b9\u5f0f\u4e3a\u7a7a", (Object[])new Object[0]));
        logDO.setReqQueryParamsJson(saveVO.getReqQueryParamsJson());
        logDO.setReqBody(saveVO.getReqBody());
        logDO.setReqHeadersJson(saveVO.getReqHeadersJson());
        logDO.setReqSuccess(false);
        logDO.setReqTime(LocalDateTime.now());
        logDO.setReqIp(CloudtAppHolder.getServerIp());
        logDO.setNeedRetry(false);
        logDO.setDetectedOperatorAuth(original.getDetectedOperatorAuth());
        logDO.setRetried(true);
        logDO.setManualRetry(true);
        logDO.setOriginalId(original.getId());
        logDO.setRetryParamJson(original.getRetryParamJson());
        this.repoProc.save((Serializable)((Object)logDO));
        this.repoProc.updateLastRetryLogId(original.getId(), logDO.getId());
        CompletableFuture.runAsync(() -> this.thirdApiRetry.executeByManual(logDO), (Executor)this.taskExecutor).whenComplete((r, e) -> {
            if (e == null) {
                log.warn("{}\u624b\u52a8\u91cd\u8bd5\u6210\u529f\uff1a", (Object)logDO.getId());
                return;
            }
            log.warn("{}\u624b\u52a8\u91cd\u8bd5\u5931\u8d25\uff1a", (Object)logDO.getId(), e);
            try {
                ((ThirdApiRetryTaskProvider)SpringContextHolder.getBean(ThirdApiRetryTaskProvider.class)).updateRetryResult(logDO.getId().toString(), false, "\u91cd\u8bd5\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u8bf7\u6c42\u53c2\u6570");
            }
            catch (Throwable ex) {
                log.error("\u66f4\u65b0\u624b\u52a8\u91cd\u8bd5\u7684\u7ed3\u679c\u5f02\u5e38\uff1a", ex);
            }
        });
        return logDO;
    }

    private SysThirdApiLogDO dto2Do(ThirdApiLogDTO dto) {
        SysThirdApiLogDO logDO = ThirdApiLogConvert.INSTANCE.dto2Do(dto);
        ObjUtil.ifNull((Object)logDO.getBusinessKey(), (Object)"", logDO::setBusinessKey);
        ObjUtil.ifNull((Object)logDO.getBusinessType(), (Object)"", logDO::setBusinessType);
        ObjUtil.ifNull((Object)logDO.getThirdApp(), (Object)"", logDO::setThirdApp);
        logDO.setSysTenantId(super.currentTenantId());
        logDO.setServer((Boolean)ObjectUtil.defaultIfNull((Object)dto.getServer(), (Object)false));
        logDO.setReqTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)dto.getReqTime(), () -> LocalDateTime.now()));
        logDO.setReqSuccess((Boolean)ObjectUtil.defaultIfNull((Object)dto.getReqSuccess(), (Object)false));
        logDO.setRespSuccess((Boolean)ObjectUtil.defaultIfNull((Object)dto.getRespSuccess(), (Object)false));
        if (!logDO.getServer().booleanValue()) {
            org.springframework.util.Assert.hasText((String)logDO.getServerAddr(), (String)"\u670d\u52a1\u7aef\u5730\u5740\u4e3a\u7a7a");
        }
        logDO.setReqHeadersJson(super.obj2Json((Object)dto.getReqHeaders()));
        logDO.setReqQueryParamsJson(super.obj2Json((Object)dto.getReqQueryParams()));
        logDO.setNeedRetry((Boolean)ObjectUtil.defaultIfNull((Object)dto.getNeedRetry(), (Object)false));
        logDO.setDetectedOperatorAuth((Boolean)ObjectUtil.defaultIfNull((Object)dto.getDetectedOperatorAuth(), (Object)false));
        if (dto.getRetryParam() != null) {
            logDO.setRetryParamJson(super.obj2Json((Object)dto.getRetryParam()));
        }
        logDO.setRetryTimes(0);
        logDO.setRetried(false);
        logDO.setManualRetry(false);
        return logDO;
    }

    private void sendAlert(SysThirdApiLogDO logDO, String failMsg) {
        if (logDO == null) {
            log.info("\u53d1\u9001\u9884\u8b66\u5931\u8d25\uff0c\u65e5\u5fd7\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        String traceId = this.getTraceId();
        CompletableFuture.supplyAsync(() -> {
            ThirdApiLogPageRespVO respVO = this.do2PageRespVO(logDO);
            HashMap<String, String> tmplParams = new HashMap<String, String>(32);
            tmplParams.put("businessType", this.convertBusinessTypeName(respVO.getBusinessType()));
            tmplParams.put("direction", Boolean.TRUE.equals(logDO.getServer()) ? "\u63a5\u6536" : "\u63a8\u9001");
            tmplParams.put("businessKey", respVO.getBusinessKey());
            tmplParams.put("reqTime", this.formatTime(respVO.getReqTime()));
            tmplParams.put("respTime", this.formatTime(respVO.getRespTime()));
            tmplParams.put("sourceApp", this.convertSystemName(respVO.getSourceSystem(), true));
            tmplParams.put("targetApp", this.convertSystemName(respVO.getTargetSystem(), false));
            tmplParams.put("traceId", traceId);
            tmplParams.put("url", respVO.getUri());
            tmplParams.put("failMsg", failMsg);
            return (ApiResult)this.tenantDataIsolateProvider.byTenantDirectly(() -> this.alertService.sendAlertByTmpl("thirdApi", logDO.getThirdApp(), tmplParams), logDO.getSysTenantId());
        }, (Executor)this.taskExecutor).whenComplete((r, e) -> {
            if (e == null) {
                log.info("\u53d1\u9001\u9884\u8b66\u7ed3\u679c\uff1a{}", (Object)JSONUtil.toJsonString((Object)r));
                return;
            }
            log.info("\u53d1\u9001\u9884\u8b66\u5f02\u5e38\uff1a", e);
        });
    }

    private String getTraceId() {
        if (CharSequenceUtil.isBlank((CharSequence)this.logProperties.getTrace().getTraceCode())) {
            return null;
        }
        for (TraceIdProvider provider : this.providers) {
            if (!this.logProperties.getTrace().getTraceCode().equals(provider.code())) continue;
            return provider.getTraceId();
        }
        return null;
    }

    private String formatTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            return "";
        }
        return DatetimeUtil.FORMATTER_DATETIME.format(dateTime);
    }
}

