/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.task.retry.RetryTaskProvider;
import com.elitescloud.cloudt.system.model.entity.SysThirdApiRetryDO;
import com.elitescloud.cloudt.system.service.ThirdApiRetrySupportService;
import com.elitescloud.cloudt.system.service.impl.ThirdApiRetry;
import com.elitescloud.cloudt.system.service.repo.ThirdApiLogRepoProc;
import com.elitescloud.cloudt.system.service.repo.ThirdApiRetryRepoProc;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnClass(value={RetryTaskProvider.class})
class ThirdApiRetryTaskProvider
implements RetryTaskProvider<ThirdApiRetry.RetryParam> {
    private static final Logger log = LoggerFactory.getLogger(ThirdApiRetryTaskProvider.class);
    @Autowired
    private ThirdApiRetryRepoProc retryRepoProc;
    @Autowired
    private ThirdApiLogRepoProc repoProc;
    @Autowired
    @Lazy
    private ThirdApiRetrySupportService supportService;

    ThirdApiRetryTaskProvider() {
    }

    public List<ThirdApiRetry.RetryParam> queryTask(String lastTaskId, int size) {
        Long taskId = StringUtils.hasText((String)lastTaskId) ? Long.valueOf(Long.parseLong(lastTaskId)) : null;
        List<SysThirdApiRetryDO> recordList = this.retryRepoProc.listToRetry(taskId, size);
        if (recordList.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> ids = recordList.stream().map(SysThirdApiRetryDO::getRecordLogId).collect(Collectors.toSet());
        Map<Long, Long> lastRetryIdMap = this.repoProc.queryLastRetry(ids);
        return recordList.stream().filter(t -> lastRetryIdMap.containsKey(t.getRecordLogId())).map(t -> {
            ThirdApiRetry.RetryParam param = new ThirdApiRetry.RetryParam();
            param.setTaskId(((Long)lastRetryIdMap.get(t.getRecordLogId())).toString());
            param.setVersion(t.getAuditDataVersion());
            param.setRetryTimes(t.getRetryTimes());
            param.setRetryTime(t.getSendTimeNext());
            return param;
        }).collect(Collectors.toList());
    }

    public void deleteTask(@NotBlank String taskId, String reason) {
        if (CharSequenceUtil.isBlank((CharSequence)taskId)) {
            log.info("\u5220\u9664\u91cd\u8bd5\u4efb\u52a1\u5f02\u5e38\uff0c\u4efb\u52a1ID\u4e3a\u7a7a");
            return;
        }
        this.supportService.deleteRetry(Long.parseLong(taskId), reason);
    }

    public boolean trySend(@NotBlank String taskId, Integer version) {
        if (CharSequenceUtil.isBlank((CharSequence)taskId)) {
            log.info("\u5224\u65ad\u662f\u5426\u53ef\u4ee5\u53d1\u9001\u5f02\u5e38\uff0c\u4efb\u52a1ID\u4e3a\u7a7a");
            return false;
        }
        return (Boolean)ObjectUtil.defaultIfNull((Object)((Boolean)this.supportService.trySend(Long.parseLong(taskId), version).getData()), (Object)false);
    }

    public void updateRetryResult(String taskId, boolean success, String failReason) {
        if (CharSequenceUtil.isBlank((CharSequence)taskId)) {
            log.info("\u4fee\u6539\u91cd\u8bd5\u7ed3\u679c\u5f02\u5e38\uff0c\u4efb\u52a1ID\u4e3a\u7a7a");
            return;
        }
        this.supportService.updateRetryResult(Long.parseLong(taskId), success, failReason);
    }
}

