/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.lang.Assert;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.InfinityPlatformConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.entity.InfinityPlatformDO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiPagingParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiPagingVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiQueryParamVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.ThirdApiSaveParamVO;
import com.elitescloud.cloudt.system.service.AuthMethodService;
import com.elitescloud.cloudt.system.service.ThirdApiService;
import com.elitescloud.cloudt.system.service.repo.InfinityPlatformRepo;
import com.elitescloud.cloudt.system.service.repo.InfinityPlatformRepoProc;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class ThirdApiServiceImpl
implements ThirdApiService {
    private static final Logger log = LoggerFactory.getLogger(ThirdApiServiceImpl.class);
    private final AuthMethodService authMethodService;
    private final InfinityPlatformRepo platformRepo;
    private final InfinityPlatformRepoProc platformRepoProc;
    @Autowired
    private TenantClientProvider tenantClientProvider;

    private long currentTenantId() {
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            tenant = this.tenantClientProvider.getCurrentTenant();
        }
        return tenant == null ? TenantConstant.DEFAULT_TENANT_ID : tenant.getId();
    }

    @Override
    public PagingVO<ThirdApiPagingVO> ThirdApiPageBy(ThirdApiPagingParamVO query) {
        long count = this.platformRepoProc.platformCountBy(query);
        if (count > 0L) {
            List<InfinityPlatformDO> list = this.platformRepoProc.platformPageBy(query);
            return new PagingVO(count, InfinityPlatformConvert.INSTANCE.toPageVO(list));
        }
        return new PagingVO();
    }

    @Override
    public List<ThirdApiRespVO> ThirdApiByParam(ThirdApiQueryParamVO query) {
        List<InfinityPlatformDO> list = this.platformRepoProc.platformByParam(query);
        List<ThirdApiRespVO> platforms = InfinityPlatformConvert.INSTANCE.doToVO(list);
        List<String> authMethodCodes = platforms.stream().map(ThirdApiRespVO::getAuthMethod).collect(Collectors.toList());
        Map<String, String> authMethodNames = this.authMethodService.fromCode(authMethodCodes);
        for (ThirdApiRespVO platform : platforms) {
            String authMethodName = authMethodNames.getOrDefault(platform.getAuthMethod(), platform.getAuthMethod());
            platform.setAuthMethodName(authMethodName);
        }
        return platforms;
    }

    @Override
    public ThirdApiRespVO ThirdApiById(Long id) {
        Optional infinityPlatformDO = this.platformRepo.findById(id);
        if (infinityPlatformDO.isEmpty()) {
            throw new BusinessException("Not Found Data");
        }
        return InfinityPlatformConvert.INSTANCE.doToVO((InfinityPlatformDO)infinityPlatformDO.get());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long save(ThirdApiSaveParamVO saveParam) {
        boolean exists = this.platformRepoProc.existsByCode(saveParam.getId(), saveParam.getPlatformCode());
        Assert.isFalse((boolean)exists, (String)"\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (saveParam.isNew()) {
            InfinityPlatformDO infinityPlatformDO = InfinityPlatformConvert.INSTANCE.saveParamToDO(saveParam);
            infinityPlatformDO.setTenantId(this.currentTenantId());
            this.platformRepo.save(infinityPlatformDO);
            return infinityPlatformDO.getId();
        }
        Optional infinityPlatformDO = this.platformRepo.findById(saveParam.getId());
        if (infinityPlatformDO.isEmpty()) {
            throw new BusinessException("Not Found Data");
        }
        InfinityPlatformDO infinityPlatform = (InfinityPlatformDO)infinityPlatformDO.get();
        InfinityPlatformConvert.INSTANCE.saveParamMergeToDO(saveParam, infinityPlatform);
        infinityPlatform.setTenantId(this.currentTenantId());
        this.platformRepo.save(infinityPlatform);
        return infinityPlatform.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long delete(List<Long> ids) {
        return this.platformRepoProc.delete(ids);
    }

    public ThirdApiServiceImpl(AuthMethodService authMethodService, InfinityPlatformRepo platformRepo, InfinityPlatformRepoProc platformRepoProc) {
        this.authMethodService = authMethodService;
        this.platformRepo = platformRepo;
        this.platformRepoProc = platformRepoProc;
    }
}

