/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.SysThirdPartyAccountBusinessType;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BaseWechatAppRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.BaseWecomAppRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatMiniProgramRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatServiceRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WechatSubscriptionRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.WecomRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.BaseWechatAppSaveVo;
import com.elitescloud.cloudt.system.model.vo.save.extend.BaseWecomAppSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatMiniProgramSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatServiceSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WechatSubscriptionSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.WecomSaveVO;
import com.elitescloud.cloudt.system.service.ThirdPartAccountMngService;
import com.elitescloud.cloudt.system.service.callback.ThirdPartyAccountChangedCallback;
import com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType;
import com.elitescloud.cloudt.system.service.model.entity.SysThirdPartyAccountDO;
import com.elitescloud.cloudt.system.service.repo.ThirdPartyAccountRepo;
import com.elitescloud.cloudt.system.service.repo.ThirdPartyAccountRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class ThirdPartAccountMngServiceImpl
extends BaseServiceImpl
implements ThirdPartAccountMngService {
    @Autowired
    private ThirdPartyAccountRepo repo;
    @Autowired
    private ThirdPartyAccountRepoProc repoProc;
    @Autowired
    private ObjectProvider<ThirdPartyAccountChangedCallback> changedCallbacks;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveWechatMiniApp(WechatMiniProgramSaveVO saveVO, String businessType) {
        SysThirdPartyAccountDO accountDO = this.convertWechatSaveVO(saveVO, ThirdPartAccountType.WECHAT_MINI_APP, businessType);
        this.saveAccount(accountDO, saveVO.getId() == null);
        return ApiResult.ok((Object)accountDO.getId());
    }

    @Override
    public ApiResult<WechatMiniProgramRespVO> getWechatMiniApp(String businessType) {
        WechatMiniProgramRespVO respVO = this.fillWechatRespVO(new WechatMiniProgramRespVO(), ThirdPartAccountType.WECHAT_MINI_APP, businessType);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveWechatService(WechatServiceSaveVO saveVO, String businessType) {
        SysThirdPartyAccountDO accountDO = this.convertWechatSaveVO(saveVO, ThirdPartAccountType.WECHAT_SERVICE, businessType);
        this.saveAccount(accountDO, saveVO.getId() == null);
        return ApiResult.ok((Object)accountDO.getId());
    }

    @Override
    public ApiResult<WechatServiceRespVO> getWechatService(String businessType) {
        WechatServiceRespVO respVO = this.fillWechatRespVO(new WechatServiceRespVO(), ThirdPartAccountType.WECHAT_SERVICE, businessType);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveWechatSubscription(WechatSubscriptionSaveVO saveVO, String businessType) {
        SysThirdPartyAccountDO accountDO = this.convertWechatSaveVO(saveVO, ThirdPartAccountType.WECHAT_SUBSCRIPTION, businessType);
        this.saveAccount(accountDO, saveVO.getId() == null);
        return ApiResult.ok((Object)accountDO.getId());
    }

    @Override
    public ApiResult<WechatSubscriptionRespVO> getWechatSubscription(String businessType) {
        WechatSubscriptionRespVO respVO = this.fillWechatRespVO(new WechatSubscriptionRespVO(), ThirdPartAccountType.WECHAT_SUBSCRIPTION, businessType);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> saveWecom(WecomSaveVO saveVO, String businessType) {
        SysThirdPartyAccountDO accountDO = this.convertWecomSaveVO(saveVO, ThirdPartAccountType.WECOM, businessType);
        this.saveAccount(accountDO, saveVO.getId() == null);
        return ApiResult.ok((Object)accountDO.getId());
    }

    @Override
    public ApiResult<WecomRespVO> getWecom(String businessType) {
        WecomRespVO respVO = this.fillWecomRespVO(new WecomRespVO(), ThirdPartAccountType.WECOM, businessType);
        return ApiResult.ok((Object)respVO);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateCasId(Long id, Long casId) {
        this.repoProc.updateCasId(id, casId);
        return ApiResult.ok((Object)id);
    }

    private void saveAccount(SysThirdPartyAccountDO accountDO, boolean isAdd) {
        this.repo.save(accountDO);
        this.changedCallbacks.forEach(t -> t.onUpsert(isAdd, accountDO));
    }

    private <T extends BaseWecomAppSaveVO> SysThirdPartyAccountDO convertWecomSaveVO(T saveVO, ThirdPartAccountType accountType, String businessType) {
        Long tenantId = super.currentTenantId();
        if (CharSequenceUtil.isBlank((CharSequence)businessType)) {
            businessType = SysThirdPartyAccountBusinessType.DEFAULT.getValue();
        }
        Long existsId = this.repoProc.getIdByType(accountType, businessType, tenantId);
        SysThirdPartyAccountDO accountDO = null;
        String account = saveVO.getCorpid() + ":" + CharSequenceUtil.blankToDefault((CharSequence)saveVO.getAgentId(), (String)"");
        if (saveVO.getId() == null) {
            Assert.isNull((Object)existsId, (String)"\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5");
            accountDO = new SysThirdPartyAccountDO();
            accountDO.setAccountType(accountType.getValue());
            exists = this.repoProc.existsAccount(account);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5e94\u7528\u5df2\u5b58\u5728");
        } else {
            if (existsId != null && existsId.longValue() != saveVO.getId().longValue()) {
                this.repoProc.delete(existsId);
            }
            if (!account.equals((accountDO = (SysThirdPartyAccountDO)this.repoProc.get(saveVO.getId())).getAccount())) {
                exists = this.repoProc.existsAccount(account);
                Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u5e94\u7528\u5df2\u5b58\u5728");
            }
        }
        accountDO.setBusinessType(businessType);
        accountDO.setSysTenantId(tenantId);
        accountDO.setName(saveVO.getName());
        accountDO.setAccount(account);
        accountDO.setAccountType(accountType.getValue());
        accountDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getEnabled(), (Object)true));
        HashMap<String, String> config = new HashMap<String, String>(4);
        config.put("corpid", saveVO.getCorpid());
        config.put("agentId", saveVO.getAgentId());
        config.put("corpsecret", saveVO.getCorpsecret());
        accountDO.setConfigJson(super.obj2Json(config));
        accountDO.setRemark(saveVO.getRemark());
        return accountDO;
    }

    private <T extends BaseWecomAppRespVO> T fillWecomRespVO(T respVO, ThirdPartAccountType accountType, String businessType) {
        Long tenantId = super.currentTenantId();
        SysThirdPartyAccountDO accountDO = this.repoProc.getOneByType(accountType, businessType, tenantId);
        if (accountDO == null) {
            return null;
        }
        respVO.setId(accountDO.getId());
        respVO.setName(accountDO.getName());
        Map config = (Map)super.json2Obj(accountDO.getConfigJson(), (TypeReference)new TypeReference<Map<String, String>>(){});
        respVO.setCorpid((String)config.get("corpid"));
        respVO.setCorpsecret((String)config.get("corpsecret"));
        respVO.setEnabled(accountDO.getEnabled());
        respVO.setRemark(accountDO.getRemark());
        return respVO;
    }

    private <T extends BaseWechatAppSaveVo> SysThirdPartyAccountDO convertWechatSaveVO(T saveVO, ThirdPartAccountType accountType, String businessType) {
        Long tenantId = super.currentTenantId();
        if (CharSequenceUtil.isBlank((CharSequence)businessType)) {
            businessType = SysThirdPartyAccountBusinessType.DEFAULT.getValue();
        }
        Long existsId = this.repoProc.getIdByType(accountType, businessType, tenantId);
        SysThirdPartyAccountDO accountDO = null;
        if (saveVO.getId() == null) {
            Assert.isNull((Object)existsId, (String)"\u6570\u636e\u5df2\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u540e\u518d\u8bd5");
            accountDO = new SysThirdPartyAccountDO();
            accountDO.setAccountType(accountType.getValue());
            exists = this.repoProc.existsAccount(saveVO.getAppId());
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"AppId\u5df2\u5b58\u5728");
        } else {
            if (existsId != null && existsId.longValue() != saveVO.getId().longValue()) {
                this.repoProc.delete(existsId);
            }
            accountDO = (SysThirdPartyAccountDO)this.repoProc.get(saveVO.getId());
            if (!saveVO.getAppId().equals(accountDO.getAccount())) {
                exists = this.repoProc.existsAccount(saveVO.getAppId());
                Assert.isTrue((!exists ? 1 : 0) != 0, (String)"AppId\u5df2\u5b58\u5728");
            }
        }
        accountDO.setBusinessType(businessType);
        accountDO.setSysTenantId(tenantId);
        accountDO.setName(saveVO.getName());
        accountDO.setAccount(saveVO.getAppId());
        accountDO.setAccountType(accountType.getValue());
        accountDO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getEnabled(), (Object)true));
        HashMap<String, String> config = new HashMap<String, String>(4);
        config.put("appId", saveVO.getAppId());
        config.put("appSecret", saveVO.getAppSecret());
        accountDO.setConfigJson(super.obj2Json(config));
        accountDO.setRemark(saveVO.getRemark());
        return accountDO;
    }

    private <T extends BaseWechatAppRespVO> T fillWechatRespVO(T respVO, ThirdPartAccountType accountType, String businessType) {
        Long tenantId = super.currentTenantId();
        SysThirdPartyAccountDO accountDO = this.repoProc.getOneByType(accountType, businessType, tenantId);
        if (accountDO == null) {
            return null;
        }
        respVO.setId(accountDO.getId());
        respVO.setName(accountDO.getName());
        respVO.setAppId(accountDO.getAccount());
        Map config = (Map)super.json2Obj(accountDO.getConfigJson(), (TypeReference)new TypeReference<Map<String, String>>(){});
        respVO.setAppSecret((String)config.get("appSecret"));
        respVO.setEnabled(accountDO.getEnabled());
        respVO.setRemark(accountDO.getRemark());
        return respVO;
    }
}

