/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.constant.SysThirdPartyAccountBusinessType;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.service.ThirdPartAccountQueryService;
import com.elitescloud.cloudt.system.service.common.constant.ThirdPartAccountType;
import com.elitescloud.cloudt.system.service.model.bo.ThirdPartAccountBO;
import com.elitescloud.cloudt.system.service.repo.ThirdPartyAccountRepoProc;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class ThirdPartAccountQueryServiceImpl
extends BaseServiceImpl
implements ThirdPartAccountQueryService {
    @Autowired
    private ThirdPartyAccountRepoProc repoProc;

    @Override
    public ApiResult<Long> getTenantIdOfAccount(String account) {
        Assert.hasText((String)account, (String)"\u8d26\u53f7\u4e3a\u7a7a");
        Long tenantId = this.repoProc.getTenantIdByAccount(account);
        return ApiResult.ok((Object)tenantId);
    }

    @Override
    public ApiResult<ThirdPartAccountBO> get(@NotNull Long tenantId, ThirdPartAccountType accountType, SysThirdPartyAccountBusinessType businessType) {
        Assert.notNull((Object)tenantId, (String)"\u79df\u6237ID\u4e3a\u7a7a");
        Assert.notNull((Object)accountType, (String)"\u8d26\u53f7\u7c7b\u578b\u4e3a\u7a7a");
        Assert.notNull((Object)businessType, (String)"\u4e1a\u52a1\u7c7b\u578b\u4e3a\u7a7a");
        ThirdPartAccountBO config = this.repoProc.getAccountConfig(accountType, businessType.getValue(), tenantId);
        return ApiResult.ok((Object)config);
    }
}

