/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ArrayUtil;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.param.FileByteVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.cacheable.SysCacheTmplApiRpcService;
import com.elitescloud.cloudt.system.dto.SysTmplDTO;
import com.elitescloud.cloudt.system.service.ResourceByteQueryService;
import com.elitescloud.cloudt.system.service.manager.ResourceByteMngManager;
import com.elitescloud.cloudt.system.service.repo.SysTmplRepoProc;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpEntity;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

abstract class TmplBaseServiceImpl
extends BaseServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(TmplBaseServiceImpl.class);
    @Autowired
    protected SysTmplRepoProc tmplRepoProc;
    @Autowired
    protected ResourceByteMngManager resourceByteMngManager;
    @Autowired
    private FileService<String> fileService;
    @Autowired
    private ResourceByteQueryService resourceByteQueryService;
    @Autowired
    private SysCacheTmplApiRpcService cacheTmplApiRpcService;

    TmplBaseServiceImpl() {
    }

    protected void cache(SysTmplDTO dto) {
        if (dto == null) {
            return;
        }
        this.redisUtils.set("system:tmpl:{TMPL_CODE}".replace("{TMPL_CODE}", dto.getCode()), (Object)dto);
    }

    protected void clearCache(String code) {
        if (!StringUtils.hasText((String)code)) {
            return;
        }
        this.redisUtils.del(new String[]{"system:tmpl:{TMPL_CODE}".replace("{TMPL_CODE}", code)});
        this.cacheTmplApiRpcService.clearCache();
    }

    public HttpEntity<StreamingResponseBody> streamByFileCode(String fileCode) {
        if (CharSequenceUtil.isBlank((CharSequence)fileCode)) {
            return ResponseEntity.badRequest().build();
        }
        ResponseEntity<StreamingResponseBody> res = this.resourceByteQueryService.download(fileCode);
        if (res.hasBody()) {
            return res;
        }
        HttpEntity downloadResult = this.fileService.download(fileCode, null);
        if (downloadResult.hasBody()) {
            return downloadResult;
        }
        byte[] notFound = "\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e".getBytes(StandardCharsets.UTF_8);
        return ((ResponseEntity.BodyBuilder)ResponseEntity.ok().contentType(MediaType.APPLICATION_OCTET_STREAM).header("Content-Disposition", new String[]{ContentDisposition.builder((String)"attachment").filename("\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u672a\u914d\u7f6e.xlsx", StandardCharsets.UTF_8).build().toString()})).contentLength((long)notFound.length).body(outputStream -> {
            try {
                StreamUtils.copy((byte[])notFound, (OutputStream)outputStream);
            }
            catch (Exception e) {
                log.error("\u4e0b\u8f7d\u8d44\u6e90\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            }
        });
    }

    protected byte[] getFile(String fileCode) {
        byte[] contents = this.resourceByteMngManager.getResourceContent(fileCode);
        if (ArrayUtil.isNotEmpty((byte[])contents)) {
            return contents;
        }
        HttpEntity resp = this.fileService.download(fileCode, null);
        if (resp == null || !resp.hasBody() || resp.getBody() == null) {
            return new byte[0];
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ((StreamingResponseBody)resp.getBody()).writeTo((OutputStream)outputStream);
        }
        catch (Exception e) {
            log.warn("\u8f6c\u6210\u6a21\u677f\u6587\u4ef6{}\u5931\u8d25", (Object)fileCode, (Object)e);
            return new byte[0];
        }
        contents = outputStream.toByteArray();
        FileObjRespVO fileInfo = (FileObjRespVO)this.fileService.get(fileCode).getData();
        if (fileInfo != null) {
            this.resourceByteMngManager.saveResourceForCompatibility(contents, fileInfo, "tmpl", fileCode, true);
        }
        return contents;
    }

    protected FileByteVO getFileVO(String fileCode) {
        return this.resourceByteMngManager.getFileForCompatibility(fileCode);
    }
}

