/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcelFactory;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.el.coordinator.boot.fsm.model.vo.FileObjRespVO;
import com.el.coordinator.boot.fsm.service.FileService;
import com.el.coordinator.core.common.api.ApiResult;
import com.elitescloud.boot.common.param.FileInfoVO;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.SheetLimitStrategy;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.TmplConvert;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplQueryParam;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplEditRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.extend.TmplPageMngRespVO;
import com.elitescloud.cloudt.system.model.vo.save.extend.TmplSaveVO;
import com.elitescloud.cloudt.system.service.TmplMngService;
import com.elitescloud.cloudt.system.service.impl.TmplBaseServiceImpl;
import com.elitescloud.cloudt.system.service.manager.ResourceByteMngManager;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplDO;
import com.elitescloud.cloudt.system.service.repo.SysTmplRepo;
import com.elitescloud.cloudt.system.service.repo.SysTmplRepoProc;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.StreamingResponseBody;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class TmplMngServiceImpl
extends TmplBaseServiceImpl
implements TmplMngService {
    private static final Logger log = LoggerFactory.getLogger(TmplMngServiceImpl.class);
    private static final int UN_LIMIT = -1;
    private static final Integer SHEET_ROW_MAX = 1000000;
    @Autowired
    private SysTmplRepo tmplRepo;
    @Autowired
    private SysTmplRepoProc tmplRepoProc;
    @Autowired
    private FileService<String> fileService;
    @Autowired
    private ResourceByteMngManager resourceManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<FileInfoVO> uploadTmpl(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u6a21\u677f\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u4e3a\u7a7a");
        }
        byte[] content = null;
        try {
            content = file.getBytes();
        }
        catch (IOException e) {
            log.warn("\u8bfb\u53d6\u6a21\u677f\u6587\u4ef6\u5f02\u5e38\uff1a", (Throwable)e);
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u5f02\u5e38");
        }
        ApiResult uploadResult = this.fileService.upload(content, file.getOriginalFilename());
        if (!uploadResult.isSuccess() || uploadResult.getData() == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)uploadResult.getMsg());
        }
        FileInfoVO resourceInfo = this.resourceManager.saveResourceForCompatibility(content, (FileObjRespVO)uploadResult.getData(), "tmpl", null, true);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)resourceInfo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> save(TmplSaveVO saveVO) {
        this.checkForSave(saveVO, null);
        byte[] tmplFile = this.getFile(saveVO.getFileCode());
        SysTmplDO tmplDO = TmplConvert.INSTANCE.vo2Do(saveVO);
        this.fillAttributeList(tmplDO, tmplFile);
        this.tmplRepo.save(tmplDO);
        this.resourceManager.updateTemp(tmplDO.getFileCode(), false);
        this.clearCache(saveVO.getCode());
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)tmplDO.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> update(Long id, TmplSaveVO saveVO) {
        this.checkForSave(saveVO, id);
        byte[] tmplFile = this.getFile(saveVO.getFileCode());
        String oldFileCode = this.tmplRepoProc.getFileCode(id);
        SysTmplDO tmplDO = TmplConvert.INSTANCE.vo2Do(saveVO);
        tmplDO.setId(id);
        this.fillAttributeList(tmplDO, tmplFile);
        this.tmplRepo.save(tmplDO);
        this.resourceManager.updateTemp(tmplDO.getFileCode(), false);
        this.clearCache(saveVO.getCode());
        if (StringUtils.hasText((String)oldFileCode) || !oldFileCode.equals(tmplDO.getFileCode())) {
            this.resourceManager.deleteByBusinessKey(oldFileCode);
        }
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> updateEnabled(Long id) {
        Boolean enabled = this.tmplRepoProc.getEnabled(id);
        this.tmplRepoProc.updateEnabled(id, (Boolean)ObjectUtil.defaultIfNull((Object)enabled, (Object)false) == false);
        String code = this.tmplRepoProc.getCode(id);
        this.clearCache(code);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<Long> delete(Long id) {
        SysTmplDO tmplInfo = (SysTmplDO)this.tmplRepoProc.get(id);
        if (tmplInfo == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)id);
        }
        this.clearCache(tmplInfo.getCode());
        this.tmplRepoProc.delete(id);
        this.resourceManager.deleteByBusinessKey(tmplInfo.getFileCode());
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public com.elitescloud.cloudt.common.base.ApiResult<String> deleteTmplFile(String fileCode) {
        this.resourceManager.deleteByBusinessKey(fileCode);
        CompletableFuture.runAsync(() -> this.fileService.delete(fileCode)).whenComplete((res, e) -> {
            if (e != null) {
                log.warn("\u5220\u9664\u6a21\u677f\u6587\u4ef6\u5f02\u5e38", e);
            }
        });
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)fileCode);
    }

    @Override
    public com.elitescloud.cloudt.common.base.ApiResult<TmplEditRespVO> get(Long id) {
        SysTmplDO tmplDO = this.tmplRepo.findById(id).orElse(null);
        if (tmplDO == null) {
            return com.elitescloud.cloudt.common.base.ApiResult.fail((String)"\u6570\u636e\u4e0d\u5b58\u5728");
        }
        TmplEditRespVO respVO = TmplConvert.INSTANCE.do2Vo(tmplDO);
        if (StrUtil.isNotBlank((CharSequence)respVO.getFileCode())) {
            respVO.setFileInfo(this.resourceManager.getForCompatibility(respVO.getFileCode()));
        }
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)respVO);
    }

    @Override
    public HttpEntity<StreamingResponseBody> download(Long id) {
        String fileCode = this.tmplRepoProc.getFileCode(id);
        return this.downloadByFileCode(fileCode);
    }

    @Override
    public HttpEntity<StreamingResponseBody> downloadByFileCode(String fileCode) {
        return super.streamByFileCode(fileCode);
    }

    @Override
    public HttpEntity<StreamingResponseBody> downloadByCode(String code) {
        if (CharSequenceUtil.isBlank((CharSequence)code)) {
            return ResponseEntity.badRequest().build();
        }
        String fileCode = this.tmplRepoProc.getFileCodeByCode(code);
        return super.streamByFileCode(fileCode);
    }

    @Override
    public com.elitescloud.cloudt.common.base.ApiResult<PagingVO<TmplPageMngRespVO>> search(TmplQueryParam queryParam) {
        PagingVO<SysTmplDO> tmplDoPage = this.tmplRepoProc.pageMng(queryParam);
        if (tmplDoPage.isEmpty()) {
            return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)PagingVO.empty());
        }
        PagingVO pageData = tmplDoPage.map(TmplConvert.INSTANCE::do2PageVo);
        return com.elitescloud.cloudt.common.base.ApiResult.ok((Object)pageData);
    }

    private void fillAttributeList(SysTmplDO tmplDO, byte[] file) {
        List<List<String>> attributes = this.readAttribute(file, tmplDO.getHeadRow());
        Assert.notEmpty(attributes, (String)"\u5934\u90e8\u6240\u5360\u884c\u6570\u8bbe\u7f6e\u6709\u8bef\uff0c\u672a\u8bfb\u53d6\u5230\u6709\u6548\u6a21\u677f\u6570\u636e", (Object[])new Object[0]);
        Assert.isTrue((attributes.size() >= tmplDO.getFieldTypeRow() ? 1 : 0) != 0, (String)"\u6570\u636e\u5b57\u6bb5\u6240\u5728\u884c\u8bbe\u7f6e\u6709\u8bef\uff0c\u672a\u8bfb\u53d6\u5230\u6709\u6548\u6570\u636e\u5b57\u6bb5", (Object[])new Object[0]);
        tmplDO.setAttributeList(super.obj2Json(attributes));
    }

    private List<List<String>> readAttribute(byte[] file, Integer headRow) {
        boolean hasFieldRow;
        List excelData = null;
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file);
            excelData = ((ExcelReaderSheetBuilder)EasyExcelFactory.read((InputStream)inputStream).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(0))).doReadSync();
        }
        catch (Exception e) {
            throw new BusinessException("\u8bfb\u53d6\u6a21\u677f\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4e0a\u4f20\u7684\u6a21\u677f\u6587\u4ef6\u683c\u5f0f", (Throwable)e);
        }
        boolean bl = hasFieldRow = excelData != null && excelData.size() >= headRow;
        if (!hasFieldRow) {
            return Collections.emptyList();
        }
        return excelData.stream().map(data -> ((Map)data).entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getKey)).map(Map.Entry::getValue).collect(Collectors.toList())).collect(Collectors.toList());
    }

    private void checkForSave(TmplSaveVO saveVO, Long id) {
        boolean isAdd = id == null;
        boolean exists = false;
        if (!isAdd) {
            exists = this.tmplRepo.existsById(id);
            Assert.isTrue((boolean)exists, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            String codeOld = this.tmplRepoProc.getCode(id);
            Assert.isTrue((boolean)CharSequenceUtil.equals((CharSequence)codeOld, (CharSequence)saveVO.getCode()), (String)"\u6a21\u677f\u7f16\u53f7\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        }
        exists = isAdd ? this.tmplRepoProc.existsByCode(saveVO.getCode()) : this.tmplRepoProc.existsByCode(saveVO.getCode(), id);
        Assert.isFalse((boolean)exists, (String)"\u6a21\u677f\u7f16\u53f7\u5df2\u5b58\u5728", (Object[])new Object[0]);
        saveVO.setExport((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getExport(), (Object)false));
        saveVO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveVO.getEnabled(), (Object)true));
        if (saveVO.getFieldTypeRow() > saveVO.getHeadRow()) {
            throw new BusinessException("\u6570\u636e\u5b57\u6bb5\u6240\u5728\u884c\u6570\u4e0d\u80fd\u5927\u4e8e\u5934\u90e8\u6240\u5360\u884c\u6570");
        }
        saveVO.setDataLimitPer((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getDataLimitPer(), (Object)-1));
        saveVO.setAsyncThreshold((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getAsyncThreshold(), (Object)-1));
        saveVO.setConcurrentLimit((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getConcurrentLimit(), (Object)-1));
        if (saveVO.getExport().booleanValue()) {
            saveVO.setExportSheetLimit((Integer)ObjectUtil.defaultIfNull((Object)saveVO.getExportSheetLimit(), (Object)SHEET_ROW_MAX));
            saveVO.setExportSheetStrategy((SheetLimitStrategy)ObjectUtil.defaultIfNull((Object)saveVO.getExportSheetStrategy(), (Object)SheetLimitStrategy.NEW_SHEET));
            saveVO.setSheetNos(null);
        } else {
            saveVO.setExportSheetLimit(null);
            saveVO.setExportSheetStrategy(null);
            saveVO.setSheetNos(this.normalizeSheetNos(saveVO.getSheetNos()));
        }
    }

    private String normalizeSheetNos(String sheetNos) {
        if (CharSequenceUtil.isBlank((CharSequence)sheetNos)) {
            return null;
        }
        String[] sheetNoArray = sheetNos.replace("\uff0c", ",").split(",");
        ArrayList<String> sheetNoList = new ArrayList<String>(sheetNoArray.length);
        Integer sheetNo = null;
        for (String s : sheetNoArray) {
            try {
                sheetNo = Integer.parseInt(s.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("sheet\u9875\u683c\u5f0f\u8bbe\u7f6e\u6709\u8bef\uff0c\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
            }
            if (sheetNo < 1) {
                throw new IllegalArgumentException("sheet\u9875\u683c\u5f0f\u8bbe\u7f6e\u6709\u8bef\uff0c\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570");
            }
            if (sheetNoList.contains(sheetNo.toString())) continue;
            sheetNoList.add(sheetNo.toString());
        }
        return String.join((CharSequence)",", sheetNoList);
    }
}

