/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.dto.SysUdcDTO;
import com.elitescloud.cloudt.system.model.bo.SysUdcBO;
import com.elitescloud.cloudt.system.model.bo.SysUdcValueBO;
import com.elitescloud.cloudt.system.model.vo.query.udc.UdcPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.udc.UdcWithValuesPageRespVO;
import com.elitescloud.cloudt.system.service.UdcQueryService;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.UdcRepoProc;
import com.elitescloud.cloudt.system.service.repo.UdcValueRepoProc;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
@Service
public class UdcQueryServiceImpl
extends BaseServiceImpl
implements UdcQueryService {
    private static final Logger log = LogManager.getLogger(UdcQueryServiceImpl.class);
    @Autowired
    private UdcRepoProc udcRepoProc;
    @Autowired
    private UdcValueRepoProc udcValueRepoProc;
    @Autowired
    private AppRepoProc appRepoProc;

    @Override
    public ApiResult<SysUdcDTO> get(String appCode, String udcCode) {
        if (CharSequenceUtil.hasBlank((CharSequence[])new CharSequence[]{appCode, udcCode})) {
            return ApiResult.fail((String)"\u5e94\u7528\u7f16\u7801\u6216UDC\u7f16\u7801\u4e3a\u7a7a");
        }
        List<SysUdcValueBO> valueBoList = this.udcValueRepoProc.listBoByUdc(appCode, udcCode, true);
        if (valueBoList.isEmpty()) {
            return ApiResult.noData();
        }
        SysUdcBO udcBo = this.udcRepoProc.getBoByAppCodeAndUdcCode(appCode, udcCode);
        if (udcBo == null) {
            return ApiResult.noData();
        }
        SysUdcDTO udcDTO = this.bo2Dto(udcBo, valueBoList);
        return ApiResult.ok((Object)udcDTO);
    }

    @Override
    public ApiResult<List<SysUdcDTO>> listByUdcCode(String appCode, Set<String> udcCodes) {
        if (!StringUtils.hasText((String)appCode)) {
            return ApiResult.fail((String)"\u5e94\u7528\u7f16\u7801\u4e3a\u7a7a");
        }
        List<SysUdcValueBO> valueBoList = this.udcValueRepoProc.queryBoByUdc(appCode, udcCodes, true);
        if (valueBoList.isEmpty()) {
            return ApiResult.noData();
        }
        List<SysUdcDTO> udcDtoList = this.udcValue2Dto(valueBoList);
        return ApiResult.ok(udcDtoList);
    }

    @Override
    public ApiResult<PagingVO<UdcWithValuesPageRespVO>> pageQuery(UdcPageQueryVO queryVO) {
        PagingVO<UdcWithValuesPageRespVO> pageData = this.udcRepoProc.pageQuery(queryVO);
        if (pageData.isEmpty()) {
            return ApiResult.ok(pageData);
        }
        HashMap appCodeAndUdcCodeMap = new HashMap(pageData.size());
        pageData.each(t -> appCodeAndUdcCodeMap.computeIfAbsent(t.getAppCode(), a -> new HashSet(8)).add(t.getUdcCode()));
        HashMap udcValueMap = new HashMap(pageData.size());
        for (Map.Entry entry : appCodeAndUdcCodeMap.entrySet()) {
            this.udcValueRepoProc.queryBoByUdc((String)entry.getKey(), (Collection)entry.getValue(), false).forEach(t -> udcValueMap.computeIfAbsent(t.getAppCode() + ":_:" + t.getUdcCode(), k -> new ArrayList(16)).add(t));
        }
        Map appMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.allParams(null))).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Functions.identity(), (t1, t2) -> t1));
        pageData.each(t -> {
            ObjUtil.ifNotNull((Object)((IdCodeNameParam)appMap.get(t.getAppCode())), app -> t.setAppName(app.getName()));
            List valueList = (List)udcValueMap.get(t.getAppCode() + ":_:" + t.getUdcCode());
            if (CollUtil.isEmpty((Collection)valueList)) {
                t.setValueList(Collections.emptyList());
                return;
            }
            List<UdcWithValuesPageRespVO.UdcValue> valueRespList = valueList.stream().map(value -> {
                UdcWithValuesPageRespVO.UdcValue valueResp = new UdcWithValuesPageRespVO.UdcValue();
                valueResp.setUdcValueCode(value.getUdcValueCode());
                valueResp.setUdcValueName(CharSequenceUtil.blankToDefault((CharSequence)value.getValueAliasName(), (String)value.getUdcValueName()));
                valueResp.setUdcOrder(value.getUdcOrder());
                return valueResp;
            }).collect(Collectors.toList());
            t.setValueList(valueRespList);
        });
        return ApiResult.ok(pageData);
    }

    private SysUdcDTO.UdcValue valueBo2Dto(SysUdcValueBO valueBO) {
        SysUdcDTO.UdcValue value = new SysUdcDTO.UdcValue();
        value.setUdcValueCode(valueBO.getUdcValueCode());
        value.setUdcValueName(CharSequenceUtil.blankToDefault((CharSequence)valueBO.getValueAliasName(), (String)valueBO.getUdcValueName()));
        value.setUdcOrder((Integer)ObjectUtil.defaultIfNull((Object)valueBO.getUdcOrder(), (Object)0));
        value.setUdcValueDescribe(valueBO.getUdcValueDescribe());
        value.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)valueBO.getAllowStart(), (Object)true));
        value.setParentUdcValueCode(valueBO.getParentUdcValueCode());
        return value;
    }

    private SysUdcDTO udcBo2Dto(SysUdcBO udcBO) {
        SysUdcDTO udcDTO = new SysUdcDTO();
        udcDTO.setAppCode(udcBO.getAppCode());
        udcDTO.setUdcCode(udcBO.getUdcCode());
        udcDTO.setUdcName(udcBO.getUdcName());
        udcDTO.setUdcDescribe(udcBO.getUdcDescribe());
        udcDTO.setParentUdcCode(udcBO.getParentUdcCode());
        return udcDTO;
    }

    private SysUdcDTO bo2Dto(SysUdcBO udcBO, List<SysUdcValueBO> valueBoList) {
        SysUdcDTO udcDto = this.udcBo2Dto(udcBO);
        List valueDtoList = valueBoList.stream().map(this::valueBo2Dto).sorted(Comparator.comparingInt(SysUdcDTO.UdcValue::getUdcOrder)).collect(Collectors.toList());
        udcDto.setValueList(valueDtoList);
        return udcDto;
    }

    private List<SysUdcDTO> udcValue2Dto(List<SysUdcValueBO> valueBos) {
        if (CollectionUtils.isEmpty(valueBos)) {
            return Collections.emptyList();
        }
        ArrayList<SysUdcDTO> dtoList = new ArrayList<SysUdcDTO>(valueBos.size());
        Map<String, List<SysUdcValueBO>> udcAppCodeMap = valueBos.stream().collect(Collectors.groupingBy(SysUdcValueBO::getAppCode));
        for (Map.Entry<String, List<SysUdcValueBO>> appCodeEntry : udcAppCodeMap.entrySet()) {
            Map<String, List<SysUdcValueBO>> udcCodeMap = appCodeEntry.getValue().stream().collect(Collectors.groupingBy(SysUdcValueBO::getUdcCode));
            Map<String, SysUdcBO> udcBoMap = this.udcRepoProc.queryBoByUdcCode(appCodeEntry.getKey(), udcCodeMap.keySet()).stream().collect(Collectors.toMap(SysUdcBO::getUdcCode, t -> t, (t1, t2) -> t1));
            List udcDtoList = udcCodeMap.entrySet().stream().filter(t -> udcBoMap.containsKey(t.getKey())).map(t -> this.bo2Dto((SysUdcBO)udcBoMap.get(t.getKey()), (List)t.getValue())).collect(Collectors.toList());
            dtoList.addAll(udcDtoList);
        }
        return dtoList;
    }
}

