/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.el.coordinator.boot.fsm.service.FileService;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.AreaVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.core.support.verifycode.common.VerifyCodeManager;
import com.elitescloud.cloudt.security.common.InnerUserEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.convert.AreaConvert;
import com.elitescloud.cloudt.system.convert.UserConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UserTypeRespVO;
import com.elitescloud.cloudt.system.service.AreaQueryService;
import com.elitescloud.cloudt.system.service.manager.EmployeeOrgManager;
import com.elitescloud.cloudt.system.service.manager.EmployeeQueryManager;
import com.elitescloud.cloudt.system.service.manager.UserMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysUserTypeBO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantUserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserTypeRepoProc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

abstract class UserBaseServiceImpl
extends BaseServiceImpl {
    protected static final UserConvert CONVERT = UserConvert.INSTANCE;
    protected static final AreaConvert CONVERT_AREA = AreaConvert.INSTANCE;
    @Autowired
    protected UserRepoProc userRepoProc;
    @Autowired
    protected UserTypeRepoProc userTypeRepoProc;
    @Autowired
    protected TenantUserRepoProc tenantUserRepoProc;
    @Autowired
    protected OrgRepoProc orgRepoProc;
    @Autowired
    protected EmployeeRepoProc employeeRepoProc;
    @Autowired
    protected UserMngManager userManager;
    @Autowired
    protected VerifyCodeManager verifyCodeManager;
    @Autowired
    protected AreaQueryService areaQueryService;
    @Autowired
    protected EmployeeQueryManager employeeQueryManager;
    @Autowired
    protected EmployeeOrgManager employeeOrgManager;
    @Autowired(required=false)
    protected FileService fileService;

    UserBaseServiceImpl() {
    }

    protected Map<Long, List<UserTypeRespVO>> convertUserType(GeneralUserDetails currentUser, Set<Long> userIds) {
        Long tenantAdminId;
        Long tenantId = super.currentTenantId();
        Map<Long, List<SysUserTypeBO>> userTypeMap = this.userTypeRepoProc.getUserTypeBos(userIds, tenantId);
        if (userIds.contains(InnerUserEnum.ADMIN.getId())) {
            userTypeMap.computeIfAbsent(InnerUserEnum.ADMIN.getId(), t -> new ArrayList(4)).add(new SysUserTypeBO(UserType.ADMIN_SYSTEM.getValue()));
        }
        Long l = tenantAdminId = currentUser.getTenant() == null ? null : currentUser.getTenant().getSysUserId();
        if (tenantAdminId != null && userIds.contains(tenantAdminId)) {
            userTypeMap.computeIfAbsent(tenantAdminId, t -> new ArrayList(4)).add(new SysUserTypeBO(UserType.ADMIN_TENANT.getValue()));
        }
        if (userTypeMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map udcMap = super.udcMap((BaseUdc)new UserType());
        if (udcMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, List<UserTypeRespVO>> result = new HashMap<Long, List<UserTypeRespVO>>(userIds.size());
        for (Map.Entry<Long, List<SysUserTypeBO>> entry : userTypeMap.entrySet()) {
            List types = entry.getValue().stream().filter(t -> udcMap.containsKey(t.getUserType())).map(t -> new UserTypeRespVO(t.getUserType(), (String)udcMap.get(t.getUserType()), t.getIdentityId())).collect(Collectors.toList());
            result.put(entry.getKey(), types);
        }
        return result;
    }

    protected List<UserTypeRespVO> getUserType(long userId) {
        Long tenantId = super.currentTenantId();
        List<SysUserTypeBO> userTypeList = this.userTypeRepoProc.getUserTypeBO(userId, tenantId);
        if (userTypeList.isEmpty()) {
            return Collections.emptyList();
        }
        Map udcMap = super.udcMap((BaseUdc)new UserType());
        if (udcMap.isEmpty()) {
            return Collections.emptyList();
        }
        return userTypeList.stream().filter(t -> udcMap.containsKey(t.getUserType())).map(t -> new UserTypeRespVO(t.getUserType(), (String)udcMap.get(t.getUserType()), t.getIdentityId())).collect(Collectors.toList());
    }

    protected AreaVO convertAreaVO(SysUserDO userDo, Map<String, String> nameMap) {
        AreaVO areaVO = new AreaVO();
        areaVO.setCountryCode(userDo.getCountryCode());
        areaVO.setCountryName(nameMap.get(userDo.getCountryCode()));
        areaVO.setProvinceCode(userDo.getProvinceCode());
        areaVO.setProvinceName(nameMap.get(userDo.getProvinceCode()));
        areaVO.setCityCode(userDo.getCityCode());
        areaVO.setCityName(nameMap.get(userDo.getCityCode()));
        areaVO.setCountyCode(userDo.getCountyCode());
        areaVO.setCountyName(nameMap.get(userDo.getCountyCode()));
        return areaVO;
    }

    protected SysUserBasicDTO fillTenantUser(SysUserBasicDTO basic) {
        Boolean enabled;
        if (basic == null) {
            return null;
        }
        SysTenantDTO tenant = super.currentTenant();
        if (Boolean.TRUE.equals(basic.getEnabled()) && tenant != null && (enabled = this.tenantUserRepoProc.getEnabled((long)tenant.getId(), basic.getId())) != null) {
            basic.setEnabled(enabled);
        }
        return basic;
    }

    protected List<SysUserBasicDTO> fillTenantUser(List<SysUserBasicDTO> basicList) {
        if (CollUtil.isEmpty(basicList)) {
            return basicList;
        }
        SysTenantDTO tenant = super.currentTenant();
        if (tenant != null) {
            Set<Long> userIds = basicList.stream().map(SysUserBasicDTO::getId).collect(Collectors.toSet());
            Map<Long, Boolean> enabledMap = this.tenantUserRepoProc.getEnabled((long)tenant.getId(), userIds);
            for (SysUserBasicDTO basic : basicList) {
                basic.setEnabled(Boolean.valueOf(Boolean.TRUE.equals(basic.getEnabled()) && Boolean.TRUE.equals(enabledMap.get(basic.getId()))));
            }
        }
        return basicList;
    }
}

