/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.service.callback.UserChangedCallback;
import com.elitescloud.cloudt.system.service.manager.EmployeeMngManager;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysEmployeeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import java.io.Serializable;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class UserChangedCallbackEmployeeServiceImpl
implements UserChangedCallback {
    private static final Logger log = LoggerFactory.getLogger(UserChangedCallbackEmployeeServiceImpl.class);
    public static final String ATTRIBUTE_SOURCE = "cloudtSystemUserChanged";
    public static final String ATTRIBUTE_SOURCE_VALUE_EMPLOYEE = "employee";
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private EmployeeMngManager employeeMngManager;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TaskExecutor taskExecutor;

    public void onUpsert(boolean add, SysUserSaveBO saveBO, SysUserDO userDO) {
        if (this.fromEmployee()) {
            return;
        }
        this.detectTenant(() -> {
            SysEmployeeDO employeeDO = this.employeeRepoProc.getByUserId(userDO.getId()).orElse(null);
            if (employeeDO == null) {
                return null;
            }
            employeeDO.setUsername(userDO.getUsername());
            employeeDO.setLastName(userDO.getLastName());
            employeeDO.setFirstName(userDO.getFirstName());
            employeeDO.setGender(userDO.getGender());
            employeeDO.setNickName(userDO.getNickName());
            employeeDO.setBirthDate(userDO.getBirthDate());
            employeeDO.setMobile(userDO.getMobile());
            employeeDO.setEmail(userDO.getEmail());
            employeeDO.setIdCard(userDO.getIdCard());
            employeeDO.setCountryCode(userDO.getCountryCode());
            employeeDO.setProvinceCode(userDO.getProvinceCode());
            employeeDO.setCityCode(userDO.getCityCode());
            employeeDO.setCountyCode(userDO.getCountyCode());
            employeeDO.setAddress(userDO.getAddress());
            employeeDO.setPersonalSign(userDO.getPersonalSign());
            employeeDO.setAvatarUrl(userDO.getAvatarUrl());
            employeeDO.setAvatarCode(userDO.getAvatarCode());
            this.employeeRepoProc.save((Serializable)employeeDO);
            return null;
        });
    }

    public void onEnabled(Long userId, boolean enabled) {
        if (this.fromEmployee()) {
            return;
        }
        this.detectTenant(() -> {
            this.employeeRepoProc.updateEnabledByUserId(userId, enabled);
            return null;
        });
    }

    public void onUpdatePassword(Long userId, String password, String originalPassword) {
    }

    public void onUpdateMobile(Long userId, String mobile) {
    }

    public void onUpdateEmail(Long userId, String email) {
    }

    public void onDelete(Long userId, Long casUserIdLong) {
        if (this.fromEmployee()) {
            return;
        }
        this.detectTenant(() -> {
            this.employeeMngManager.deleteEmployeeByUser(userId);
            return null;
        });
    }

    private void detectTenant(Supplier<Void> supplier) {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        this.taskExecutor.execute(() -> {
            if (tenant == null) {
                this.tenantDataIsolateProvider.byAllTenant(supplier);
                return;
            }
            this.tenantDataIsolateProvider.byTenantDirectly(supplier, tenant);
        });
    }

    private boolean fromEmployee() {
        HttpServletRequest request = HttpServletUtil.currentRequest();
        if (request == null) {
            return false;
        }
        return ATTRIBUTE_SOURCE_VALUE_EMPLOYEE.equals(request.getAttribute(ATTRIBUTE_SOURCE));
    }
}

