/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.provider.AuthenticationService;
import com.elitescloud.boot.auth.provider.common.param.UserLoginDeviceDTO;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.BaseUdc;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.SysSendVerifyCodeVO;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.util.EncryptUtils;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.constant.UserType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.dto.req.UserCreateDTO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UserTypeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserDetailRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserPageRespVO;
import com.elitescloud.cloudt.system.model.vo.save.user.UserSaveVO;
import com.elitescloud.cloudt.system.param.SysPasswordUpdate;
import com.elitescloud.cloudt.system.service.UserMngService;
import com.elitescloud.cloudt.system.service.impl.UserBaseServiceImpl;
import com.elitescloud.cloudt.system.service.model.bo.SysUserSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysUserTypeBO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserTypeDO;
import com.elitescloud.cloudt.system.service.param.SysAccountUpdateParam;
import com.elitescloud.cloudt.system.service.param.SysPasswordUpdateParam;
import com.elitescloud.cloudt.system.service.param.SysUserAvatarUpdateParam;
import com.elitescloud.cloudt.system.service.param.SysVerifyCodeParam;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT, supportOperation=true)
@TenantOrgTransaction(useTenantOrg=false)
public class UserMngServiceImpl
extends UserBaseServiceImpl
implements UserMngService {
    private static final Logger log = LogManager.getLogger(UserMngServiceImpl.class);
    @Autowired
    private AuthenticationService authenticationService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(UserSaveVO saveVO) {
        SysUserSaveBO saveBo = CONVERT.vo2SaveBo(saveVO);
        saveBo.setAreaBO(CONVERT_AREA.vo2Bo(saveVO.getAreaVO()));
        if (saveVO.getUserTypes() == null) {
            saveBo.setUserTypes(this.queryUserTypes(saveVO.getId()));
        } else {
            saveBo.setUserTypes(saveVO.getUserTypes().stream().map(t -> new SysUserTypeBO(t.getType(), t.getIdentityId())).collect(Collectors.toSet()));
        }
        SysUserDO user = this.userManager.upsert(saveBo);
        return ApiResult.ok((Object)user.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> save(UserCreateDTO basicDTO) {
        SysUserSaveBO saveBo = CONVERT.dto2SaveBo(basicDTO);
        saveBo.setTerminals(basicDTO.getTerminalsAll());
        if (CollUtil.isEmpty((Collection)basicDTO.getUserTypesAll()) && CollUtil.isNotEmpty((Collection)basicDTO.getTypesAll())) {
            saveBo.setUserTypes(basicDTO.getTypesAll().stream().map(SysUserTypeBO::new).collect(Collectors.toSet()));
        }
        if (CollUtil.isEmpty((Collection)basicDTO.getUserTypesAdd()) && CollUtil.isNotEmpty((Collection)basicDTO.getTypesAdd())) {
            saveBo.setUserTypesAdd(basicDTO.getTypesAdd().stream().map(SysUserTypeBO::new).collect(Collectors.toSet()));
        }
        SysUserDO user = this.userManager.upsert(saveBo);
        Long userId = user.getId();
        return ApiResult.ok((Object)userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (!this.hasPermission(currentUser)) {
            return ApiResult.fail((String)"\u65e0\u6743\u9650");
        }
        Boolean enabled = null;
        enabled = !this.enabledTenant() || currentUser.isOperation() ? this.userRepoProc.getEnabled(id) : this.tenantUserRepoProc.getEnabled((long)currentUser.getTenantId(), id);
        enabled = enabled != null && enabled == false;
        this.userManager.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEnabled(Long id, Boolean enabled) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (enabled == null) {
            enabled = true;
        }
        this.userManager.updateEnabled(id, enabled);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> addUserType(Long id, String userType, String identityId) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isBlank((CharSequence)userType)) {
            return ApiResult.fail((String)"\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        this.userManager.updateUserType(id, userType, identityId);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> removeUserType(Long id, String userType, String identityId) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isBlank((CharSequence)userType)) {
            return ApiResult.fail((String)"\u8d26\u6237\u7c7b\u578b\u4e3a\u7a7a");
        }
        this.userManager.deleteUserType(id, userType, identityId);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<List<UserTypeRespVO>> listUserType(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        List<SysUserTypeDO> userTypeDoList = this.userTypeRepoProc.getUserTypeList(id, this.currentTenantId());
        if (userTypeDoList.isEmpty()) {
            return ApiResult.ok(Collections.emptyList());
        }
        Map userTypeUdcMap = super.udcMap((BaseUdc)new UserType());
        List userTypeList = userTypeDoList.stream().map(t -> {
            UserTypeRespVO vo = new UserTypeRespVO();
            vo.setType(t.getType());
            vo.setTypeName((String)userTypeUdcMap.get(t.getType()));
            vo.setIdentityId(t.getIdentityId());
            vo.setCreateTime(t.getCreateTime());
            return vo;
        }).collect(Collectors.toList());
        return ApiResult.ok(userTypeList);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updatePassword(Long id) {
        this.userManager.resetPassword(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updatePassword(Long id, String pwd) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        if (CharSequenceUtil.isBlank((CharSequence)pwd)) {
            this.userManager.resetPassword(id);
        } else {
            this.userManager.updatePassword(id, pwd, null, true);
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<Long> updatePassword(SysPasswordUpdate passwordUpdate) {
        if (passwordUpdate.getUserId() == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        String currentPassword = passwordUpdate.getCurrentPassword();
        if (CharSequenceUtil.isBlank((CharSequence)currentPassword)) {
            return ApiResult.fail((String)"\u5f53\u524d\u5bc6\u7801\u4e3a\u7a7a");
        }
        try {
            currentPassword = EncryptUtils.decodeBase64((String)currentPassword);
        }
        catch (UnsupportedEncodingException e) {
            log.info("\u89e3\u5bc6\u5f53\u524d\u5bc6\u7801\u5f02\u5e38\uff1a{}", (Object)currentPassword, (Object)e);
            throw new BusinessException("\u539f\u59cb\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u52a0\u5bc6\u9519\u8bef");
        }
        String newPassword = passwordUpdate.getNewPassword();
        if (CharSequenceUtil.isBlank((CharSequence)newPassword)) {
            return ApiResult.fail((String)"\u65b0\u5bc6\u7801\u4e3a\u7a7a");
        }
        try {
            newPassword = EncryptUtils.decodeBase64((String)newPassword);
        }
        catch (UnsupportedEncodingException e) {
            log.info("\u89e3\u5bc6\u65b0\u5bc6\u7801\u5f02\u5e38\uff1a{}", (Object)newPassword, (Object)e);
            throw new BusinessException("\u65b0\u5bc6\u7801\u52a0\u5bc6\u9519\u8bef");
        }
        this.userManager.updatePassword(passwordUpdate.getUserId(), newPassword, currentPassword, false);
        return ApiResult.ok((Object)passwordUpdate.getUserId());
    }

    @Override
    public ApiResult<String> sendVerifyCodeForUpdatePassword(SysSendVerifyCodeVO verifyCodeParam) {
        String verifyCode = this.verifyCodeManager.send("cloudt_system_update_pwd", verifyCodeParam);
        if (CharSequenceUtil.isNotBlank((CharSequence)verifyCode)) {
            return ApiResult.ok((Object)("\u6d4b\u8bd5\u6a21\u5f0f\u9a8c\u8bc1\u7801\uff1a" + verifyCode));
        }
        return ApiResult.ok();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updatePasswordByVerifyCode(SysPasswordUpdateParam updateParam) {
        String verifyMsg = this.verifyCodeManager.verify("cloudt_system_update_pwd", updateParam.getAccount(), updateParam.getVerifyCode());
        if (verifyMsg != null) {
            return ApiResult.fail((String)verifyMsg);
        }
        String accountType = CharSequenceUtil.blankToDefault((CharSequence)updateParam.getAccountType(), (String)"mobile");
        List<Long> userIdList = null;
        switch (accountType) {
            case "mobile": {
                userIdList = this.userRepoProc.getIdByMobile(updateParam.getAccount());
                break;
            }
            case "email": {
                userIdList = this.userRepoProc.getIdByEmail(updateParam.getAccount());
                break;
            }
            default: {
                return ApiResult.fail((String)"\u8d26\u53f7\u7c7b\u578b\u4e0d\u652f\u6301");
            }
        }
        if (userIdList.isEmpty()) {
            return ApiResult.fail((String)("\u672a\u67e5\u8be2\u5230\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4" + this.convertAccountType(accountType) + "\u6b63\u786e"));
        }
        if (userIdList.size() > 1) {
            return ApiResult.fail((String)"\u67e5\u8be2\u5230\u591a\u6761\u8d26\u53f7\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        Long userId = userIdList.get(0);
        this.userManager.updatePassword(userId, updateParam.getPassword(), null, false);
        return ApiResult.ok((Object)userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateMobile(Long id, String mobile) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        this.userManager.updateMobile(id, mobile);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateEmail(Long id, String email) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        this.userManager.updateEmail(id, email);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<Long> updateOuterKey(Long id, String outerKey) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        this.userManager.updateOuterKey(id, outerKey);
        return ApiResult.ok((Object)id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateLastLoginTime(Long id, Long tenantId, LocalDateTime lastLoginTime) {
        Assert.notNull((Object)id, (String)"\u7528\u6237ID\u4e3a\u7a7a");
        this.userRepoProc.updateLoginTime(id, lastLoginTime);
        if (tenantId != null) {
            this.tenantUserRepoProc.updateLoginTime(id, tenantId, lastLoginTime);
        }
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<String> sendVerifyCodeForUpdateAccount(SysSendVerifyCodeVO verifyCodeParam) {
        String accountType = CharSequenceUtil.blankToDefault((CharSequence)verifyCodeParam.getAccountType(), (String)"mobile");
        String verifyCode = null;
        switch (accountType) {
            case "mobile": {
                verifyCode = this.verifyCodeManager.send("cloudt_system_update_mobile", verifyCodeParam);
                break;
            }
            case "email": {
                verifyCode = this.verifyCodeManager.send("cloudt_system_update_email", verifyCodeParam);
                break;
            }
            default: {
                return ApiResult.fail((String)"\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b");
            }
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)verifyCode)) {
            return ApiResult.ok((Object)("\u6d4b\u8bd5\u6a21\u5f0f\u9a8c\u8bc1\u7801\uff1a" + verifyCode));
        }
        return ApiResult.ok();
    }

    @Override
    public ApiResult<String> verifyCodeForUpdateAccount(SysVerifyCodeParam codeParam) {
        String accountType = CharSequenceUtil.blankToDefault((CharSequence)codeParam.getAccountType(), (String)"mobile");
        String verifyMsg = null;
        switch (accountType) {
            case "mobile": {
                verifyMsg = this.verifyCodeManager.verify("cloudt_system_update_mobile", codeParam.getAccount(), codeParam.getVerifyCode());
                break;
            }
            case "email": {
                verifyMsg = this.verifyCodeManager.verify("cloudt_system_update_email", codeParam.getAccount(), codeParam.getVerifyCode());
                break;
            }
            default: {
                return ApiResult.fail((String)"\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b");
            }
        }
        if (verifyMsg != null) {
            return ApiResult.fail((String)verifyMsg);
        }
        String verifyId = UUID.fastUUID().toString();
        this.redisUtils.set(verifyId, (Object)verifyId, 30L, TimeUnit.MINUTES);
        return ApiResult.ok((Object)verifyId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateAccountByVerifyCode(SysAccountUpdateParam updateParam) {
        Long userId;
        String accountType = CharSequenceUtil.blankToDefault((CharSequence)updateParam.getAccountType(), (String)"mobile");
        String verifyMsg = null;
        switch (accountType) {
            case "mobile": {
                verifyMsg = this.verifyCodeManager.verify("cloudt_system_update_mobile", updateParam.getAccount(), updateParam.getVerifyCode());
                break;
            }
            case "email": {
                verifyMsg = this.verifyCodeManager.verify("cloudt_system_update_email", updateParam.getAccount(), updateParam.getVerifyCode());
                break;
            }
            default: {
                return ApiResult.fail((String)"\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b");
            }
        }
        if (verifyMsg != null) {
            return ApiResult.fail((String)verifyMsg);
        }
        String verifyId = (String)this.redisUtils.get(updateParam.getVerifyId());
        if (!CharSequenceUtil.equals((CharSequence)updateParam.getVerifyId(), (CharSequence)verifyId)) {
            return ApiResult.fail((String)"\u6821\u9a8c\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u9a8c\u8bc1\u4e4b\u524d\u7684\u624b\u673a\u53f7");
        }
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        Long l = userId = user == null ? null : user.getUser().getId();
        if (userId == null) {
            return ApiResult.fail((String)"\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        if (CharSequenceUtil.isBlank((CharSequence)updateParam.getAccountType())) {
            return ApiResult.fail((String)"\u8d26\u53f7\u7c7b\u578b\u4e3a\u7a7a");
        }
        List<Long> existsUserIdList = null;
        switch (updateParam.getAccountType()) {
            case "mobile": {
                existsUserIdList = this.userRepoProc.getIdByMobile(updateParam.getAccount());
                break;
            }
            case "email": {
                existsUserIdList = this.userRepoProc.getIdByEmail(updateParam.getAccount());
                break;
            }
            default: {
                return ApiResult.fail((String)"\u8d26\u53f7\u7c7b\u578b\u4e0d\u652f\u6301");
            }
        }
        if (!existsUserIdList.isEmpty()) {
            if (existsUserIdList.size() == 1) {
                if (existsUserIdList.get(0).longValue() == userId.longValue()) {
                    return ApiResult.ok();
                }
                return ApiResult.fail((String)("\u8be5" + this.convertAccountType(updateParam.getAccountType()) + "\u5df2\u88ab\u5176\u5b83\u7528\u6237\u7ed1\u5b9a"));
            }
            return ApiResult.fail((String)("\u8be5" + this.convertAccountType(updateParam.getAccountType()) + "\u5df2\u88ab\u5176\u5b83\u7528\u6237\u7ed1\u5b9a"));
        }
        switch (updateParam.getAccountType()) {
            case "mobile": {
                this.userRepoProc.updateMobile(userId, updateParam.getAccount());
                break;
            }
            case "email": {
                this.userRepoProc.updateEmail(userId, updateParam.getAccount());
                break;
            }
            default: {
                return ApiResult.fail((String)"\u8d26\u53f7\u7c7b\u578b\u4e0d\u652f\u6301");
            }
        }
        return ApiResult.ok((Object)userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> updateAvatar(SysUserAvatarUpdateParam updateParam) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (this.fileService == null) {
            return ApiResult.fail((String)"\u672a\u542f\u7528\u6587\u4ef6\u670d\u52a1");
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)updateParam.getAvatarCode()) && !this.fileService.existsAll(updateParam.getAvatarCode()).isSuccess()) {
            return ApiResult.fail((String)"\u672a\u627e\u5230\u5934\u50cf\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20");
        }
        Long userId = currentUser.getUser().getId();
        this.userRepoProc.updateAvatar(userId, updateParam.getAvatarUrl(), updateParam.getAvatarCode());
        return ApiResult.ok((Object)userId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Boolean> clearCasUserId(List<Long> ids) {
        this.userRepoProc.clearCasUserId(ids);
        return ApiResult.ok((Object)true);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ApiResult<Long> delete(Long id) {
        this.userManager.delete(id);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<UserDetailRespVO> get(Long id) {
        Map areaNameMap;
        Set<String> areaCodes;
        Boolean enabled;
        SysUserDO userDO = (SysUserDO)this.userRepoProc.get(id);
        if (userDO == null) {
            return ApiResult.noData();
        }
        UserDetailRespVO respVO = CONVERT.doToDetailRespVo(userDO);
        respVO.setFullName(userDO.getFullName());
        respVO.setGenderName(userDO.getGenderName());
        SysTenantDTO tenant = super.currentTenant();
        if (tenant != null && (enabled = this.tenantUserRepoProc.getEnabled((long)tenant.getId(), id)) != null) {
            respVO.setEnabled(enabled);
        }
        if (!(areaCodes = Stream.of(userDO.getProvinceCode(), userDO.getCityCode(), userDO.getCountyCode()).filter(StringUtils::hasText).collect(Collectors.toSet())).isEmpty() && (areaNameMap = (Map)this.areaQueryService.queryNamesByAreaCode(areaCodes).getData()) != null && !areaNameMap.isEmpty()) {
            respVO.setAreaVO(this.convertAreaVO(userDO, areaNameMap));
        }
        respVO.setUserTypes(this.getUserType(id));
        return ApiResult.ok((Object)respVO);
    }

    @Override
    public ApiResult<PagingVO<UserPageRespVO>> page(UserPageQueryVO queryVO) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        if (!this.hasPermission(currentUser)) {
            return ApiResult.fail((String)"\u65e0\u6743\u9650");
        }
        PagingVO<SysUserDO> userPage = this.userRepoProc.pageMng(currentUser, queryVO);
        if (userPage.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        Set<Long> userIds = userPage.getRecords().stream().map(BaseModel::getId).collect(Collectors.toSet());
        Map<Long, List<UserTypeRespVO>> userTypeMap = this.convertUserType(currentUser, userIds);
        PagingVO userVoPage = userPage.map(t -> {
            UserPageRespVO vo = CONVERT.doToPageRespVo((SysUserDO)t);
            vo.setFullName(t.getFullName());
            vo.setGenderName(new Gender(t.getGender()).getDescription());
            vo.setSourceName(new UserSourceType(t.getSourceType()).getDescription());
            List userTypes = (List)userTypeMap.get(t.getId());
            if (CollUtil.isNotEmpty((Collection)userTypes)) {
                vo.setUserTypes(userTypes.stream().map(UserTypeRespVO::getType).collect(Collectors.toList()));
                vo.setUserTypeNames(userTypes.stream().map(UserTypeRespVO::getTypeName).collect(Collectors.toList()));
                vo.setUserTypeIds(userTypes.stream().map(tt -> CharSequenceUtil.blankToDefault((CharSequence)tt.getIdentityId(), (String)"")).collect(Collectors.toList()));
            }
            return vo;
        });
        if (this.enabledTenant() && !currentUser.isOperation()) {
            Map<Long, SysTenantUserDO> tenantUserMap = this.tenantUserRepoProc.listByUserIds(currentUser.getTenantId(), userIds).stream().collect(Collectors.toMap(SysTenantUserDO::getSysUserId, t -> t, (t1, t2) -> t1));
            userVoPage.each(t -> {
                SysTenantUserDO tenantUser = (SysTenantUserDO)tenantUserMap.get(t.getId());
                if (tenantUser == null) {
                    return;
                }
                t.setLastLoginTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)tenantUser.getLastLoginTime(), (Object)t.getLastLoginTime()));
                t.setExpiredTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)tenantUser.getExpiredTime(), (Object)t.getExpiredTime()));
                t.setEnabled(Boolean.TRUE.equals(tenantUser.getEnabled()));
                t.setCreateTime(tenantUser.getBindTime());
                SysTenantDTO tenant = currentUser.getTenant();
                t.setTenants(tenant == null ? Collections.emptyList() : List.of(new IdCodeNameParam(tenant.getId(), tenant.getTenantCode(), tenant.getTenantName())));
            });
        } else {
            Map<Long, List<IdCodeNameParam>> tenantMap = this.tenantUserRepoProc.getTenantsOfUser(userIds);
            userVoPage.each(t -> t.setTenants(tenantMap.getOrDefault(t.getId(), Collections.emptyList())));
        }
        return ApiResult.ok((Object)userVoPage);
    }

    @Override
    public ApiResult<List<UserLoginDeviceDTO>> userOnlineDevice(Long userId) {
        return this.authenticationService.userOnlineDevice(userId);
    }

    @Override
    public ApiResult<Boolean> expiredUserOnlineDevice(Long userId, String clientId) {
        return this.authenticationService.expiredUserOnlineDevice(userId, clientId);
    }

    @Override
    public ApiResult<Integer> onlineUserNum() {
        String key = "cloudt:current_user:*";
        Set keys = this.redisUtils.getRedisTemplate().keys((Object)key);
        return ApiResult.ok((Object)keys.size());
    }

    @Override
    public ApiResult<Integer> expiredAllOnlineUser() {
        String key = "cloudt:current_user:*";
        Set keys = this.redisUtils.getRedisTemplate().keys((Object)key);
        this.redisUtils.getRedisTemplate().delete((Collection)keys);
        return ApiResult.ok((Object)keys.size());
    }

    private Set<SysUserTypeBO> queryUserTypes(Long userId) {
        if (userId == null) {
            return Collections.emptySet();
        }
        Long tenantId = super.currentTenantId();
        return new HashSet<SysUserTypeBO>(this.userTypeRepoProc.getUserTypeBO(userId, tenantId));
    }

    private boolean hasPermission(GeneralUserDetails currentUser) {
        if (currentUser == null) {
            return false;
        }
        return currentUser.isOperation() || currentUser.isTenantAdmin() || currentUser.isTenantOrgAdmin();
    }

    private String convertAccountType(String accountType) {
        switch (accountType) {
            case "mobile": {
                return "\u624b\u673a\u53f7";
            }
            case "email": {
                return "\u90ae\u7bb1";
            }
        }
        throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u8d26\u53f7\u7c7b\u578b");
    }
}

