/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.IdNameParam;
import com.elitescloud.boot.constant.Gender;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.spi.common.ServiceProviderLoader;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.constant.OrgType;
import com.elitescloud.cloudt.system.constant.UserSourceType;
import com.elitescloud.cloudt.system.convert.UserConvert;
import com.elitescloud.cloudt.system.convert.old.SysUserConvert;
import com.elitescloud.cloudt.system.dto.SysOuBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.dto.SysUserType;
import com.elitescloud.cloudt.system.dto.SysUserTypeDTO;
import com.elitescloud.cloudt.system.dto.req.UserQueryDTO;
import com.elitescloud.cloudt.system.model.bo.UserOrgBO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserListQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.user.UserQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmpOrgRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.UserTypeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserListRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.user.UserQueryRespVO;
import com.elitescloud.cloudt.system.service.EmployeeQueryService;
import com.elitescloud.cloudt.system.service.SysUserTerminalService;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.impl.UserBaseServiceImpl;
import com.elitescloud.cloudt.system.service.manager.OuQueryManager;
import com.elitescloud.cloudt.system.service.manager.PermissionQueryManager;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.spi.SysUserLoginSpi;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT, supportOperation=true)
@TenantOrgTransaction(useTenantOrg=false)
public class UserQueryServiceImpl
extends UserBaseServiceImpl
implements UserQueryService {
    private static final Logger log = LogManager.getLogger(UserQueryServiceImpl.class);
    private static final UserConvert CONVERT = UserConvert.INSTANCE;
    @Autowired
    private PermissionQueryManager permissionQueryManager;
    @Autowired
    private OuQueryManager ouQueryManager;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private EmployeeQueryService employeeQueryService;
    @Autowired
    private SysUserTerminalService userTerminalService;
    private AtomicBoolean userLoginSpiLoaded = new AtomicBoolean(false);
    private List<SysUserLoginSpi> userLoginSpiList = new ArrayList<SysUserLoginSpi>();

    @Override
    public ApiResult<Long> getIdByUsername(String username) {
        if (StrUtil.isBlank((CharSequence)username)) {
            return ApiResult.fail((String)"\u8d26\u53f7\u4e3a\u7a7a");
        }
        Long id = this.userRepoProc.getIdByUsername(username);
        return ApiResult.ok((Object)id);
    }

    @Override
    public ApiResult<Boolean> existsUsername(String username) {
        if (StrUtil.isBlank((CharSequence)username)) {
            return ApiResult.fail((String)"\u8d26\u53f7\u4e3a\u7a7a");
        }
        boolean exists = this.userRepoProc.existsUsername(username);
        return ApiResult.ok((Object)exists);
    }

    @Override
    public ApiResult<Boolean> existsMobile(String mobile) {
        if (StrUtil.isBlank((CharSequence)mobile)) {
            return ApiResult.fail((String)"\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        boolean exists = this.userRepoProc.existsMobile(mobile);
        return ApiResult.ok((Object)exists);
    }

    @Override
    public ApiResult<Boolean> existsEmail(String email) {
        if (StrUtil.isBlank((CharSequence)email)) {
            return ApiResult.fail((String)"\u90ae\u7bb1\u4e3a\u7a7a");
        }
        boolean exists = this.userRepoProc.existsEmail(email);
        return ApiResult.ok((Object)exists);
    }

    @Override
    public ApiResult<Boolean> existsOuterKey(String outerKey) {
        if (StrUtil.isBlank((CharSequence)outerKey)) {
            return ApiResult.fail((String)"\u5916\u90e8\u6807\u8bc6\u4e3a\u7a7a");
        }
        boolean exists = this.userRepoProc.existsOuterKey(outerKey);
        return ApiResult.ok((Object)exists);
    }

    @Override
    public ApiResult<SysUserBasicDTO> getBasicById(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u7528\u6237ID\u4e3a\u7a7a");
        }
        SysUserDO userDO = (SysUserDO)this.userRepoProc.get(id);
        if (userDO == null) {
            return ApiResult.ok();
        }
        SysUserBasicDTO basic = CONVERT.do2Basic(userDO);
        super.fillTenantUser(basic);
        return ApiResult.ok((Object)basic);
    }

    @Override
    public ApiResult<SysUserBasicDTO> getBasicByUsername(String username) {
        if (CharSequenceUtil.isBlank((CharSequence)username)) {
            return ApiResult.fail((String)"\u767b\u5f55\u53f7\u4e3a\u7a7a");
        }
        SysUserDO userDO = this.userRepoProc.getByUsername(username);
        if (userDO == null) {
            return ApiResult.ok();
        }
        SysUserBasicDTO basic = CONVERT.do2Basic(userDO);
        super.fillTenantUser(basic);
        return ApiResult.ok((Object)basic);
    }

    @Override
    public ApiResult<List<SysUserBasicDTO>> getBasicById(List<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.ok(Collections.emptyList());
        }
        List<SysUserBasicDTO> userList = this.userRepoProc.get(ids).stream().map(CONVERT::do2Basic).collect(Collectors.toList());
        super.fillTenantUser(userList);
        return ApiResult.ok(userList);
    }

    @Override
    public ApiResult<List<SysUserBasicDTO>> queryUser(UserQueryDTO queryParam) {
        List<SysUserBasicDTO> userList = this.userRepoProc.queryBasicDto(queryParam);
        super.fillTenantUser(userList);
        return ApiResult.ok(userList);
    }

    @Override
    public ApiResult<PagingVO<UserQueryRespVO>> pageQuery(UserQueryVO queryVO) {
        GeneralUserDetails currentUser = super.currentUser(true);
        if (queryVO.getRoleId() != null) {
            Set roleUserIds = (Set)this.tenantDataIsolateProvider.byTenantAuto(() -> this.permissionQueryManager.queryUserIdOfRole(queryVO.getRoleId()));
            if (roleUserIds.isEmpty()) {
                return ApiResult.ok((Object)PagingVO.empty());
            }
            queryVO.setIdSet(new LinkedHashSet(roleUserIds));
        }
        Long tenantId = super.currentTenantId();
        UserPageQueryVO pageQueryVO = this.convertPageQueryVO(queryVO);
        PagingVO<SysUserDO> userPage = this.userRepoProc.pageQuery(currentUser, pageQueryVO);
        if (userPage.isEmpty()) {
            return ApiResult.ok((Object)PagingVO.empty());
        }
        Set<Long> userIds = userPage.getRecords().stream().map(BaseModel::getId).collect(Collectors.toSet());
        Map<Long, List<UserTypeRespVO>> userTypeMap = this.convertUserType(currentUser, userIds);
        Map userOrgMap = Boolean.TRUE.equals(queryVO.getWithOrg()) ? (Map)this.tenantDataIsolateProvider.byTenantAuto(() -> this.employeeQueryManager.getEmployeeOrgsByUserIds(userIds)) : Collections.emptyMap();
        PagingVO userVoPage = userPage.map(t -> {
            List userOrgs;
            UserQueryRespVO vo = CONVERT.doToQueryRespVo((SysUserDO)t);
            vo.setFullName(t.getFullName());
            vo.setGenderName(new Gender(t.getGender()).getDescription());
            vo.setSourceName(new UserSourceType(t.getSourceType()).getDescription());
            List userTypes = (List)userTypeMap.get(t.getId());
            if (CollUtil.isNotEmpty((Collection)userTypes)) {
                vo.setUserTypes(userTypes.stream().map(UserTypeRespVO::getType).collect(Collectors.toList()));
                vo.setUserTypeNames(userTypes.stream().map(UserTypeRespVO::getTypeName).collect(Collectors.toList()));
            }
            vo.setOrgList((userOrgs = (List)userOrgMap.get(t.getId())) == null ? Collections.emptyList() : userOrgs.stream().map(o -> {
                EmpOrgRespVO org = new EmpOrgRespVO();
                org.setDetails(userOrgs);
                return org;
            }).collect(Collectors.toList()));
            return vo;
        });
        if (!((Boolean)ObjectUtil.defaultIfNull((Object)queryVO.getAllTenant(), (Object)false)).booleanValue() && this.enabledTenant()) {
            Map<Long, SysTenantUserDO> tenantUserMap = this.tenantUserRepoProc.listByUserIds(tenantId, userIds).stream().collect(Collectors.toMap(SysTenantUserDO::getSysUserId, t -> t, (t1, t2) -> t1));
            userVoPage.each(t -> {
                SysTenantUserDO tenantUser = (SysTenantUserDO)tenantUserMap.get(t.getId());
                if (tenantUser == null) {
                    return;
                }
                t.setLastLoginTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)tenantUser.getLastLoginTime(), (Object)t.getLastLoginTime()));
                t.setExpiredTime((LocalDateTime)ObjectUtil.defaultIfNull((Object)tenantUser.getExpiredTime(), (Object)t.getExpiredTime()));
                t.setEnabled(Boolean.TRUE.equals(t.getEnabled()) && Boolean.TRUE.equals(tenantUser.getEnabled()));
                t.setCreateTime(tenantUser.getBindTime());
            });
        }
        return ApiResult.ok((Object)userVoPage);
    }

    @Override
    public ApiResult<List<UserListRespVO>> listUser(UserListQueryVO queryVO) {
        List<UserListRespVO> userList = this.userRepoProc.queryUser(queryVO);
        return ApiResult.ok(userList);
    }

    @Override
    public ApiResult<List<IdNameParam>> queryUserName(Set<Long> ids) {
        if (CollUtil.isEmpty(ids)) {
            return ApiResult.fail((String)"ID\u4e3a\u7a7a");
        }
        List<IdNameParam> userNames = this.userRepoProc.queryUserName(ids);
        return ApiResult.ok(userNames);
    }

    @Override
    public ApiResult<List<SysUserTypeDTO>> getUserTypes(Long id) {
        if (id == null) {
            return ApiResult.fail((String)"\u8d26\u53f7ID\u4e3a\u7a7a");
        }
        Long tenantId = super.currentTenantId();
        List userTypeList = this.userTypeRepoProc.getUserTypeList(id, tenantId).stream().map(t -> {
            SysUserTypeDTO dto = new SysUserTypeDTO();
            dto.setUserType(t.getType());
            dto.setIdentityId(t.getIdentityId());
            return dto;
        }).collect(Collectors.toList());
        return ApiResult.ok(userTypeList);
    }

    @Override
    public SysUserDTO getUserByUsername(String username) {
        return this.queryUserDtoOne(() -> {
            SysUserDO user = this.userRepoProc.getByUsername(username);
            return user == null ? Collections.emptyList() : List.of(user);
        }, users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u7528\u6237\u540d");
        });
    }

    @Override
    public SysUserDTO getUserByMobile(String mobile) {
        return this.queryUserDtoOne(() -> this.userRepoProc.queryByMobile(mobile), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u624b\u673a\u53f7");
        });
    }

    @Override
    public SysUserDTO getUserByEmail(String email) {
        return this.queryUserDtoOne(() -> this.userRepoProc.queryByEmail(email), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u90ae\u7bb1");
        });
    }

    @Override
    public SysUserDTO getUserById(Long id) {
        return this.queryUserDtoOne(() -> {
            SysUserDO user = (SysUserDO)this.userRepoProc.get(id);
            return user == null ? Collections.emptyList() : List.of(user);
        }, users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u7528\u6237ID");
        });
    }

    @Override
    public SysUserDTO getUserByAccount(String account) {
        return this.queryUserDtoOne(() -> this.userRepoProc.queryByAccount(account), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u8d26\u53f7");
        });
    }

    @Override
    public SysUserDTO getUserByWechatOpenid(String wechatOpenid) {
        return this.getUserByOpenId(null, wechatOpenid);
    }

    @Override
    public SysUserDTO getUserByOpenId(String appId, String openId) {
        return this.queryUserDtoOne(() -> this.userRepoProc.queryByOpenId(appId, openId), users -> {
            throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u8d26\u53f7");
        });
    }

    private SysUserDTO queryUserDtoOne(Supplier<List<SysUserDO>> usersSupplier, Function<List<SysUserDO>, SysUserDO> duplicateStrategy) {
        List users = usersSupplier.get().stream().filter(p -> p.getDeleteFlag() == null || p.getDeleteFlag() == 0).collect(Collectors.toList());
        if (users.isEmpty()) {
            return null;
        }
        if (users.size() == 1) {
            return this.wrapUserDetail((SysUserDO)users.get(0));
        }
        SysUserDO userDto = duplicateStrategy.apply(users);
        return this.wrapUserDetail(userDto);
    }

    private SysUserDTO wrapUserDetail(SysUserDO sysUserDO) {
        if (sysUserDO == null) {
            return null;
        }
        SysUserDTO user = SysUserConvert.INSTANCE.doToDto(sysUserDO);
        this.expendUserInfoBySpi(user);
        Long tenantId = (Long)ObjectUtil.defaultIfNull((Object)user.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID);
        List userTypeList = this.userTypeRepoProc.getUserTypeBO(user.getId(), tenantId).stream().map(t -> new SysUserType(t.getUserType(), t.getIdentityId())).collect(Collectors.toList());
        user.setUserTypeList(userTypeList);
        this.tenantDataIsolateProvider.byTenantUser(() -> {
            this.wrapIsolatedData(user);
            return null;
        }, user);
        log.info("\u767b\u5f55\u7528\u6237\uff1a{}", (Object)user);
        return user;
    }

    private void wrapIsolatedData(SysUserDTO user) {
        ApiResult userTerminal;
        IdCodeNameParam employee;
        this.fillUserOrg(user);
        if (user.getOrg() != null) {
            SysOuBasicDTO ou;
            if (Boolean.TRUE.equals(this.systemProperties.getUseCompanyOrgAsOu())) {
                IdCodeNameParam company = this.orgRepoProc.queryParentNameForType(List.of(user.getOrg().getId()), OrgType.COMPANY.getValue(), true).get(user.getOrg().getId());
                if (company != null) {
                    user.setOuId(company.getId());
                    user.setOuCode(company.getCode());
                    user.setOuName(company.getName());
                }
            } else if (user.getOrg().getOuId() != null && (ou = this.ouQueryManager.getOuBasicDTO(user.getOrg().getOuId())) != null && Boolean.TRUE.equals(ou.getEnabled())) {
                user.setOuId(ou.getId());
                user.setOuCode(ou.getOuCode());
                user.setOuName(ou.getOuName());
            }
        }
        if ((employee = this.employeeRepoProc.getEmployeeNameByUserId(user.getId(), true)) != null) {
            user.setEmployeeId(employee.getId());
            user.setEmployeeCode(employee.getCode());
        }
        Set<String> roleCodes = this.permissionQueryManager.queryRoleByUser(user);
        user.setRoleCodes(roleCodes);
        if (employee != null) {
            List underlingList = (List)this.employeeQueryService.getUnderlingId(employee.getId()).computeData();
            user.setUnderlingList(underlingList);
        }
        if (CollUtil.isNotEmpty((Collection)((Collection)(userTerminal = this.userTerminalService.getByUser(user.getId())).getData()))) {
            user.setTerminals((List)userTerminal.getData());
        }
    }

    private void fillUserOrg(SysUserDTO user) {
        UserOrgBO userOrg = this.employeeOrgManager.queryOrgByUser(user.getId());
        user.setOrgList(userOrg.getOrgList());
        user.setOrg(userOrg.getOrg());
        user.setTenantOrg(userOrg.getTenantOrg());
        user.setTenantOrgAdminId(userOrg.getTenantOrgAdminId());
        if (user.getOrg() != null) {
            IdCodeNameParam position = this.employeeOrgManager.getPositionOfUser(user.getId(), user.getOrg().getId());
            user.setPosition(position);
        }
    }

    private void expendUserInfoBySpi(SysUserDTO userDetails) {
        if (this.userLoginSpiLoaded.compareAndSet(false, true)) {
            this.userLoginSpiList = ServiceProviderLoader.loadProviderInstances(SysUserLoginSpi.class);
        }
        if (this.userLoginSpiList.isEmpty()) {
            log.info("\u6682\u65e0\u767b\u5f55\u6269\u5c55\u5b9e\u73b0");
            return;
        }
        for (SysUserLoginSpi spi : this.userLoginSpiList) {
            log.info("\u3010{}\u3011SPI\u8c03\u7528...", (Object)spi.getServiceName());
            spi.expendLoginUserInfo(userDetails);
        }
    }

    private UserPageQueryVO convertPageQueryVO(UserQueryVO queryVO) {
        UserPageQueryVO pageQueryVO = new UserPageQueryVO();
        pageQueryVO.setAllTenant(queryVO.getAllTenant());
        pageQueryVO.setUsername(queryVO.getUsername());
        pageQueryVO.setFullName(queryVO.getFullName());
        pageQueryVO.setMobile(queryVO.getMobile());
        pageQueryVO.setEmail(queryVO.getEmail());
        pageQueryVO.setIncludeSelf(queryVO.getIncludeSelf());
        pageQueryVO.setUserType(queryVO.getUserType());
        pageQueryVO.setUserTypeList(queryVO.getUserTypeList());
        pageQueryVO.setOrders(queryVO.getOrders());
        pageQueryVO.setKeyword(queryVO.getKeyword());
        pageQueryVO.setEnabled(queryVO.getEnabled());
        pageQueryVO.setCurrent(queryVO.getCurrent() + 1);
        pageQueryVO.setSize(queryVO.getSize());
        pageQueryVO.setIdSet(queryVO.getIdSet());
        return pageQueryVO;
    }
}

