/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.boot.provider.TenantOrgDataIsolateProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.platform.service.repo.MenuOperationRepoProc;
import com.elitescloud.cloudt.security.common.InnerUserEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.bo.MasterUserBO;
import com.elitescloud.cloudt.system.service.common.constant.SubUserPermissionTypeEnum;
import com.elitescloud.cloudt.system.service.manager.UserQueryManager;
import com.elitescloud.cloudt.system.service.model.bo.AppBO;
import com.elitescloud.cloudt.system.service.repo.AppRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRefRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessObjectRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessOperationRepoProc;
import com.elitescloud.cloudt.system.service.repo.BusinessParamRepoProc;
import com.elitescloud.cloudt.system.service.repo.MenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.PermissionResRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleDataPermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleFieldPermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRoleRepoProc;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

abstract class BasePermissionManager {
    @Autowired
    protected AppRepoProc appRepoProc;
    @Autowired
    protected MenuRepoProc menuRepoProc;
    @Autowired
    protected MenuOperationRepoProc menuOperationRepoProc;
    @Autowired
    protected RoleDataPermissionRepoProc dataPermissionRepoProc;
    @Autowired
    protected RoleFieldPermissionRepoProc fieldPermissionRepoProc;
    @Autowired
    protected BusinessObjectRepoProc businessObjectRepoProc;
    @Autowired
    protected BusinessOperationRepoProc businessOperationRepoProc;
    @Autowired
    protected BusinessObjectRefRepoProc refRepoProc;
    @Autowired
    protected BusinessParamRepoProc businessParamRepoProc;
    @Autowired
    protected RoleRepoProc roleRepoProc;
    @Autowired
    protected UserRoleRepoProc userRoleRepoProc;
    @Autowired
    protected PermissionResRepoProc permissionResRepoProc;
    @Autowired
    protected UserQueryManager userQueryManager;
    @Autowired
    protected TenantDataIsolateProvider tenantDataIsolateProvider;
    @Autowired
    protected TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider;
    @Autowired
    protected TenantClientProvider tenantClientProvider;
    @Autowired
    protected TaskExecutor taskExecutor;
    @Autowired
    protected RedisUtils redisUtils;

    BasePermissionManager() {
    }

    public Map<String, AppBO> tenantApps(String appCodeFilter) {
        return this.tenantApps(appCodeFilter, null);
    }

    public Map<String, AppBO> tenantApps(String appCodeFilter, String terminal) {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        if (tenant != null && CollUtil.isEmpty((Collection)tenant.getAppCodes())) {
            return Collections.emptyMap();
        }
        boolean needFilterAppCode = StringUtils.hasText((String)appCodeFilter);
        boolean needFilterTerminal = StringUtils.hasText((String)terminal);
        List appList = (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.allBO(Boolean.valueOf(true)));
        Set tenantAppCodes = tenant == null ? null : tenant.getAppCodes();
        LinkedHashMap<String, AppBO> appsMap = new LinkedHashMap<String, AppBO>(appList.size());
        for (AppBO param : appList) {
            if (needFilterAppCode && !appCodeFilter.equals(param.getAppCode()) || needFilterTerminal && !terminal.equals(param.getAdaptedTerminal()) || tenantAppCodes != null && !tenantAppCodes.contains(param.getAppCode())) continue;
            appsMap.put(param.getAppCode(), param);
        }
        return appsMap;
    }

    public Set<String> tenantAppCodes(@NotNull GeneralUserDetails currentUser, boolean defaultAllApp) {
        if (currentUser.getTenant() != null) {
            if (CollectionUtils.isEmpty((Collection)currentUser.getTenant().getAppCodes())) {
                return Collections.emptySet();
            }
            return currentUser.getTenant().getAppCodes();
        }
        if (!defaultAllApp) {
            return null;
        }
        return new HashSet<String>((Collection)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.allCodes(Boolean.valueOf(true))));
    }

    protected Long obtainTenantId() {
        SysTenantDTO tenant = this.tenantClientProvider.getSessionTenant();
        if (tenant == null) {
            return TenantConstant.DEFAULT_TENANT_ID;
        }
        return tenant.getId();
    }

    protected boolean isSystemAdmin(@NotNull GeneralUserDetails currentUser, MasterUserBO masterUser) {
        if (currentUser.isSystemAdmin()) {
            return true;
        }
        return this.isSystemAdmin(masterUser);
    }

    protected boolean isSystemAdmin(@NotNull SysUserDTO user, MasterUserBO masterUser) {
        if (this.isSystemAdmin(user.getUsername())) {
            return true;
        }
        return this.isSystemAdmin(masterUser);
    }

    private boolean isSystemAdmin(MasterUserBO masterUser) {
        return masterUser != null && this.isSystemAdmin(masterUser.getUsername()) && SubUserPermissionTypeEnum.EXTENDS_ALL == masterUser.getPermissionType();
    }

    private boolean isSystemAdmin(@NotBlank String username) {
        return InnerUserEnum.ADMIN.getUsername().equals(username);
    }

    protected boolean isTenantAdmin(@NotNull GeneralUserDetails currentUser, MasterUserBO masterUser) {
        return this.isTenantAdmin(currentUser.getUser(), masterUser);
    }

    protected boolean isTenantAdmin(@NotNull SysUserDTO user, MasterUserBO masterUser) {
        SysTenantDTO tenant = user.getSysTenantVO();
        if (tenant == null) {
            return false;
        }
        if (Objects.equals(user.getId(), tenant.getSysUserId())) {
            return true;
        }
        return masterUser != null && Objects.equals(tenant.getSysUserId(), masterUser.getMasterUserId()) && SubUserPermissionTypeEnum.EXTENDS_ALL == masterUser.getPermissionType();
    }

    protected boolean isTenantOrgAdmin(@NotNull GeneralUserDetails currentUser, MasterUserBO masterUser) {
        return this.isTenantOrgAdmin(currentUser.getUser(), masterUser);
    }

    protected boolean isTenantOrgAdmin(@NotNull SysUserDTO user, MasterUserBO masterUser) {
        Long tenantOrgAdminId = user.getTenantOrgAdminId();
        if (tenantOrgAdminId == null) {
            return false;
        }
        if (Objects.equals(user.getId(), tenantOrgAdminId)) {
            return true;
        }
        return masterUser != null && Objects.equals(tenantOrgAdminId, masterUser.getMasterUserId()) && SubUserPermissionTypeEnum.EXTENDS_ALL == masterUser.getPermissionType();
    }
}

