/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.util.JSONUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstQueryBO;
import com.elitescloud.cloudt.system.model.bo.DataRelationInstValueBO;
import com.elitescloud.cloudt.system.service.repo.DataRelationInstRepoProc;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
@TenantOrgTransaction(useTenantOrg=false)
public class DataRelationManager {
    @Autowired
    private DataRelationInstRepoProc instRepoProc;

    public List<DataRelationInstValueBO> queryValues(@NotNull DataRelationInstQueryBO queryBO) {
        return this.queryValues(queryBO, false);
    }

    public List<DataRelationInstValueBO> queryValues(@NotNull DataRelationInstQueryBO queryBO, boolean byRef) {
        Assert.notBlank((CharSequence)queryBO.getDrCode(), (String)"\u6570\u636e\u5173\u7cfb\u7f16\u7801\u4e3a\u7a7a", (Object[])new Object[0]);
        boolean filterByAttribute = CollUtil.isNotEmpty(queryBO.getDataExt());
        return (byRef ? this.instRepoProc.getValuesByRef(queryBO) : this.instRepoProc.getValues(queryBO)).stream().peek(t -> {
            Map dataExt = StringUtils.hasText((String)t.getDataExtJson()) ? (Map)JSONUtil.json2Obj((String)t.getDataExtJson(), (TypeReference)new TypeReference<HashMap<String, String>>(){}) : Collections.emptyMap();
            t.setDataExt(dataExt);
            Map refDataExt = StringUtils.hasText((String)t.getRefDataExtJson()) ? (Map)JSONUtil.json2Obj((String)t.getRefDataExtJson(), (TypeReference)new TypeReference<HashMap<String, String>>(){}) : Collections.emptyMap();
            t.setRefDataExt(refDataExt);
        }).filter(t -> {
            if (!filterByAttribute) {
                return true;
            }
            for (Map.Entry<String, String> entry : queryBO.getDataExt().entrySet()) {
                if (CharSequenceUtil.isBlank((CharSequence)entry.getKey()) || !(byRef ? !CharSequenceUtil.equals((CharSequence)entry.getValue(), (CharSequence)t.getRefDataExt().get(entry.getKey())) : !CharSequenceUtil.equals((CharSequence)entry.getValue(), (CharSequence)t.getDataExt().get(entry.getKey())))) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
    }
}

