/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseTreeModel;
import com.elitescloud.boot.provider.IdFactory;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.cacheable.SysCacheOrgRpcService;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.convert.OrgConvert;
import com.elitescloud.cloudt.system.service.callback.OrgChangedCallback;
import com.elitescloud.cloudt.system.service.manager.OrgTreeManager;
import com.elitescloud.cloudt.system.service.model.bo.SysOrgSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;
import com.elitescloud.cloudt.system.service.repo.EmployeeOrgRepoProc;
import com.elitescloud.cloudt.system.service.repo.OrgRepoProc;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class OrgMngManager {
    private static final Logger logger = LoggerFactory.getLogger(OrgMngManager.class);
    private static final OrgConvert CONVERT = OrgConvert.INSTANCE;
    @Autowired
    private OrgRepoProc orgRepoProc;
    @Autowired
    private EmployeeOrgRepoProc employeeOrgRepoProc;
    @Autowired
    private ObjectProvider<OrgChangedCallback> orgChangedCallbacks;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private OrgTreeManager treeManager;
    @Autowired
    private SysCacheOrgRpcService cacheOrgRpcService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public SysOrgDO upsert(@NotNull SysOrgSaveBO saveBO) {
        boolean isAdd = saveBO.getId() == null;
        SysOrgDO orgDO = isAdd ? this.checkForInsert(saveBO) : this.checkForUpdate(saveBO);
        Boolean executiveOld = isAdd ? null : this.orgRepoProc.getExecutive(orgDO.getId());
        Boolean syncOuterOld = isAdd ? null : this.orgRepoProc.getSyncOuter(orgDO.getId());
        this.orgRepoProc.save((Serializable)orgDO);
        this.saveOrgTreeNode(orgDO, executiveOld);
        if (!isAdd && CharSequenceUtil.isBlank((CharSequence)orgDO.getParentCode()) && ObjUtil.notEqual((Object)syncOuterOld, (Object)orgDO.getSyncOuter())) {
            this.orgRepoProc.updateChildrenSyncOuter(orgDO.getId(), orgDO.getSyncOuter());
        }
        this.orgChangedCallbacks.forEach(t -> t.onUpsert(isAdd, saveBO, orgDO));
        this.cleaCache();
        return orgDO;
    }

    public void updateEnabled(@NotNull Long orgId, Boolean enabled) {
        if (enabled == null) {
            enabled = true;
        }
        this.orgRepoProc.updateEnabled(orgId, enabled);
        Boolean finalEnabled = enabled;
        this.orgChangedCallbacks.forEach(t -> t.onEnabled(orgId, finalEnabled.booleanValue()));
        this.cleaCache();
    }

    public void delete(@NotNull Long orgId) {
        SysOrgDO org = (SysOrgDO)this.orgRepoProc.get(orgId);
        if (org == null) {
            return;
        }
        if (this.orgRepoProc.existsChildNode((BaseTreeModel)org)) {
            throw new BusinessException("\u8bf7\u5148\u5220\u9664\u4e0b\u7ea7\u7ec4\u7ec7");
        }
        if (this.employeeOrgRepoProc.existsEmployee(orgId)) {
            throw new BusinessException("\u8bf7\u5148\u5220\u9664\u7ec4\u7ec7\u4e0b\u5458\u5de5");
        }
        if (Boolean.TRUE.equals(org.getExecutive())) {
            this.orgRepoProc.removeTreeNode((BaseTreeModel)org);
        }
        this.orgRepoProc.delete(orgId);
        this.orgChangedCallbacks.forEach(t -> t.onDelete(orgId));
        this.cleaCache();
    }

    public void rebuildTree(Long rootOrgId) {
        String cacheKey = "sys:orgTree:rebuild:" + String.valueOf(rootOrgId == null ? "root" : rootOrgId);
        String cacheSource = IdFactory.generateLong().toString();
        String cached = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
        this.stringRedisTemplate.opsForValue().set((Object)cacheKey, (Object)cacheSource, Duration.ofMinutes(10L));
        if (cached != null) {
            return;
        }
        Supplier<Void> builder = () -> {
            Map<String, Long> codeIdMap = this.orgRepoProc.queryCodeName(rootOrgId, true).stream().collect(Collectors.toMap(IdCodeNameParam::getCode, IdCodeNameParam::getId, (t1, t2) -> t1));
            if (codeIdMap.isEmpty()) {
                return null;
            }
            this.orgRepoProc.rebuildTree(rootOrgId, t -> (Long)codeIdMap.get(t.getParentCode()));
            return null;
        };
        CompletableFuture.runAsync(() -> {
            String source = cacheSource;
            while (true) {
                builder.get();
                String sourceCurrent = (String)this.stringRedisTemplate.opsForValue().get((Object)cacheKey);
                if (source.equals(sourceCurrent) || sourceCurrent == null) {
                    return;
                }
                source = sourceCurrent;
            }
        }, (Executor)this.taskExecutor).whenComplete((r, e) -> {
            if (e != null) {
                logger.error("\u91cd\u6784\u7ec4\u7ec7\u6811\u5f02\u5e38\uff1a", e);
                return;
            }
            logger.info("\u91cd\u6784\u7ec4\u7ec7\u6811\u5b8c\u6210");
            this.cleaCache();
        });
    }

    private void cleaCache() {
        this.cacheOrgRpcService.clearCache();
        this.treeManager.clearCache();
    }

    private void saveOrgTreeNode(SysOrgDO orgDO, Boolean executiveOld) {
        if (Boolean.FALSE.equals(orgDO.getExecutive())) {
            if (executiveOld == null) {
                return;
            }
            if (Boolean.TRUE.equals(executiveOld)) {
                this.orgRepoProc.removeTreeNode((BaseTreeModel)orgDO);
                final Long rootId = orgDO.getRootId();
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                    public void afterCommit() {
                        CompletableFuture.runAsync(() -> OrgMngManager.this.rebuildTree(rootId), (Executor)OrgMngManager.this.taskExecutor);
                    }
                });
                return;
            }
        }
        long parentId = -1L;
        if (StringUtils.hasText((String)orgDO.getParentCode())) {
            SysOrgDO parentOrg = this.orgRepoProc.getByCode(orgDO.getParentCode());
            Assert.notNull((Object)parentOrg, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)Boolean.TRUE.equals(parentOrg.getExecutive()), (String)"\u884c\u653f\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u5fc5\u987b\u662f\u884c\u653f\u7ec4\u7ec7");
            parentId = parentOrg.getId();
        }
        this.orgRepoProc.saveTreeNode((BaseTreeModel)orgDO, parentId, orgDO.getSortNo());
        final Long rootId = orgDO.getRootId();
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                CompletableFuture.runAsync(() -> OrgMngManager.this.rebuildTree(rootId), (Executor)OrgMngManager.this.taskExecutor);
            }
        });
    }

    private SysOrgDO checkForInsert(SysOrgSaveBO saveBO) {
        SysOrgDO orgDo = CONVERT.saveBo2Do(saveBO);
        Assert.notNull((Object)saveBO.getExecutive(), (String)"\u672a\u77e5\u7ec4\u7ec7\u662f\u5426\u4e3a\u884c\u653f\u7ec4\u7ec7");
        Assert.hasText((String)saveBO.getCode(), (String)"\u7ec4\u7ec7\u7f16\u53f7\u4e3a\u7a7a");
        boolean exists = this.orgRepoProc.existsCode(saveBO.getCode());
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u7f16\u53f7\u5df2\u5b58\u5728");
        if (saveBO.getOuterCode() == null) {
            saveBO.setOuterCode("");
        }
        if (saveBO.getType() == null) {
            saveBO.setType("");
        }
        orgDo.setEntity((Boolean)ObjectUtil.defaultIfNull((Object)saveBO.getEntity(), (Object)true));
        orgDo.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)saveBO.getSortNo(), (Object)0));
        orgDo.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveBO.getEnabled(), (Object)true));
        Assert.isTrue((!saveBO.getCode().equals(saveBO.getParentCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u9009\u62e9\u7ec4\u7ec7\u672c\u8eab\u53ca\u4e0b\u7ea7\u7ec4\u7ec7");
        if (Boolean.TRUE.equals(orgDo.getExecutive()) && CharSequenceUtil.isBlank((CharSequence)orgDo.getParentCode()) && Boolean.TRUE.equals(this.systemProperties.getLimitOrgTreeOne())) {
            Long existsRootOrgId = this.orgRepoProc.getRootOrgId();
            Assert.isNull((Object)existsRootOrgId, (String)"\u884c\u653f\u6839\u7ec4\u7ec7\u53ea\u80fd\u6709\u4e00\u4e2a");
        }
        return orgDo;
    }

    private SysOrgDO checkForUpdate(SysOrgSaveBO saveBO) {
        SysOrgDO orgDo = (SysOrgDO)this.orgRepoProc.get(saveBO.getId());
        Assert.notNull((Object)orgDo, (String)"\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u5b58\u5728");
        Assert.notNull((Object)saveBO.getExecutive(), (String)"\u672a\u77e5\u7ec4\u7ec7\u662f\u5426\u4e3a\u884c\u653f\u7ec4\u7ec7");
        boolean exists = false;
        Assert.hasText((String)saveBO.getCode(), (String)"\u7ec4\u7ec7\u7f16\u53f7\u4e3a\u7a7a");
        if (this.systemProperties.getOrgCodeEditable().booleanValue()) {
            if (!saveBO.getCode().equals(orgDo.getCode())) {
                exists = this.orgRepoProc.existsCode(saveBO.getCode());
                Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u7f16\u53f7\u5df2\u5b58\u5728");
            }
        } else {
            Assert.isTrue((boolean)saveBO.getCode().equals(orgDo.getCode()), (String)"\u7ec4\u7ec7\u7f16\u53f7\u4e0d\u53ef\u4fee\u6539");
        }
        if (saveBO.getOuterCode() == null) {
            saveBO.setOuterCode("");
        }
        if (saveBO.getType() == null) {
            saveBO.setType("");
        }
        Assert.isTrue((!saveBO.getCode().equals(saveBO.getParentCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u9009\u62e9\u7ec4\u7ec7\u672c\u8eab\u53ca\u4e0b\u7ea7\u7ec4\u7ec7");
        if (!Objects.equals(orgDo.getParentCode(), saveBO.getParentCode()) && Boolean.TRUE.equals(saveBO.getExecutive())) {
            if (CharSequenceUtil.isBlank((CharSequence)saveBO.getParentCode())) {
                if (Boolean.TRUE.equals(this.systemProperties.getLimitOrgTreeOne())) {
                    Long existsRootOrgId = this.orgRepoProc.getRootOrgId();
                    Assert.isNull((Object)existsRootOrgId, (String)"\u884c\u653f\u6839\u7ec4\u7ec7\u53ea\u80fd\u6709\u4e00\u4e2a");
                }
            } else {
                Long parentId = this.orgRepoProc.getIdByCode(saveBO.getParentCode());
                Assert.notNull((Object)parentId, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                boolean isChild = this.orgRepoProc.isChildNode(parentId, orgDo.getId());
                Assert.isTrue((!isChild ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u9009\u62e9\u7ec4\u7ec7\u672c\u8eab\u53ca\u4e0b\u7ea7\u7ec4\u7ec7");
            }
        }
        saveBO.setEntity((Boolean)ObjectUtil.defaultIfNull((Object)saveBO.getEntity(), (Object)true));
        saveBO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)saveBO.getSortNo(), (Object)0));
        saveBO.setEnabled((Boolean)ObjectUtil.defaultIfNull((Object)saveBO.getEnabled(), (Object)true));
        CONVERT.copySaveBo2Do(saveBO, orgDo);
        return orgDo;
    }
}

