/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.extra.pinyin.PinyinUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.OuConvert;
import com.elitescloud.cloudt.system.service.callback.OuChangedCallback;
import com.elitescloud.cloudt.system.service.model.bo.SysOuSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysOuDO;
import com.elitescloud.cloudt.system.service.repo.OuRepo;
import com.elitescloud.cloudt.system.service.repo.OuRepoProc;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class OuMngManager {
    private static final OuConvert CONVERT = OuConvert.INSTANCE;
    @Autowired
    private OuRepo repo;
    @Autowired
    private OuRepoProc repoProc;
    @Autowired
    private ObjectProvider<OuChangedCallback> ouChangedCallbacks;

    public Long upsert(@NotNull SysOuSaveBO saveBO) {
        SysOuDO ouDO;
        try {
            ouDO = this.convertForUpsert(saveBO);
        }
        catch (IllegalArgumentException e) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c" + e.getMessage());
        }
        this.repo.save(ouDO);
        this.ouChangedCallbacks.forEach(t -> t.onUpsert(saveBO.getId() == null, saveBO, ouDO));
        return ouDO.getId();
    }

    public Long updateEnabled(long ouId, boolean enabled) {
        this.repoProc.updateEnabled(ouId, enabled);
        this.ouChangedCallbacks.forEach(t -> t.onEnabled(Long.valueOf(ouId), enabled));
        return ouId;
    }

    public void delete(long ouId) {
        this.repoProc.delete(ouId);
        this.ouChangedCallbacks.forEach(t -> t.onDelete(Long.valueOf(ouId)));
    }

    private SysOuDO convertForUpsert(SysOuSaveBO saveBO) {
        boolean isAdd = saveBO.getId() == null;
        SysOuDO ouDO = null;
        if (isAdd) {
            boolean exists = this.repoProc.existsOuCode(saveBO.getOuCode(), null);
            Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u516c\u53f8\u7f16\u7801\u5df2\u5b58\u5728");
        } else {
            ouDO = (SysOuDO)this.repoProc.get(saveBO.getId());
            Assert.notNull((Object)ouDO, (String)"\u4fee\u6539\u7684\u6570\u636e\u4e0d\u5b58\u5728");
            if (!ouDO.getOuCode().equals(saveBO.getOuCode())) {
                boolean exists = this.repoProc.existsOuCode(saveBO.getOuCode(), null);
                Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u516c\u53f8\u7f16\u7801\u5df2\u5b58\u5728");
            }
        }
        if (saveBO.getSortNo() == null) {
            saveBO.setSortNo(Integer.valueOf(0));
        }
        if (saveBO.getEnabled() == null) {
            saveBO.setEnabled(Boolean.valueOf(true));
        }
        if (StringUtils.hasText((String)saveBO.getPhoneNum())) {
            Assert.hasText((String)saveBO.getPhonePrefix(), (String)"\u7535\u8bdd\u53f7\u7801\u7684\u533a\u53f7\u4e3a\u7a7a");
        } else {
            saveBO.setPhonePrefix(null);
        }
        ouDO = isAdd ? CONVERT.saveBo2DO(saveBO) : CONVERT.copySaveBo2DO(saveBO, ouDO);
        ouDO.setPinyin(PinyinUtil.getPinyin((String)ouDO.getOuName()));
        if (StringUtils.hasText((String)saveBO.getPhoneNum())) {
            ouDO.setPhone(saveBO.getPhonePrefix() + "-" + saveBO.getPhoneNum());
        }
        return ouDO;
    }
}

