/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.base.SafeEnum;
import com.elitescloud.boot.common.param.IdCodeNameCheckParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.common.param.TreeRespParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.boot.util.LockUtil;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.model.vo.resp.MenuOperationRespVO;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.common.BusinessObjectNodeType;
import com.elitescloud.cloudt.system.common.DprPropagateStrategyEnum;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.convert.PermissionConverter;
import com.elitescloud.cloudt.system.convert.RoleConvert;
import com.elitescloud.cloudt.system.convert.SysDpcRoleApiFieldsConvert;
import com.elitescloud.cloudt.system.convert.SysDprRoleApiRuleConvert;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.model.bo.BusinessObjectBO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationBO;
import com.elitescloud.cloudt.system.model.bo.BusinessParamBO;
import com.elitescloud.cloudt.system.model.bo.BusinessRefBO;
import com.elitescloud.cloudt.system.model.bo.MenuBO;
import com.elitescloud.cloudt.system.model.bo.MenuSimpleBO;
import com.elitescloud.cloudt.system.model.bo.PermissionResBO;
import com.elitescloud.cloudt.system.model.bo.RoleApiRuleBO;
import com.elitescloud.cloudt.system.model.bo.RolePermissionRuleBO;
import com.elitescloud.cloudt.system.model.vo.resp.api.SysMenuApiRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.permission.DataPermissionTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.RolePermissionRespVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.DataPermissionFieldSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.DataPermissionRuleSaveVO;
import com.elitescloud.cloudt.system.model.vo.save.dpr.DataPermissionSaveVO;
import com.elitescloud.cloudt.system.modules.dpr.strategy.DprValueResolverFactory;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.common.constant.BusinessObjectRefTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.manager.BasePermissionManager;
import com.elitescloud.cloudt.system.service.model.bo.AppBO;
import com.elitescloud.cloudt.system.service.model.bo.SysAppPermissionBatchSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysAppPermissionSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysDprApiCustomRuleSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysDprApiFieldSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysDprBatchSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysDprSaveBO;
import com.elitescloud.cloudt.system.service.model.bo.SysPermissionSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysDpcrApiFieldsDO;
import com.elitescloud.cloudt.system.service.model.entity.SysDprRoleApiRowRuleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPermissionResDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDataPermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleFieldPermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRolePermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuTreeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserRoleDO;
import com.elitescloud.cloudt.system.service.repo.ApiRepoProc;
import com.elitescloud.cloudt.system.service.repo.MenuApiRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleDataPermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RolePermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysDpcrApiFieldsRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysDprRoleApiRowRuleRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuTreeRepoProc;
import com.google.common.base.Functions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class PermissionMngManager
extends BasePermissionManager {
    private static final Logger log = LogManager.getLogger(PermissionMngManager.class);
    @Autowired
    private RolePermissionRepoProc rolePermissionRepoProc;
    @Autowired
    private TenantMenuTreeRepoProc tenantMenuTreeRepoProc;
    @Autowired
    private TenantMenuRepoProc tenantMenuRepoProc;
    @Autowired
    private ApiRepoProc apiRepoProc;
    @Autowired
    private MenuApiRepoProc menuApiRepoProc;
    @Autowired
    private SysDprRoleApiRowRuleRepoProc roleApiRowRuleRepoProc;
    @Autowired
    private SysDpcrApiFieldsRepoProc apiFieldsRepoProc;
    @Autowired
    private RoleDataPermissionRepoProc roleDataPermissionRepoProc;

    public void saveUserRole(@NotNull Long userId, List<Long> roleIds) {
        List<SysUserRoleDO> userRoles = this.userRoleRepoProc.getByUser(userId, BelongType.getBelonger());
        if (CollectionUtils.isEmpty(roleIds)) {
            List ids = userRoles.stream().map(BaseModel::getId).collect(Collectors.toList());
            if (!ids.isEmpty()) {
                this.userRoleRepoProc.delete(ids);
            }
            return;
        }
        if ((roleIds = this.roleRepoProc.exists(roleIds)).isEmpty()) {
            throw new BusinessException("\u90e8\u5206\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        Map<Long, SysUserRoleDO> userRoleMap = userRoles.stream().collect(Collectors.toMap(SysUserRoleDO::getRoleId, t -> t, (t1, t2) -> t1));
        List userRoleToAdd = roleIds.stream().filter(t -> !userRoleMap.containsKey(t)).map(t -> {
            SysUserRoleDO userRoleDO = new SysUserRoleDO();
            userRoleDO.setRoleId(t);
            userRoleDO.setUserId(userId);
            return userRoleDO;
        }).collect(Collectors.toList());
        if (!userRoleToAdd.isEmpty()) {
            this.userRoleRepoProc.save(userRoleToAdd);
        }
        List finalRoleIds = roleIds;
        List idsToDel = userRoles.stream().filter(t -> !finalRoleIds.contains(t.getRoleId())).map(BaseModel::getId).collect(Collectors.toList());
        if (!idsToDel.isEmpty()) {
            this.userRoleRepoProc.delete(idsToDel);
        }
    }

    public List<IdCodeNameCheckParam> getUserRole(@NotNull Long userId, boolean onlyOwn) {
        return this.userRoleRepoProc.getByUser(userId, BelongType.getBelonger(), onlyOwn);
    }

    public void addUserRole(Set<Long> userIds, Set<String> roleCodes) {
        if (CollUtil.isEmpty(userIds) || CollUtil.isEmpty(roleCodes)) {
            return;
        }
        Map<Long, Set<String>> existsUserRoleMap = this.userRoleRepoProc.getRoleCodesOfUser(userIds, null);
        Map<String, Long> roleCodeIdMap = this.roleRepoProc.getIdAndCodeByCode(roleCodes);
        ArrayList<SysUserRoleDO> userRoleList = new ArrayList<SysUserRoleDO>();
        for (Long userId : userIds) {
            Set<String> existsUserRoleCodes = existsUserRoleMap.get(userId);
            for (String roleCode : roleCodes) {
                if (existsUserRoleCodes != null && existsUserRoleCodes.contains(roleCode) || !roleCodeIdMap.containsKey(roleCode)) continue;
                SysUserRoleDO userRoleDO = new SysUserRoleDO();
                userRoleDO.setUserId(userId);
                userRoleDO.setRoleId(roleCodeIdMap.get(roleCode));
                userRoleList.add(userRoleDO);
            }
        }
        if (!userRoleList.isEmpty()) {
            this.userRoleRepoProc.save(userRoleList);
        }
    }

    public void saveRoleUser(@NotNull Long roleId, List<Long> userIds, boolean incremental, boolean employeeOnly) {
        if (CollUtil.isEmpty(userIds)) {
            if (incremental) {
                return;
            }
            this.userRoleRepoProc.deleteByRole(roleId, employeeOnly);
            return;
        }
        Set<Long> userIdsCurrent = this.userRoleRepoProc.getUserIdsByRole(roleId, employeeOnly);
        List userRoleDoList = userIds.stream().filter(t -> !userIdsCurrent.contains(t)).map(t -> {
            SysUserRoleDO userRoleDO = new SysUserRoleDO();
            userRoleDO.setUserId(t);
            userRoleDO.setRoleId(roleId);
            return userRoleDO;
        }).collect(Collectors.toList());
        if (!userRoleDoList.isEmpty()) {
            this.userRoleRepoProc.save(userRoleDoList);
        }
        if (!incremental) {
            Set<Long> toDelUserIds = userIdsCurrent.isEmpty() ? Collections.emptySet() : userIdsCurrent.stream().filter(t -> !userIds.contains(t)).collect(Collectors.toSet());
            this.userRoleRepoProc.deleteRoleUser(roleId, toDelUserIds);
        }
    }

    public void removeRoleUser(@NotNull Long roleId, List<Long> userIds) {
        if (CollUtil.isEmpty(userIds)) {
            return;
        }
        this.userRoleRepoProc.deleteRoleUser(roleId, userIds);
    }

    public void savePermissionRes(@NotEmpty List<PermissionResBO> permissionResList, BelongType.Belonger assigner) {
        Assert.notEmpty(permissionResList, (String)"\u8d44\u6e90\u5217\u8868\u4e3a\u7a7a");
        Assert.notNull((Object)assigner, (String)"\u5206\u914d\u4eba\u4e3a\u7a7a");
        this.checkPermissionRes(permissionResList);
        List permissionResDoList = permissionResList.stream().flatMap(t -> {
            if (CollUtil.isEmpty(t.getResList())) {
                return Stream.empty();
            }
            return t.getResList().stream().map(tt -> {
                SysPermissionResDO permissionResDO = new SysPermissionResDO();
                permissionResDO.setResType(tt.getResTypeEnum().getValue());
                permissionResDO.setResId(tt.getResId());
                permissionResDO.setOwnerType(t.getOwnerTypeEnum().name());
                permissionResDO.setOwnerId(t.getOwnerId());
                permissionResDO.setAssignerType(assigner.getBelongType().getValue());
                permissionResDO.setAssignerId(assigner.getBelongId());
                return permissionResDO;
            });
        }).collect(Collectors.toList());
        for (PermissionResBO permissionResBO : permissionResList) {
            this.permissionResRepoProc.delete(assigner, permissionResBO.getOwnerTypeEnum(), permissionResBO.getOwnerId());
        }
        if (!permissionResDoList.isEmpty()) {
            this.permissionResRepoProc.save(permissionResDoList);
        }
    }

    public void saveRoleMenu(@NotNull Long roleId, List<SysAppPermissionSaveBO> saveVOList) {
        Assert.notNull((Object)roleId, (String)"\u89d2\u8272ID\u4e3a\u7a7a");
        boolean hasCustom = false;
        this.saveRolePermission(roleId, saveVOList, List.of(MenuTreeNodeType.APP, MenuTreeNodeType.MENU, MenuTreeNodeType.ACTION), hasCustom);
    }

    public void addRoleMenu(long roleId, SysAppPermissionSaveBO saveBO) {
        boolean hasCustom = false;
        List<MenuTreeNodeType> nodeTypes = List.of(MenuTreeNodeType.APP, MenuTreeNodeType.MENU, MenuTreeNodeType.ACTION);
        this.addRolePermission(List.of(Long.valueOf(roleId)), saveBO, nodeTypes, hasCustom);
    }

    public void removeRoleMenu(long roleId, SysAppPermissionSaveBO saveBO) {
        boolean hasCustom = false;
        saveBO.getPermissionList().stream().collect(Collectors.groupingBy(SysPermissionSaveBO::getNodeType)).forEach((nodeType, permissionList) -> {
            Set<String> codes = permissionList.stream().map(SysPermissionSaveBO::getCode).collect(Collectors.toSet());
            this.rolePermissionRepoProc.deleteByRole(roleId, saveBO.getAppCode(), (String)nodeType, (Collection<String>)codes, hasCustom);
        });
    }

    public void saveRoleMenuBatch(SysAppPermissionBatchSaveBO saveBO) {
        boolean hasCustom = false;
        if (!saveBO.isAdd()) {
            saveBO.getPermissionList().stream().collect(Collectors.groupingBy(SysPermissionSaveBO::getNodeType)).forEach((nodeType, permissionList) -> {
                Set<String> codes = permissionList.stream().map(SysPermissionSaveBO::getCode).collect(Collectors.toSet());
                this.rolePermissionRepoProc.deleteByRoleBatch(saveBO.getRoleIds(), saveBO.getAppCode(), (String)nodeType, (Collection<String>)codes, hasCustom);
            });
            return;
        }
        List<MenuTreeNodeType> nodeTypes = List.of(MenuTreeNodeType.APP, MenuTreeNodeType.MENU, MenuTreeNodeType.ACTION);
        this.addRolePermission(saveBO.getRoleIds(), new SysAppPermissionSaveBO(saveBO.getAppCode(), saveBO.getPermissionList()), nodeTypes, hasCustom);
    }

    public List<RolePermissionRespVO> getPermissionMenuByRole(long roleId, String appCode, boolean includeApp, boolean includeAction, boolean tree) {
        Set menuCodes;
        Map tenantApp = (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> super.tenantApps(appCode));
        Set<String> appCodes = tenantApp.keySet();
        List<RolePermissionRespVO> respVOList = this.queryAppAndMenu(tenantApp, false, includeApp);
        if (respVOList.isEmpty()) {
            return Collections.emptyList();
        }
        this.fillApiNumOfMenu(appCodes, respVOList);
        if (includeAction && !(menuCodes = respVOList.stream().filter(t -> MenuTreeNodeType.MENU.getValue().equals(t.getNodeType())).map(RolePermissionRespVO::getCode).collect(Collectors.toSet())).isEmpty()) {
            List actionList = this.queryActionList(appCodes).stream().filter(t -> StringUtils.hasText((String)t.getParentCode()) && menuCodes.contains(t.getParentCode())).collect(Collectors.toList());
            respVOList.addAll(actionList);
        }
        List<String> checkCodes = this.rolePermissionRepoProc.getCodeByRole(roleId, tenantApp.keySet(), Set.of(MenuTreeNodeType.MENU.getValue(), MenuTreeNodeType.ACTION.getValue()));
        return this.convertPermissionTreeRespVO(respVOList, checkCodes, tree);
    }

    public List<DataPermissionTreeNodeRespVO> getDataPermissionByRole(Long roleId, String appCode, boolean includeApp, boolean tree) {
        SysTenantDTO currentTenant = this.tenantClientProvider.getCurrentTenant();
        Long tenantId = currentTenant == null ? TenantConstant.DEFAULT_TENANT_ID : currentTenant.getId();
        LinkedHashMap<String, AppBO> tenantApp = new LinkedHashMap<String, AppBO>();
        Map menuApiMap = (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            Map<String, AppBO> tenantApps = super.tenantApps(appCode);
            if (tenantApps.isEmpty()) {
                return Collections.emptyMap();
            }
            tenantApp.putAll(tenantApps);
            return this.menuApiRepoProc.queryApiDetailOfMenu(tenantApp.keySet());
        });
        if (menuApiMap.isEmpty()) {
            return Collections.emptyList();
        }
        boolean custom = this.hasCustomMenuTree(tenantId);
        List<RolePermissionRespVO> respVOList = this.queryAppAndMenu(tenantApp, custom, includeApp);
        if (respVOList.isEmpty()) {
            return Collections.emptyList();
        }
        List<RoleApiRuleBO> roleApiRuleList = roleId == null ? Collections.emptyList() : this.roleApiRowRuleRepoProc.queryByRole(roleId);
        List<DataPermissionTreeNodeRespVO> treeNodeList = respVOList.stream().map(this::convertDataPermissionTreeNode).collect(Collectors.toList());
        treeNodeList.addAll(this.convertDataPermissionTreeNode(menuApiMap, roleApiRuleList));
        return this.convertDataPermissionTreeRespVO(treeNodeList, tree, MenuTreeNodeType.API);
    }

    public List<DataPermissionTreeNodeRespVO> getDataPermissionByRole(String roleCode, @NotNull DataPermissionType permissionType, boolean withRef, String appCode, boolean includeApp, boolean tree) {
        SysTenantDTO currentTenant = this.tenantClientProvider.getCurrentTenant();
        Long tenantId = currentTenant == null ? TenantConstant.DEFAULT_TENANT_ID : currentTenant.getId();
        List<DataPermissionTreeNodeRespVO> treeNodeList = null;
        Assert.notNull((Object)permissionType, (String)"\u672a\u77e5\u6743\u9650\u7c7b\u578b");
        MenuTreeNodeType lastTreeNodeType = null;
        switch (permissionType) {
            case MENU_OPERATION_RULE: {
                treeNodeList = this.queryDataPermissionTreeOfMenuOperation(roleCode, appCode, tenantId, includeApp);
                lastTreeNodeType = MenuTreeNodeType.BUSINESS_OPERATION;
                break;
            }
            case BUSINESS_OPERATION_RULE: {
                treeNodeList = this.queryDataPermissionTreeOfBusinessOperation(roleCode, appCode, withRef, includeApp);
                lastTreeNodeType = MenuTreeNodeType.BUSINESS_OPERATION;
                break;
            }
            case BUSINESS_OBJECT_RULE: {
                treeNodeList = this.queryDataPermissionTreeOfBusinessObject(roleCode, appCode, includeApp, false);
                lastTreeNodeType = MenuTreeNodeType.BUSINESS_OBJECT;
                break;
            }
            case BUSINESS_RESOURCE_RULE: {
                treeNodeList = this.queryDataPermissionTreeOfBusinessObject(roleCode, appCode, includeApp, true);
                lastTreeNodeType = MenuTreeNodeType.BUSINESS_OBJECT;
                break;
            }
            default: {
                throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6743\u9650\u7c7b\u578b");
            }
        }
        return this.convertDataPermissionTreeRespVO(treeNodeList, tree, lastTreeNodeType);
    }

    public void saveDataPermission(SysDprSaveBO saveBO) {
        AtomicLong appId = new AtomicLong();
        AtomicReference apiList = new AtomicReference();
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            Long tempAppId = this.menuRepoProc.getAppIdByMenuCode(saveBO.getMenuCode());
            Assert.notNull((Object)tempAppId, (String)"\u83dc\u5355\u4fe1\u606f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            appId.set(tempAppId);
            List apis = this.menuApiRepoProc.queryApiOfMenu(saveBO.getMenuCode()).stream().map(t -> {
                IdCodeNameParam param = new IdCodeNameParam();
                param.setId(t.getId());
                param.setCode(t.getApiCode());
                param.setName(t.getApiName());
                return param;
            }).collect(Collectors.toList());
            apiList.set(apis);
            return null;
        });
        Set<String> apiCodesAll = ((List)apiList.get()).stream().map(IdCodeNameParam::getCode).collect(Collectors.toSet());
        this.saveDataPermissionCustomRule(appId.get(), saveBO, DprRuleRelationEnum.DPR_RULE_RELATION_AND, apiCodesAll);
        this.saveDataPermissionField(appId.get(), saveBO);
    }

    public void saveDataPermission(DataPermissionSaveVO saveVO) {
        this.check(saveVO);
        this.savePermissionRule(saveVO);
        this.savePermissionField(saveVO);
    }

    public void saveDataPermissionBatch(SysDprBatchSaveBO saveBO) {
        List menuCodes = saveBO.getMenuApiList().stream().map(SysDprBatchSaveBO.MenuApiSaveBO::getMenuCode).collect(Collectors.toList());
        Map<String, MenuSimpleBO> menuMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuRepoProc.listSimpleByMenuCode(menuCodes))).stream().collect(Collectors.toMap(MenuSimpleBO::getMenusCode, t -> t, (t1, t2) -> t1));
        Map<String, Long> existsData = null;
        if (SysDprBatchSaveBO.Strategy.APPEND != saveBO.getStrategy()) {
            if (SysDprBatchSaveBO.Strategy.REPLACE == saveBO.getStrategy()) {
                existsData = this.roleApiRowRuleRepoProc.listByRole(saveBO.getRoleId()).stream().collect(Collectors.toMap(t -> t.getMenuCode() + ":" + t.getApiCode() + ":" + t.getDprRuleField(), BaseModel::getId, (t1, t2) -> t1));
            } else if (SysDprBatchSaveBO.Strategy.CLEAR == saveBO.getStrategy()) {
                for (SysDprBatchSaveBO.MenuApiSaveBO menuApiSaveBO : saveBO.getMenuApiList()) {
                    this.roleApiRowRuleRepoProc.deleteByApi(saveBO.getRoleId(), menuApiSaveBO.getMenuCode(), menuApiSaveBO.getApiCode());
                }
            }
        }
        ArrayList<SysDprRoleApiRowRuleDO> ruleList = new ArrayList<SysDprRoleApiRowRuleDO>(16);
        SysDprRoleApiRowRuleDO ruleDO = null;
        for (SysDprBatchSaveBO.MenuApiSaveBO menuApiSaveBO : saveBO.getMenuApiList()) {
            SysDprSaveBO dprSaveBO = new SysDprSaveBO();
            dprSaveBO.setRoleId(saveBO.getRoleId());
            dprSaveBO.setMenuCode(menuApiSaveBO.getMenuCode());
            dprSaveBO.setApiCode(menuApiSaveBO.getApiCode());
            dprSaveBO.setCustomRuleList(saveBO.getCustomRuleList());
            MenuSimpleBO menu = menuMap.get(menuApiSaveBO.getMenuCode());
            Assert.notNull((Object)menu, (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
            int order = 0;
            for (SysDprApiCustomRuleSaveBO customRuleSaveBO : saveBO.getCustomRuleList()) {
                ruleDO = this.convertDprRoleApiRowRuleDO(menu.getMenusAppCode(), dprSaveBO, customRuleSaveBO, order++, DprRuleRelationEnum.DPR_RULE_RELATION_AND);
                if (existsData != null) {
                    Long id = existsData.get(menuApiSaveBO.getMenuCode() + ":" + menuApiSaveBO.getApiCode() + ":" + customRuleSaveBO.getDprRuleField());
                    ruleDO.setId(id);
                }
                ruleList.add(ruleDO);
            }
        }
        if (!ruleList.isEmpty()) {
            this.roleApiRowRuleRepoProc.save(ruleList);
        }
    }

    public void cloneRolePermission(long originalId, long roleId, boolean withMenu, boolean withDataPermission) {
        if (withMenu) {
            this.cloneRoleMenu(originalId, roleId);
        }
        if (withDataPermission) {
            this.cloneRoleDataPermission(originalId, roleId);
        }
    }

    public void clearRoleMenu(long roleId, String appCode) {
        this.rolePermissionRepoProc.deleteByRole(roleId, appCode, null, null, null);
    }

    public void copyRoleMenu(long roleId, Set<Long> targetRoleIds, String appCode, boolean merge) {
        Function<SysRolePermissionDO, String> keyBuilder = t -> String.join((CharSequence)"#&#", t.getPermissionCode(), t.getPermissionType(), t.getAppCode(), t.getCustom() == null ? "0" : "1");
        if (merge) {
            ArrayList<Long> roleIds = new ArrayList<Long>(targetRoleIds);
            roleIds.add(roleId);
            Map<Long, List<SysRolePermissionDO>> permissionsMap = this.rolePermissionRepoProc.listByRoles(roleIds, appCode).parallelStream().collect(Collectors.groupingBy(SysRolePermissionDO::getRoleId));
            List<SysRolePermissionDO> sourcePermissions = permissionsMap.get(roleId);
            if (CollUtil.isEmpty(sourcePermissions)) {
                return;
            }
            List<IdCodeNameParam> targetRoles = this.roleRepoProc.queryIdCodeNames(targetRoleIds);
            for (IdCodeNameParam r : targetRoles) {
                HashSet existsKey;
                Set<Object> set = existsKey = permissionsMap.containsKey(r.getId()) ? permissionsMap.get(r.getId()).parallelStream().map(keyBuilder).collect(Collectors.toSet()) : new HashSet(0);
                List newPermissionList = permissionsMap.get(roleId).stream().filter(t -> !existsKey.contains(keyBuilder.apply((SysRolePermissionDO)t))).map(t -> {
                    SysRolePermissionDO permissionDO = RoleConvert.INSTANCE.do2do((SysRolePermissionDO)t);
                    permissionDO.setId(null);
                    permissionDO.setRoleId(r.getId());
                    permissionDO.setRoleCode(r.getCode());
                    return permissionDO;
                }).collect(Collectors.toList());
                if (newPermissionList.isEmpty()) continue;
                this.rolePermissionRepoProc.save(newPermissionList);
            }
            return;
        }
        this.rolePermissionRepoProc.deleteByRole(targetRoleIds, appCode);
        List<SysRolePermissionDO> sourcePermissions = this.rolePermissionRepoProc.listByRoles(List.of(Long.valueOf(roleId)), appCode);
        if (sourcePermissions.isEmpty()) {
            return;
        }
        List<IdCodeNameParam> targetRoles = this.roleRepoProc.queryIdCodeNames(targetRoleIds);
        for (IdCodeNameParam r : targetRoles) {
            List newPermissionList = sourcePermissions.stream().map(t -> {
                SysRolePermissionDO permissionDO = RoleConvert.INSTANCE.do2do((SysRolePermissionDO)t);
                permissionDO.setId(null);
                permissionDO.setRoleId(r.getId());
                permissionDO.setRoleCode(r.getCode());
                return permissionDO;
            }).collect(Collectors.toList());
            if (newPermissionList.isEmpty()) continue;
            this.rolePermissionRepoProc.save(newPermissionList);
        }
    }

    public void propagateDataPermission(long roleId, @NotBlank String businessObjectCode, @NotNull DprPropagateStrategyEnum strategy) {
        String roleCode = this.roleRepoProc.getCode(roleId);
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        List<String> resourcePermissionFields = this.roleDataPermissionRepoProc.listFieldByRoleForBusinessObjectResource(roleCode, businessObjectCode);
        if (resourcePermissionFields.isEmpty()) {
            return;
        }
        HashSet refBusinessObjectCodes = new HashSet(64);
        HashMap refBusinessParamsMap = new HashMap(64);
        HashMap refOperationMap = new HashMap(512);
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            Map<String, List<BusinessParamBO>> tempRefBusinessParamsMap = this.businessParamRepoProc.listSimpleBoByRelatedBusinessObject(businessObjectCode).stream().filter(t -> Boolean.TRUE.equals(t.getDataPermissionEnabled()) && Boolean.TRUE.equals(t.getEnabled())).collect(Collectors.groupingBy(BusinessParamBO::getBusinessObjectCode));
            if (tempRefBusinessParamsMap.isEmpty()) {
                return null;
            }
            refBusinessParamsMap.putAll(tempRefBusinessParamsMap);
            refBusinessObjectCodes.addAll(tempRefBusinessParamsMap.keySet());
            Map tempRefOperationMap = this.businessOperationRepoProc.listSimpleByBusinessObjectCodes(refBusinessObjectCodes).stream().filter(t -> Boolean.TRUE.equals(t.getPermissionEnabled()) && Boolean.TRUE.equals(t.getEnabled()) && CharSequenceUtil.isBlank((CharSequence)t.getPermissionRef())).collect(Collectors.toMap(BusinessOperationBO::getOperationCode, Function.identity(), (t1, t2) -> t1));
            if (tempRefOperationMap.isEmpty()) {
                return null;
            }
            refOperationMap.putAll(tempRefOperationMap);
            return null;
        });
        if (refBusinessParamsMap.isEmpty()) {
            return;
        }
        String lockKey = String.join((CharSequence)":", "propagateDataPermission", roleCode, businessObjectCode);
        LockUtil.executeByLock((String)lockKey, () -> {
            this.propagateDataPermissionOfBusinessOperation(roleCode, strategy, refBusinessObjectCodes, refBusinessParamsMap, refOperationMap);
            this.propagateDataPermissionOfMenuBusinessOperation(roleCode, strategy, refBusinessObjectCodes, refBusinessParamsMap, refOperationMap);
            return null;
        }, (Duration)Duration.ofMinutes(2L), (String)"\u6709\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u64cd\u4f5c\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
    }

    private void propagateDataPermissionOfBusinessOperation(String roleCode, DprPropagateStrategyEnum strategy, Set<String> refBusinessObjectCodes, Map<String, List<BusinessParamBO>> refBusinessParamMap, Map<String, BusinessOperationBO> refOperationMap) {
        Map<String, List<SysRoleDataPermissionDO>> existPermissionsMap = this.roleDataPermissionRepoProc.listByRoleAndBusinessObjectForBusinessOperation(roleCode, refBusinessObjectCodes).stream().collect(Collectors.groupingBy(SysRoleDataPermissionDO::getOperationCode));
        HashSet toDelIds = new HashSet(1024);
        ArrayList<SysRoleDataPermissionDO> toAddPermissions = new ArrayList<SysRoleDataPermissionDO>(1024);
        List<BusinessParamBO> refParams = null;
        SysRoleDataPermissionDO permissionDO = null;
        for (BusinessOperationBO operationBO : refOperationMap.values()) {
            Iterator<BusinessParamBO> iterator;
            List existsPermissions = existPermissionsMap.getOrDefault(operationBO.getOperationCode(), Collections.emptyList());
            refParams = refBusinessParamMap.getOrDefault(operationBO.getBusinessObjectCode(), Collections.emptyList()).stream().filter(t -> {
                if (existsPermissions.isEmpty()) {
                    return true;
                }
                for (SysRoleDataPermissionDO existsPermission : existsPermissions) {
                    if (!t.getFieldName().equals(existsPermission.getRuleField())) continue;
                    if (strategy == DprPropagateStrategyEnum.OVERWRITE) {
                        toDelIds.add(existsPermission.getId());
                    } else if (strategy == DprPropagateStrategyEnum.SKIP) {
                        return false;
                    }
                    return true;
                }
                return true;
            }).toList();
            if (refParams.isEmpty() || !(iterator = refParams.iterator()).hasNext()) continue;
            BusinessParamBO refParam = iterator.next();
            permissionDO = new SysRoleDataPermissionDO();
            permissionDO.setRoleCode(roleCode);
            permissionDO.setPermissionType(DataPermissionType.BUSINESS_OPERATION_RULE.name());
            permissionDO.setAppCode(operationBO.getAppCode());
            permissionDO.setBusinessObjectCode(operationBO.getBusinessObjectCode());
            permissionDO.setOperationCode(operationBO.getOperationCode());
            permissionDO.setRuleGroup(Boolean.valueOf(false));
            permissionDO.setRuleRelation(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name());
            permissionDO.setRuleOrder(Integer.valueOf(existsPermissions.size() + 1));
            permissionDO.setRuleField(refParam.getFieldName());
            permissionDO.setRuleFieldType(refParam.getFieldJavaType());
            permissionDO.setRefResource(Boolean.valueOf(true));
            permissionDO.setRefBusinessObject(refParam.getRelatedBusinessObject());
            permissionDO.setRefField(refParam.getRelatedField());
            permissionDO.setFieldValueCondition(DprRuleConditionEnum.InList.name());
            permissionDO.setRuleValueType(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS.name());
            permissionDO.setDataSet(refParam.getRelatedBusinessObject());
            toAddPermissions.add(permissionDO);
        }
        if (!toDelIds.isEmpty()) {
            this.roleDataPermissionRepoProc.delete(toDelIds);
        }
        if (!toAddPermissions.isEmpty()) {
            this.roleDataPermissionRepoProc.save(toAddPermissions);
        }
    }

    private void propagateDataPermissionOfMenuBusinessOperation(String roleCode, DprPropagateStrategyEnum strategy, Set<String> refBusinessObjectCodes, Map<String, List<BusinessParamBO>> refBusinessParamMap, Map<String, BusinessOperationBO> refOperationMap) {
        Map<String, List<SysRoleDataPermissionDO>> existPermissionsMap = this.roleDataPermissionRepoProc.listByRoleAndBusinessObjectForMenuBusinessOperation(roleCode, refBusinessObjectCodes).stream().collect(Collectors.groupingBy(SysRoleDataPermissionDO::getOperationCode));
        HashSet toDelIds = new HashSet(1024);
        ArrayList<SysRoleDataPermissionDO> toAddPermissions = new ArrayList<SysRoleDataPermissionDO>(1024);
        Map<String, List<SysRoleDataPermissionDO>> menuOperationsMap = null;
        List<BusinessParamBO> refParams = null;
        SysRoleDataPermissionDO permissionDO = null;
        for (BusinessOperationBO operationBO : refOperationMap.values()) {
            List existsPermissions = existPermissionsMap.getOrDefault(operationBO.getOperationCode(), Collections.emptyList());
            if (existsPermissions.isEmpty()) continue;
            menuOperationsMap = existsPermissions.stream().collect(Collectors.groupingBy(SysRoleDataPermissionDO::getMenuCode));
            for (Map.Entry<String, List<SysRoleDataPermissionDO>> entry : menuOperationsMap.entrySet()) {
                refParams = refBusinessParamMap.getOrDefault(operationBO.getBusinessObjectCode(), Collections.emptyList()).stream().filter(t -> {
                    if (((List)entry.getValue()).isEmpty()) {
                        return true;
                    }
                    for (SysRoleDataPermissionDO existsPermission : (List)entry.getValue()) {
                        if (!t.getFieldName().equals(existsPermission.getRuleField())) continue;
                        if (strategy == DprPropagateStrategyEnum.OVERWRITE) {
                            toDelIds.add(existsPermission.getId());
                        } else if (strategy == DprPropagateStrategyEnum.SKIP) {
                            return false;
                        }
                        return true;
                    }
                    return true;
                }).toList();
                if (refParams.isEmpty()) continue;
                for (BusinessParamBO refParam : refParams) {
                    permissionDO = new SysRoleDataPermissionDO();
                    permissionDO.setRoleCode(roleCode);
                    permissionDO.setPermissionType(DataPermissionType.MENU_OPERATION_RULE.name());
                    permissionDO.setAppCode(operationBO.getAppCode());
                    permissionDO.setMenuCode(entry.getKey());
                    permissionDO.setBusinessObjectCode(operationBO.getBusinessObjectCode());
                    permissionDO.setOperationCode(operationBO.getOperationCode());
                    permissionDO.setRuleGroup(Boolean.valueOf(false));
                    permissionDO.setRuleRelation(DprRuleRelationEnum.DPR_RULE_RELATION_AND.name());
                    permissionDO.setRuleOrder(Integer.valueOf(entry.getValue().size() + 1));
                    permissionDO.setRuleField(refParam.getFieldName());
                    permissionDO.setRuleFieldType(refParam.getFieldJavaType());
                    permissionDO.setRefResource(Boolean.valueOf(true));
                    permissionDO.setRefBusinessObject(refParam.getRelatedBusinessObject());
                    permissionDO.setRefField(refParam.getRelatedField());
                    permissionDO.setFieldValueCondition(DprRuleConditionEnum.InList.name());
                    permissionDO.setRuleValueType(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS.name());
                    permissionDO.setDataSet(refParam.getRelatedBusinessObject());
                    toAddPermissions.add(permissionDO);
                }
            }
        }
        if (!toDelIds.isEmpty()) {
            this.roleDataPermissionRepoProc.delete(toDelIds);
        }
        if (!toAddPermissions.isEmpty()) {
            this.roleDataPermissionRepoProc.save(toAddPermissions);
        }
    }

    private void checkPermissionRes(List<PermissionResBO> permissionResList) {
        HashMap<MenuTreeNodeType, Set> resMap = new HashMap<MenuTreeNodeType, Set>(8);
        for (PermissionResBO permissionResBO : permissionResList) {
            Assert.notNull((Object)permissionResBO.getOwnerTypeEnum(), (String)"\u6301\u6709\u8005\u7c7b\u578b\u4e3a\u7a7a");
            Assert.hasText((String)permissionResBO.getOwnerId(), (String)"\u6301\u6709\u8005\u6807\u8bc6\u4e3a\u7a7a");
            if (CollUtil.isEmpty(permissionResBO.getResList())) continue;
            for (PermissionResBO.Res res : permissionResBO.getResList()) {
                Assert.notNull((Object)res.getResTypeEnum(), (String)"\u8d44\u6e90\u7c7b\u578b\u4e3a\u7a7a");
                Assert.hasText((String)res.getResId(), (String)"\u8d44\u6e90\u6807\u8bc6\u4e3a\u7a7a");
                resMap.computeIfAbsent(res.getResTypeEnum(), rt -> new HashSet(256)).add(res.getResId());
            }
        }
        HashSet menuCodesAll = new HashSet();
        if (CollUtil.isNotEmpty((Collection)((Collection)resMap.get(MenuTreeNodeType.MENU)))) {
            this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                menuCodesAll.addAll(this.menuRepoProc.getMenuCodes(true, true, true, true));
                return null;
            });
        }
        for (PermissionResBO permissionResBO : permissionResList) {
            if (CollUtil.isEmpty(permissionResBO.getResList())) continue;
            ArrayList<PermissionResBO.Res> resList = new ArrayList<PermissionResBO.Res>(permissionResBO.getResList().size());
            for (PermissionResBO.Res res : permissionResBO.getResList()) {
                if (res.getResTypeEnum() == MenuTreeNodeType.MENU && !menuCodesAll.contains(res.getResId())) continue;
                resList.add(res);
            }
            permissionResBO.setResList(resList);
        }
    }

    private void savePermissionField(DataPermissionSaveVO saveVO) {
        Supplier<SysRoleFieldPermissionDO> permissionDoSupplier = null;
        List<SysRoleFieldPermissionDO> permissionDoList = null;
        switch (saveVO.getPermissionType()) {
            case MENU_OPERATION_RULE: {
                permissionDoSupplier = () -> {
                    SysRoleFieldPermissionDO permissionDO = new SysRoleFieldPermissionDO();
                    permissionDO.setRoleCode(saveVO.getRoleCode());
                    permissionDO.setPermissionType(saveVO.getPermissionType().name());
                    permissionDO.setAppCode(saveVO.getAppCode());
                    permissionDO.setMenuCode(saveVO.getMenuCode());
                    permissionDO.setBusinessObjectCode(saveVO.getBusinessObjectCode());
                    permissionDO.setOperationCode(saveVO.getOperationCode());
                    return permissionDO;
                };
                this.fieldPermissionRepoProc.deleteByRoleForMenuOperation(saveVO.getRoleCode(), saveVO.getMenuCode(), saveVO.getOperationCode());
                break;
            }
            case BUSINESS_OPERATION_RULE: {
                permissionDoSupplier = () -> {
                    SysRoleFieldPermissionDO permissionDO = new SysRoleFieldPermissionDO();
                    permissionDO.setRoleCode(saveVO.getRoleCode());
                    permissionDO.setPermissionType(saveVO.getPermissionType().name());
                    permissionDO.setAppCode(saveVO.getAppCode());
                    permissionDO.setMenuCode(null);
                    permissionDO.setBusinessObjectCode(saveVO.getBusinessObjectCode());
                    permissionDO.setOperationCode(saveVO.getOperationCode());
                    return permissionDO;
                };
                this.fieldPermissionRepoProc.deleteByRoleForBusinessOperation(saveVO.getRoleCode(), saveVO.getOperationCode());
                break;
            }
            case BUSINESS_OBJECT_RULE: {
                permissionDoSupplier = () -> {
                    SysRoleFieldPermissionDO permissionDO = new SysRoleFieldPermissionDO();
                    permissionDO.setRoleCode(saveVO.getRoleCode());
                    permissionDO.setPermissionType(saveVO.getPermissionType().name());
                    permissionDO.setAppCode(saveVO.getAppCode());
                    permissionDO.setMenuCode(null);
                    permissionDO.setBusinessObjectCode(saveVO.getBusinessObjectCode());
                    permissionDO.setOperationCode(null);
                    return permissionDO;
                };
                this.fieldPermissionRepoProc.deleteByRoleForBusinessObject(saveVO.getRoleCode(), saveVO.getAppCode(), saveVO.getBusinessObjectCode());
                break;
            }
            case BUSINESS_RESOURCE_RULE: {
                permissionDoSupplier = () -> {
                    SysRoleFieldPermissionDO permissionDO = new SysRoleFieldPermissionDO();
                    permissionDO.setRoleCode(saveVO.getRoleCode());
                    permissionDO.setPermissionType(saveVO.getPermissionType().name());
                    permissionDO.setAppCode(saveVO.getAppCode());
                    permissionDO.setMenuCode(null);
                    permissionDO.setBusinessObjectCode(saveVO.getBusinessObjectCode());
                    permissionDO.setOperationCode(null);
                    return permissionDO;
                };
                this.fieldPermissionRepoProc.deleteByRoleForBusinessObjectResource(saveVO.getRoleCode(), saveVO.getAppCode(), saveVO.getBusinessObjectCode());
                break;
            }
            default: {
                throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6743\u9650\u7c7b\u578b");
            }
        }
        permissionDoList = this.convertForField(saveVO.getFieldList(), permissionDoSupplier);
        if (CollUtil.isNotEmpty(permissionDoList)) {
            this.fieldPermissionRepoProc.save(permissionDoList);
        }
    }

    private void savePermissionRule(DataPermissionSaveVO saveVO) {
        Supplier<SysRoleDataPermissionDO> permissionDoSupplier = null;
        switch (saveVO.getPermissionType()) {
            case MENU_OPERATION_RULE: {
                permissionDoSupplier = () -> {
                    SysRoleDataPermissionDO permissionDO = new SysRoleDataPermissionDO();
                    permissionDO.setRoleCode(saveVO.getRoleCode());
                    permissionDO.setPermissionType(saveVO.getPermissionType().name());
                    permissionDO.setAppCode(saveVO.getAppCode());
                    permissionDO.setMenuCode(saveVO.getMenuCode());
                    permissionDO.setBusinessObjectCode(saveVO.getBusinessObjectCode());
                    permissionDO.setOperationCode(saveVO.getOperationCode());
                    return permissionDO;
                };
                this.dataPermissionRepoProc.deleteByRoleForMenuOperation(saveVO.getRoleCode(), saveVO.getMenuCode(), saveVO.getOperationCode());
                break;
            }
            case BUSINESS_OPERATION_RULE: {
                permissionDoSupplier = () -> {
                    SysRoleDataPermissionDO permissionDO = new SysRoleDataPermissionDO();
                    permissionDO.setRoleCode(saveVO.getRoleCode());
                    permissionDO.setPermissionType(saveVO.getPermissionType().name());
                    permissionDO.setAppCode(saveVO.getAppCode());
                    permissionDO.setMenuCode(null);
                    permissionDO.setBusinessObjectCode(saveVO.getBusinessObjectCode());
                    permissionDO.setOperationCode(saveVO.getOperationCode());
                    return permissionDO;
                };
                this.dataPermissionRepoProc.deleteByRoleForBusinessOperation(saveVO.getRoleCode(), saveVO.getOperationCode());
                break;
            }
            case BUSINESS_OBJECT_RULE: {
                permissionDoSupplier = () -> {
                    SysRoleDataPermissionDO permissionDO = new SysRoleDataPermissionDO();
                    permissionDO.setRoleCode(saveVO.getRoleCode());
                    permissionDO.setPermissionType(saveVO.getPermissionType().name());
                    permissionDO.setAppCode(saveVO.getAppCode());
                    permissionDO.setMenuCode(null);
                    permissionDO.setBusinessObjectCode(saveVO.getBusinessObjectCode());
                    permissionDO.setOperationCode(null);
                    return permissionDO;
                };
                this.dataPermissionRepoProc.deleteByRoleForBusinessObject(saveVO.getRoleCode(), saveVO.getAppCode(), saveVO.getBusinessObjectCode());
                break;
            }
            case BUSINESS_RESOURCE_RULE: {
                permissionDoSupplier = () -> {
                    SysRoleDataPermissionDO permissionDO = new SysRoleDataPermissionDO();
                    permissionDO.setRoleCode(saveVO.getRoleCode());
                    permissionDO.setPermissionType(saveVO.getPermissionType().name());
                    permissionDO.setAppCode(saveVO.getAppCode());
                    permissionDO.setMenuCode(null);
                    permissionDO.setBusinessObjectCode(saveVO.getBusinessObjectCode());
                    permissionDO.setOperationCode(null);
                    return permissionDO;
                };
                this.dataPermissionRepoProc.deleteByRoleForRefResourceBusinessObject(saveVO.getRoleCode(), saveVO.getAppCode(), saveVO.getBusinessObjectCode());
                break;
            }
            default: {
                throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6743\u9650\u7c7b\u578b");
            }
        }
        List<SysRoleDataPermissionDO> permissionDoList = this.convertForCustomRules(saveVO.getCustomRuleList(), permissionDoSupplier, new RuleGroup());
        if (CollUtil.isNotEmpty(permissionDoList)) {
            this.dataPermissionRepoProc.save(permissionDoList);
        }
    }

    private List<SysRoleDataPermissionDO> convertForCustomRules(List<DataPermissionRuleSaveVO> saveVoList, Supplier<SysRoleDataPermissionDO> baseSupplier, RuleGroup group) {
        if (CollUtil.isEmpty(saveVoList)) {
            return Collections.emptyList();
        }
        ArrayList<SysRoleDataPermissionDO> result = new ArrayList<SysRoleDataPermissionDO>(saveVoList.size());
        int ruleIndex = 0;
        for (DataPermissionRuleSaveVO vo : saveVoList) {
            SysRoleDataPermissionDO permissionDO = baseSupplier.get();
            permissionDO.setRuleGroupCode(group.getCode());
            permissionDO.setRuleRelation(group.getRelation().name());
            permissionDO.setRuleOrder(Integer.valueOf(ruleIndex++));
            this.fillVO(permissionDO, vo);
            result.add(permissionDO);
            if (!permissionDO.getRuleGroup().booleanValue()) continue;
            Assert.notNull((Object)vo.getGroupRelation(), (String)("\u5b58\u5728\u89c4\u5219\u7ec4" + (String)(StringUtils.hasText((String)vo.getDprRuleName()) ? "[" + vo.getDprRuleName() + "]" : "") + "\u7684\u5173\u7cfb\u7c7b\u578b\u4e3a\u7a7a"));
            String groupCode = group.getCode() + "_" + permissionDO.getRuleOrder();
            permissionDO.setRuleGroupCode(groupCode);
            permissionDO.setRuleRelation(vo.getGroupRelation().name());
            result.addAll(this.convertForCustomRules(vo.getGroupRules(), baseSupplier, new RuleGroup(groupCode, vo.getGroupRelation())));
        }
        return result;
    }

    private List<SysRoleFieldPermissionDO> convertForField(List<DataPermissionFieldSaveVO> saveVoList, Supplier<SysRoleFieldPermissionDO> baseSupplier) {
        if (CollUtil.isEmpty(saveVoList)) {
            return Collections.emptyList();
        }
        return saveVoList.stream().filter(this::isAvailableField).map(t -> {
            SysRoleFieldPermissionDO permissionDO = (SysRoleFieldPermissionDO)baseSupplier.get();
            permissionDO.setFieldName(t.getFieldName());
            permissionDO.setReadable(Boolean.valueOf(t.getReadable() == null || t.getReadable() != false));
            permissionDO.setWriteable(Boolean.valueOf(t.getWriteable() == null || t.getWriteable() != false));
            return permissionDO;
        }).collect(Collectors.toList());
    }

    private boolean isAvailableField(DataPermissionFieldSaveVO saveVO) {
        if (saveVO == null || CharSequenceUtil.isBlank((CharSequence)saveVO.getFieldName())) {
            return false;
        }
        return !Boolean.TRUE.equals(saveVO.getReadable()) || !Boolean.TRUE.equals(saveVO.getWriteable());
    }

    private void fillVO(SysRoleDataPermissionDO permissionDO, DataPermissionRuleSaveVO ruleSaveVO) {
        permissionDO.setRuleGroup(Boolean.valueOf(Boolean.TRUE.equals(ruleSaveVO.getRuleGroup())));
        permissionDO.setRuleName(ruleSaveVO.getDprRuleName());
        permissionDO.setRuleDescription(ruleSaveVO.getDprRuleDeclare());
        permissionDO.setRuleField(ruleSaveVO.getDprRuleField());
        permissionDO.setRuleFieldType(ruleSaveVO.getRuleFieldType());
        permissionDO.setRefResource(ruleSaveVO.getRefResource());
        permissionDO.setRefBusinessObject(ruleSaveVO.getRefBusinessObject());
        permissionDO.setRefField(ruleSaveVO.getRefField());
        permissionDO.setFieldValueCondition(ruleSaveVO.getDprRuleCondition() == null ? null : ruleSaveVO.getDprRuleCondition().name());
        permissionDO.setRuleValueType(ruleSaveVO.getDprRuleValueType() == null ? null : ruleSaveVO.getDprRuleValueType().name());
        permissionDO.setRuleValue(ruleSaveVO.getDprRuleValue());
        permissionDO.setRuleValueName(ruleSaveVO.getDprRuleValueName());
        permissionDO.setDataSet(ruleSaveVO.getDataSet());
        permissionDO.setBs1(ruleSaveVO.getBs1());
        permissionDO.setBs2(ruleSaveVO.getBs2());
        permissionDO.setBs3(ruleSaveVO.getBs3());
    }

    private void check(DataPermissionSaveVO saveVO) {
        if (this.existsCircularReference(saveVO)) {
            throw new BusinessException("\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61\u4e4b\u95f4\u7684\u5faa\u73af\u4f9d\u8d56, \u8bf7\u68c0\u67e5\u914d\u7f6e\u6743\u9650\u89c4\u5219");
        }
        Assert.hasText((String)saveVO.getRoleCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        Assert.notNull((Object)saveVO.getPermissionType(), (String)"\u6743\u9650\u7c7b\u578b\u4e3a\u7a7a");
        switch (saveVO.getPermissionType()) {
            case MENU_OPERATION_RULE: {
                Assert.hasText((String)saveVO.getMenuCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
                Assert.hasText((String)saveVO.getOperationCode(), (String)"\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a");
                BusinessOperationBO operationInfo = (BusinessOperationBO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.businessOperationRepoProc.getSimpleBO(saveVO.getOperationCode()));
                Assert.notNull((Object)operationInfo, (String)"\u64cd\u4f5c\u4e0d\u5b58\u5728");
                saveVO.setAppCode(operationInfo.getAppCode());
                saveVO.setBusinessObjectCode(operationInfo.getBusinessObjectCode());
                break;
            }
            case BUSINESS_OPERATION_RULE: {
                Assert.hasText((String)saveVO.getOperationCode(), (String)"\u64cd\u4f5c\u7f16\u7801\u4e3a\u7a7a");
                BusinessOperationBO menuOperationInfo = (BusinessOperationBO)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.businessOperationRepoProc.getSimpleBO(saveVO.getOperationCode()));
                Assert.notNull((Object)menuOperationInfo, (String)"\u64cd\u4f5c\u4e0d\u5b58\u5728");
                saveVO.setAppCode(menuOperationInfo.getAppCode());
                saveVO.setBusinessObjectCode(menuOperationInfo.getBusinessObjectCode());
                break;
            }
            case BUSINESS_OBJECT_RULE: 
            case BUSINESS_RESOURCE_RULE: {
                Assert.hasText((String)saveVO.getBusinessObjectCode(), (String)"\u4e1a\u52a1\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a");
                this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                    saveVO.setAppCode(this.businessObjectRepoProc.getAppCode(saveVO.getBusinessObjectCode()));
                    return null;
                });
                Assert.hasText((String)saveVO.getAppCode(), (String)"\u672a\u77e5\u4e1a\u52a1\u5bf9\u8c61\u6240\u5c5e\u5e94\u7528");
                break;
            }
            default: {
                throw new BusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6743\u9650\u7c7b\u578b");
            }
        }
        if (CollUtil.isNotEmpty(saveVO.getCustomRuleList())) {
            Map<String, Object> businessParamMap = StringUtils.hasText((String)saveVO.getBusinessObjectCode()) ? ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.businessParamRepoProc.listSimpleBoByBusinessObjectCode(saveVO.getBusinessObjectCode(), saveVO.getAppCode()))).stream().collect(Collectors.toMap(BusinessParamBO::getFieldName, Functions.identity(), (t1, t2) -> t1)) : Collections.emptyMap();
            this.checkRules(saveVO.getCustomRuleList(), (Map<String, BusinessParamBO>)businessParamMap);
        }
        if (CollUtil.isNotEmpty(saveVO.getFieldList())) {
            for (DataPermissionFieldSaveVO fieldSaveVO : saveVO.getFieldList()) {
                Assert.hasText((String)fieldSaveVO.getFieldName(), (String)"\u5b57\u6bb5\u6743\u9650\u914d\u7f6e\u4e2d\u5b58\u5728\u5b57\u6bb5\u540d\u79f0\u4e3a\u7a7a");
            }
        }
        AtomicBoolean supportUseDef = new AtomicBoolean(false);
        if (Boolean.TRUE.equals(saveVO.getUseRef()) && StringUtils.hasText((String)saveVO.getOperationCode())) {
            this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
                String permissionRef = this.businessOperationRepoProc.getPermissionRefByOperationCode(saveVO.getOperationCode());
                if (!StringUtils.hasText((String)permissionRef)) {
                    throw new IllegalArgumentException("\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61\u64cd\u4f5c\u65e0\u5173\u8054\u7684\u64cd\u4f5c\uff0c\u5f15\u7528\u6743\u9650\u89c4\u5219\u5931\u8d25");
                }
                saveVO.setCustomRuleList(Collections.emptyList());
                saveVO.setFieldList(Collections.emptyList());
                supportUseDef.set(true);
                return null;
            });
        }
        saveVO.setUseRef(supportUseDef.get());
    }

    private boolean existsCircularReference(DataPermissionSaveVO saveVO) {
        if (CollUtil.isEmpty(saveVO.getCustomRuleList())) {
            return false;
        }
        Set<String> refBusinessObjectCodes = this.getRefBusinessObjectCodes(saveVO.getCustomRuleList());
        if (refBusinessObjectCodes.isEmpty()) {
            return false;
        }
        Map<String, String> businessObjectRefMap = this.roleDataPermissionRepoProc.queryBusinessObjectRef(saveVO.getRoleCode());
        for (String refBusinessObjectCode : refBusinessObjectCodes) {
            if (!this.existsCircularReference(refBusinessObjectCode, businessObjectRefMap, new HashSet<String>(8))) continue;
            return true;
        }
        return false;
    }

    private boolean existsCircularReference(String businessObjectCode, Map<String, String> businessObjectRefMap, Set<String> existsRef) {
        existsRef.add(businessObjectCode);
        String ref = businessObjectRefMap.get(businessObjectCode);
        if (StrUtil.isBlank((CharSequence)ref)) {
            return false;
        }
        if (existsRef.contains(ref)) {
            return true;
        }
        return this.existsCircularReference(ref, businessObjectRefMap, existsRef);
    }

    private Set<String> getRefBusinessObjectCodes(List<DataPermissionRuleSaveVO> ruleList) {
        if (CollUtil.isEmpty(ruleList)) {
            return Collections.emptySet();
        }
        HashSet<String> codes = new HashSet<String>(ruleList.size());
        for (DataPermissionRuleSaveVO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) {
                codes.addAll(this.getRefBusinessObjectCodes(rule.getGroupRules()));
                continue;
            }
            if (!StrUtil.isNotBlank((CharSequence)rule.getRefBusinessObject())) continue;
            codes.add(rule.getRefBusinessObject());
        }
        return codes;
    }

    private void checkRules(List<DataPermissionRuleSaveVO> customRuleList, Map<String, BusinessParamBO> businessParamMap) {
        if (CollUtil.isEmpty(customRuleList)) {
            return;
        }
        for (DataPermissionRuleSaveVO ruleSaveVO : customRuleList) {
            ruleSaveVO.setRuleGroup((Boolean)ObjUtil.defaultIfNull((Object)ruleSaveVO.getRuleGroup(), (Object)false));
            ruleSaveVO.setGroupRelation((DprRuleRelationEnum)ObjUtil.defaultIfNull((Object)ruleSaveVO.getGroupRelation(), (Object)DprRuleRelationEnum.DPR_RULE_RELATION_AND));
            if (ruleSaveVO.getRuleGroup().booleanValue()) {
                this.checkRules(ruleSaveVO.getGroupRules(), businessParamMap);
                continue;
            }
            Assert.hasText((String)ruleSaveVO.getDprRuleField(), (String)"\u5b58\u5728\u89c4\u5219\u7684\u5b57\u6bb5\u4e3a\u7a7a");
            Assert.notNull((Object)ruleSaveVO.getDprRuleValueType(), (String)"\u5b58\u5728\u89c4\u5219\u7684\u503c\u7c7b\u578b\u4e3a\u7a7a");
            BusinessParamBO businessParam = businessParamMap.get(ruleSaveVO.getDprRuleField());
            Assert.notNull((Object)businessParam, (String)("\u53c2\u6570" + ruleSaveVO.getDprRuleField() + "\u4e0d\u5b58\u5728"));
            ruleSaveVO.setRuleFieldType(businessParam.getFieldJavaType());
            if (Boolean.TRUE.equals(ruleSaveVO.getRefResource())) {
                Assert.hasText((String)ruleSaveVO.getRefBusinessObject(), (String)"\u5173\u8054\u7684\u8d44\u6e90\u4e1a\u52a1\u5bf9\u8c61\u4e3a\u7a7a");
                if (StrUtil.isBlank((CharSequence)ruleSaveVO.getRefField())) {
                    ruleSaveVO.setRefField(businessParam.getRelatedField());
                }
                Assert.hasText((String)ruleSaveVO.getRefField(), (String)("\u672a\u77e5\u5173\u8054\u7684\u4e1a\u52a1\u5bf9\u8c61\u7684\u5b57\u6bb5\uff1a" + ruleSaveVO.getRefBusinessObject() + "-" + ruleSaveVO.getDprRuleField()));
            } else {
                Assert.notNull((Object)ruleSaveVO.getDprRuleCondition(), (String)"\u5b58\u5728\u89c4\u5219\u7684\u6761\u4ef6\u4e3a\u7a7a");
                Assert.hasText((String)ruleSaveVO.getDprRuleValue(), (String)"\u89c4\u5219\u503c\u4e0d\u80fd\u4e3a\u7a7a");
            }
            ruleSaveVO.setDprRuleCondition((DprRuleConditionEnum)ObjUtil.defaultIfNull((Object)ruleSaveVO.getDprRuleCondition(), (Object)DprRuleConditionEnum.InList));
        }
    }

    private List<DataPermissionTreeNodeRespVO> queryDataPermissionTreeOfBusinessObject(String roleCode, String appCode, boolean includeApp, boolean publicResource) {
        List roleDataPermissionRuleList;
        ArrayList<DataPermissionTreeNodeRespVO> respVoList = new ArrayList<DataPermissionTreeNodeRespVO>(128);
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            Map<String, AppBO> tenantApps = super.tenantApps(appCode);
            if (tenantApps.isEmpty()) {
                return Collections.emptyList();
            }
            List<BusinessObjectBO> objectList = this.businessObjectRepoProc.listSimpleByAppCodes(tenantApps.keySet(), true, publicResource);
            if (objectList.isEmpty()) {
                return Collections.emptyList();
            }
            int i = 0;
            DataPermissionTreeNodeRespVO respVO = null;
            HashSet<String> existsAppCodes = new HashSet<String>(objectList.size());
            for (BusinessObjectBO businessObjectBO : objectList) {
                respVO = this.convertDataPermissionTreeNode(businessObjectBO, includeApp);
                respVO.setSortNo(i++);
                respVoList.add(respVO);
                existsAppCodes.add(businessObjectBO.getAppCode());
            }
            if (includeApp) {
                i = 0;
                for (Map.Entry entry : tenantApps.entrySet()) {
                    if (!existsAppCodes.contains(entry.getKey())) continue;
                    respVO = this.convertDataPermissionTreeNode((AppBO)entry.getValue());
                    respVO.setSortNo(i++);
                    respVoList.add(respVO);
                }
            }
            return null;
        });
        if (respVoList.isEmpty()) {
            return Collections.emptyList();
        }
        DataPermissionType permissionType = publicResource ? DataPermissionType.BUSINESS_RESOURCE_RULE : DataPermissionType.BUSINESS_OBJECT_RULE;
        List<Object> list = roleDataPermissionRuleList = CharSequenceUtil.isBlank((CharSequence)roleCode) ? Collections.emptyList() : this.dataPermissionRepoProc.listRolePermissionRuleByRole(roleCode, permissionType);
        if (roleDataPermissionRuleList.isEmpty()) {
            return respVoList;
        }
        Map<String, Long> ruleCount = roleDataPermissionRuleList.stream().collect(Collectors.groupingBy(t -> t.getBusinessObjectCode(), Collectors.counting()));
        for (DataPermissionTreeNodeRespVO respVO : respVoList) {
            if (!MenuTreeNodeType.BUSINESS_OBJECT.getValue().equals(respVO.getNodeType())) continue;
            respVO.setRuleNum(ruleCount.getOrDefault(respVO.getCode(), 0L));
        }
        return respVoList;
    }

    private List<DataPermissionTreeNodeRespVO> queryDataPermissionTreeOfBusinessOperation(String roleCode, String appCode, boolean withRef, boolean includeApp) {
        List roleDataPermissionRuleList;
        ArrayList<DataPermissionTreeNodeRespVO> respVoList = new ArrayList<DataPermissionTreeNodeRespVO>(128);
        HashMap<String, List<BusinessRefBO>> refMap = new HashMap<String, List<BusinessRefBO>>(8);
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            Map<String, AppBO> tenantApps = super.tenantApps(appCode);
            if (tenantApps.isEmpty()) {
                return Collections.emptyList();
            }
            List<BusinessObjectBO> objectList = this.businessObjectRepoProc.listSimpleByAppCodes(tenantApps.keySet(), true, null);
            if (objectList.isEmpty()) {
                return Collections.emptyList();
            }
            int i = 0;
            DataPermissionTreeNodeRespVO respVO = null;
            HashSet<Long> existsBusinessIds = new HashSet<Long>(objectList.size());
            HashSet<String> existsAppCodes = new HashSet<String>(objectList.size());
            for (BusinessObjectBO businessObjectBO : objectList) {
                respVO = this.convertDataPermissionTreeNode(businessObjectBO, includeApp);
                respVO.setSortNo(i++);
                respVoList.add(respVO);
                existsBusinessIds.add(businessObjectBO.getId());
                existsAppCodes.add(businessObjectBO.getAppCode());
            }
            if (includeApp) {
                i = 0;
                for (Map.Entry entry : tenantApps.entrySet()) {
                    if (!existsAppCodes.contains(entry.getKey())) continue;
                    respVO = this.convertDataPermissionTreeNode((AppBO)entry.getValue());
                    respVO.setSortNo(i++);
                    respVoList.add(respVO);
                }
            }
            AtomicInteger sortNo = new AtomicInteger(0);
            this.businessOperationRepoProc.listSimpleByAppCode(existsAppCodes, true, true).stream().filter(t -> existsBusinessIds.contains(t.getBusinessObjectId())).forEach(t -> {
                DataPermissionTreeNodeRespVO vo = this.convertDataPermissionTreeNode((BusinessOperationBO)t);
                vo.setSortNo(sortNo.getAndIncrement());
                respVoList.add(vo);
            });
            if (withRef) {
                refMap.putAll(this.refRepoProc.listSimpleBo().stream().collect(Collectors.groupingBy(BusinessRefBO::getBusinessObjectCode)));
            }
            return null;
        });
        if (respVoList.isEmpty()) {
            return Collections.emptyList();
        }
        this.dealRefNode(respVoList, refMap);
        List<Object> list = roleDataPermissionRuleList = CharSequenceUtil.isBlank((CharSequence)roleCode) ? Collections.emptyList() : this.dataPermissionRepoProc.listRolePermissionRuleByRole(roleCode, DataPermissionType.BUSINESS_OPERATION_RULE);
        if (roleDataPermissionRuleList.isEmpty()) {
            return respVoList;
        }
        Map<String, Long> ruleCount = roleDataPermissionRuleList.stream().collect(Collectors.groupingBy(RolePermissionRuleBO::getOperationCode, Collectors.counting()));
        for (DataPermissionTreeNodeRespVO respVO : respVoList) {
            if (!MenuTreeNodeType.BUSINESS_OPERATION.getValue().equals(respVO.getNodeType())) continue;
            if (StringUtils.hasText((String)respVO.getRefPermission())) {
                respVO.setRuleNum(ruleCount.getOrDefault(respVO.getRefPermission(), 0L));
                continue;
            }
            respVO.setRuleNum(ruleCount.getOrDefault(respVO.getCode(), 0L));
        }
        return respVoList;
    }

    private void dealRefNode(List<DataPermissionTreeNodeRespVO> ruleList, Map<String, List<BusinessRefBO>> refMap) {
        if (ruleList.isEmpty() || refMap.isEmpty()) {
            return;
        }
        Map operationMap = ruleList.stream().filter(t -> BusinessObjectNodeType.BUSINESS_OPERATION.name().equals(t.getNodeType())).collect(Collectors.toMap(TreeRespParam::getCode, Function.identity(), (t1, t2) -> t1));
        ArrayList newNodeList = new ArrayList();
        for (DataPermissionTreeNodeRespVO respVo : ruleList) {
            List refList;
            if (!BusinessObjectNodeType.BUSINESS_OBJECT.name().equals(respVo.getNodeType()) || (refList = refMap.getOrDefault(respVo.getCode().split(":")[1], Collections.emptyList())).isEmpty()) continue;
            AtomicInteger sortNo = new AtomicInteger(0);
            List refNodeList = refList.stream().filter(t -> BusinessObjectRefTypeEnum.BUSINESS_OPERATION.name().equals(t.getRefType()) && operationMap.containsKey(t.getRef())).map(t -> {
                DataPermissionTreeNodeRespVO operation = (DataPermissionTreeNodeRespVO)((Object)((Object)operationMap.get(t.getRef())));
                DataPermissionTreeNodeRespVO refVo = new DataPermissionTreeNodeRespVO();
                refVo.setRoute(operation.getRoute());
                refVo.setNodeType(operation.getNodeType());
                refVo.setNodeTypeName(operation.getNodeTypeName());
                refVo.setRefNode(true);
                refVo.setRuleNum(operation.getRuleNum());
                refVo.setIcon(operation.getIcon());
                refVo.setApiDetail(operation.getApiDetail());
                refVo.setOperationDetail(operation.getOperationDetail());
                refVo.setId(operation.getId());
                refVo.setCode(operation.getCode());
                refVo.setName(operation.getName());
                refVo.setSortNo(sortNo.getAndIncrement());
                refVo.setParentId(respVo.getId());
                refVo.setParentCode(respVo.getCode());
                refVo.setChildren(respVo.getChildren());
                return refVo;
            }).collect(Collectors.toList());
            if (refNodeList.isEmpty()) continue;
            newNodeList.addAll(refNodeList);
        }
        if (newNodeList.isEmpty()) {
            return;
        }
        ruleList.addAll(newNodeList);
    }

    private List<DataPermissionTreeNodeRespVO> queryDataPermissionTreeOfMenuOperation(String roleCode, String appCode, Long tenantId, boolean includeApp) {
        LinkedHashMap<String, AppBO> tenantApp = new LinkedHashMap<String, AppBO>();
        Map menuOperationMap = (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            Map<String, AppBO> tenantApps = super.tenantApps(appCode);
            if (tenantApps.isEmpty()) {
                return Collections.emptyMap();
            }
            tenantApp.putAll(tenantApps);
            return this.menuOperationRepoProc.listOperationOfMenu(tenantApps.keySet());
        });
        if (menuOperationMap.isEmpty()) {
            return Collections.emptyList();
        }
        boolean custom = false;
        List<RolePermissionRespVO> respVOList = this.queryAppAndMenu(tenantApp, custom, includeApp);
        if (respVOList.isEmpty()) {
            return Collections.emptyList();
        }
        List<RolePermissionRuleBO> roleDataPermissionRuleList = CharSequenceUtil.isBlank((CharSequence)roleCode) ? Collections.emptyList() : this.dataPermissionRepoProc.listRolePermissionRuleByRole(roleCode, DataPermissionType.MENU_OPERATION_RULE);
        List<DataPermissionTreeNodeRespVO> treeNodeList = respVOList.stream().map(this::convertDataPermissionTreeNode).collect(Collectors.toList());
        treeNodeList.addAll(this.convertDataPermissionTreeNodeForMenuOperation(menuOperationMap, roleDataPermissionRuleList));
        return treeNodeList;
    }

    private List<DataPermissionTreeNodeRespVO> convertDataPermissionTreeNode(Map<String, List<SysMenuApiRespVO>> menuApiMap, List<RoleApiRuleBO> roleApiRuleList) {
        Map<String, Long> roleApiMap = roleApiRuleList.stream().collect(Collectors.groupingBy(t -> t.getMenuCode() + ":" + t.getApiCode(), Collectors.counting()));
        ArrayList<DataPermissionTreeNodeRespVO> respVoList = new ArrayList<DataPermissionTreeNodeRespVO>();
        DataPermissionTreeNodeRespVO respVO = null;
        for (Map.Entry<String, List<SysMenuApiRespVO>> entry : menuApiMap.entrySet()) {
            int i = 0;
            String menuCode = entry.getKey();
            for (SysMenuApiRespVO param : entry.getValue()) {
                respVO = new DataPermissionTreeNodeRespVO();
                respVO.setNodeType(MenuTreeNodeType.API.getValue());
                respVO.setRuleNum(roleApiMap.getOrDefault(menuCode + ":" + param.getCode(), 0L));
                respVO.setCode(param.getCode());
                respVO.setName(param.getName());
                respVO.setSortNo(i++);
                respVO.setParentCode(menuCode);
                respVO.setHasChildren(false);
                respVO.setChildren(Collections.emptyList());
                respVO.setApiDetail(param);
                respVoList.add(respVO);
            }
        }
        return respVoList;
    }

    private List<DataPermissionTreeNodeRespVO> convertDataPermissionTreeNodeForMenuOperation(Map<String, List<MenuOperationRespVO>> menuApiMap, List<RolePermissionRuleBO> roleApiRuleList) {
        Map<String, Long> roleApiMap = roleApiRuleList.stream().collect(Collectors.groupingBy(t -> t.getMenuCode() + ":" + t.getOperationCode(), Collectors.counting()));
        ArrayList<DataPermissionTreeNodeRespVO> respVoList = new ArrayList<DataPermissionTreeNodeRespVO>();
        DataPermissionTreeNodeRespVO respVO = null;
        for (Map.Entry<String, List<MenuOperationRespVO>> entry : menuApiMap.entrySet()) {
            int i = 0;
            String menuCode = entry.getKey();
            for (MenuOperationRespVO param : entry.getValue()) {
                respVO = new DataPermissionTreeNodeRespVO();
                respVO.setId(param.getId());
                respVO.setNodeType(MenuTreeNodeType.BUSINESS_OPERATION.getValue());
                respVO.setNodeTypeName(MenuTreeNodeType.BUSINESS_OPERATION.getDescription());
                if (StringUtils.hasText((String)param.getPermissionRef())) {
                    respVO.setRuleNum(roleApiMap.getOrDefault(menuCode + ":" + param.getPermissionRef(), 0L));
                } else {
                    respVO.setRuleNum(roleApiMap.getOrDefault(menuCode + ":" + param.getOperationCode(), 0L));
                }
                respVO.setCode(param.getOperationCode());
                respVO.setName(param.getOperationName());
                respVO.setSortNo(i++);
                respVO.setParentCode(menuCode);
                respVO.setHasChildren(false);
                respVO.setChildren(Collections.emptyList());
                respVO.setOperationDetail(param);
                if (StringUtils.hasText((String)param.getPermissionRef())) {
                    respVO.setRefPermission(param.getPermissionRef());
                    respVO.setRefPermissionName(param.getPermissionRefName());
                }
                respVoList.add(respVO);
            }
        }
        return respVoList;
    }

    private DataPermissionTreeNodeRespVO convertDataPermissionTreeNode(AppBO app) {
        DataPermissionTreeNodeRespVO respVO = new DataPermissionTreeNodeRespVO();
        respVO.setNodeType(MenuTreeNodeType.APP.getValue());
        respVO.setNodeTypeName(MenuTreeNodeType.APP.getDescription());
        respVO.setRefNode(false);
        respVO.setIcon(app.getIcon());
        respVO.setId(app.getId());
        respVO.setCode(app.getAppCode());
        respVO.setName(app.getAppName());
        respVO.setSortNo(0);
        respVO.setHasChildren(false);
        respVO.setChildren(Collections.emptyList());
        return respVO;
    }

    private DataPermissionTreeNodeRespVO convertDataPermissionTreeNode(BusinessOperationBO simpleBO) {
        DataPermissionTreeNodeRespVO respVO = new DataPermissionTreeNodeRespVO();
        respVO.setNodeType(MenuTreeNodeType.BUSINESS_OPERATION.getValue());
        respVO.setNodeTypeName(MenuTreeNodeType.BUSINESS_OPERATION.getDescription());
        respVO.setRefNode(false);
        if (StringUtils.hasText((String)simpleBO.getPermissionRef())) {
            respVO.setRefPermission(simpleBO.getPermissionRef());
            respVO.setRefPermissionName(simpleBO.getPermissionRefName());
        }
        respVO.setRuleNum(0L);
        respVO.setId(simpleBO.getId());
        respVO.setCode(simpleBO.getOperationCode());
        respVO.setName(CharSequenceUtil.blankToDefault((CharSequence)simpleBO.getCustomName(), (String)simpleBO.getOperationDescription()));
        respVO.setSortNo(0);
        respVO.setParentCode(simpleBO.getBusinessObjectCode());
        respVO.setHasChildren(false);
        respVO.setChildren(new ArrayList(64));
        respVO.setBusinessObjectCode(simpleBO.getBusinessObjectCode());
        MenuOperationRespVO operationDetail = new MenuOperationRespVO();
        operationDetail.setId(simpleBO.getId());
        operationDetail.setAppCode(simpleBO.getAppCode());
        operationDetail.setAppName(simpleBO.getAppName());
        operationDetail.setBusinessObjectCode(simpleBO.getBusinessObjectCode());
        operationDetail.setBusinessObjectName(simpleBO.getBusinessObjectName());
        operationDetail.setOperationCode(simpleBO.getOperationCode());
        operationDetail.setOperationName(CharSequenceUtil.blankToDefault((CharSequence)simpleBO.getCustomName(), (String)simpleBO.getApiName()));
        operationDetail.setApiMethod(simpleBO.getApiMethod());
        operationDetail.setApiUrl(simpleBO.getApiUrl());
        operationDetail.setPermissionRef(simpleBO.getPermissionRef());
        operationDetail.setPermissionRefName(simpleBO.getPermissionRefName());
        respVO.setOperationDetail(operationDetail);
        return respVO;
    }

    private DataPermissionTreeNodeRespVO convertDataPermissionTreeNode(BusinessObjectBO simpleBO, boolean includeApp) {
        DataPermissionTreeNodeRespVO respVO = new DataPermissionTreeNodeRespVO();
        respVO.setNodeType(MenuTreeNodeType.BUSINESS_OBJECT.getValue());
        respVO.setNodeTypeName(MenuTreeNodeType.BUSINESS_OBJECT.getDescription());
        respVO.setRefNode(false);
        respVO.setRuleNum(0L);
        respVO.setId(simpleBO.getId());
        respVO.setCode(simpleBO.getCode());
        respVO.setName(CharSequenceUtil.blankToDefault((CharSequence)simpleBO.getCustomName(), (String)simpleBO.getName()));
        respVO.setSortNo(0);
        if (includeApp) {
            respVO.setParentCode(simpleBO.getAppCode());
        }
        respVO.setHasChildren(false);
        respVO.setChildren(new ArrayList(64));
        respVO.setBusinessObjectCode(simpleBO.getCode());
        return respVO;
    }

    private DataPermissionTreeNodeRespVO convertDataPermissionTreeNode(RolePermissionRespVO rolePermissionRespVO) {
        DataPermissionTreeNodeRespVO treeNodeRespVO = new DataPermissionTreeNodeRespVO();
        treeNodeRespVO.setId(rolePermissionRespVO.getId());
        treeNodeRespVO.setRoute(rolePermissionRespVO.getRoute());
        treeNodeRespVO.setNodeType(rolePermissionRespVO.getNodeType());
        treeNodeRespVO.setNodeTypeName(MenuTreeNodeType.valueOf((String)rolePermissionRespVO.getNodeType()).getDescription());
        treeNodeRespVO.setIcon(rolePermissionRespVO.getMenusIcon());
        treeNodeRespVO.setRuleNum(0L);
        treeNodeRespVO.setCode(rolePermissionRespVO.getCode());
        treeNodeRespVO.setName(rolePermissionRespVO.getName());
        treeNodeRespVO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)rolePermissionRespVO.getSortNo(), (Object)0));
        treeNodeRespVO.setParentId(null);
        treeNodeRespVO.setParentCode(rolePermissionRespVO.getParentCode());
        treeNodeRespVO.setHasChildren(false);
        treeNodeRespVO.setChildren(new ArrayList(0));
        return treeNodeRespVO;
    }

    private void cloneRoleDataPermission(long originalId, long roleId) {
        List fieldPermissionList;
        List roleColumnPermissionList;
        List dataPermissionList;
        String originalRoleCode = this.roleRepoProc.getCode(originalId);
        String roleCode = this.roleRepoProc.getCode(roleId);
        if (CharSequenceUtil.isBlank((CharSequence)originalRoleCode) || CharSequenceUtil.isBlank((CharSequence)roleCode)) {
            return;
        }
        List roleDataPermissionList = this.roleApiRowRuleRepoProc.listByRole(originalId).stream().map(t -> {
            SysDprRoleApiRowRuleDO ruleDO = SysDprRoleApiRuleConvert.INSTANCE.do2Do((SysDprRoleApiRowRuleDO)t);
            ruleDO.setId(null);
            ruleDO.setRoleId(Long.valueOf(roleId));
            return ruleDO;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(roleDataPermissionList)) {
            this.roleApiRowRuleRepoProc.save(roleDataPermissionList);
        }
        if (CollUtil.isNotEmpty(dataPermissionList = this.roleDataPermissionRepoProc.listByRole(originalRoleCode).stream().map(t -> {
            SysRoleDataPermissionDO permissionDO = PermissionConverter.INSTANCE.convertDataPermission((SysRoleDataPermissionDO)t);
            permissionDO.setId(null);
            permissionDO.setRoleCode(roleCode);
            return permissionDO;
        }).collect(Collectors.toList()))) {
            this.roleDataPermissionRepoProc.save(dataPermissionList);
        }
        if (CollUtil.isNotEmpty(roleColumnPermissionList = this.apiFieldsRepoProc.listByRole(originalId).stream().map(t -> {
            SysDpcrApiFieldsDO permissionDO = SysDpcRoleApiFieldsConvert.INSTANCE.do2Do((SysDpcrApiFieldsDO)t);
            permissionDO.setId(null);
            permissionDO.setRoleId(Long.valueOf(roleId));
            return permissionDO;
        }).collect(Collectors.toList()))) {
            this.apiFieldsRepoProc.save(roleColumnPermissionList);
        }
        if (CollUtil.isNotEmpty(fieldPermissionList = this.fieldPermissionRepoProc.listByRole(originalRoleCode).stream().map(t -> {
            SysRoleFieldPermissionDO permissionDO = PermissionConverter.INSTANCE.convertFieldPermission((SysRoleFieldPermissionDO)t);
            permissionDO.setId(null);
            permissionDO.setRoleCode(roleCode);
            return permissionDO;
        }).collect(Collectors.toList()))) {
            this.fieldPermissionRepoProc.save(fieldPermissionList);
        }
    }

    private void cloneRoleMenu(long originalId, long roleId) {
        String roleCode = this.roleRepoProc.getCode(roleId);
        List rolePermissionList = this.rolePermissionRepoProc.listByRole(originalId).stream().map(t -> {
            SysRolePermissionDO permissionDO = RoleConvert.INSTANCE.do2do((SysRolePermissionDO)t);
            permissionDO.setId(null);
            permissionDO.setRoleId(Long.valueOf(roleId));
            permissionDO.setRoleCode(roleCode);
            return permissionDO;
        }).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(rolePermissionList)) {
            this.rolePermissionRepoProc.save(rolePermissionList);
        }
    }

    private Long currentTenantId() {
        SysTenantDTO currentTenant = this.tenantClientProvider.getCurrentTenant();
        return currentTenant == null ? TenantConstant.DEFAULT_TENANT_ID : currentTenant.getId();
    }

    private boolean hasCustomMenuTree(Long tenantId) {
        Boolean custom;
        if (tenantId == null) {
            GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
            tenantId = (Long)ObjectUtil.defaultIfNull((Object)currentUser.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID);
        }
        return (custom = this.tenantMenuRepoProc.getEnabledByTenant(tenantId)) != null && custom != false;
    }

    private Set<String> getApps() {
        SysTenantDTO currentTenant = this.tenantClientProvider.getCurrentTenant();
        if (currentTenant != null) {
            return currentTenant.getAppCodes();
        }
        return this.queryAppAll(true).stream().map(IdCodeNameParam::getCode).collect(Collectors.toSet());
    }

    private List<IdCodeNameParam> queryAppAll(Boolean enabled) {
        return (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.allParams(enabled));
    }

    private SysDprRoleApiRowRuleDO convertDprRoleApiRowRuleDO(String appCode, SysDprSaveBO saveBO, SysDprApiCustomRuleSaveBO ruleBO, int ruleOrder, DprRuleRelationEnum relation) {
        SysDprRoleApiRowRuleDO ruleDO = new SysDprRoleApiRowRuleDO();
        ruleDO.setRoleId(saveBO.getRoleId());
        ruleDO.setAppCode(appCode);
        ruleDO.setMenuCode(saveBO.getMenuCode());
        ruleDO.setApiCode(saveBO.getApiCode());
        ruleDO.setRuleOrder(Integer.valueOf(ruleOrder));
        ruleDO.setDprRuleRelation(relation.name());
        ruleDO.setDprRuleRelationName(relation.getValueDescription());
        ruleDO.setDprRuleName(ruleBO.getDprRuleName());
        ruleDO.setDprRuleDeclare(ruleBO.getDprRuleDeclare());
        ruleDO.setDprRuleField(ruleBO.getDprRuleField());
        if (ruleBO.getDprRuleCondition() != null) {
            ruleDO.setDprRuleCondition(ruleBO.getDprRuleCondition().name());
            ruleDO.setDprRuleConditionName(ruleBO.getDprRuleCondition().getValueDescription());
        }
        DprRuleValueTypeEnum valueType = ruleBO.getDprRuleValueType();
        Assert.notNull((Object)valueType, (String)"\u53d6\u503c\u65b9\u5f0f\u4e3a\u7a7a");
        if (DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_CUSTOM != valueType && DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS != valueType && DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS != valueType && DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_COMP != valueType) {
            throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u53d6\u503c\u65b9\u5f0f\uff1a" + valueType.getValueDescription());
        }
        ruleDO.setDprRuleValueType(valueType.name());
        ruleDO.setDprRuleValueTypeName(valueType.getValueDescription());
        ruleDO.setDprRuleValue(ruleBO.getDprRuleValue());
        ruleDO.setDprRuleValueName(ruleBO.getDprRuleValueName());
        ruleDO.setRoleRuleValueType(valueType.name());
        ruleDO.setDataSet(ruleBO.getDataSet());
        ruleDO.setRoleRuleValue(ruleBO.getDprRuleValue());
        if (DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS == valueType) {
            ruleDO.setDprSysInternally(ruleBO.getDprRuleValue());
            ruleDO.setDprSysInternallyName(DprValueResolverFactory.convertDprValueTypeName(ruleBO.getDprRuleValue()));
        }
        ruleDO.setDataRange(Boolean.valueOf(false));
        ruleDO.setBs1(ruleBO.getBs1());
        ruleDO.setBs2(ruleBO.getBs2());
        ruleDO.setBs3(ruleBO.getBs3());
        return ruleDO;
    }

    private void saveDataPermissionCustomRule(Long appId, SysDprSaveBO saveBO, DprRuleRelationEnum relation, Set<String> apiCodesAll) {
        String appCode = (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.getCode(appId.longValue()));
        ArrayList<SysDprRoleApiRowRuleDO> rowRuleDOList = new ArrayList<SysDprRoleApiRowRuleDO>(saveBO.getCustomRuleList().size());
        int order = 0;
        SysDprRoleApiRowRuleDO ruleDO = null;
        if (saveBO.getRange() != null) {
            ruleDO = new SysDprRoleApiRowRuleDO();
            ruleDO.setRoleId(saveBO.getRoleId());
            ruleDO.setAppCode(appCode);
            ruleDO.setMenuCode(saveBO.getMenuCode());
            ruleDO.setApiCode(saveBO.getApiCode());
            ruleDO.setRuleOrder(Integer.valueOf(order++));
            ruleDO.setDprRuleRelation(relation.name());
            ruleDO.setDprRuleRelationName(relation.getValueDescription());
            ruleDO.setDprRuleName("\u6570\u636e\u8303\u56f4");
            ruleDO.setDprRuleValueType(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.name());
            ruleDO.setDprRuleValueTypeName(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.getValueDescription());
            ruleDO.setDprSysInternally(saveBO.getRange());
            ruleDO.setDprSysInternallyName(DprValueResolverFactory.convertDprValueTypeName(saveBO.getRange()));
            ruleDO.setDataRange(Boolean.valueOf(true));
            ruleDO.setBs1(null);
            ruleDO.setBs2(null);
            ruleDO.setBs3(null);
            rowRuleDOList.add(ruleDO);
        }
        for (SysDprApiCustomRuleSaveBO bo : saveBO.getCustomRuleList()) {
            ruleDO = this.convertDprRoleApiRowRuleDO(appCode, saveBO, bo, order++, relation);
            rowRuleDOList.add(ruleDO);
        }
        this.roleApiRowRuleRepoProc.deleteByApi(saveBO.getRoleId(), saveBO.getMenuCode(), saveBO.getApiCode());
        this.roleApiRowRuleRepoProc.deleteForNotExistsApi(saveBO.getMenuCode(), apiCodesAll);
        if (!rowRuleDOList.isEmpty()) {
            this.roleApiRowRuleRepoProc.save(rowRuleDOList);
        }
    }

    private void saveDataPermissionField(Long appId, SysDprSaveBO saveBO) {
        String appCode = (String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.appRepoProc.getCode(appId.longValue()));
        ArrayList<SysDpcrApiFieldsDO> fieldDoList = new ArrayList<SysDpcrApiFieldsDO>(saveBO.getFieldList().size());
        SysDpcrApiFieldsDO fieldsDO = null;
        for (SysDprApiFieldSaveBO bo : saveBO.getFieldList()) {
            fieldsDO = new SysDpcrApiFieldsDO();
            fieldsDO.setRoleId(saveBO.getRoleId());
            fieldsDO.setAppCode(appCode);
            fieldsDO.setMenuCode(saveBO.getMenuCode());
            fieldsDO.setApiCode(saveBO.getApiCode());
            fieldsDO.setFieldName(bo.getFieldName());
            fieldsDO.setFieldRemark(bo.getFieldRemark());
            fieldsDO.setFieldApiVisible((Boolean)ObjectUtil.defaultIfNull((Object)bo.isFieldApiVisible(), (Object)false));
            fieldsDO.setFieldFormVisible((Boolean)ObjectUtil.defaultIfNull((Object)bo.isFieldFormVisible(), (Object)false));
            fieldsDO.setFieldFormUpdate((Boolean)ObjectUtil.defaultIfNull((Object)bo.isFieldFormUpdate(), (Object)false));
            fieldDoList.add(fieldsDO);
        }
        this.apiFieldsRepoProc.deleteByApi(saveBO.getRoleId(), saveBO.getMenuCode(), saveBO.getApiCode());
        if (!fieldDoList.isEmpty()) {
            this.apiFieldsRepoProc.save(fieldDoList);
        }
    }

    private List<RolePermissionRespVO> queryAppAndMenu(Map<String, AppBO> appMap, boolean custom, boolean includeApp) {
        if (custom) {
            return this.queryCustomMenuTree(appMap);
        }
        return this.queryDefaultMenuTree(includeApp, appMap);
    }

    private <T> List<T> filterChildrenForTree(List<T> respVoList, Function<T, List<T>> childrenGetter, BiConsumer<T, List<T>> childrenSetter, Predicate<T> predicate) {
        if (CollUtil.isEmpty(respVoList)) {
            return Collections.emptyList();
        }
        ArrayList<T> dataList = new ArrayList<T>();
        for (T t : respVoList) {
            boolean result = predicate.test(t);
            if (result) {
                dataList.add(t);
            }
            List<T> children = this.filterChildrenForTree(childrenGetter.apply(t), childrenGetter, childrenSetter, predicate);
            childrenSetter.accept(t, children);
            if (result || !CollUtil.isNotEmpty(children)) continue;
            dataList.add(t);
        }
        return dataList;
    }

    private List<DataPermissionTreeNodeRespVO> convertDataPermissionTreeRespVO(List<DataPermissionTreeNodeRespVO> respVoList, boolean tree, MenuTreeNodeType lastNodeType) {
        TreeDataUtil treeDataUtil = new TreeDataUtil(respVoList, TreeRespParam::getCode, TreeRespParam::getParentCode, TreeRespParam::setChildren, Comparator.comparingInt(TreeRespParam::getSortNo));
        respVoList = treeDataUtil.getRoots();
        if (lastNodeType != null) {
            respVoList = this.filterChildrenForTree(respVoList, TreeRespParam::getChildren, TreeRespParam::setChildren, t -> lastNodeType.getValue().equals(t.getNodeType()));
        }
        return tree ? respVoList : CollectionUtil.expandTree((List)respVoList, TreeRespParam::getChildren);
    }

    private List<RolePermissionRespVO> convertPermissionTreeRespVO(List<RolePermissionRespVO> respVOList, List<String> checked, boolean tree) {
        for (RolePermissionRespVO respVO : respVOList) {
            if (checked.contains(respVO.getCode())) {
                respVO.setChecked(true);
            }
            if (respVO.getSortNo() != null) continue;
            respVO.setSortNo(1);
        }
        if (!tree) {
            return respVOList;
        }
        TreeDataUtil treeDataUtil = new TreeDataUtil(respVOList, RolePermissionRespVO::getCode, RolePermissionRespVO::getParentCode, RolePermissionRespVO::setChildren, Comparator.comparingInt(RolePermissionRespVO::getSortNo));
        return treeDataUtil.getRoots();
    }

    private List<RolePermissionRespVO> queryActionList(Set<String> appCodes) {
        return ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuRepoProc.queryActionByAppCode(appCodes, true))).stream().filter(t -> (t.getMenusState() == null || t.getMenusState() != false) && StringUtils.hasText((String)t.getMenusParentCode())).map(t -> {
            RolePermissionRespVO respVO = new RolePermissionRespVO();
            respVO.setCode(t.getMenusCode());
            respVO.setName(t.getMenusName());
            respVO.setNodeType(MenuTreeNodeType.ACTION.getValue());
            respVO.setParentCode(t.getMenusParentCode());
            respVO.setMenusIcon(t.getMenusIcon());
            respVO.setRoute(t.getMenusRoute());
            respVO.setChecked(false);
            respVO.setSortNo(t.getMenusOrder());
            respVO.setHasChildren(false);
            respVO.setChildren(new ArrayList<RolePermissionRespVO>(8));
            return respVO;
        }).collect(Collectors.toList());
    }

    private List<RolePermissionRespVO> queryApiList(Set<String> appCodes) {
        return ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.apiRepoProc.queryByAppCode(appCodes))).stream().map(t -> {
            RolePermissionRespVO respVO = new RolePermissionRespVO();
            respVO.setCode(t.getPermissonCode());
            respVO.setName(t.getPermissonName());
            respVO.setNodeType(MenuTreeNodeType.API.getValue());
            respVO.setParentCode(t.getMenusCode());
            respVO.setChecked(false);
            respVO.setHasChildren(false);
            respVO.setChildren(new ArrayList<RolePermissionRespVO>(8));
            return respVO;
        }).collect(Collectors.toList());
    }

    private List<RolePermissionRespVO> queryCustomMenuTree(Map<String, AppBO> appMap) {
        List<SysTenantMenuTreeDO> menuTreeDOList = this.tenantMenuTreeRepoProc.queryByTenantId();
        if (menuTreeDOList.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, MenuBO> menuDOMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuRepoProc.queryMenu(appMap.keySet(), true, true, true, true))).stream().filter(t -> PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name().equals(t.getMenusType())).collect(Collectors.toMap(MenuBO::getMenusCode, t -> t, (t1, t2) -> t1));
        ArrayList<RolePermissionRespVO> menuVOList = new ArrayList<RolePermissionRespVO>(menuTreeDOList.size());
        RolePermissionRespVO menuVO = null;
        for (SysTenantMenuTreeDO menuTreeDO : menuTreeDOList) {
            menuVO = new RolePermissionRespVO();
            menuVO.setCode(menuTreeDO.getMenuCode());
            menuVO.setName(menuTreeDO.getMenuName());
            MenuTreeNodeType nodeType = MenuTreeNodeType.valueOf((String)menuTreeDO.getNodeType());
            if (nodeType == null) {
                log.error("\u672a\u77e5\u83dc\u5355\u8282\u70b9\u7c7b\u578b\uff1a" + menuTreeDO.getNodeType());
                continue;
            }
            if (MenuTreeNodeType.MENU == nodeType) {
                MenuBO menuBO = menuDOMap.get(menuTreeDO.getMenuCode());
                if (menuBO == null) {
                    if (!menuTreeDO.getCustom().booleanValue()) {
                        log.info("\u83dc\u5355\u4e0d\u5b58\u5728\uff1a" + menuTreeDO.getMenuCode());
                        continue;
                    }
                } else {
                    if (CharSequenceUtil.isBlank((CharSequence)menuVO.getName())) {
                        menuVO.setName(menuBO.getMenusName());
                    }
                    if (menuBO.getMenusState() != null && !menuBO.getMenusState().booleanValue()) continue;
                    menuVO.setRoute(menuBO.getMenusRoute());
                }
            } else if (MenuTreeNodeType.APP == nodeType) {
                AppBO app = appMap.get(menuTreeDO.getMenuCode());
                if (app == null) {
                    log.info("\u5e94\u7528\u5df2\u4e0d\u5b58\u5728\uff1a{}", (Object)menuTreeDO.getMenuCode());
                    continue;
                }
                if (CharSequenceUtil.isBlank((CharSequence)menuVO.getName())) {
                    menuVO.setName(app.getAppName());
                }
            } else {
                log.error("\u6682\u4e0d\u652f\u6301\u7684\u8282\u70b9\u7c7b\u578b\uff1a{}", (Object)nodeType.getValue());
                continue;
            }
            menuVO.setNodeType(menuTreeDO.getNodeType());
            menuVO.setParentCode(menuTreeDO.getParentMenuCode());
            menuVO.setMenusIcon(menuTreeDO.getIcon());
            menuVO.setChecked(false);
            menuVO.setSortNo(menuTreeDO.getSortNo());
            menuVO.setHasChildren(false);
            menuVO.setChildren(new ArrayList<RolePermissionRespVO>(128));
            menuVOList.add(menuVO);
        }
        return menuVOList;
    }

    private List<RolePermissionRespVO> queryDefaultMenuTree(boolean includeApp, Map<String, AppBO> appMap) {
        List<Object> respVOList;
        List<Object> list = respVOList = includeApp ? this.convertMenuTreeRespVO(appMap) : new ArrayList(128);
        if (includeApp && respVOList.isEmpty()) {
            return Collections.emptyList();
        }
        ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuRepoProc.queryMenu(appMap.keySet(), true, true, true, true))).stream().filter(t -> PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name().equals(t.getMenusType())).forEach(t -> {
            RolePermissionRespVO respVO = new RolePermissionRespVO();
            respVO.setId(t.getId());
            respVO.setCode(t.getMenusCode());
            respVO.setName(t.getMenusName());
            respVO.setNodeType(MenuTreeNodeType.MENU.getValue());
            respVO.setParentCode(t.getMenusParentCode());
            if (CharSequenceUtil.isBlank((CharSequence)t.getMenusParentCode())) {
                respVO.setParentCode(t.getMenusAppCode());
            }
            respVO.setMenusIcon(t.getMenusIcon());
            respVO.setRoute(t.getMenusRoute());
            respVO.setChecked(false);
            respVO.setSortNo(t.getMenusOrder());
            respVO.setHasChildren(false);
            respVO.setChildren(new ArrayList<RolePermissionRespVO>(128));
            respVOList.add(respVO);
        });
        return respVOList;
    }

    private List<RolePermissionRespVO> convertMenuTreeRespVO(Map<String, AppBO> appMap) {
        ArrayList<RolePermissionRespVO> respVOList = new ArrayList<RolePermissionRespVO>(256);
        RolePermissionRespVO respVO = null;
        int sortNo = 1;
        for (AppBO app : appMap.values()) {
            respVO = new RolePermissionRespVO();
            respVO.setCode(app.getAppCode());
            respVO.setName(app.getAppName());
            respVO.setNodeType(MenuTreeNodeType.APP.getValue());
            respVO.setMenusIcon(app.getIcon());
            respVO.setChecked(false);
            respVO.setSortNo(sortNo++);
            respVO.setHasChildren(false);
            respVO.setChildren(new ArrayList<RolePermissionRespVO>(128));
            respVOList.add(respVO);
        }
        return respVOList;
    }

    private void fillApiNumOfMenu(Set<String> appCodes, List<RolePermissionRespVO> respVOList) {
        if (CollectionUtils.isEmpty(respVOList)) {
            return;
        }
        Map apiNumMap = (Map)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.menuApiRepoProc.queryNumOfApi(appCodes));
        if (apiNumMap.isEmpty()) {
            return;
        }
        for (RolePermissionRespVO respVO : respVOList) {
            if (!MenuTreeNodeType.MENU.getValue().equals(respVO.getNodeType())) continue;
            respVO.setApiNum((Long)apiNumMap.get(respVO.getCode()));
        }
    }

    private void saveRolePermission(long roleId, List<SysAppPermissionSaveBO> saveVOList, List<MenuTreeNodeType> nodeTypes, boolean custom) {
        Set permissionType = nodeTypes.stream().map(SafeEnum::getValue).collect(Collectors.toSet());
        String roleCode = this.roleRepoProc.getCode(roleId);
        CompletableFuture.runAsync(() -> saveVOList.forEach(saveBO -> {
            String lockKey = "cloudt_sys_role_permission:" + roleId + ":" + saveBO.getAppCode();
            LockUtil.executeByLock((String)lockKey, () -> {
                this.rolePermissionRepoProc.deleteByRole(roleId, saveBO.getAppCode(), permissionType, custom);
                if (CollectionUtils.isEmpty((Collection)saveBO.getPermissionList())) {
                    return null;
                }
                List doList = saveBO.getPermissionList().stream().map(t -> {
                    SysRolePermissionDO permissionDO = new SysRolePermissionDO();
                    permissionDO.setRoleId(Long.valueOf(roleId));
                    permissionDO.setRoleCode(roleCode);
                    permissionDO.setPermissionCode(t.getCode());
                    permissionDO.setAppCode(saveBO.getAppCode());
                    permissionDO.setPermissionType(t.getNodeType());
                    permissionDO.setCustom(Boolean.valueOf(custom));
                    return permissionDO;
                }).collect(Collectors.toList());
                this.rolePermissionRepoProc.save(doList);
                return null;
            }, (Duration)Duration.ofMinutes(2L), (String)"\u5f53\u524d\u89d2\u8272\u64cd\u4f5c\u4eba\u8fc7\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }), (Executor)this.taskExecutor).whenComplete((r, e) -> {
            if (e == null) {
                log.info("\u89d2\u8272\u6743\u9650\u4fdd\u5b58\u6210\u529f\uff1a{}", (Object)roleId);
                return;
            }
            log.error("\u89d2\u8272\u6743\u9650\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)roleId, e);
        });
    }

    private void addRolePermission(Collection<Long> roleIds, SysAppPermissionSaveBO saveBO, List<MenuTreeNodeType> nodeTypes, boolean custom) {
        Set<String> permissionTypes = nodeTypes.stream().map(SafeEnum::getValue).collect(Collectors.toSet());
        Map<Long, String> roleCodeMap = this.roleRepoProc.getCodes(roleIds);
        Assert.notEmpty(roleCodeMap, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        Set permissionsExists = this.rolePermissionRepoProc.getPermissionByRole(roleIds, saveBO.getAppCode(), permissionTypes, (Boolean)custom).stream().map(t -> String.join((CharSequence)":", t.getRoleId().toString(), t.getAppCode(), t.getPermissionType(), t.getPermissionCode())).collect(Collectors.toSet());
        ArrayList<SysRolePermissionDO> permissionDoNewList = new ArrayList<SysRolePermissionDO>();
        for (Map.Entry<Long, String> roleEntry : roleCodeMap.entrySet()) {
            Long roleId = roleEntry.getKey();
            List<SysRolePermissionDO> permissionDoList = saveBO.getPermissionList().stream().filter(t -> {
                if (permissionsExists.isEmpty()) {
                    return true;
                }
                return !permissionsExists.contains(String.join((CharSequence)":", roleId.toString(), saveBO.getAppCode(), t.getNodeType(), t.getCode()));
            }).map(t -> {
                SysRolePermissionDO permissionDO = new SysRolePermissionDO();
                permissionDO.setRoleId(roleId);
                permissionDO.setRoleCode((String)roleEntry.getValue());
                permissionDO.setPermissionCode(t.getCode());
                permissionDO.setAppCode(saveBO.getAppCode());
                permissionDO.setPermissionType(t.getNodeType());
                permissionDO.setCustom(Boolean.valueOf(custom));
                return permissionDO;
            }).toList();
            permissionDoNewList.addAll(permissionDoList);
        }
        if (!permissionDoNewList.isEmpty()) {
            this.rolePermissionRepoProc.save(permissionDoNewList);
        }
    }

    static class RuleGroup {
        public static final String DEFAULT_CODE = "0";
        private final String code;
        private final DprRuleRelationEnum relation;

        public RuleGroup() {
            this(DEFAULT_CODE);
        }

        public RuleGroup(String code) {
            this(code, DprRuleRelationEnum.DPR_RULE_RELATION_AND);
        }

        public RuleGroup(String code, DprRuleRelationEnum relation) {
            this.code = code;
            this.relation = relation;
        }

        public String getCode() {
            return this.code;
        }

        public DprRuleRelationEnum getRelation() {
            return this.relation;
        }
    }
}

