/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOps;
import cn.zhxu.bs.util.MapBuilder;
import cn.zhxu.bs.util.MapUtils;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.datasecurity.config.DataSecurityProperties;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleValueTypeEnum;
import com.elitescloud.boot.security.common.InnerRole;
import com.elitescloud.boot.util.ObjUtil;
import com.elitescloud.cloudt.context.util.CollectionUtil;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.context.util.TreeDataUtil;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.platform.model.constant.PlatformAdminTypeEnum;
import com.elitescloud.cloudt.security.common.InnerUserEnum;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.system.convert.PermissionConverter;
import com.elitescloud.cloudt.system.convert.SysDpcRoleApiFieldsConvert;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDpcRoleApiFieldsDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import com.elitescloud.cloudt.system.dto.SysEmployeeBasicDTO;
import com.elitescloud.cloudt.system.model.bo.BusinessOperationBO;
import com.elitescloud.cloudt.system.model.bo.BusinessParamBO;
import com.elitescloud.cloudt.system.model.bo.MasterUserBO;
import com.elitescloud.cloudt.system.model.bo.MenuBO;
import com.elitescloud.cloudt.system.model.bo.OperationRequestInfoBO;
import com.elitescloud.cloudt.system.model.bo.PermissionMenuBO;
import com.elitescloud.cloudt.system.model.bo.PermissionParameterBO;
import com.elitescloud.cloudt.system.model.bo.TenantMenuBO;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserFieldRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.index.UserMenuRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.org.EmployeeUserInfoRespVO;
import com.elitescloud.cloudt.system.model.vo.resp.role.UserRoleMenuRespVO;
import com.elitescloud.cloudt.system.model.vo.sbean.SysDprRoleApiDataColumnRuleListQueryBean;
import com.elitescloud.cloudt.system.model.vo.sbean.SysDprRoleApiDataRuleListQueryBean;
import com.elitescloud.cloudt.system.modules.dpr.RoleAppApiDataPermissionUtil;
import com.elitescloud.cloudt.system.modules.dpr.SysDprValueType;
import com.elitescloud.cloudt.system.service.UserQueryService;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.common.constant.PermissionOwnerTypeEnum;
import com.elitescloud.cloudt.system.service.common.constant.SubUserPermissionTypeEnum;
import com.elitescloud.cloudt.system.service.manager.BasePermissionManager;
import com.elitescloud.cloudt.system.service.model.bo.AppBO;
import com.elitescloud.cloudt.system.service.repo.AdminMenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.ApiManageRepoProc;
import com.elitescloud.cloudt.system.service.repo.ApiParameterRepoProc;
import com.elitescloud.cloudt.system.service.repo.EmployeeRepoProc;
import com.elitescloud.cloudt.system.service.repo.RolePermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysDpcrApiFieldsRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuRepoProc;
import com.elitescloud.cloudt.system.service.repo.TenantMenuTreeRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRoleRepoProc;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class PermissionQueryManager
extends BasePermissionManager {
    private static final Logger log = LogManager.getLogger(PermissionQueryManager.class);
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private UserRoleRepoProc userRoleRepoProc;
    @Autowired
    private EmployeeRepoProc employeeRepoProc;
    @Autowired
    private TenantMenuRepoProc tenantMenuRepoProc;
    @Autowired
    private TenantMenuTreeRepoProc tenantMenuTreeRepoProc;
    @Autowired
    private AdminMenuRepoProc adminMenuRepoProc;
    @Autowired
    private RolePermissionRepoProc rolePermissionRepoProc;
    @Autowired
    private ApiManageRepoProc apiRepoProc;
    @Autowired
    private ApiParameterRepoProc apiParameterRepoProc;
    @Autowired
    private SysDpcrApiFieldsRepoProc dpcrApiFieldsRepoProc;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private AuthorizationProperties authorizationProperties;
    @Autowired
    private DataSecurityProperties dataSecurityProperties;
    @Autowired
    private BeanSearcher beanSearcher;

    public Set<String> queryRoleByUser(SysUserDTO userDTO) {
        if (userDTO == null) {
            return Set.of(InnerRole.ANONYMOUS.getValue());
        }
        HashSet<String> roles = new HashSet<String>(16);
        if (InnerUserEnum.ADMIN.getUsername().equals(userDTO.getUsername())) {
            roles.add(InnerRole.SYSTEM_ADMIN.getValue());
        }
        if (userDTO.getSysTenantVO() != null && Objects.equals(userDTO.getSysTenantVO().getSysUserId(), userDTO.getId())) {
            roles.add(InnerRole.TENANT_ADMIN.getValue());
        }
        if (Objects.equals(userDTO.getId(), userDTO.getTenantOrgAdminId())) {
            roles.add(InnerRole.TENANT_ORG_ADMIN.getValue());
        }
        List<IdCodeNameParam> businessRoles = this.queryRoleWithParent(userDTO.getId(), userDTO.getTenantId(), userDTO.getTenantOrg() == null ? null : userDTO.getTenantOrg().getId());
        roles.addAll(businessRoles.stream().map(IdCodeNameParam::getCode).toList());
        userDTO.setRoles(businessRoles);
        return Collections.unmodifiableSet(roles);
    }

    public Map<Long, List<IdCodeNameParam>> queryUserRoles(@NotEmpty Set<Long> userIds) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        return this.userRoleRepoProc.getRoleOfUser(userIds, currentUser.getTenantId(), currentUser.getTenantOrgId());
    }

    public List<UserMenuRespVO> queryUserMenusCacheable(String terminal, boolean includeAction, boolean tree) {
        String cacheKey = "System:CurrentMenu:" + SecurityContextUtil.currentToken() + ":terminal_" + terminal + ":includeAction_" + includeAction + ":tree_" + tree;
        List cacheResult = (List)this.redisUtils.get(cacheKey);
        if (cacheResult != null) {
            return cacheResult;
        }
        List<UserMenuRespVO> dataList = this.queryUserMenus(terminal, includeAction, tree);
        this.redisUtils.set(cacheKey, dataList, 20L, TimeUnit.MINUTES);
        return dataList;
    }

    public List<UserMenuRespVO> queryUserMenus(String terminal, boolean includeAction, boolean tree) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        SysUserDTO user = currentUser.getUser();
        Map<String, AppBO> appMap = super.tenantApps(null, terminal);
        if (appMap.isEmpty()) {
            return Collections.emptyList();
        }
        Long tenantId = super.obtainTenantId();
        MasterUserBO masterUser = this.userQueryManager.getMasterUser(user.getId());
        boolean customized = this.hasCustomMenuTree(tenantId);
        CompletableFuture<Map<String, MenuBO>> menuMapFuture = this.getAllMenus(false, customized, user, appMap.keySet(), includeAction);
        CompletableFuture<Map<String, MenuBO>> sysMenuMapFuture = this.getAllMenus(true, customized, user, appMap.keySet(), includeAction);
        CompletableFuture<List<UserMenuRespVO>> adminMenuFuture = this.getAdminUserPermissionMenuFuture(user, masterUser, sysMenuMapFuture, customized, appMap, includeAction);
        CompletableFuture<List<UserMenuRespVO>> commonMenuFuture = this.getCommonUserPermissionMenuFuture(user, masterUser, menuMapFuture, customized, appMap, includeAction);
        return (List)((CompletableFuture)adminMenuFuture.thenCombineAsync(commonMenuFuture, (adminMenus, commonMenus) -> {
            ArrayList menuList = new ArrayList(256);
            menuList.addAll(adminMenus);
            menuList.addAll(commonMenus);
            if (menuList.isEmpty()) {
                return new ArrayList(0);
            }
            TreeDataUtil treeDataUtil = new TreeDataUtil(menuList, UserMenuRespVO::getMenuCode, UserMenuRespVO::getParentMenuCode, UserMenuRespVO::setChildren, Comparator.comparingInt(UserMenuRespVO::getSortNo));
            List result = treeDataUtil.getRoots().stream().filter(t -> !StringUtils.hasText((String)t.getParentMenuCode()) && CollUtil.isNotEmpty(t.getChildren())).collect(Collectors.toList());
            if (tree) {
                return result;
            }
            return CollectionUtil.expandTree(result, UserMenuRespVO::getChildren);
        })).join();
    }

    public List<UserRoleMenuRespVO> queryUserRoleMenus(long userId, boolean includeAction, boolean tree) {
        SysUserDTO user = ((UserQueryService)SpringContextHolder.getBean(UserQueryService.class)).getUserById(userId);
        if (user == null) {
            return Collections.emptyList();
        }
        Map<String, AppBO> appMap = super.tenantApps(null, null);
        if (appMap.isEmpty()) {
            return Collections.emptyList();
        }
        Long tenantId = super.obtainTenantId();
        MasterUserBO masterUser = this.userQueryManager.getMasterUser(user.getId());
        boolean customized = this.hasCustomMenuTree(tenantId);
        CompletableFuture<Map<String, MenuBO>> menuMapFuture = this.getAllMenus(false, customized, user, appMap.keySet(), includeAction);
        CompletableFuture<List<UserMenuRespVO>> commonMenuFuture = this.getCommonUserPermissionMenuFuture(user, masterUser, menuMapFuture, customized, appMap, includeAction);
        CompletableFuture<Map<String, Set<Long>>> roleOfMenuFuture = this.queryUserMenuRole(user, true, includeAction);
        return (List)((CompletableFuture)commonMenuFuture.thenCombine(roleOfMenuFuture, (commonMenus, roleOfMenus) -> {
            List respVoList = commonMenus.stream().map(t -> {
                UserRoleMenuRespVO respVO = PermissionConverter.INSTANCE.convert2UserRoleMenu((UserMenuRespVO)t);
                Map roleMap = user.getRoles() == null ? Collections.emptyMap() : user.getRoles().stream().collect(Collectors.toMap(IdCodeNameParam::getId, r -> new CodeNameParam(r.getCode(), r.getName()), (t1, t2) -> t1));
                Set roleIds = (Set)roleOfMenus.get(t.getMenuCode());
                respVO.setRoles(CollUtil.isEmpty((Collection)roleIds) ? Collections.emptyList() : roleIds.stream().map(roleMap::get).collect(Collectors.toList()));
                return respVO;
            }).collect(Collectors.toList());
            if (respVoList.isEmpty()) {
                return Collections.emptyList();
            }
            TreeDataUtil treeDataUtil = new TreeDataUtil(respVoList, UserRoleMenuRespVO::getMenuCode, UserRoleMenuRespVO::getParentMenuCode, UserRoleMenuRespVO::setChildren, Comparator.comparingInt(UserRoleMenuRespVO::getSortNo));
            List result = treeDataUtil.getRoots().stream().filter(t -> !StringUtils.hasText((String)t.getParentMenuCode()) && CollUtil.isNotEmpty(t.getChildren())).collect(Collectors.toList());
            if (tree) {
                return result;
            }
            return CollectionUtil.expandTree(result, UserRoleMenuRespVO::getChildren);
        })).join();
    }

    public List<UserMenuRespVO> queryUserActionByMenu(@NotBlank String menuCode) {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        SysUserDTO user = currentUser.getUser();
        MasterUserBO masterUser = this.userQueryManager.getMasterUser(user.getId());
        AtomicReference menuType = new AtomicReference();
        List<MenuBO> actionBos = (List<MenuBO>)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            String tempMenuType = this.menuRepoProc.getMenuTypeByMenuCode(menuCode);
            if (CharSequenceUtil.isBlank((CharSequence)tempMenuType)) {
                return Collections.emptyList();
            }
            menuType.set(tempMenuType);
            return this.menuRepoProc.queryActionByMenuCode(menuCode, true);
        });
        if (actionBos.isEmpty()) {
            return Collections.emptyList();
        }
        actionBos.forEach(t -> t.setNodeType(MenuTreeNodeType.ACTION.getValue()));
        if (PlatformAppMenusTypeEnum.MENUS_TYPE_PLATFORM.name().equals(menuType.get()) || PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name().equals(menuType.get())) {
            return this.platformMenu2Bo2Vo(actionBos);
        }
        Set<String> menuCodes = this.queryMenuCodeOfCommonUser(user, masterUser, false, true);
        if (menuCodes.isEmpty()) {
            return Collections.emptyList();
        }
        actionBos = actionBos.stream().filter(t -> menuCodes.contains(t.getMenusCode())).collect(Collectors.toList());
        return this.platformMenu2Bo2Vo(actionBos);
    }

    public List<UserMenuRespVO> queryAllUserAction() {
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        SysUserDTO user = currentUser.getUser();
        Map<String, AppBO> appMap = super.tenantApps(null);
        if (appMap.isEmpty()) {
            return Collections.emptyList();
        }
        MasterUserBO masterUser = this.userQueryManager.getMasterUser(user.getId());
        CompletableFuture<Map<String, MenuBO>> menuMapFuture = this.getAllActions(user, appMap.keySet());
        CompletableFuture<List<UserMenuRespVO>> adminMenuFuture = this.getAdminUserPermissionActionFuture(menuMapFuture);
        CompletableFuture<List<UserMenuRespVO>> commonMenuFuture = this.getCommonUserPermissionActionFuture(user, masterUser, menuMapFuture);
        return (List)((CompletableFuture)adminMenuFuture.thenCombineAsync(commonMenuFuture, (adminMenus, commonMenus) -> {
            ArrayList menuList = new ArrayList(256);
            menuList.addAll(adminMenus);
            menuList.addAll(commonMenus);
            return menuList;
        })).join();
    }

    public List<UserFieldRespVO> queryUserField(@NotBlank String menuCode, @NotBlank String apiCode) {
        Assert.hasText((String)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e3a\u7a7a");
        Assert.hasText((String)apiCode, (String)"API\u63a5\u53e3\u7f16\u7801\u4e3a\u7a7a");
        GeneralUserDetails currentUser = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        AtomicReference appCode = new AtomicReference();
        List apiParamList = (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            List<CodeNameParam> params = this.apiParameterRepoProc.queryOutParamByApiCode(apiCode);
            if (params.isEmpty()) {
                log.warn("\u63a5\u53e3{}\u672a\u914d\u7f6e\u51fa\u53c2", (Object)apiCode);
                return Collections.emptyList();
            }
            appCode.set(this.apiRepoProc.getAppCodeByCode(apiCode));
            Assert.hasText((String)((String)appCode.get()), (String)"\u63a5\u53e3\u4e0d\u5b58\u5728\u6216\u6570\u636e\u5f02\u5e38");
            return params;
        });
        if (apiParamList.isEmpty()) {
            return Collections.emptyList();
        }
        if (currentUser.getTenant() != null && !CollUtil.contains((Collection)currentUser.getTenant().getAppCodes(), appCode.get())) {
            log.warn("\u63a5\u53e3{}\u6240\u5c5e\u5e94\u7528{}\u672a\u5206\u914d\u7ed9\u79df\u6237{}", (Object)apiCode, appCode, (Object)currentUser.getTenantId());
            return this.convertUserField(apiParamList, Collections.emptyList());
        }
        Set<Long> userRoles = this.obtainUserRoleIds(currentUser.getUser());
        if (userRoles.isEmpty()) {
            return this.convertUserField(apiParamList, Collections.emptyList());
        }
        List<PermissionParameterBO> permissionFields = this.dpcrApiFieldsRepoProc.queryBoByRole(userRoles, menuCode, apiCode);
        return this.convertUserField(apiParamList, permissionFields);
    }

    public Set<Long> queryUserIdOfRole(@NotBlank String roleCode) {
        return this.userRoleRepoProc.getUserIdByRole(roleCode);
    }

    public Set<Long> queryUserIdOfRole(long roleId) {
        return this.userRoleRepoProc.getUserIdsByRole(roleId);
    }

    public List<EmployeeUserInfoRespVO> queryUserOfRole(long roleId, boolean onlyEmployee) {
        if (onlyEmployee) {
            return this.employeeRepoProc.listEmployeeByRole(roleId).stream().map(t -> {
                EmployeeUserInfoRespVO respVO = new EmployeeUserInfoRespVO();
                respVO.setId(t.getId());
                respVO.setCode(t.getCode());
                respVO.setUserId(t.getUserId());
                respVO.setUsername(t.getUsername());
                respVO.setFullName(t.getFullName());
                respVO.setEmail(CharSequenceUtil.blankToDefault((CharSequence)t.getEmailWork(), (String)t.getEmail()));
                respVO.setMobile(t.getMobile());
                return respVO;
            }).collect(Collectors.toList());
        }
        Set<Long> userIds = this.userRoleRepoProc.getUserIdsByRole(roleId);
        if (userIds.isEmpty()) {
            return Collections.emptyList();
        }
        Map employeeMap = this.employeeRepoProc.queryBasicByUserIds(userIds).stream().collect(Collectors.toMap(SysEmployeeBasicDTO::getUserId, Function.identity(), (t1, t2) -> t1));
        return ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.getBasicDto(userIds))).stream().map(t -> {
            EmployeeUserInfoRespVO respVO = new EmployeeUserInfoRespVO();
            SysEmployeeBasicDTO emp = (SysEmployeeBasicDTO)employeeMap.get(t.getId());
            if (emp != null) {
                respVO.setId(emp.getId());
                respVO.setCode(emp.getCode());
                respVO.setEmail(CharSequenceUtil.blankToDefault((CharSequence)emp.getEmailWork(), (String)emp.getEmail()));
                respVO.setMobile(emp.getMobile());
            } else {
                respVO.setEmail(t.getEmail());
                respVO.setMobile(t.getMobile());
            }
            respVO.setUserId(t.getId());
            respVO.setUsername(t.getUsername());
            respVO.setFullName(t.getFullName());
            return respVO;
        }).collect(Collectors.toList());
    }

    public SysDprRoleApiRowColumnRuleDTO getDataPermissionOfCurrentUser() {
        GeneralUserDetails userInfo = SecurityContextUtil.currentUserIfUnauthorizedThrow();
        return this.getDataPermissionByUser(userInfo.getUser());
    }

    public SysDprRoleApiRowColumnRuleDTO getDataPermissionByUser(SysUserDTO user) {
        SysDprRoleApiRowColumnRuleDTO roleRuleDTO = new SysDprRoleApiRowColumnRuleDTO();
        roleRuleDTO.setUserId(user.getId());
        roleRuleDTO.setTenantId((Long)ObjUtil.defaultIfNull((Object)user.getTenantId(), (Object)TenantConstant.DEFAULT_TENANT_ID));
        List<String> roleCodeList = CollUtil.isEmpty((Collection)user.getRoles()) ? Collections.emptyList() : user.getRoles().stream().map(IdCodeNameParam::getCode).collect(Collectors.toList());
        roleRuleDTO.setRoleCodeList(roleCodeList);
        List roleIdList = CollUtil.isEmpty((Collection)user.getRoles()) ? Collections.emptyList() : user.getRoles().stream().map(IdCodeNameParam::getId).collect(Collectors.toList());
        roleRuleDTO.setRoelIdList(roleIdList);
        if (roleCodeList.isEmpty() || user.getSysTenantVO() != null && CollUtil.isEmpty((Collection)user.getSysTenantVO().getAppCodes())) {
            roleRuleDTO.setSysDpcRoleApiFieldsDTOList(Collections.emptyList());
            roleRuleDTO.setSysDprRoleApiDataRuleListQueryDTO(Collections.emptyList());
            return roleRuleDTO;
        }
        GeneralUserDetails userDetails = new GeneralUserDetails(user);
        ArrayList<SysDprRoleApiDataRuleListQueryDTO> dataRuleList = new ArrayList<SysDprRoleApiDataRuleListQueryDTO>();
        ArrayList<SysDpcRoleApiFieldsDTO> fieldRuleList = new ArrayList<SysDpcRoleApiFieldsDTO>();
        switch (this.dataSecurityProperties.getCompatible()) {
            case LATEST: {
                dataRuleList.addAll(this.queryDataPermission(userDetails, roleCodeList));
                fieldRuleList.addAll(this.queryFieldPermission(userDetails, roleCodeList));
                break;
            }
            case OLDEST: {
                dataRuleList.addAll(this.queryDprRoleApiDataRule(userDetails, roleCodeList));
                fieldRuleList.addAll(this.queryDprRoleApiFields(roleCodeList));
                break;
            }
            case FIRST_LATEST: {
                dataRuleList.addAll(this.queryDataPermission(userDetails, roleCodeList));
                dataRuleList.addAll(this.queryDprRoleApiDataRule(userDetails, roleCodeList));
                fieldRuleList.addAll(this.queryFieldPermission(userDetails, roleCodeList));
                fieldRuleList.addAll(this.queryDprRoleApiFields(roleCodeList));
                break;
            }
            case FIRST_OLDEST: {
                dataRuleList.addAll(this.queryDprRoleApiDataRule(userDetails, roleCodeList));
                dataRuleList.addAll(this.queryDataPermission(userDetails, roleCodeList));
                fieldRuleList.addAll(this.queryDprRoleApiFields(roleCodeList));
                fieldRuleList.addAll(this.queryFieldPermission(userDetails, roleCodeList));
                break;
            }
            default: {
                throw new IllegalArgumentException("\u6682\u4e0d\u652f\u6301\u7684\u517c\u5bb9\u6a21\u5f0f\uff1a" + String.valueOf(this.dataSecurityProperties.getCompatible()));
            }
        }
        roleRuleDTO.setSysDprRoleApiDataRuleListQueryDTO(dataRuleList);
        roleRuleDTO.setSysDpcRoleApiFieldsDTOList(fieldRuleList);
        return roleRuleDTO;
    }

    private List<IdCodeNameParam> queryRoleWithParent(long userId, Long tenantId, Long tenantOrgId) {
        HashMap<String, IdCodeNameParam> rolesAll = new HashMap<String, IdCodeNameParam>(32);
        List<IdCodeNameParam> userRoles = this.userRoleRepoProc.getRoleOfUser(userId, tenantId, tenantOrgId);
        ArrayList<String> tempRoleCodes = new ArrayList<String>();
        while (!CollUtil.isEmpty(userRoles)) {
            for (IdCodeNameParam userRole : userRoles) {
                if (rolesAll.containsKey(userRole.getCode())) continue;
                rolesAll.put(userRole.getCode(), userRole);
                tempRoleCodes.add(userRole.getCode());
            }
            if (tempRoleCodes.isEmpty()) break;
            userRoles = this.userRoleRepoProc.queryRolesParents(tempRoleCodes, tenantId, tenantOrgId);
            tempRoleCodes.clear();
        }
        return new ArrayList<IdCodeNameParam>(rolesAll.values());
    }

    private List<SysDpcRoleApiFieldsDTO> queryFieldPermission(GeneralUserDetails userInfo, List<String> roleCodeList) {
        List<SysDpcRoleApiFieldsDTO> permissionList = this.fieldPermissionRepoProc.queryByRoleCodes(roleCodeList);
        if (permissionList.isEmpty()) {
            return permissionList;
        }
        Map roleMap = userInfo.getUser().getRoles().stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Function.identity(), (t1, t2) -> t1));
        HashSet<String> operationCodes = new HashSet<String>(permissionList.size());
        for (SysDpcRoleApiFieldsDTO dto : permissionList) {
            if (StringUtils.hasText((String)dto.getApiPermissionCode())) {
                operationCodes.add(dto.getApiPermissionCode());
            }
            dto.setRoleId(((IdCodeNameParam)roleMap.get(dto.getRoleCode())).getId());
            dto.setFieldApiVisible(dto.getReadable());
            dto.setFieldFormVisible(dto.getReadable());
            dto.setFieldFormUpdate(dto.getWriteable());
        }
        if (operationCodes.isEmpty()) {
            return permissionList;
        }
        return this.fillByBusinessObject(permissionList, operationCodes, PermissionConverter.INSTANCE::cloneRule);
    }

    private List<SysDprRoleApiDataRuleListQueryDTO> queryDataPermission(GeneralUserDetails userInfo, List<String> roleCodeList) {
        List<SysDprRoleApiDataRuleListQueryDTO> permissionList = this.dataPermissionRepoProc.queryDataPermissionByRoles(roleCodeList);
        if (permissionList.isEmpty()) {
            return Collections.emptyList();
        }
        Map roleMap = userInfo.getUser().getRoles().stream().collect(Collectors.toMap(IdCodeNameParam::getCode, Function.identity(), (t1, t2) -> t1));
        HashSet<String> operationCodes = new HashSet<String>(permissionList.size());
        HashSet<String> businessObjectCodes = new HashSet<String>(permissionList.size());
        for (SysDprRoleApiDataRuleListQueryDTO dto : permissionList) {
            if (StringUtils.hasText((String)dto.getApiPermissionCode())) {
                operationCodes.add(dto.getApiPermissionCode());
            }
            if (StringUtils.hasText((String)dto.getBusinessObjectCode())) {
                businessObjectCodes.add(dto.getBusinessObjectCode());
            }
            dto.setRoleId(((IdCodeNameParam)roleMap.get(dto.getRoleCode())).getId());
            dto.setRuleOrder(Double.valueOf(dto.getOrder() == null ? 0.0 : (double)dto.getOrder().intValue() * 1.0));
        }
        if (!businessObjectCodes.isEmpty()) {
            Map businessParamsMap = ((List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.businessParamRepoProc.listSimpleBoByBusinessObjectCode(businessObjectCodes))).stream().collect(Collectors.groupingBy(BusinessParamBO::getBusinessObjectCode, Collectors.toMap(BusinessParamBO::getFieldName, Functions.identity(), (t1, t2) -> t1)));
            for (SysDprRoleApiDataRuleListQueryDTO dto : permissionList) {
                BusinessParamBO paramBO;
                if (!StringUtils.hasText((String)dto.getBusinessObjectCode()) || !StringUtils.hasText((String)dto.getDprRuleField()) || (paramBO = (BusinessParamBO)businessParamsMap.getOrDefault(dto.getBusinessObjectCode(), Collections.emptyMap()).get(dto.getDprRuleField())) == null) continue;
                dto.setDprRuleFieldType(paramBO.getFieldJavaType());
                dto.setEntityClassName(paramBO.getEntityClassName());
                dto.setSubTable(paramBO.getSubTable());
                dto.setRelatedMasField(paramBO.getRelatedMasField());
                dto.setMasField(paramBO.getMasField());
                dto.setRefBusinessObject(paramBO.getRelatedBusinessObject());
                dto.setRefField(paramBO.getRelatedField());
            }
        }
        RoleAppApiDataPermissionUtil.fillDataPermissionValue(permissionList, userInfo);
        permissionList = this.collectByRuleGroup(permissionList);
        if (!operationCodes.isEmpty()) {
            Function<List<SysDprRoleApiDataRuleListQueryDTO>, List<SysDprRoleApiDataRuleListQueryDTO>> groupRulesCloner = this.groupRulesClone();
            permissionList = this.fillByBusinessObject(permissionList, operationCodes, t -> {
                SysDprRoleApiDataRuleListQueryDTO res = PermissionConverter.INSTANCE.cloneRule((SysDprRoleApiDataRuleListQueryDTO)t);
                res.setGroupRules((List)groupRulesCloner.apply(t.getGroupRules()));
                return res;
            });
        }
        return permissionList;
    }

    private Function<List<SysDprRoleApiDataRuleListQueryDTO>, List<SysDprRoleApiDataRuleListQueryDTO>> groupRulesClone() {
        return dataList -> {
            if (CollUtil.isEmpty((Collection)dataList)) {
                return Collections.emptyList();
            }
            ArrayList<SysDprRoleApiDataRuleListQueryDTO> resultList = new ArrayList<SysDprRoleApiDataRuleListQueryDTO>(dataList.size());
            Function<List<SysDprRoleApiDataRuleListQueryDTO>, List<SysDprRoleApiDataRuleListQueryDTO>> groupRulesCloner = this.groupRulesClone();
            SysDprRoleApiDataRuleListQueryDTO result = null;
            for (SysDprRoleApiDataRuleListQueryDTO dto : dataList) {
                result = PermissionConverter.INSTANCE.cloneRule(dto);
                result.setGroupRules(groupRulesCloner.apply(dto.getGroupRules()));
                resultList.add(result);
            }
            return resultList;
        };
    }

    private List<SysDprRoleApiDataRuleListQueryDTO> collectByRuleGroup(List<SysDprRoleApiDataRuleListQueryDTO> permissionList) {
        boolean existsGroup = false;
        for (SysDprRoleApiDataRuleListQueryDTO dto : permissionList) {
            dto.setRuleGroup(Boolean.valueOf(Boolean.TRUE.equals(dto.getRuleGroup())));
            String groupPrefix = String.join((CharSequence)"#GROUP#", dto.getRoleCode(), (CharSequence)ObjUtil.defaultIfNull((Object)dto.getBusinessObjectCode(), (Object)"NULL"), (CharSequence)ObjUtil.defaultIfNull((Object)dto.getApiPermissionCode(), (Object)"NULL"), (CharSequence)ObjUtil.defaultIfNull((Object)dto.getMenusCode(), (Object)"NULL")) + ">>";
            if (dto.getRuleGroup().booleanValue()) {
                existsGroup = true;
                int index = dto.getRuleGroupCode().lastIndexOf("_");
                String parentId = index > 0 ? dto.getRuleGroupCode().substring(0, index) : "0";
                dto.setRuleGroupCodeParent(groupPrefix + parentId);
                dto.setOrder(Integer.valueOf(dto.getRuleGroupCode().substring(index + 1)));
                dto.setGroupRules(new ArrayList());
                dto.setRuleGroupCode(groupPrefix + dto.getRuleGroupCode());
                continue;
            }
            dto.setRuleGroupCodeParent(groupPrefix + CharSequenceUtil.blankToDefault((CharSequence)dto.getRuleGroupCode(), (String)"0"));
            dto.setRuleGroupCode(dto.getDprRuleId().toString());
            dto.setOrder((Integer)ObjUtil.defaultIfNull((Object)dto.getOrder(), (Object)0));
            dto.setGroupRules(null);
        }
        if (!existsGroup) {
            return permissionList;
        }
        return new TreeDataUtil(permissionList, SysDprRoleApiDataRuleListQueryDTO::getRuleGroupCode, SysDprRoleApiDataRuleListQueryDTO::getRuleGroupCodeParent, SysDprRoleApiDataRuleListQueryDTO::setGroupRules, Comparator.comparingInt(SysDprRoleApiDataRuleListQueryDTO::getOrder)).getRoots();
    }

    private <T extends BaseDataSecurityRuleDTO> List<T> fillByBusinessObject(List<T> ruleList, Collection<String> operationCodes, Function<T, T> cloner) {
        if (operationCodes.isEmpty()) {
            return ruleList;
        }
        ArrayList operations = new ArrayList(operationCodes.size());
        ArrayList<BusinessOperationBO> refOperations = new ArrayList<BusinessOperationBO>(operationCodes.size());
        this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            operations.addAll(this.businessOperationRepoProc.listRequestInfo(operationCodes, null));
            refOperations.addAll(this.businessOperationRepoProc.listSimpleByRef(operationCodes));
            return null;
        });
        Map operationMap = operations.stream().collect(Collectors.toMap(OperationRequestInfoBO::getOperationCode, Function.identity(), (t1, t2) -> t1));
        ArrayList<BaseDataSecurityRuleDTO> resultList = new ArrayList<BaseDataSecurityRuleDTO>(ruleList.size());
        for (BaseDataSecurityRuleDTO dto : ruleList) {
            if (StringUtils.hasText((String)dto.getApiPermissionCode())) {
                ObjUtil.ifNotNull((Object)((OperationRequestInfoBO)operationMap.get(dto.getApiPermissionCode())), t -> {
                    dto.setApiPermissionRequestType(t.getApiMethod());
                    dto.setApiPermissionPath(t.getApiUrl());
                    dto.setPermissionRef(t.getPermissionRef());
                });
                if (!StringUtils.hasText((String)dto.getApiPermissionPath())) continue;
            }
            resultList.add(dto);
        }
        this.fillRefPermission(resultList, refOperations, cloner);
        return resultList;
    }

    private <T extends BaseDataSecurityRuleDTO> void fillRefPermission(List<T> ruleList, List<BusinessOperationBO> refOperations, Function<T, T> cloner) {
        if (ruleList.isEmpty() || refOperations.isEmpty()) {
            return;
        }
        Set refOperationCodes = refOperations.stream().map(BusinessOperationBO::getOperationCode).collect(Collectors.toSet());
        Map<String, List<BaseDataSecurityRuleDTO>> refRuleMap = ruleList.stream().filter(t -> StringUtils.hasText((String)t.getApiPermissionCode())).collect(Collectors.groupingBy(BaseDataSecurityRuleDTO::getApiPermissionCode));
        Map<String, List<BaseDataSecurityRuleDTO>> existsRefRuleMap = ruleList.stream().filter(t -> StringUtils.hasText((String)t.getApiPermissionCode()) && refOperationCodes.contains(t.getApiPermissionCode())).collect(Collectors.groupingBy(t -> t.getPermissionType() + "::" + t.getApiPermissionCode()));
        for (BusinessOperationBO operation : refOperations) {
            List<BaseDataSecurityRuleDTO> refRuleList = refRuleMap.get(operation.getPermissionRef());
            if (CollUtil.isEmpty(refRuleList)) continue;
            for (BaseDataSecurityRuleDTO refRule : refRuleList) {
                if (existsRefRuleMap.containsKey(refRule.getPermissionType() + "::" + operation.getOperationCode())) continue;
                BaseDataSecurityRuleDTO newRule = (BaseDataSecurityRuleDTO)cloner.apply(refRule);
                newRule.setPermissionRef(operation.getPermissionRef());
                newRule.setAppCode(operation.getAppCode());
                newRule.setBusinessObjectCode(operation.getBusinessObjectCode());
                newRule.setApiPermissionCode(operation.getOperationCode());
                newRule.setApiPermissionPath(operation.getApiUrl());
                newRule.setApiPermissionRequestType(operation.getApiMethod());
                ruleList.add(newRule);
            }
        }
    }

    private List<SysDprRoleApiDataRuleListQueryDTO> queryDprRoleApiDataRule(GeneralUserDetails userInfo, List<String> roleCodeList) {
        List<SysDprRoleApiDataRuleListQueryDTO> beanValueList;
        List<SysDprRoleApiDataRuleListQueryBean> businessBean;
        Map mapWhere = ((MapBuilder)((MapBuilder)MapUtils.builder().field(SysDprRoleApiDataRuleListQueryBean::getRoleCode, roleCodeList)).op((FieldOp)FieldOps.InList)).build();
        List sysDprRoleApiDataRuleListQueryBeans = this.beanSearcher.searchAll(SysDprRoleApiDataRuleListQueryBean.class, mapWhere);
        List beanList = sysDprRoleApiDataRuleListQueryBeans.stream().filter(t -> {
            if (CharSequenceUtil.equals((CharSequence)SysDprValueType.DPR_SYS_INTERNALLY_ALL.name(), (CharSequence)t.getDprSysInternally())) {
                return false;
            }
            if (t.getApiId() == null) {
                log.error("\u63a5\u53e3\u4e0d\u5b58\u5728\uff1a{}", (Object)t.getId());
                return false;
            }
            if (CharSequenceUtil.isBlank((CharSequence)t.getMenusCode())) {
                return false;
            }
            if (CharSequenceUtil.isBlank((CharSequence)t.getDprRuleValueType())) {
                log.error("\u89c4\u5219\u503c\u7c7b\u578b\u4e0d\u5b58\u5728\uff1a{}", (Object)t.getId());
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<SysDprRoleApiDataRuleListQueryBean>> dprRuleValueTypeGroupMap = beanList.stream().collect(Collectors.groupingBy(SysDprRoleApiDataRuleListQueryBean::getDprRuleValueType));
        ArrayList<SysDprRoleApiDataRuleListQueryDTO> dtoList = new ArrayList<SysDprRoleApiDataRuleListQueryDTO>();
        if (dprRuleValueTypeGroupMap.containsKey(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS.name())) {
            businessBean = dprRuleValueTypeGroupMap.get(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_BUSINESS.name());
            beanValueList = RoleAppApiDataPermissionUtil.setBusinessSysDprRoleApiRuleValue(userInfo, businessBean);
            dtoList.addAll(beanValueList);
        }
        if (dprRuleValueTypeGroupMap.containsKey(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_COMP.name())) {
            businessBean = dprRuleValueTypeGroupMap.get(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_COMP.name());
            beanValueList = RoleAppApiDataPermissionUtil.setBusinessSysDprRoleApiRuleValue(userInfo, businessBean);
            dtoList.addAll(beanValueList);
        }
        if (dprRuleValueTypeGroupMap.containsKey(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_CUSTOM.name())) {
            List<SysDprRoleApiDataRuleListQueryBean> customBean = dprRuleValueTypeGroupMap.get(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_CUSTOM.name());
            beanValueList = RoleAppApiDataPermissionUtil.setCustomSysDprRoleApiRuleValue(userInfo, customBean);
            dtoList.addAll(beanValueList);
        }
        if (dprRuleValueTypeGroupMap.containsKey(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.name())) {
            List<SysDprRoleApiDataRuleListQueryBean> sysBean = dprRuleValueTypeGroupMap.get(DprRuleValueTypeEnum.DPR_RULE_VALUE_TYPE_SYS.name());
            beanValueList = RoleAppApiDataPermissionUtil.setSysSysDprRoleApiRuleValue(userInfo, sysBean);
            dtoList.addAll(beanValueList);
        }
        return dtoList;
    }

    private List<SysDpcRoleApiFieldsDTO> queryDprRoleApiFields(List<String> roleCodeList) {
        Map mapColumnWhere = ((MapBuilder)((MapBuilder)MapUtils.builder().field(SysDprRoleApiDataColumnRuleListQueryBean::getRoleCode, roleCodeList)).op((FieldOp)FieldOps.InList)).build();
        List roleApiColumnRuleList = this.beanSearcher.searchAll(SysDprRoleApiDataColumnRuleListQueryBean.class, mapColumnWhere);
        if (CollUtil.isEmpty((Collection)roleApiColumnRuleList)) {
            return Collections.emptyList();
        }
        return roleApiColumnRuleList.stream().map(SysDpcRoleApiFieldsConvert.INSTANCE::beanToDto).collect(Collectors.toList());
    }

    private List<UserFieldRespVO> convertUserField(List<CodeNameParam> apiParamList, List<PermissionParameterBO> permissionFields) {
        Map perMap = CollectionUtils.isEmpty(permissionFields) ? Collections.emptyMap() : permissionFields.stream().collect(Collectors.groupingBy(PermissionParameterBO::getFieldName));
        boolean conflictShow = this.systemProperties.getPermissionConflictShow() == null || this.systemProperties.getPermissionConflictShow() != false;
        return apiParamList.stream().map(t -> {
            UserFieldRespVO respVO = new UserFieldRespVO();
            respVO.setFieldName(t.getCode());
            respVO.setFieldRemark(t.getName());
            if (perMap.isEmpty() || !perMap.containsKey(t.getCode())) {
                respVO.setFieldApiVisible(false);
                respVO.setFieldFormVisible(false);
                respVO.setFieldFormUpdate(false);
                return respVO;
            }
            List perList = (List)perMap.get(t.getCode());
            respVO.setId(CollUtil.isEmpty((Collection)perList) ? null : ((PermissionParameterBO)perList.get(0)).getId());
            respVO.setFieldApiVisible(this.authShow(conflictShow, perList, PermissionParameterBO::getFieldApiVisible));
            respVO.setFieldFormVisible(this.authShow(conflictShow, perList, PermissionParameterBO::getFieldFormVisible));
            respVO.setFieldFormUpdate(this.authShow(conflictShow, perList, PermissionParameterBO::getFieldFormUpdate));
            return respVO;
        }).collect(Collectors.toList());
    }

    private boolean authShow(boolean conflictShow, List<PermissionParameterBO> parameterBOList, Function<PermissionParameterBO, Boolean> valueFunction) {
        if (CollUtil.isEmpty(parameterBOList)) {
            return false;
        }
        boolean show = false;
        for (PermissionParameterBO parameterBO : parameterBOList) {
            show = Boolean.TRUE.equals(valueFunction.apply(parameterBO));
            if (conflictShow) {
                if (!show) continue;
                return true;
            }
            if (show) continue;
            return false;
        }
        return show;
    }

    private List<UserMenuRespVO> permissionMenuBo2Vo(List<PermissionMenuBO> menuBos) {
        if (CollectionUtils.isEmpty(menuBos)) {
            return Collections.emptyList();
        }
        ArrayList<UserMenuRespVO> respVos = new ArrayList<UserMenuRespVO>(menuBos.size());
        UserMenuRespVO respVO = null;
        for (PermissionMenuBO menuBO : menuBos) {
            respVO = new UserMenuRespVO();
            respVO.setMenuCode(menuBO.getMenusCode());
            respVO.setMenuName(menuBO.getMenusName());
            respVO.setParentMenuCode(menuBO.getMenusParentCode());
            respVO.setMenusIcon(menuBO.getMenusIcon());
            respVO.setRoute(menuBO.getMenusRoute());
            respVO.setNodeType(menuBO.getNodeType());
            respVO.setDataType(menuBO.getDataType());
            respVO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)menuBO.getMenusOrder(), (Object)1));
            respVO.setDisplay((Boolean)ObjectUtil.defaultIfNull((Object)menuBO.getDisplay(), (Object)true));
            respVO.setOuterLink(menuBO.getOuterLink());
            respVO.setOuterLinkType(menuBO.getOuterLinkType());
            respVO.setHasChildren(false);
            respVO.setChildren(new ArrayList<UserMenuRespVO>(16));
            respVos.add(respVO);
        }
        return respVos;
    }

    private List<UserMenuRespVO> platformMenu2Bo2Vo(List<MenuBO> menuBos) {
        if (CollectionUtils.isEmpty(menuBos)) {
            return Collections.emptyList();
        }
        ArrayList<UserMenuRespVO> respVos = new ArrayList<UserMenuRespVO>(menuBos.size());
        UserMenuRespVO respVO = null;
        for (MenuBO menuBO : menuBos) {
            respVO = new UserMenuRespVO();
            respVO.setMenuCode(menuBO.getMenusCode());
            respVO.setMenuName(menuBO.getMenusName());
            respVO.setParentMenuCode(menuBO.getMenusParentCode());
            respVO.setMenusIcon(menuBO.getMenusIcon());
            respVO.setRoute(menuBO.getMenusRoute());
            respVO.setNodeType(menuBO.getNodeType());
            respVO.setDataType(menuBO.getMenusType());
            respVO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)menuBO.getMenusOrder(), (Object)1));
            respVO.setDisplay((Boolean)ObjectUtil.defaultIfNull((Object)menuBO.getDisplay(), (Object)true));
            respVO.setOuterLink(menuBO.getOuterLink());
            respVO.setOuterLinkType(menuBO.getOuterLinkType());
            respVO.setHasChildren(false);
            respVO.setChildren(new ArrayList<UserMenuRespVO>(16));
            respVos.add(respVO);
        }
        return respVos;
    }

    private MenuBO tenantMenuBo2MenuBo(TenantMenuBO tenantMenuBO, MenuBO originalMenu) {
        MenuBO menuBO = new MenuBO();
        menuBO.setId(tenantMenuBO.getId());
        if (originalMenu != null) {
            menuBO.setMenusAppCode(originalMenu.getMenusAppCode());
            menuBO.setMenusType(originalMenu.getMenusType());
            menuBO.setMenusRoute(originalMenu.getMenusRoute());
            menuBO.setDisplay(originalMenu.getDisplay());
            menuBO.setOuterLink(originalMenu.getOuterLink());
            menuBO.setOuterLinkType(originalMenu.getOuterLinkType());
        } else {
            menuBO.setDisplay(true);
        }
        menuBO.setMenusName(tenantMenuBO.getMenuName());
        menuBO.setNodeType(tenantMenuBO.getNodeType());
        menuBO.setMenusCode(tenantMenuBO.getMenuCode());
        menuBO.setMenusOrder((Integer)ObjUtil.defaultIfNull((Object)tenantMenuBO.getSortNo(), (Object)0));
        menuBO.setMenusState(true);
        menuBO.setMenusParentCode(tenantMenuBO.getParentMenuCode());
        menuBO.setMenusIcon(tenantMenuBO.getIcon());
        return menuBO;
    }

    private CompletableFuture<Map<String, MenuBO>> getAllMenus(Boolean sys, boolean customMenu, SysUserDTO user, Set<String> appCodes, boolean includeAction) {
        CompletableFuture<Map<String, MenuBO>> originalMenuFuture = CompletableFuture.supplyAsync(() -> {
            boolean includeSys = true;
            boolean includeBusiness = true;
            if (sys != null) {
                if (sys.booleanValue()) {
                    includeBusiness = false;
                } else {
                    includeSys = false;
                }
            }
            return this.menuRepoProc.queryMenu(appCodes, includeSys, includeBusiness, !includeAction, true).stream().collect(Collectors.toMap(MenuBO::getMenusCode, Functions.identity(), (t1, t2) -> t1));
        });
        if (sys.booleanValue() || !customMenu) {
            return originalMenuFuture;
        }
        return originalMenuFuture.thenApplyAsync(originalMenuMap -> {
            if (originalMenuMap.isEmpty()) {
                return Collections.emptyMap();
            }
            List tenantMenuBoList = (List)this.tenantDataIsolateProvider.byTenantUser(() -> this.tenantMenuTreeRepoProc.queryMenuBos(), user);
            if (tenantMenuBoList.isEmpty()) {
                return Collections.emptyMap();
            }
            return tenantMenuBoList.stream().filter(t -> {
                if (Boolean.FALSE.equals(t.getEnabled())) {
                    return false;
                }
                if (MenuTreeNodeType.MENU.getValue().equals(t.getNodeType())) {
                    MenuBO menu = (MenuBO)originalMenuMap.get(t.getMenuCode());
                    return menu != null && Boolean.TRUE.equals(menu.getMenusState());
                }
                return true;
            }).map(t -> this.tenantMenuBo2MenuBo((TenantMenuBO)t, (MenuBO)originalMenuMap.get(t.getMenuCode()))).collect(Collectors.toMap(MenuBO::getMenusCode, Function.identity(), (t1, t2) -> t1));
        }, (Executor)this.taskExecutor);
    }

    private CompletableFuture<Map<String, MenuBO>> getAllActions(SysUserDTO user, Set<String> appCodes) {
        return CompletableFuture.supplyAsync(() -> this.menuRepoProc.queryActionByAppCode(appCodes, true).stream().collect(Collectors.toMap(MenuBO::getMenusCode, Functions.identity(), (t1, t2) -> t1)));
    }

    private CompletableFuture<List<UserMenuRespVO>> getAdminUserPermissionActionFuture(CompletableFuture<Map<String, MenuBO>> menuMapFuture) {
        return CompletableFuture.supplyAsync(() -> {
            Map allMenuMap = null;
            try {
                allMenuMap = (Map)menuMapFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            List<PermissionMenuBO> actionBoList = allMenuMap.values().stream().filter(t -> PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name().equals(t.getMenusType()) || PlatformAppMenusTypeEnum.MENUS_TYPE_PLATFORM.name().equals(t.getMenusType())).map(this::convertPermissionMenuBoForActionBo).collect(Collectors.toList());
            return this.permissionMenuBo2Vo(actionBoList);
        });
    }

    private CompletableFuture<List<UserMenuRespVO>> getCommonUserPermissionActionFuture(SysUserDTO user, MasterUserBO masterUser, CompletableFuture<Map<String, MenuBO>> menuMapFuture) {
        return CompletableFuture.supplyAsync(() -> {
            Map allMenuMap;
            Set<String> menuCodes = this.queryMenuCodeOfCommonUser(user, masterUser, false, true);
            if (menuCodes.isEmpty()) {
                return Collections.emptyList();
            }
            try {
                allMenuMap = (Map)menuMapFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            List<PermissionMenuBO> userMenus = menuCodes.stream().filter(allMenuMap::containsKey).map(t -> this.convertPermissionMenuBoForActionBo((MenuBO)allMenuMap.get(t))).collect(Collectors.toList());
            return this.permissionMenuBo2Vo(userMenus);
        }, (Executor)this.taskExecutor);
    }

    private CompletableFuture<List<UserMenuRespVO>> getCommonUserPermissionMenuFuture(SysUserDTO user, MasterUserBO masterUser, CompletableFuture<Map<String, MenuBO>> menuMapFuture, boolean customMenu, Map<String, AppBO> appMap, boolean includeAction) {
        return CompletableFuture.supplyAsync(() -> {
            Set<String> appCodes = appMap.keySet();
            Set menuCodes = (Set)this.tenantOrgDataIsolateProvider.byNoTenantOrg(() -> this.queryMenuCodeOfCommonUser(user, masterUser, true, includeAction));
            if (menuCodes.isEmpty()) {
                return Collections.emptyList();
            }
            Map allMenuMap = null;
            try {
                allMenuMap = (Map)menuMapFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ArrayList<PermissionMenuBO> userMenus = new ArrayList<PermissionMenuBO>(256);
            HashSet<String> existsMenuBos = new HashSet<String>(256);
            for (String menuCode : menuCodes) {
                this.addPermissionMenuBO(customMenu, menuCode, allMenuMap, appCodes, userMenus, existsMenuBos, (m, mb) -> mb.setMenusParentCode(m.getMenusAppCode()));
            }
            if (!customMenu) {
                userMenus.addAll(this.convertPermissionMenuForApp(appMap.values()));
            }
            return this.permissionMenuBo2Vo(userMenus);
        }, (Executor)this.taskExecutor);
    }

    private CompletableFuture<List<UserMenuRespVO>> getAdminUserPermissionMenuFuture(SysUserDTO user, MasterUserBO masterUser, CompletableFuture<Map<String, MenuBO>> menuMapFuture, boolean customMenu, Map<String, AppBO> appMap, boolean includeAction) {
        return CompletableFuture.supplyAsync(() -> {
            Set<String> appCodes = appMap.keySet();
            Set<String> menuCodes = this.queryMenuCodeOfAdminUser(user, masterUser, appCodes);
            if (menuCodes.isEmpty()) {
                return Collections.emptyList();
            }
            Map allMenuMap = null;
            try {
                allMenuMap = (Map)menuMapFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ArrayList<PermissionMenuBO> userMenus = new ArrayList<PermissionMenuBO>(256);
            HashSet<String> existsMenuBos = new HashSet<String>(256);
            for (String menuCode : menuCodes) {
                this.addPermissionMenuBO(customMenu, menuCode, allMenuMap, appCodes, userMenus, existsMenuBos, null);
            }
            if (!includeAction) {
                return this.permissionMenuBo2Vo(userMenus);
            }
            List actionBoList = allMenuMap.values().stream().filter(t -> {
                if (!PlatformMenusNodeEnum.BUTTON.name().equals(t.getNodeType())) {
                    return false;
                }
                if (!PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name().equals(t.getMenusType()) && !PlatformAppMenusTypeEnum.MENUS_TYPE_PLATFORM.name().equals(t.getMenusType())) {
                    return false;
                }
                return menuCodes.contains(t.getMenusParentCode());
            }).map(this::convertPermissionMenuBoForActionBo).collect(Collectors.toList());
            userMenus.addAll(actionBoList);
            return this.permissionMenuBo2Vo(userMenus);
        });
    }

    private CompletableFuture<Map<String, Set<Long>>> queryUserMenuRole(SysUserDTO user, boolean includeMenu, boolean includeAction) {
        return CompletableFuture.supplyAsync(() -> {
            Set<Long> roleIds = this.obtainUserRoleIds(user);
            if (roleIds.isEmpty()) {
                return Collections.emptyMap();
            }
            return this.rolePermissionRepoProc.queryPermissionCodeAndRolesByRoles(roleIds, includeMenu, includeAction);
        }, (Executor)this.taskExecutor);
    }

    private Set<String> queryMenuCodeOfCommonUser(@NotNull SysUserDTO user, MasterUserBO masterUser, boolean includeMenu, boolean includeAction) {
        HashSet<String> menuCodes = new HashSet<String>(256);
        Set<Long> roleIds = this.obtainUserRoleIds(user, masterUser);
        if (!roleIds.isEmpty()) {
            menuCodes.addAll(this.rolePermissionRepoProc.queryPermissionCodesByRoles(roleIds, includeMenu, includeAction));
        }
        HashMap<String, PermissionOwnerTypeEnum> owners = new HashMap<String, PermissionOwnerTypeEnum>(4);
        owners.put(user.getId().toString(), PermissionOwnerTypeEnum.USER);
        if (masterUser != null && SubUserPermissionTypeEnum.EXTENDS_ALL == masterUser.getPermissionType()) {
            owners.put(masterUser.getMasterUserId().toString(), PermissionOwnerTypeEnum.USER);
        }
        menuCodes.addAll(this.permissionResRepoProc.listMenuCodeByUsers(owners, includeMenu, includeAction));
        return menuCodes;
    }

    private Set<String> queryMenuCodeOfAdminUser(@NotNull SysUserDTO user, MasterUserBO masterUser, Set<String> authedAppCodes) {
        HashSet<String> adminTypeEnums = new HashSet<String>(8);
        if (super.isSystemAdmin(user, masterUser)) {
            adminTypeEnums.add(PlatformAdminTypeEnum.SYS_ADMIN.name());
        }
        if (super.isTenantAdmin(user, masterUser) && CollUtil.isNotEmpty(authedAppCodes)) {
            adminTypeEnums.add(PlatformAdminTypeEnum.TENANT_ADMIN.name());
        }
        if (super.isTenantOrgAdmin(user, masterUser)) {
            adminTypeEnums.add(PlatformAdminTypeEnum.TENANT_ORG_ADMIN.name());
        }
        if (adminTypeEnums.isEmpty()) {
            return Collections.emptySet();
        }
        return (Set)this.tenantDataIsolateProvider.byDefaultDirectly(() -> {
            List<String> menuCodes = this.adminMenuRepoProc.getMenuCodes(adminTypeEnums);
            if (!menuCodes.isEmpty()) {
                return new HashSet<String>(menuCodes);
            }
            if (adminTypeEnums.contains(PlatformAdminTypeEnum.SYS_ADMIN.name())) {
                return new HashSet<String>(this.menuRepoProc.getMenuCodes(true, true, false, true));
            }
            return Collections.emptySet();
        });
    }

    private void addPermissionMenuBO(boolean customMenu, @NotBlank String menuCodeAuthed, Map<String, MenuBO> menusAllMap, Set<String> appCodesAuthed, List<PermissionMenuBO> result, Set<String> existsResult, BiConsumer<MenuBO, PermissionMenuBO> rootMenuFunction) {
        if (existsResult.contains(menuCodeAuthed)) {
            return;
        }
        MenuBO menu = menusAllMap.get(menuCodeAuthed);
        if (menu == null) {
            return;
        }
        if (appCodesAuthed != null && (CharSequenceUtil.isBlank((CharSequence)menu.getMenusAppCode()) ? !customMenu || MenuTreeNodeType.MENU.getValue().equals(menu.getNodeType()) : !appCodesAuthed.contains(menu.getMenusAppCode()))) {
            return;
        }
        existsResult.add(menuCodeAuthed);
        PermissionMenuBO menuBO = this.convertPermissionMenuForMenuBo(menu);
        result.add(menuBO);
        if (StringUtils.hasText((String)menu.getMenusParentCode())) {
            this.addPermissionMenuBO(customMenu, menu.getMenusParentCode(), menusAllMap, appCodesAuthed, result, existsResult, rootMenuFunction);
        } else if (rootMenuFunction != null) {
            rootMenuFunction.accept(menu, menuBO);
        }
    }

    private List<PermissionMenuBO> convertPermissionMenuForApp(Collection<AppBO> appBoList) {
        if (CollUtil.isEmpty(appBoList)) {
            return Collections.emptyList();
        }
        ArrayList<PermissionMenuBO> menuBoList = new ArrayList<PermissionMenuBO>(appBoList.size());
        for (AppBO app : appBoList) {
            menuBoList.add(this.convertPermissionMenuBoForAppBo(app));
        }
        return menuBoList;
    }

    private PermissionMenuBO convertPermissionMenuBoForAppBo(AppBO appBO) {
        PermissionMenuBO menuBO = new PermissionMenuBO();
        menuBO.setMenusName(appBO.getAppName());
        menuBO.setAppCode(appBO.getAppCode());
        menuBO.setNodeType(MenuTreeNodeType.APP.getValue());
        menuBO.setMenusOrder((Integer)ObjUtil.defaultIfNull((Object)appBO.getAppOrder(), (Object)1));
        menuBO.setDisplay(true);
        menuBO.setMenusCode(appBO.getAppCode());
        return menuBO;
    }

    private PermissionMenuBO convertPermissionMenuForMenuBo(MenuBO menu) {
        PermissionMenuBO menuBO = new PermissionMenuBO();
        menuBO.setMenusName(menu.getMenusName());
        menuBO.setAppCode(menu.getMenusAppCode());
        MenuTreeNodeType nodeType = MenuTreeNodeType.valueOfPlatformMenu((String)menu.getNodeType());
        menuBO.setNodeType(nodeType == null ? null : nodeType.getValue());
        menuBO.setDataType(menu.getNodeType());
        menuBO.setMenusCode(menu.getMenusCode());
        menuBO.setMenusOrder(menu.getMenusOrder());
        menuBO.setMenusParentCode(menu.getMenusParentCode());
        menuBO.setMenusRoute(menu.getMenusRoute());
        menuBO.setMenusIcon(menu.getMenusIcon());
        menuBO.setDisplay(menu.getDisplay());
        menuBO.setMenusIcon(menu.getMenusIcon());
        menuBO.setOuterLink(menu.getOuterLink());
        menuBO.setOuterLinkType(menu.getOuterLinkType());
        return menuBO;
    }

    private PermissionMenuBO convertPermissionMenuBoForActionBo(MenuBO menuBO) {
        PermissionMenuBO actionBO = new PermissionMenuBO();
        actionBO.setMenusName(menuBO.getMenusName());
        actionBO.setAppCode(menuBO.getMenusAppCode());
        actionBO.setNodeType(MenuTreeNodeType.ACTION.getValue());
        actionBO.setDataType(menuBO.getNodeType());
        actionBO.setMenusCode(menuBO.getMenusCode());
        actionBO.setMenusOrder(menuBO.getMenusOrder());
        actionBO.setMenusParentCode(menuBO.getMenusParentCode());
        actionBO.setMenusRoute(menuBO.getMenusRoute());
        actionBO.setMenusIcon(menuBO.getMenusIcon());
        actionBO.setDisplay(menuBO.getDisplay());
        actionBO.setOuterLink(menuBO.getOuterLink());
        actionBO.setOuterLinkType(menuBO.getOuterLinkType());
        return actionBO;
    }

    private Set<Long> obtainUserRoleIds(SysUserDTO user, MasterUserBO masterUser) {
        Set<Long> userRoles = this.obtainUserRoleIds(user);
        if (masterUser == null || SubUserPermissionTypeEnum.EXTENDS_ALL != masterUser.getPermissionType()) {
            return userRoles;
        }
        Set mastUserRoles = this.userRoleRepoProc.getRolesOfUser(masterUser.getMasterUserId(), null).stream().map(IdCodeNameParam::getId).collect(Collectors.toSet());
        HashSet<Long> roleCodes = new HashSet<Long>(16);
        roleCodes.addAll(userRoles);
        roleCodes.addAll(mastUserRoles);
        return roleCodes;
    }

    private Set<Long> obtainUserRoleIds(SysUserDTO user) {
        Set<String> roleCodes = this.normalizeUserRoleCodes(user);
        if (CollectionUtils.isEmpty(roleCodes)) {
            return Collections.emptySet();
        }
        return this.roleRepoProc.filterEnabledId(roleCodes);
    }

    private Set<String> normalizeUserRoleCodes(SysUserDTO user) {
        if (CollectionUtils.isEmpty((Collection)user.getRoleCodes())) {
            return Collections.emptySet();
        }
        Set<String> roleCodes = null;
        if (StringUtils.hasText((String)this.authorizationProperties.getRolePrefix())) {
            String prefix = this.authorizationProperties.getRolePrefix();
            roleCodes = user.getRoleCodes().stream().map(t -> t.startsWith(prefix) ? t.substring(this.authorizationProperties.getRolePrefix().length()) : t).collect(Collectors.toSet());
        } else {
            roleCodes = new HashSet<String>(user.getRoleCodes());
        }
        return roleCodes;
    }

    private boolean hasCustomMenuTree(GeneralUserDetails currentUser) {
        return this.hasCustomMenuTree(currentUser.getTenantId());
    }

    private boolean hasCustomMenuTree(Long tenantId) {
        Boolean enabled;
        String testCustomMenu = HttpServletUtil.currentRequest().getParameter("testCustomMenu");
        if (CharSequenceUtil.isNotBlank((CharSequence)testCustomMenu)) {
            return Boolean.parseBoolean(testCustomMenu);
        }
        if (tenantId == null) {
            tenantId = TenantConstant.DEFAULT_TENANT_ID;
        }
        return (enabled = this.tenantMenuRepoProc.getEnabledByTenant(tenantId)) != null && enabled != false;
    }
}

