/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.security.common.InnerRole;
import com.elitescloud.cloudt.constant.SysRoleBusiness;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.convert.RoleConvert;
import com.elitescloud.cloudt.system.model.vo.resp.role.GroupRoleRespVO;
import com.elitescloud.cloudt.system.service.callback.RoleChangedCallback;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.model.bo.SysRoleSaveBO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleRelatedDO;
import com.elitescloud.cloudt.system.service.repo.RoleDataPermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleFieldPermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleGroupRepoProc;
import com.elitescloud.cloudt.system.service.repo.RolePermissionRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRelatedRepoProc;
import com.elitescloud.cloudt.system.service.repo.RoleRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysDpcrApiFieldsRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysDprRoleApiRowRuleRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRoleRepoProc;
import com.google.common.base.Functions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.TENANT)
public class RoleMngManager {
    private static final RoleConvert CONVERT = RoleConvert.INSTANCE;
    @Autowired
    private RoleRepoProc roleRepoProc;
    @Autowired
    private RolePermissionRepoProc rolePermissionRepoProc;
    @Autowired
    private RoleFieldPermissionRepoProc roleFieldPermissionRepoProc;
    @Autowired
    private RoleDataPermissionRepoProc roleDataPermissionRepoProc;
    @Autowired
    private RoleGroupRepoProc roleGroupRepoProc;
    @Autowired
    private RoleRelatedRepoProc roleRelatedRepoProc;
    @Autowired
    private UserRoleRepoProc userRoleRepoProc;
    @Autowired
    private SysDprRoleApiRowRuleRepoProc apiRowRuleRepoProc;
    @Autowired
    private SysDpcrApiFieldsRepoProc apiFieldsRepoProc;
    @Autowired
    private ObjectProvider<RoleChangedCallback> roleChangedCallbacks;
    @Autowired
    private AuthorizationProperties authorizationProperties;

    public SysRoleDO upsert(@NotNull SysRoleSaveBO saveBO) {
        boolean isAdd = saveBO.getId() == null;
        SysRoleDO roleDO = isAdd ? this.checkForInsert(saveBO) : this.checkForUpdate(saveBO);
        SysRoleDO roleOld = isAdd ? null : (SysRoleDO)this.roleRepoProc.get(saveBO.getId());
        this.roleRepoProc.save((Serializable)roleDO);
        this.roleChangedCallbacks.forEach(t -> t.onUpsert(isAdd, saveBO, roleDO));
        if (!isAdd && !Objects.equals(roleDO.getEnabled(), roleOld.getEnabled())) {
            this.roleChangedCallbacks.forEach(t -> t.onEnabled(saveBO.getId(), roleDO.getEnabled().booleanValue()));
        }
        return roleDO;
    }

    public void updateEnabled(@NotNull Long roleId, Boolean enabled) {
        if (enabled == null) {
            enabled = true;
        }
        this.roleRepoProc.updateEnabled(roleId, enabled);
        Boolean finalEnabled = enabled;
        this.roleChangedCallbacks.forEach(t -> t.onEnabled(roleId, finalEnabled.booleanValue()));
    }

    public void updateName(long roleId, @NotBlank String name) {
        Assert.hasText((String)name, (String)"\u89d2\u8272\u540d\u79f0\u4e3a\u7a7a");
        this.roleRepoProc.updateName(roleId, name);
    }

    public void delete(@NotNull Long roleId) {
        SysRoleDO role = (SysRoleDO)this.roleRepoProc.get(roleId);
        if (role == null) {
            return;
        }
        if (this.userRoleRepoProc.existsRole(roleId)) {
            throw new BusinessException("\u8bf7\u5148\u79fb\u9664\u89d2\u8272\u4e0b\u7684\u6210\u5458");
        }
        this.roleRepoProc.delete(roleId);
        this.rolePermissionRepoProc.deleteByRole(roleId);
        this.apiRowRuleRepoProc.deleteByRole(roleId);
        this.apiFieldsRepoProc.deleteByRole(roleId);
        this.roleFieldPermissionRepoProc.deleteByRole(role.getCode());
        this.roleDataPermissionRepoProc.deleteByRole(role.getCode());
        this.roleChangedCallbacks.forEach(t -> t.onDelete(role));
    }

    public List<GroupRoleRespVO> listGroupRole(boolean showDisabled, BelongType.Belonger belonger) {
        Boolean enabled = !showDisabled ? Boolean.valueOf(true) : null;
        List<GroupRoleRespVO> groupList = this.roleGroupRepoProc.listIdCodeName(belonger, enabled).stream().map(t -> {
            GroupRoleRespVO respVO = new GroupRoleRespVO();
            respVO.setGroupId(t.getId());
            respVO.setGroupCode(t.getCode());
            respVO.setGroupName(t.getName());
            respVO.setRoles(new ArrayList<GroupRoleRespVO.Role>(32));
            return respVO;
        }).collect(Collectors.toList());
        Map groupMap = groupList.stream().collect(Collectors.toMap(GroupRoleRespVO::getGroupId, Functions.identity(), (t1, t2) -> t1));
        GroupRoleRespVO groupDefault = groupMap.computeIfAbsent(-1L, t -> {
            GroupRoleRespVO respVO = new GroupRoleRespVO();
            respVO.setGroupId((Long)t);
            respVO.setGroupName("\u9ed8\u8ba4\u5206\u7ec4");
            respVO.setRoles(new ArrayList<GroupRoleRespVO.Role>(32));
            return respVO;
        });
        List<SysRoleDO> roleList = this.roleRepoProc.queryIdCodeNames(enabled, null, belonger, null);
        if (roleList.isEmpty()) {
            return groupList;
        }
        GroupRoleRespVO.Role roleRespVO = null;
        for (SysRoleDO role : roleList) {
            roleRespVO = new GroupRoleRespVO.Role();
            roleRespVO.setRoleId(role.getId());
            roleRespVO.setRoleCode(role.getCode());
            roleRespVO.setRoleName(role.getName());
            if (role.getGroupId() == null || !groupMap.containsKey(role.getGroupId())) {
                groupDefault.getRoles().add(roleRespVO);
                continue;
            }
            ((GroupRoleRespVO)groupMap.get(role.getGroupId())).getRoles().add(roleRespVO);
        }
        if (CharSequenceUtil.isBlank((CharSequence)groupDefault.getGroupCode())) {
            groupList.add(0, groupDefault);
        }
        return groupList;
    }

    public List<GroupRoleRespVO> listGroupRoleByRelated(@NotBlank String relatedType, @NotBlank String relationId, BelongType.Belonger belonger) {
        List<SysRoleRelatedDO> relatedList = this.roleRelatedRepoProc.queryByRelated(relationId, relatedType);
        if (relatedList.isEmpty()) {
            return Collections.emptyList();
        }
        HashSet<Long> roleGroupCodes = new HashSet<Long>(relatedList.size());
        for (SysRoleRelatedDO related : relatedList) {
            if (!related.getRoleGroup().booleanValue()) continue;
            roleGroupCodes.add(Long.parseLong(related.getRoleCode()));
        }
        if (roleGroupCodes.isEmpty()) {
            return Collections.emptyList();
        }
        Boolean enabled = true;
        List<GroupRoleRespVO> groupList = this.roleGroupRepoProc.listIdCodeName(roleGroupCodes, belonger, enabled).stream().map(t -> {
            GroupRoleRespVO respVO = new GroupRoleRespVO();
            respVO.setGroupId(t.getId());
            respVO.setGroupCode(t.getCode());
            respVO.setGroupName(t.getName());
            respVO.setRoles(new ArrayList<GroupRoleRespVO.Role>(32));
            return respVO;
        }).toList();
        if (groupList.isEmpty()) {
            return Collections.emptyList();
        }
        Map groupMap = groupList.stream().collect(Collectors.toMap(GroupRoleRespVO::getGroupId, Functions.identity(), (t1, t2) -> t1));
        List<SysRoleDO> roleList = this.roleRepoProc.queryIdCodeNames(enabled, groupMap.keySet(), belonger, null);
        GroupRoleRespVO.Role roleRespVO = null;
        for (SysRoleDO role : roleList) {
            roleRespVO = new GroupRoleRespVO.Role();
            roleRespVO.setRoleId(role.getId());
            roleRespVO.setRoleCode(role.getCode());
            roleRespVO.setRoleName(role.getName());
            if (role.getGroupId() == null || !groupMap.containsKey(role.getGroupId())) continue;
            ((GroupRoleRespVO)groupMap.get(role.getGroupId())).getRoles().add(roleRespVO);
        }
        return groupList;
    }

    private SysRoleDO checkForInsert(SysRoleSaveBO saveBO) {
        Assert.hasText((String)saveBO.getCode(), (String)"\u89d2\u8272\u7f16\u7801\u4e3a\u7a7a");
        String codePrefix = this.rolePrefix();
        Assert.isTrue((!saveBO.getCode().startsWith(codePrefix) ? 1 : 0) != 0, (String)("\u89d2\u8272\u7f16\u7801\u7684\u524d\u7f00\u4e0d\u80fd\u662f" + codePrefix));
        boolean exists = this.roleRepoProc.existsCode(saveBO.getCode());
        Assert.isTrue((!exists ? 1 : 0) != 0, (String)"\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728");
        if (InnerRole.valueOf((String)saveBO.getCode()) != null) {
            throw new IllegalArgumentException(saveBO.getCode() + "\u662f\u7cfb\u7edf\u5185\u7f6e\u89d2\u8272\uff0c\u4e0d\u53ef\u4f7f\u7528");
        }
        if (saveBO.getGroupId() == null) {
            saveBO.setGroupId(Long.valueOf(-1L));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saveBO.getParentCode())) {
            exists = this.roleRepoProc.existsCode(saveBO.getParentCode());
            Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u89d2\u8272\u4e0d\u5b58\u5728");
        } else {
            saveBO.setParentCode("");
        }
        if (saveBO.getEnabled() == null) {
            saveBO.setEnabled(Boolean.valueOf(true));
        }
        Assert.hasText((String)saveBO.getType(), (String)"\u672a\u77e5\u89d2\u8272\u7c7b\u578b");
        saveBO.setBusinessKey(CharSequenceUtil.blankToDefault((CharSequence)saveBO.getBusinessKey(), (String)SysRoleBusiness.SYS.getValue()));
        return CONVERT.saveBo2DO(saveBO);
    }

    private SysRoleDO checkForUpdate(SysRoleSaveBO saveBO) {
        SysRoleDO roleDO = (SysRoleDO)this.roleRepoProc.get(saveBO.getId());
        Assert.notNull((Object)roleDO, (String)"\u89d2\u8272\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)roleDO.getCode().equals(saveBO.getCode()), (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u53ef\u4fee\u6539");
        if (InnerRole.valueOf((String)saveBO.getCode()) != null) {
            throw new IllegalArgumentException(saveBO.getCode() + "\u662f\u7cfb\u7edf\u5185\u7f6e\u89d2\u8272\uff0c\u4e0d\u53ef\u4f7f\u7528");
        }
        if (saveBO.getGroupId() == null) {
            saveBO.setGroupId(Long.valueOf(-1L));
        }
        if (CharSequenceUtil.isNotBlank((CharSequence)saveBO.getParentCode())) {
            if (!saveBO.getParentCode().equals(roleDO.getParentCode())) {
                boolean exists = this.roleRepoProc.existsCode(saveBO.getParentCode());
                Assert.isTrue((boolean)exists, (String)"\u4e0a\u7ea7\u89d2\u8272\u4e0d\u5b58\u5728");
            }
        } else {
            saveBO.setParentCode("");
        }
        if (saveBO.getEnabled() == null) {
            saveBO.setEnabled(roleDO.getEnabled());
        }
        if (!StringUtils.hasText((String)saveBO.getType())) {
            saveBO.setType(roleDO.getType());
        }
        if (!StringUtils.hasText((String)saveBO.getTypeId())) {
            saveBO.setTypeId(roleDO.getTypeId());
        }
        saveBO.setBusinessKey(CharSequenceUtil.blankToDefault((CharSequence)saveBO.getBusinessKey(), (String)SysRoleBusiness.SYS.getValue()));
        CONVERT.copySaveBO(saveBO, roleDO);
        return roleDO;
    }

    private String rolePrefix() {
        return CharSequenceUtil.blankToDefault((CharSequence)this.authorizationProperties.getRolePrefix(), (String)"ROLE_");
    }
}

