/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.manager;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.dto.SysUserBasicDTO;
import com.elitescloud.cloudt.system.model.bo.MasterUserBO;
import com.elitescloud.cloudt.system.model.bo.SubUserBO;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.repo.SubUserRepoProc;
import com.elitescloud.cloudt.system.service.repo.SysTenantUserRepoProc;
import com.elitescloud.cloudt.system.service.repo.UserRepoProc;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
@TenantOrgTransaction(useTenantOrg=false)
public class UserQueryManager {
    @Autowired
    private UserRepoProc userRepoProc;
    @Autowired
    private SysTenantUserRepoProc tenantUserRepoProc;
    @Autowired
    private SubUserRepoProc subUserRepoProc;
    @Autowired
    private SystemProperties systemProperties;
    @Autowired
    private TenantClientProvider tenantClientProvider;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public Long getUniqueIdByUsername(@NotBlank String username) {
        return this.userRepoProc.getIdByUsername(username);
    }

    public Long getUniqueIdByMobile(@NotBlank String mobile) {
        if (!this.systemProperties.getMobileUnique().booleanValue()) {
            throw new BusinessException("\u7cfb\u7edf\u672a\u9650\u5236\u624b\u673a\u53f7\u552f\u4e00");
        }
        List<Long> ids = this.userRepoProc.getIdByMobile(mobile);
        if (ids.isEmpty()) {
            return null;
        }
        if (ids.size() == 1) {
            return ids.get(0);
        }
        throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u624b\u673a\u53f7");
    }

    public Long getUniqueIdByEmail(@NotBlank String email) {
        if (!this.systemProperties.getEmailUnique().booleanValue()) {
            throw new BusinessException("\u7cfb\u7edf\u672a\u9650\u5236\u90ae\u7bb1\u552f\u4e00");
        }
        List<Long> ids = this.userRepoProc.getIdByEmail(email);
        if (ids.isEmpty()) {
            return null;
        }
        if (ids.size() == 1) {
            return ids.get(0);
        }
        throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u90ae\u7bb1");
    }

    public Long getUniqueIdByIdCard(@NotBlank String idCard) {
        if (!this.systemProperties.getIdCardUnique().booleanValue()) {
            throw new BusinessException("\u7cfb\u7edf\u672a\u9650\u5236\u8eab\u4efd\u8bc1\u552f\u4e00");
        }
        List<Long> ids = this.userRepoProc.getIdByIdCard(idCard);
        if (ids.isEmpty()) {
            return null;
        }
        if (ids.size() == 1) {
            return ids.get(0);
        }
        throw new BusinessException("\u5b58\u5728\u91cd\u590d\u7684\u8eab\u4efd\u8bc1\u53f7");
    }

    public boolean belongToTenant(@NotNull Long userId, @NotNull Long tenantId) {
        if (!this.tenantClientProvider.enabledTenant()) {
            return true;
        }
        List tenantIds = this.tenantUserRepoProc.getTenantIdOfUser(userId);
        return tenantIds.contains(tenantId);
    }

    public SysUserBasicDTO getBasic(@NotNull Long userId) {
        return this.userRepoProc.getBasicDto(userId);
    }

    public List<SysUserBasicDTO> getBasic(@NotNull Collection<Long> userIds) {
        return this.userRepoProc.getBasicDto(userIds);
    }

    @TenantTransaction(isolateType=TenantIsolateType.TENANT)
    public MasterUserBO getMasterUser(long userId) {
        SubUserBO subUserBO = this.subUserRepoProc.getBySubUser(userId);
        if (subUserBO == null) {
            return null;
        }
        if (subUserBO.getBelongType() != BelongType.PERSONAL) {
            return null;
        }
        long masterUserId = Long.parseLong(subUserBO.getTypeId());
        MasterUserBO masterUserBO = new MasterUserBO();
        masterUserBO.setMasterUserId(masterUserId);
        masterUserBO.setUsername((String)this.tenantDataIsolateProvider.byDefaultDirectly(() -> this.userRepoProc.queryUserName(masterUserId)));
        if (StringUtils.hasText((String)masterUserBO.getUsername())) {
            return null;
        }
        masterUserBO.setPermissionType(subUserBO.getPermissionTypeEnum());
        return masterUserBO;
    }

    public List<Long> filterExistsUserIds(@NotEmpty Collection<Long> userIds, Long tenantId) {
        if (tenantId == null || tenantId.longValue() == TenantConstant.DEFAULT_TENANT_ID.longValue()) {
            return this.userRepoProc.exists(userIds);
        }
        return this.tenantUserRepoProc.filterExistsUserIds(userIds, tenantId);
    }

    public List<IdCodeNameParam> queryUsers(@NotEmpty Collection<Long> userIds, Long tenantId) {
        return this.tenantUserRepoProc.queryUsers(userIds, tenantId);
    }
}

