/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.model.bo.BusinessObjectBO;
import com.elitescloud.cloudt.system.model.vo.query.businessobject.BusinessObjectPageQueryVO;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiSourceEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessObjectDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysBusinessOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysBusinessObjectDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class BusinessObjectRepoProc
extends BaseRepoProc<SysBusinessObjectDO> {
    private static final QSysBusinessObjectDO QDO = QSysBusinessObjectDO.sysBusinessObjectDO;
    @Autowired
    private SystemProperties systemProperties;

    public BusinessObjectRepoProc() {
        super((EntityPathBase)QDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteForGatherByOpenApiCode(@NotBlank String openApiCode) {
        BooleanExpression predicate = BusinessObjectRepoProc.QDO.openApiCode.eq((Object)openApiCode).and((Predicate)BusinessObjectRepoProc.QDO.dataSource.in((Object[])new String[]{OpenApiSourceEnum.GATHER_PULL.name(), OpenApiSourceEnum.GATHER_PUSH.name()}));
        super.delete((Predicate)predicate);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteByCodes(@NotBlank String openApiId, Collection<String> codes) {
        super.delete((Predicate)BusinessObjectRepoProc.QDO.code.in(codes).and((Predicate)BusinessObjectRepoProc.QDO.openApiCode.eq((Object)openApiId)));
    }

    public Map<String, Long> countByOpenApi(Collection<String> openApiCodes) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessObjectRepoProc.QDO.openApiCode, BusinessObjectRepoProc.QDO.openApiCode.count()}).from((EntityPath)QDO)).where((Predicate)BusinessObjectRepoProc.QDO.openApiCode.in(openApiCodes))).groupBy((Expression)BusinessObjectRepoProc.QDO.openApiCode)).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)BusinessObjectRepoProc.QDO.openApiCode), t -> (Long)t.get((Expression)BusinessObjectRepoProc.QDO.openApiCode.count()), (t1, t2) -> t1));
    }

    public Map<String, Long> getIdAndCodeByOpenApiId(@NotBlank String openApiCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessObjectRepoProc.QDO.id, BusinessObjectRepoProc.QDO.code}).from((EntityPath)QDO)).where((Predicate)BusinessObjectRepoProc.QDO.openApiCode.eq((Object)openApiCode))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)BusinessObjectRepoProc.QDO.code), t -> (Long)t.get((Expression)BusinessObjectRepoProc.QDO.id), (t1, t2) -> t1));
    }

    public List<SysBusinessObjectDO> listByOpenApiCode(@NotBlank String openApiCode) {
        return super.getList((Predicate)BusinessObjectRepoProc.QDO.openApiCode.eq((Object)openApiCode), new OrderSpecifier[0]);
    }

    public PagingVO<SysBusinessObjectDO> pageMng(BusinessObjectPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)BusinessObjectRepoProc.QDO.openApiCode, (Object)queryVO.getOpenApiCode()).andEq((SimpleExpression)BusinessObjectRepoProc.QDO.appCode, (Object)queryVO.getAppCode()).andEq((SimpleExpression)BusinessObjectRepoProc.QDO.code, (Object)queryVO.getCode()).andLike((StringExpression)BusinessObjectRepoProc.QDO.name, queryVO.getName()).andLike((StringExpression)BusinessObjectRepoProc.QDO.description, queryVO.getDescription()).andLike((StringExpression)BusinessObjectRepoProc.QDO.domain, queryVO.getDomain()).andEq((SimpleExpression)BusinessObjectRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), BusinessObjectRepoProc.QDO.modifyTime.desc());
    }

    public List<BusinessObjectBO> listSimpleByAppCodes(@NotEmpty Collection<String> appCodes, Boolean enabled, Boolean publicResource) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)BusinessObjectRepoProc.QDO.appCode, appCodes).andEq((SimpleExpression)BusinessObjectRepoProc.QDO.enabled, (Object)enabled).and(Boolean.TRUE.equals(publicResource), () -> {
            if (CollUtil.isEmpty((Collection)this.systemProperties.getBusinessObjectPublicResources())) {
                return BusinessObjectRepoProc.QDO.publicResource.eq(Boolean.valueOf(true));
            }
            return BusinessObjectRepoProc.QDO.publicResource.eq(Boolean.valueOf(true)).or((Predicate)BusinessObjectRepoProc.QDO.code.in((Collection)this.systemProperties.getBusinessObjectPublicResources()));
        }).build();
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSimpleBO()).from((EntityPath)QDO)).where(predicate)).orderBy(BusinessObjectRepoProc.QDO.createTime.asc())).fetch();
    }

    public BusinessObjectBO getSimple(@NotBlank String code) {
        return (BusinessObjectBO)super.getOneByValue(this.qBeanSimpleBO(), (Path)BusinessObjectRepoProc.QDO.code, (Object)code);
    }

    public BusinessObjectBO getSimpleByOperationCode(@NotBlank String operationCode) {
        QSysBusinessOperationDO QDO_OPERATION = QSysBusinessOperationDO.sysBusinessOperationDO;
        BooleanExpression predicate = BusinessObjectRepoProc.QDO.code.eq((Expression)JPAExpressions.select((Expression)QDO_OPERATION.businessObjectCode).from(new EntityPath[]{QDO_OPERATION}).where(new Predicate[]{QDO_OPERATION.operationCode.eq((Object)operationCode)}));
        return (BusinessObjectBO)super.getOne(this.qBeanSimpleBO(), (Predicate)predicate);
    }

    public List<BusinessObjectBO> listSimple(@NotEmpty Collection<String> codes) {
        return super.getList(this.qBeanSimpleBO(), (Predicate)BusinessObjectRepoProc.QDO.code.in(codes), new OrderSpecifier[0]);
    }

    public List<BusinessObjectBO> listSimple(Boolean enabled) {
        BooleanExpression predicate = enabled == null ? null : BusinessObjectRepoProc.QDO.enabled.eq(enabled);
        return super.getList(this.qBeanSimpleBO(), (Predicate)predicate, new OrderSpecifier[0]);
    }

    public List<String> filterCodes(@NotEmpty Collection<String> codes) {
        return super.getValueListByValue((Path)BusinessObjectRepoProc.QDO.code, (Path)BusinessObjectRepoProc.QDO.code, codes, new OrderSpecifier[0]);
    }

    public Map<String, String> getCodeAndNames(@NotEmpty Collection<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{BusinessObjectRepoProc.QDO.code, BusinessObjectRepoProc.QDO.customName, BusinessObjectRepoProc.QDO.name}).from((EntityPath)QDO)).where((Predicate)BusinessObjectRepoProc.QDO.code.in(codes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)BusinessObjectRepoProc.QDO.code), t -> CharSequenceUtil.blankToDefault((CharSequence)((CharSequence)t.get((Expression)BusinessObjectRepoProc.QDO.customName)), (String)((String)t.get((Expression)BusinessObjectRepoProc.QDO.name))), (t1, t2) -> t1));
    }

    public String getName(@NotBlank String code) {
        return (String)super.getValueByValue((Path)BusinessObjectRepoProc.QDO.name, (Path)BusinessObjectRepoProc.QDO.code, (Object)code);
    }

    public String getAppCode(@NotBlank String code) {
        return (String)super.getValueByValue((Path)BusinessObjectRepoProc.QDO.appCode, (Path)BusinessObjectRepoProc.QDO.code, (Object)code);
    }

    public Boolean getSupportTenant(@NotBlank String code) {
        return (Boolean)super.getValueByValue((Path)BusinessObjectRepoProc.QDO.supportTenant, (Path)BusinessObjectRepoProc.QDO.code, (Object)code);
    }

    private QBean<BusinessObjectBO> qBeanSimpleBO() {
        return Projections.bean(BusinessObjectBO.class, (Expression[])new Expression[]{BusinessObjectRepoProc.QDO.id, BusinessObjectRepoProc.QDO.appCode, BusinessObjectRepoProc.QDO.code, BusinessObjectRepoProc.QDO.name, BusinessObjectRepoProc.QDO.customName, BusinessObjectRepoProc.QDO.description, BusinessObjectRepoProc.QDO.enabled, BusinessObjectRepoProc.QDO.publicResource, BusinessObjectRepoProc.QDO.entityClassName});
    }
}

