/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.constant.PlatformAppMenusTypeEnum;
import com.elitescloud.cloudt.system.constant.PlatformMenusNodeEnum;
import com.elitescloud.cloudt.system.model.bo.MenuBO;
import com.elitescloud.cloudt.system.model.bo.MenuSimpleBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformAppDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysPlatformMenusDO;
import com.elitescloud.cloudt.system.service.model.entity.SysPlatformMenusDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Repository
public class MenuRepoProc
extends BaseRepoProc<SysPlatformMenusDO> {
    private static final QSysPlatformMenusDO QDO = QSysPlatformMenusDO.sysPlatformMenusDO;
    private static final QSysPlatformAppDO QDO_APP = QSysPlatformAppDO.sysPlatformAppDO;

    public MenuRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByMenuCode(@NotBlank String menuCode) {
        super.deleteByValue((Path)MenuRepoProc.QDO.menusCode, (Object)menuCode);
    }

    public boolean existsMenuCode(@NotBlank String menuCode) {
        return super.exists((Path)MenuRepoProc.QDO.menusCode, (Object)menuCode);
    }

    public List<String> queryMenuCodeByMenuNameLike(@NotBlank String menuNameLike) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)MenuRepoProc.QDO.menusCode).from((EntityPath)QDO)).where((Predicate)MenuRepoProc.QDO.menusName.like("%" + menuNameLike + "%"))).fetch();
    }

    public List<String> getMenuCodes(boolean menuOnly, boolean withAdmin, boolean withBusiness, Boolean enabled) {
        Set<String> menuTypes = this.getMenuTypes(withAdmin, withBusiness);
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn(menuOnly, (SimpleExpression)MenuRepoProc.QDO.nodeType, this.nodeTypeOfMenu()).andIn((SimpleExpression)MenuRepoProc.QDO.menusType, menuTypes).andEq((SimpleExpression)MenuRepoProc.QDO.menusState, (Object)enabled).build();
        return super.getValueList((Path)MenuRepoProc.QDO.menusCode, predicate, new OrderSpecifier[0]);
    }

    public List<IdCodeNameParam> getMenuCodeAndNames() {
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{MenuRepoProc.QDO.id, MenuRepoProc.QDO.menusCode.as("code"), MenuRepoProc.QDO.menusName.as("name")});
        return super.getList(qBean, null, new OrderSpecifier[0]);
    }

    public List<IdCodeNameParam> getMenuCodeAndNames(@NotEmpty Collection<String> menuCodes) {
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{MenuRepoProc.QDO.id, MenuRepoProc.QDO.menusCode.as("code"), MenuRepoProc.QDO.menusName.as("name")});
        return super.getList(qBean, (Predicate)MenuRepoProc.QDO.menusCode.in(menuCodes), new OrderSpecifier[0]);
    }

    public String getMenuNameByMenuCode(@NotBlank String menuCode) {
        return (String)super.getValueByValue((Path)MenuRepoProc.QDO.menusName, (Path)MenuRepoProc.QDO.menusCode, (Object)menuCode);
    }

    public String getAppCodeByMenuCode(@NotBlank String menuCode) {
        return (String)super.getValueByValue((Path)MenuRepoProc.QDO.menusAppCode, (Path)MenuRepoProc.QDO.menusCode, (Object)menuCode);
    }

    public String getParentCode(@NotBlank String menuCode) {
        return (String)super.getValueByValue((Path)MenuRepoProc.QDO.menusParentCode, (Path)MenuRepoProc.QDO.menusCode, (Object)menuCode);
    }

    public Long getAppIdByMenuCode(@NotBlank String menuCode) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)MenuRepoProc.QDO_APP.id).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_APP)).on((Predicate)MenuRepoProc.QDO_APP.appCode.eq((Expression)MenuRepoProc.QDO.menusAppCode))).where((Predicate)MenuRepoProc.QDO.menusCode.eq((Object)menuCode))).limit(1L)).fetchOne();
    }

    public String getMenuTypeByMenuCode(@NotBlank String menuCode) {
        return (String)super.getValueByValue((Path)MenuRepoProc.QDO.menusType, (Path)MenuRepoProc.QDO.menusCode, (Object)menuCode);
    }

    public Map<String, String> getMenuNameByMenuCode(@NotEmpty Collection<String> menuCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{MenuRepoProc.QDO.menusCode, MenuRepoProc.QDO.menusName}).from((EntityPath)QDO)).where((Predicate)MenuRepoProc.QDO.menusCode.in(menuCodes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)MenuRepoProc.QDO.menusCode), t -> (String)t.get((Expression)MenuRepoProc.QDO.menusName), (t1, t2) -> t1));
    }

    public Map<String, String> getMenuNames(Collection<String> appCodes, boolean withSys, boolean withMenuGroup, boolean withAction) {
        Set<String> nodeTypes = null;
        nodeTypes = withAction ? null : (withMenuGroup ? this.nodeTypeOfMenuAndGroup() : this.nodeTypeOfMenu());
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)MenuRepoProc.QDO.menusAppCode, appCodes).andIn((SimpleExpression)MenuRepoProc.QDO.nodeType, nodeTypes).andIn((SimpleExpression)MenuRepoProc.QDO.menusType, this.getMenuTypes(withSys, true)).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{MenuRepoProc.QDO.menusCode, MenuRepoProc.QDO.menusName}).from((EntityPath)QDO)).where(predicate)).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)MenuRepoProc.QDO.menusCode), t -> (String)t.get((Expression)MenuRepoProc.QDO.menusName), (t1, t2) -> t1));
    }

    public MenuBO getByMenuCode(@NotBlank String menuCode) {
        return (MenuBO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanMenu()).from((EntityPath)QDO)).where((Predicate)MenuRepoProc.QDO.menusCode.eq((Object)menuCode))).limit(1L)).fetchOne();
    }

    public List<MenuBO> listByMenuCode(@NotEmpty Collection<String> menuCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanMenu()).from((EntityPath)QDO)).where((Predicate)MenuRepoProc.QDO.menusCode.in(menuCodes))).fetch();
    }

    public List<MenuSimpleBO> listSimpleByMenuCode(@NotEmpty Collection<String> menuCodes) {
        return super.getList(this.qBeanSimpleMenu(), (Predicate)MenuRepoProc.QDO.menusCode.in(menuCodes), new OrderSpecifier[0]);
    }

    public List<MenuBO> queryMenu(Set<String> appCodes, boolean includeSys, boolean includeBusiness, boolean menuOnly, Boolean enabled) {
        HashSet<String> menuTypes = new HashSet<String>(4);
        if (includeSys) {
            menuTypes.add(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name());
            menuTypes.add(PlatformAppMenusTypeEnum.MENUS_TYPE_PLATFORM.name());
        }
        if (includeBusiness) {
            menuTypes.add(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name());
        }
        if (menuTypes.isEmpty()) {
            return Collections.emptyList();
        }
        if (includeSys && includeBusiness) {
            menuTypes.clear();
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)MenuRepoProc.QDO.menusAppCode, appCodes).andIn((SimpleExpression)MenuRepoProc.QDO.menusType, menuTypes).andIn(menuOnly, (SimpleExpression)MenuRepoProc.QDO.nodeType, this.nodeTypeOfMenuAndGroup()).andEq((SimpleExpression)MenuRepoProc.QDO.menusState, (Object)enabled).build();
        return super.getList(this.qBeanMenu(), predicate, new OrderSpecifier[0]);
    }

    public List<MenuBO> queryActionByAppCode(Set<String> appCodes, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn(!CollectionUtils.isEmpty(appCodes), (SimpleExpression)MenuRepoProc.QDO.menusAppCode, appCodes).andEq(true, (SimpleExpression)MenuRepoProc.QDO.nodeType, (Object)PlatformMenusNodeEnum.BUTTON.name()).andEq((SimpleExpression)MenuRepoProc.QDO.menusState, (Object)enabled).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanMenu()).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public List<MenuBO> queryActionByMenuCode(String menuCode, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(StringUtils.hasText((String)menuCode), (SimpleExpression)MenuRepoProc.QDO.menusParentCode, (Object)menuCode).andEq(true, (SimpleExpression)MenuRepoProc.QDO.nodeType, (Object)PlatformMenusNodeEnum.BUTTON.name()).andEq((SimpleExpression)MenuRepoProc.QDO.menusState, (Object)enabled).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanMenu()).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    private Set<String> getMenuTypes(boolean withAdmin, boolean withBusiness) {
        if (withAdmin && withBusiness) {
            return Collections.emptySet();
        }
        HashSet<String> menuTypes = new HashSet<String>(8);
        if (withAdmin) {
            menuTypes.add(PlatformAppMenusTypeEnum.MENUS_TYPE_PLATFORM.name());
            menuTypes.add(PlatformAppMenusTypeEnum.MENUS_TYPE_SYS.name());
        }
        if (withBusiness) {
            menuTypes.add(PlatformAppMenusTypeEnum.MENUS_TYPE_BUS.name());
        }
        return menuTypes;
    }

    private Set<String> nodeTypeOfMenuAndGroup() {
        return Set.of(PlatformMenusNodeEnum.MENUS.name(), PlatformMenusNodeEnum.MENUS_GROUP.name());
    }

    private Set<String> nodeTypeOfMenu() {
        return Set.of(PlatformMenusNodeEnum.MENUS.name());
    }

    private QBean<MenuBO> qBeanMenu() {
        return Projections.bean(MenuBO.class, (Expression[])new Expression[]{MenuRepoProc.QDO.id, MenuRepoProc.QDO.menusAppCode, MenuRepoProc.QDO.menusName, MenuRepoProc.QDO.menusType, MenuRepoProc.QDO.nodeType, MenuRepoProc.QDO.menusCode, MenuRepoProc.QDO.menusOrder, MenuRepoProc.QDO.menusState, MenuRepoProc.QDO.menusParentCode, MenuRepoProc.QDO.menusRoute, MenuRepoProc.QDO.menusIcon, MenuRepoProc.QDO.display, MenuRepoProc.QDO.outerLink, MenuRepoProc.QDO.outerLinkType});
    }

    private QBean<MenuSimpleBO> qBeanSimpleMenu() {
        return Projections.bean(MenuSimpleBO.class, (Expression[])new Expression[]{MenuRepoProc.QDO.id, MenuRepoProc.QDO.menusAppCode, MenuRepoProc.QDO.menusName, MenuRepoProc.QDO.menusCode, MenuRepoProc.QDO.menusRoute});
    }
}

