/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.sys.OpenApiPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.resp.sys.OpenApiPageRespVO;
import com.elitescloud.cloudt.system.service.common.constant.OpenApiStatusEnum;
import com.elitescloud.cloudt.system.service.model.entity.QSysOpenApiInfoDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOpenApiOperationDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOpenApiInfoDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class OpenApiInfoRepoProc
extends BaseRepoProc<SysOpenApiInfoDO> {
    private static final Logger log = LoggerFactory.getLogger(OpenApiInfoRepoProc.class);
    private static final QSysOpenApiInfoDO QDO = QSysOpenApiInfoDO.sysOpenApiInfoDO;
    private static final QSysOpenApiOperationDO QDO_OPERATION = QSysOpenApiOperationDO.sysOpenApiOperationDO;

    public OpenApiInfoRepoProc() {
        super((EntityPathBase)QDO);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(long id, OpenApiStatusEnum status, String failReason) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)OpenApiInfoRepoProc.QDO.state, (Object)status.name()).set((Path)OpenApiInfoRepoProc.QDO.failReason, (Object)failReason).where(new Predicate[]{OpenApiInfoRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStartUpdate(long id) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)OpenApiInfoRepoProc.QDO.state, (Object)OpenApiStatusEnum.UPDATING.name()).setNull((Path)OpenApiInfoRepoProc.QDO.failReason).set((Path)OpenApiInfoRepoProc.QDO.startUpdateTime, (Object)LocalDateTime.now()).where(new Predicate[]{OpenApiInfoRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateEndUpdate(long id, OpenApiStatusEnum status, String failReason) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)OpenApiInfoRepoProc.QDO.state, (Object)status.name()).set((Path)OpenApiInfoRepoProc.QDO.failReason, (Object)failReason).set((Path)OpenApiInfoRepoProc.QDO.endUpdateTime, (Object)LocalDateTime.now()).where(new Predicate[]{OpenApiInfoRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBusinessObjectStatus(long id, OpenApiStatusEnum status, String failReason) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)OpenApiInfoRepoProc.QDO.businessObjectState, (Object)status.name()).set((Path)OpenApiInfoRepoProc.QDO.businessObjectFailReason, (Object)failReason).where(new Predicate[]{OpenApiInfoRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBusinessObjectStart(long id) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)OpenApiInfoRepoProc.QDO.businessObjectState, (Object)OpenApiStatusEnum.UPDATING.name()).setNull((Path)OpenApiInfoRepoProc.QDO.businessObjectFailReason).set((Path)OpenApiInfoRepoProc.QDO.businessObjectStartUpdateTime, (Object)LocalDateTime.now()).where(new Predicate[]{OpenApiInfoRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBusinessObjectEnd(long id, OpenApiStatusEnum status, String failReason) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)OpenApiInfoRepoProc.QDO.businessObjectState, (Object)status.name()).set((Path)OpenApiInfoRepoProc.QDO.businessObjectFailReason, (Object)failReason).set((Path)OpenApiInfoRepoProc.QDO.businessObjectEndUpdateTime, (Object)LocalDateTime.now()).where(new Predicate[]{OpenApiInfoRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateResourceId(long id, long resourceId) {
        super.updateValue((Path)OpenApiInfoRepoProc.QDO.resourceId, (Object)resourceId, id);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateBusinessResourceId(long id, long resourceId) {
        super.updateValue((Path)OpenApiInfoRepoProc.QDO.businessResourceId, (Object)resourceId, id);
    }

    public Long getId(String project, String env, String appCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)OpenApiInfoRepoProc.QDO.appCode, (Object)appCode).build();
        if (predicate == null) {
            return null;
        }
        return super.getIdByPredicate(predicate, new OrderSpecifier[0]);
    }

    public String getAppCode(long id) {
        return (String)super.getValue((Path)OpenApiInfoRepoProc.QDO.appCode, id);
    }

    public PagingVO<SysOpenApiInfoDO> pageMng(OpenApiPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)OpenApiInfoRepoProc.QDO.appCode, (Object)queryVO.getAppCode()).andEq((SimpleExpression)OpenApiInfoRepoProc.QDO.project, (Object)queryVO.getProject()).andEq((SimpleExpression)OpenApiInfoRepoProc.QDO.env, (Object)queryVO.getEnv()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), OpenApiInfoRepoProc.QDO.modifyTime.desc());
    }

    public OpenApiStatusEnum getState(long id) {
        String state = (String)super.getValue((Path)OpenApiInfoRepoProc.QDO.state, id);
        if (CharSequenceUtil.isBlank((CharSequence)state)) {
            return null;
        }
        return OpenApiStatusEnum.valueOf((String)state);
    }

    public OpenApiStatusEnum getBusinessObjectState(long id) {
        String state = (String)super.getValue((Path)OpenApiInfoRepoProc.QDO.businessObjectState, id);
        if (CharSequenceUtil.isBlank((CharSequence)state)) {
            return null;
        }
        return OpenApiStatusEnum.valueOf((String)state);
    }

    public Long getResourceId(long id) {
        return (Long)super.getValue((Path)OpenApiInfoRepoProc.QDO.resourceId, id);
    }

    private QBean<OpenApiPageRespVO> qBeanPageRespVO() {
        return Projections.bean(OpenApiPageRespVO.class, (Expression[])new Expression[]{OpenApiInfoRepoProc.QDO.id, OpenApiInfoRepoProc.QDO.openApiCode, OpenApiInfoRepoProc.QDO.project, OpenApiInfoRepoProc.QDO.projectName, OpenApiInfoRepoProc.QDO.appCode, OpenApiInfoRepoProc.QDO.appName, OpenApiInfoRepoProc.QDO.env, OpenApiInfoRepoProc.QDO.envName, OpenApiInfoRepoProc.QDO.title, OpenApiInfoRepoProc.QDO.description, OpenApiInfoRepoProc.QDO.version, OpenApiInfoRepoProc.QDO.buildTime, OpenApiInfoRepoProc.QDO.projectVersion, OpenApiInfoRepoProc.QDO.cloudtBootVersion, OpenApiInfoRepoProc.QDO.state, OpenApiInfoRepoProc.QDO.failReason, OpenApiInfoRepoProc.QDO.modifyTime, OpenApiInfoRepoProc.QDO.createTime});
    }
}

