/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.jpa.common.BaseTreeRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.OrgTreeNodeType;
import com.elitescloud.cloudt.system.convert.OrgConvert;
import com.elitescloud.cloudt.system.dto.SysOrgBasicDTO;
import com.elitescloud.cloudt.system.dto.req.SysOrgPageQueryDTO;
import com.elitescloud.cloudt.system.dto.resp.OrgTreeNodeRespVO;
import com.elitescloud.cloudt.system.model.entity.QSysPositionDO;
import com.elitescloud.cloudt.system.model.entity.QSysPositionOrgDO;
import com.elitescloud.cloudt.system.model.vo.query.common.CommonOrgPageQueryVO;
import com.elitescloud.cloudt.system.model.vo.query.org.OrgPageQueryVO;
import com.elitescloud.cloudt.system.param.SysOrgQueryDTO;
import com.elitescloud.cloudt.system.service.model.entity.QSysEmployeeOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysOrgDO;
import com.elitescloud.cloudt.system.service.model.entity.SysOrgDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class OrgRepoProc
extends BaseTreeRepoProc<SysOrgDO> {
    private static final QSysOrgDO QDO = QSysOrgDO.sysOrgDO;
    private static final OrgConvert CONVERT = OrgConvert.INSTANCE;
    private static final QSysPositionDO QDO_POST = QSysPositionDO.sysPositionDO;
    private static final QSysPositionOrgDO QDO_POST_ORG = QSysPositionOrgDO.sysPositionOrgDO;
    private static final QSysEmployeeOrgDO QDO_EMP_ORG = QSysEmployeeOrgDO.sysEmployeeOrgDO;

    public OrgRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue((Path)OrgRepoProc.QDO.enabled, (Object)enabled, id);
    }

    public void updateChildrenSyncOuter(long id, Boolean syncOuter) {
        super.updateValue((Path)OrgRepoProc.QDO.syncOuter, (Object)syncOuter, (Predicate)super.predicateForChildren(Long.valueOf(id)));
    }

    public boolean existsCode(@NotBlank String code) {
        return super.exists((Path)OrgRepoProc.QDO.code, (Object)code);
    }

    public Boolean getEnabled(long id) {
        return (Boolean)super.getValue((Path)OrgRepoProc.QDO.enabled, id);
    }

    public Boolean getSyncOuter(long id) {
        return (Boolean)super.getValue((Path)OrgRepoProc.QDO.syncOuter, id);
    }

    public Boolean getSyncOuterByCode(@NotBlank String code) {
        return (Boolean)super.getValueByValue((Path)OrgRepoProc.QDO.syncOuter, (Path)OrgRepoProc.QDO.code, (Object)code);
    }

    public Boolean getExecutive(long id) {
        return (Boolean)super.getValue((Path)OrgRepoProc.QDO.executive, id);
    }

    public Long getIdByCode(@NotBlank String code) {
        return super.getIdByValue((Path)OrgRepoProc.QDO.code, (Object)code);
    }

    public Map<String, Long> getIdByCode(Collection<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{OrgRepoProc.QDO.id, OrgRepoProc.QDO.code}).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.code.in(codes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)OrgRepoProc.QDO.code), t -> (Long)t.get((Expression)OrgRepoProc.QDO.id), (t1, t2) -> t1));
    }

    public Long getIdByName(@NotBlank String name) {
        return super.getIdByValue((Path)OrgRepoProc.QDO.name, (Object)name);
    }

    public List<Long> getIdsByName(@NotBlank String name) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.name.eq((Object)name))).fetch();
    }

    public List<IdCodeNameParam> queryIdCodeName(@NotEmpty Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanIdCodeName()).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.id.in(ids))).fetch();
    }

    public List<IdCodeNameParam> queryIdCodeNameByCodes(@NotEmpty Collection<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanIdCodeName()).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.code.in(codes))).fetch();
    }

    public String getCodeById(long id) {
        return (String)super.getValue((Path)OrgRepoProc.QDO.code, id);
    }

    public String getNameById(long id) {
        return (String)super.getValue((Path)OrgRepoProc.QDO.name, id);
    }

    public String getNameByCode(@NotBlank String code) {
        return (String)super.getValueByValue((Path)OrgRepoProc.QDO.name, (Path)OrgRepoProc.QDO.code, (Object)code);
    }

    public Integer getSortNo(long id) {
        return (Integer)super.getValue((Path)OrgRepoProc.QDO.sortNo, id);
    }

    public Long getRootId(long id) {
        return (Long)super.getValue((Path)OrgRepoProc.QDO.rootId, id);
    }

    public Long getParentIdByCode(String code) {
        return (Long)super.getValueByValue((Path)OrgRepoProc.QDO.pId, (Path)OrgRepoProc.QDO.code, (Object)code);
    }

    public Map<String, String> getParentCodeByCode(Collection<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{OrgRepoProc.QDO.code, OrgRepoProc.QDO.parentCode}).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.code.in(codes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)OrgRepoProc.QDO.code), t -> (String)t.get((Expression)OrgRepoProc.QDO.parentCode), (t1, t2) -> t1));
    }

    public Integer getMaxSortNo(@NotBlank String parentCode) {
        return (Integer)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO.sortNo.max()).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.parentCode.eq((Object)parentCode))).fetchOne();
    }

    public Long getLeftOrgId(long parentId, int sortNo) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.pId.eq((Object)parentId).and((Predicate)OrgRepoProc.QDO.sortNo.lt((Number)sortNo)))).orderBy(OrgRepoProc.QDO.sortNo.asc())).limit(1L)).fetchOne();
    }

    public Map<String, String> getNameByCode(@NotEmpty Collection<String> codes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{OrgRepoProc.QDO.name, OrgRepoProc.QDO.code}).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.code.in(codes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)OrgRepoProc.QDO.code), t -> (String)t.get((Expression)OrgRepoProc.QDO.name), (t1, t2) -> t1));
    }

    public Set<Long> queryAllOrgIds(Long tenantId, boolean includeDisabled) {
        if (tenantId == null) {
            tenantId = TenantConstant.DEFAULT_TENANT_ID;
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(true, (SimpleExpression)OrgRepoProc.QDO.tenantId, (Object)tenantId).andEq(!includeDisabled, (SimpleExpression)OrgRepoProc.QDO.enabled, (Object)true).build();
        return new HashSet<Long>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO.id).from((EntityPath)QDO)).where(predicate)).fetch());
    }

    public Set<Long> queryOrgIdsByBelong(long orgIdBelong, boolean includeDisabled) {
        BooleanExpression predicate = super.predicateForChildren(Long.valueOf(orgIdBelong));
        if (!includeDisabled) {
            predicate = predicate.and((Predicate)OrgRepoProc.QDO.enabled.eq(Boolean.valueOf(true)));
        }
        return new HashSet<Long>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)predicate)).fetch());
    }

    public List<Long> filterExecutiveOrg(@NotEmpty Collection<Long> orgIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.id.in(orgIds).and((Predicate)OrgRepoProc.QDO.executive.eq(Boolean.valueOf(true))))).fetch();
    }

    public List<OrgTreeNodeRespVO> getOrgTree(Long orgIdBelong, boolean includeDisabled) {
        return super.getTree(orgIdBelong, (Predicate)OrgRepoProc.QDO.executive.eq(Boolean.valueOf(true)), t -> includeDisabled || t.getEnabled() != false, t -> {
            OrgTreeNodeRespVO respVO = CONVERT.do2TreeNodeRespVO((SysOrgDO)t);
            respVO.setName(t.getPrettyName() + "[" + t.getCode() + "]");
            respVO.setRealName(t.getName());
            respVO.setParentId(t.getPId());
            respVO.setParentCode(t.getParentCode());
            respVO.setNodeType(OrgTreeNodeType.ORG.getValue());
            respVO.setNodeTypeName(OrgTreeNodeType.ORG.getDescription());
            respVO.setDataType(t.getType());
            return respVO;
        });
    }

    public List<OrgTreeNodeRespVO> getOrgTreeByParentId(Long pId, boolean includeDisabled) {
        if (pId == null) {
            pId = -1L;
        }
        BooleanExpression predicate = OrgRepoProc.QDO.pId.eq((Object)pId);
        if (!includeDisabled) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)OrgRepoProc.QDO.enabled.eq(Boolean.valueOf(true)));
        }
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{OrgRepoProc.QDO.id, OrgRepoProc.QDO.code, OrgRepoProc.QDO.name, OrgRepoProc.QDO.shortName, OrgRepoProc.QDO.type, OrgRepoProc.QDO.sortNo, OrgRepoProc.QDO.pId, OrgRepoProc.QDO.lft, OrgRepoProc.QDO.rgt}).from((EntityPath)QDO)).where((Predicate)predicate)).fetch().stream().map(t -> {
            OrgTreeNodeRespVO respVO = new OrgTreeNodeRespVO();
            respVO.setId((Long)t.get((Expression)OrgRepoProc.QDO.id));
            respVO.setCode((String)t.get((Expression)OrgRepoProc.QDO.code));
            respVO.setName(this.prettyName((String)t.get((Expression)OrgRepoProc.QDO.name), (String)t.get((Expression)OrgRepoProc.QDO.shortName)));
            respVO.setNodeType(OrgTreeNodeType.ORG.getValue());
            respVO.setNodeTypeName(OrgTreeNodeType.ORG.getDescription());
            respVO.setDataType((String)t.get((Expression)OrgRepoProc.QDO.type));
            respVO.setSortNo((Integer)t.get((Expression)OrgRepoProc.QDO.sortNo));
            respVO.setParentId((Long)t.get((Expression)OrgRepoProc.QDO.pId));
            respVO.setHasChildren(Boolean.valueOf(super.hasChildren((Integer)t.get((Expression)OrgRepoProc.QDO.lft), (Integer)t.get((Expression)OrgRepoProc.QDO.rgt))));
            respVO.setChildren(Collections.emptyList());
            return respVO;
        }).collect(Collectors.toList());
    }

    public SysOrgBasicDTO getBasicDto(long id) {
        return (SysOrgBasicDTO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSysOrgBasicDto()).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.id.eq((Object)id))).limit(1L)).fetchOne();
    }

    public SysOrgDO getByCode(@NotBlank String code) {
        return (SysOrgDO)super.getOneByValue((Path)OrgRepoProc.QDO.code, (Object)code);
    }

    public SysOrgBasicDTO getBasicDtoByCode(@NotBlank String code) {
        return (SysOrgBasicDTO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSysOrgBasicDto()).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.code.eq((Object)code))).limit(1L)).fetchOne();
    }

    public SysOrgBasicDTO getParentBasicDtoByCode(@NotBlank String code) {
        QSysOrgDO child = new QSysOrgDO("_parent");
        return (SysOrgBasicDTO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSysOrgBasicDto()).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.id.eq((Expression)((JPQLQuery)JPAExpressions.select((Expression)child.pId).from(new EntityPath[]{child}).where(new Predicate[]{child.code.eq((Object)code)})).limit(1L)))).limit(1L)).fetchOne();
    }

    public List<SysOrgBasicDTO> getParentBasicDtoByCode(Collection<String> codes) {
        QSysOrgDO child = new QSysOrgDO("_parent");
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSysOrgBasicDto()).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.id.in((SubQueryExpression)JPAExpressions.select((Expression)child.pId).from(new EntityPath[]{child}).where(new Predicate[]{child.code.in(codes)})))).fetch();
    }

    public List<SysOrgBasicDTO> getBasicDtoList(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSysOrgBasicDto()).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.id.in(ids))).fetch();
    }

    public List<SysOrgBasicDTO> getBasicDtoOfParents(Long id) {
        BooleanExpression predicate = this.predicateForParents(id);
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSysOrgBasicDto()).from((EntityPath)QDO)).where((Predicate)predicate)).orderBy(OrgRepoProc.QDO.lft.asc())).fetch();
    }

    public List<SysOrgBasicDTO> queryList(SysOrgQueryDTO queryDTO) {
        JPQLQuery subQueryOrgCodeByPost = null;
        if (queryDTO.getPositionId() != null) {
            subQueryOrgCodeByPost = (JPQLQuery)JPAExpressions.select((Expression)OrgRepoProc.QDO_POST_ORG.orgCode).from(new EntityPath[]{QDO_POST_ORG}).where(new Predicate[]{OrgRepoProc.QDO_POST_ORG.positionCode.eq((Expression)JPAExpressions.select((Expression)OrgRepoProc.QDO_POST.positionCode).from(new EntityPath[]{QDO_POST}).where(new Predicate[]{OrgRepoProc.QDO_POST.id.eq((Object)queryDTO.getPositionId())}))});
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)OrgRepoProc.QDO.id, (Collection)queryDTO.getIds()).andIn((SimpleExpression)OrgRepoProc.QDO.code, (Collection)queryDTO.getCodes()).andIn(subQueryOrgCodeByPost != null, (SimpleExpression)OrgRepoProc.QDO.code, subQueryOrgCodeByPost).andIn((SimpleExpression)OrgRepoProc.QDO.outerCode, (Collection)queryDTO.getOuterCodes()).andEq((SimpleExpression)OrgRepoProc.QDO.parentCode, (Object)queryDTO.getParentCode()).andEq((SimpleExpression)OrgRepoProc.QDO.executive, (Object)queryDTO.getExecutive()).andEq(Boolean.TRUE.equals(queryDTO.getRoot()), (SimpleExpression)OrgRepoProc.QDO.pId, (Object)-1L).andEq((SimpleExpression)OrgRepoProc.QDO.type, (Object)queryDTO.getType()).andIn((SimpleExpression)OrgRepoProc.QDO.type, (Collection)queryDTO.getTypes()).andEq((SimpleExpression)OrgRepoProc.QDO.entity, (Object)queryDTO.getEntity()).andEq((SimpleExpression)OrgRepoProc.QDO.enabled, (Object)queryDTO.getEnabled()).andEq((SimpleExpression)OrgRepoProc.QDO.ouId, (Object)queryDTO.getOuId()).and(queryDTO.getOrgIdBelong() != null, () -> super.predicateForChildren(queryDTO.getOrgIdBelong()).and((Predicate)OrgRepoProc.QDO.executive.eq(Boolean.valueOf(true)))).andLike((StringExpression)OrgRepoProc.QDO.name, queryDTO.getName()).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanSysOrgBasicDto()).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public PagingVO<SysOrgDO> pageMng(OrgPageQueryVO queryVO) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)OrgRepoProc.QDO.parentCode, (Object)queryVO.getParentCode()).andEq(queryVO.getOuId() != null, (SimpleExpression)OrgRepoProc.QDO.ouId, (Object)queryVO.getOuId()).andLike((StringExpression)OrgRepoProc.QDO.code, queryVO.getCode()).andLike((StringExpression)OrgRepoProc.QDO.outerCode, queryVO.getOuterCode()).andLike((StringExpression)OrgRepoProc.QDO.name, queryVO.getName()).andEq(queryVO.getExecutive() != null, (SimpleExpression)OrgRepoProc.QDO.executive, (Object)queryVO.getExecutive()).andEq((SimpleExpression)OrgRepoProc.QDO.type, (Object)queryVO.getType()).andIn((SimpleExpression)OrgRepoProc.QDO.type, queryVO.getTypes()).andEq(queryVO.getEntity() != null, (SimpleExpression)OrgRepoProc.QDO.entity, (Object)queryVO.getEntity()).andEq(queryVO.getEnabled() != null, (SimpleExpression)OrgRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    public PagingVO<SysOrgDO> pageQuery(CommonOrgPageQueryVO queryVO) {
        Supplier<Predicate> predicateChildren = null;
        if (queryVO.getExcludeBelongId() != null) {
            String parentCode = (String)super.getValueByValue((Path)OrgRepoProc.QDO.parentCode, (Path)OrgRepoProc.QDO.id, (Object)queryVO.getExcludeBelongId());
            predicateChildren = StringUtils.hasText((String)parentCode) ? () -> super.predicateForChildren(queryVO.getExcludeBelongId()).not() : () -> OrgRepoProc.QDO.id.ne((Object)queryVO.getExcludeBelongId());
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)OrgRepoProc.QDO.ouId, (Object)queryVO.getOuId()).andLike((StringExpression)OrgRepoProc.QDO.code, queryVO.getCode()).andLike((StringExpression)OrgRepoProc.QDO.name, queryVO.getName()).andLike(new StringExpression[]{OrgRepoProc.QDO.code, OrgRepoProc.QDO.name, OrgRepoProc.QDO.shortName}, queryVO.getKeyword()).andEq((SimpleExpression)OrgRepoProc.QDO.executive, (Object)queryVO.getExecutive()).andEq((SimpleExpression)OrgRepoProc.QDO.type, (Object)queryVO.getType()).andIn((SimpleExpression)OrgRepoProc.QDO.type, queryVO.getTypes()).and(predicateChildren != null, predicateChildren).andEq((SimpleExpression)OrgRepoProc.QDO.parentCode, (Object)queryVO.getParentCode()).andEq((SimpleExpression)OrgRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).andLike((StringExpression)OrgRepoProc.QDO.outerCode, queryVO.getOuterCode()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest());
    }

    public PagingVO<SysOrgDO> pageQuery(SysOrgPageQueryDTO queryDTO) {
        Long orgIdBelong = queryDTO.getOrgIdBelong();
        if (orgIdBelong == null && StringUtils.hasText((String)queryDTO.getOrgCodeBelong())) {
            orgIdBelong = this.getIdByCode(queryDTO.getOrgCodeBelong());
        }
        Long finalOrgIdBelong = orgIdBelong;
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andIn((SimpleExpression)OrgRepoProc.QDO.id, (Collection)queryDTO.getIds()).andIn((SimpleExpression)OrgRepoProc.QDO.code, (Collection)queryDTO.getCodes()).andIn((SimpleExpression)OrgRepoProc.QDO.outerCode, (Collection)queryDTO.getOuterCodes()).andEq((SimpleExpression)OrgRepoProc.QDO.pId, (Object)queryDTO.getParentId()).andEq((SimpleExpression)OrgRepoProc.QDO.parentCode, (Object)queryDTO.getParentCode()).andEq((SimpleExpression)OrgRepoProc.QDO.executive, (Object)queryDTO.getExecutive()).andEq((SimpleExpression)OrgRepoProc.QDO.type, (Object)queryDTO.getType()).andEq((SimpleExpression)OrgRepoProc.QDO.entity, (Object)queryDTO.getEntity()).andEq((SimpleExpression)OrgRepoProc.QDO.enabled, (Object)queryDTO.getEnabled()).andEq((SimpleExpression)OrgRepoProc.QDO.ouId, (Object)queryDTO.getOuId()).and(orgIdBelong != null, () -> super.predicateForChildren(finalOrgIdBelong).and((Predicate)OrgRepoProc.QDO.executive.eq(Boolean.valueOf(true)))).andLike((StringExpression)OrgRepoProc.QDO.name, queryDTO.getName()).andLike((StringExpression)OrgRepoProc.QDO.code, queryDTO.getCode()).andLike((StringExpression)OrgRepoProc.QDO.outerCode, queryDTO.getOuterCode()).andLike((StringExpression)OrgRepoProc.QDO.shortName, queryDTO.getShortName()).andLike(new StringExpression[]{OrgRepoProc.QDO.code, OrgRepoProc.QDO.name, OrgRepoProc.QDO.shortName}, queryDTO.getKeyword()).and(queryDTO.getOwnOuterCode() != null, () -> Boolean.TRUE.equals(queryDTO.getOwnOuterCode()) ? OrgRepoProc.QDO.outerCode.isNotNull().and((Predicate)OrgRepoProc.QDO.outerCode.ne((Object)"")) : OrgRepoProc.QDO.outerCode.isNull().or((Predicate)OrgRepoProc.QDO.outerCode.eq((Object)""))).build();
        return super.queryByPage(predicate, queryDTO.getPageRequest());
    }

    public Long getRootOrgId() {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO.id).from((EntityPath)QDO)).where((Predicate)OrgRepoProc.QDO.parentCode.isNull().or((Predicate)OrgRepoProc.QDO.parentCode.eq((Object)"")).and((Predicate)OrgRepoProc.QDO.executive.eq(Boolean.valueOf(true))))).limit(1L)).fetchOne();
    }

    public List<IdCodeNameParam> queryCodeName(Long rootId, Boolean executive) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)OrgRepoProc.QDO.executive, (Object)executive).andEq((SimpleExpression)OrgRepoProc.QDO.rootId, (Object)rootId).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanIdCodeName()).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public Map<Long, IdCodeNameParam> queryParentNameForType(@NotEmpty Collection<Long> ids, @NotBlank String type, boolean onlyEnabled) {
        QSysOrgDO qdoParent = new QSysOrgDO("child");
        Map withParentIdMap = super.filterParentId((EntityPathBase)qdoParent, (Predicate)qdoParent.type.eq((Object)type).and(onlyEnabled ? qdoParent.enabled.eq(Boolean.valueOf(true)) : null), (Predicate)OrgRepoProc.QDO.id.in(ids).and((Predicate)OrgRepoProc.QDO.executive.eq(Boolean.valueOf(true))));
        Set<Long> parentIds = withParentIdMap.values().stream().filter(t -> t != -1L).collect(Collectors.toSet());
        if (parentIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<Long, IdCodeNameParam> withParentMap = this.queryIdCodeName(parentIds).stream().collect(Collectors.toMap(IdCodeNameParam::getId, t -> t, (t1, t2) -> t1));
        HashMap<Long, IdCodeNameParam> idWithParentMap = new HashMap<Long, IdCodeNameParam>(withParentIdMap.size());
        for (Map.Entry entry : withParentIdMap.entrySet()) {
            IdCodeNameParam withParent = withParentMap.get(entry.getValue());
            if (withParent == null) continue;
            idWithParentMap.put((Long)entry.getKey(), withParent);
        }
        return idWithParentMap;
    }

    public List<SysOrgDO> listChildrens(long id) {
        return super.getList((Predicate)this.predicateForChildren(id), new OrderSpecifier[0]);
    }

    public List<IdCodeNameParam> listChildrenNames(long id) {
        QBean qbean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{OrgRepoProc.QDO.id, OrgRepoProc.QDO.code, OrgRepoProc.QDO.name});
        return super.getList(qbean, (Predicate)this.predicateOfOrgChildren(id), new OrderSpecifier[0]);
    }

    public Set<Long> queryEmployeeByOrg(@NotEmpty Collection<String> orgCodes, boolean withChildrenOrg, boolean selectUser) {
        if (!withChildrenOrg) {
            JPAQuery jpaQuery = selectUser ? (JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO_EMP_ORG.userId).from((EntityPath)QDO_EMP_ORG) : (JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO_EMP_ORG.employeeId).from((EntityPath)QDO_EMP_ORG);
            jpaQuery.where((Predicate)OrgRepoProc.QDO_EMP_ORG.orgId.in((SubQueryExpression)JPAExpressions.select((Expression)OrgRepoProc.QDO.id).from(new EntityPath[]{QDO}).where(new Predicate[]{OrgRepoProc.QDO.code.in(orgCodes)})));
            return new HashSet<Long>(jpaQuery.fetch());
        }
        List orgIds = super.getIds((Predicate)OrgRepoProc.QDO.code.in(orgCodes), new OrderSpecifier[0]);
        if (orgIds.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Long> userIds = new HashSet<Long>(512);
        for (Long orgId : orgIds) {
            JPAQuery jpaQuery = selectUser ? (JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO_EMP_ORG.userId).from((EntityPath)QDO_EMP_ORG) : (JPAQuery)this.jpaQueryFactory.select((Expression)OrgRepoProc.QDO_EMP_ORG.employeeId).from((EntityPath)QDO_EMP_ORG);
            jpaQuery.where((Predicate)OrgRepoProc.QDO_EMP_ORG.orgId.in((SubQueryExpression)JPAExpressions.select((Expression)OrgRepoProc.QDO.id).from(new EntityPath[]{QDO}).where(new Predicate[]{this.predicateOfOrgChildren(orgId)})));
            userIds.addAll(jpaQuery.fetch());
        }
        return userIds;
    }

    protected BooleanExpression predicateOfOrgChildren(Long id) {
        return super.predicateForChildren(id);
    }

    protected String prettyName(String name, String shortName) {
        return CharSequenceUtil.blankToDefault((CharSequence)shortName, (String)name);
    }

    protected QBean<IdCodeNameParam> qBeanIdCodeName() {
        return Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{OrgRepoProc.QDO.id, OrgRepoProc.QDO.code, OrgRepoProc.QDO.name});
    }

    protected QBean<SysOrgBasicDTO> qBeanSysOrgBasicDto() {
        return Projections.bean(SysOrgBasicDTO.class, (Expression[])new Expression[]{OrgRepoProc.QDO.id, OrgRepoProc.QDO.code, OrgRepoProc.QDO.outerCode, OrgRepoProc.QDO.name, OrgRepoProc.QDO.pId.as("parentId"), OrgRepoProc.QDO.parentCode, OrgRepoProc.QDO.shortName, OrgRepoProc.QDO.type, OrgRepoProc.QDO.enabled, OrgRepoProc.QDO.ouId, OrgRepoProc.QDO.remark});
    }
}

