/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.constant.DataPermissionType;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.model.bo.RolePermissionRuleBO;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleDataPermissionDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleDataPermissionDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;

@Repository
public class RoleDataPermissionRepoProc
extends BaseRepoProc<SysRoleDataPermissionDO> {
    private static final QSysRoleDataPermissionDO QDO = QSysRoleDataPermissionDO.sysRoleDataPermissionDO;
    private static final QSysRoleDO QDO_ROLE = QSysRoleDO.sysRoleDO;

    public RoleDataPermissionRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByRole(@NotBlank String roleCode) {
        super.deleteByValue((Path)RoleDataPermissionRepoProc.QDO.roleCode, (Object)roleCode);
    }

    public void deleteByRoleForMenuOperation(@NotBlank String roleCode, @NotBlank String menuCode, @NotBlank String operationCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.menuCode.eq((Object)menuCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.operationCode.eq((Object)operationCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.MENU_OPERATION_RULE.name()));
        super.delete((Predicate)predicate);
    }

    public void deleteByRoleForBusinessOperation(@NotBlank String roleCode, @NotBlank String operationCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.operationCode.eq((Object)operationCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_OPERATION_RULE.name()));
        super.delete((Predicate)predicate);
    }

    public void deleteByRoleForBusinessObject(@NotBlank String roleCode, @NotBlank String appCode, @NotBlank String businessObjectCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.eq((Object)businessObjectCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.appCode.eq((Object)appCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_OBJECT_RULE.name()));
        super.delete((Predicate)predicate);
    }

    public void deleteByRoleForRefResourceBusinessObject(@NotBlank String roleCode, @NotBlank String appCode, @NotBlank String businessObjectCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.eq((Object)businessObjectCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.appCode.eq((Object)appCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_RESOURCE_RULE.name()));
        super.delete((Predicate)predicate);
    }

    public List<SysRoleDataPermissionDO> listByRoleForMenuOperation(@NotBlank String roleCode, @NotBlank String menuCode, @NotBlank String operationCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.menuCode.eq((Object)menuCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.operationCode.eq((Object)operationCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.MENU_OPERATION_RULE.name()));
        return super.getList((Predicate)predicate, new OrderSpecifier[]{RoleDataPermissionRepoProc.QDO.ruleOrder.asc()});
    }

    public List<SysRoleDataPermissionDO> listByRoleForBusinessOperation(@NotBlank String roleCode, @NotBlank String operationCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.operationCode.eq((Object)operationCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_OPERATION_RULE.name()));
        return super.getList((Predicate)predicate, new OrderSpecifier[]{RoleDataPermissionRepoProc.QDO.ruleOrder.asc()});
    }

    public List<SysRoleDataPermissionDO> listByRoleAndBusinessObjectForBusinessOperation(@NotBlank String roleCode, @NotEmpty Collection<String> businessObjectCodes) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.in(businessObjectCodes)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_OPERATION_RULE.name()));
        return super.getList((Predicate)predicate, new OrderSpecifier[0]);
    }

    public List<SysRoleDataPermissionDO> listByRoleAndBusinessObjectForMenuBusinessOperation(@NotBlank String roleCode, @NotEmpty Collection<String> businessObjectCodes) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.in(businessObjectCodes)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.MENU_OPERATION_RULE.name()));
        return super.getList((Predicate)predicate, new OrderSpecifier[0]);
    }

    public List<SysRoleDataPermissionDO> listByRoleForBusinessObject(@NotBlank String roleCode, @NotBlank String businessObjectCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.eq((Object)businessObjectCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_OBJECT_RULE.name()));
        return super.getList((Predicate)predicate, new OrderSpecifier[]{RoleDataPermissionRepoProc.QDO.ruleOrder.asc()});
    }

    public List<SysRoleDataPermissionDO> listByRoleForBusinessObjectResource(@NotBlank String roleCode, @NotBlank String businessObjectCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.eq((Object)businessObjectCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_RESOURCE_RULE.name()));
        return super.getList((Predicate)predicate, new OrderSpecifier[]{RoleDataPermissionRepoProc.QDO.ruleOrder.asc()});
    }

    public List<String> listFieldByRoleForBusinessObjectResource(@NotBlank String roleCode, @NotBlank String businessObjectCode) {
        BooleanExpression predicate = RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.eq((Object)businessObjectCode)).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_RESOURCE_RULE.name())).and((Predicate)RoleDataPermissionRepoProc.QDO.ruleField.isNotNull());
        return super.getValueList((Path)RoleDataPermissionRepoProc.QDO.ruleField, (Predicate)predicate, new OrderSpecifier[]{RoleDataPermissionRepoProc.QDO.ruleOrder.asc()});
    }

    public List<SysRoleDataPermissionDO> listByRole(@NotBlank String roleCode) {
        return super.getListByValue((Path)RoleDataPermissionRepoProc.QDO.roleCode, (Object)roleCode, new OrderSpecifier[0]);
    }

    public List<RolePermissionRuleBO> listRolePermissionRuleByRole(@NotBlank String roleCode, DataPermissionType permissionType) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)RoleDataPermissionRepoProc.QDO.roleCode, (Object)roleCode).andEq((SimpleExpression)RoleDataPermissionRepoProc.QDO.permissionType, (Object)(permissionType == null ? null : permissionType.name())).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanRolePermissionRule()).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public List<RolePermissionRuleBO> listRolePermissionRuleByRole(long roleId) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanRolePermissionRule()).from((EntityPath)QDO)).where((Predicate)RoleDataPermissionRepoProc.QDO.roleCode.eq((Expression)JPAExpressions.select((Expression)RoleDataPermissionRepoProc.QDO_ROLE.code).from(new EntityPath[]{QDO_ROLE}).where(new Predicate[]{RoleDataPermissionRepoProc.QDO_ROLE.id.eq((Object)roleId)})))).fetch();
    }

    public List<SysDprRoleApiDataRuleListQueryDTO> queryDataPermissionByRoles(@NotEmpty Collection<String> roleCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanDataPermission()).from((EntityPath)QDO)).where((Predicate)RoleDataPermissionRepoProc.QDO.roleCode.in(roleCodes))).fetch();
    }

    public List<SysDprRoleApiDataRuleListQueryDTO> queryForRefBusinessObjectResourceByRole(@NotBlank String roleCode, @NotBlank String businessObjectCode) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanDataPermission()).from((EntityPath)QDO)).where((Predicate)RoleDataPermissionRepoProc.QDO.roleCode.eq((Object)roleCode).and((Predicate)RoleDataPermissionRepoProc.QDO.permissionType.eq((Object)DataPermissionType.BUSINESS_RESOURCE_RULE.name())).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.eq((Object)businessObjectCode)))).fetch();
    }

    public Map<String, String> queryBusinessObjectRef(@NotBlank String roleCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)RoleDataPermissionRepoProc.QDO.roleCode, (Object)roleCode).andIn((SimpleExpression)RoleDataPermissionRepoProc.QDO.permissionType, Set.of(DataPermissionType.BUSINESS_RESOURCE_RULE.name(), DataPermissionType.BUSINESS_OBJECT_RULE.name())).and((Predicate)RoleDataPermissionRepoProc.QDO.businessObjectCode.isNotEmpty().and((Predicate)RoleDataPermissionRepoProc.QDO.refBusinessObject.isNotNull())).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{RoleDataPermissionRepoProc.QDO.businessObjectCode, RoleDataPermissionRepoProc.QDO.refBusinessObject}).from((EntityPath)QDO)).where(predicate)).fetch().stream().filter(t -> StrUtil.isAllNotBlank((CharSequence[])new CharSequence[]{(CharSequence)t.get((Expression)RoleDataPermissionRepoProc.QDO.businessObjectCode), (CharSequence)t.get((Expression)RoleDataPermissionRepoProc.QDO.refBusinessObject)})).collect(Collectors.toMap(t -> (String)t.get((Expression)RoleDataPermissionRepoProc.QDO.refBusinessObject), t -> (String)t.get((Expression)RoleDataPermissionRepoProc.QDO.businessObjectCode), (t1, t2) -> t1));
    }

    private QBean<SysDprRoleApiDataRuleListQueryDTO> qBeanDataPermission() {
        return Projections.bean(SysDprRoleApiDataRuleListQueryDTO.class, (Expression[])new Expression[]{RoleDataPermissionRepoProc.QDO.ruleGroup, RoleDataPermissionRepoProc.QDO.roleCode, RoleDataPermissionRepoProc.QDO.permissionType, RoleDataPermissionRepoProc.QDO.ruleGroupCode, RoleDataPermissionRepoProc.QDO.appCode, RoleDataPermissionRepoProc.QDO.menuCode.as("menusCode"), RoleDataPermissionRepoProc.QDO.businessObjectCode, RoleDataPermissionRepoProc.QDO.operationCode.as("apiPermissionCode"), RoleDataPermissionRepoProc.QDO.id.as("dprRuleId"), RoleDataPermissionRepoProc.QDO.ruleOrder.as("order"), RoleDataPermissionRepoProc.QDO.dataSet, RoleDataPermissionRepoProc.QDO.ruleRelation.as("dprRuleRelation"), RoleDataPermissionRepoProc.QDO.ruleName.as("dprRuleName"), RoleDataPermissionRepoProc.QDO.ruleField.as("dprRuleField"), RoleDataPermissionRepoProc.QDO.refResource, RoleDataPermissionRepoProc.QDO.refBusinessObject, RoleDataPermissionRepoProc.QDO.refField, RoleDataPermissionRepoProc.QDO.ruleFieldType.as("dprRuleFieldType"), RoleDataPermissionRepoProc.QDO.fieldValueCondition.as("dprRuleCondition"), RoleDataPermissionRepoProc.QDO.ruleValueType.as("dprRuleValueType"), RoleDataPermissionRepoProc.QDO.ruleValue.as("dprRuleValue"), RoleDataPermissionRepoProc.QDO.bs1, RoleDataPermissionRepoProc.QDO.bs2, RoleDataPermissionRepoProc.QDO.bs3});
    }

    private QBean<RolePermissionRuleBO> qBeanRolePermissionRule() {
        return Projections.bean(RolePermissionRuleBO.class, (Expression[])new Expression[]{RoleDataPermissionRepoProc.QDO.id, RoleDataPermissionRepoProc.QDO.roleCode, RoleDataPermissionRepoProc.QDO.permissionType, RoleDataPermissionRepoProc.QDO.appCode, RoleDataPermissionRepoProc.QDO.menuCode, RoleDataPermissionRepoProc.QDO.businessObjectCode, RoleDataPermissionRepoProc.QDO.operationCode});
    }
}

