/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.role.RoleGroupPageQueryVO;
import com.elitescloud.cloudt.system.service.common.constant.BelongType;
import com.elitescloud.cloudt.system.service.model.entity.QSysRoleGroupDO;
import com.elitescloud.cloudt.system.service.model.entity.SysRoleGroupDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.springframework.stereotype.Repository;

@Repository
public class RoleGroupRepoProc
extends BaseRepoProc<SysRoleGroupDO> {
    private static final QSysRoleGroupDO QDO = QSysRoleGroupDO.sysRoleGroupDO;

    public RoleGroupRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateEnabled(long id, boolean enabled) {
        super.updateValue((Path)RoleGroupRepoProc.QDO.enabled, (Object)enabled, id);
    }

    public void updateName(long id, String name) {
        super.updateValue((Path)RoleGroupRepoProc.QDO.groupName, (Object)name, id);
    }

    public boolean existsCode(@NotBlank String groupCode, @NotNull BelongType.Belonger belong) {
        BooleanExpression predicate = RoleGroupRepoProc.QDO.groupCode.eq((Object)groupCode).and((Predicate)RoleGroupRepoProc.QDO.type.eq((Object)belong.getBelongType().getValue())).and((Predicate)RoleGroupRepoProc.QDO.typeId.eq((Object)belong.getBelongId()));
        return super.exists((Predicate)predicate);
    }

    public String getName(long id) {
        return (String)super.getValue((Path)RoleGroupRepoProc.QDO.groupName, id);
    }

    public String getCode(long id) {
        return (String)super.getValue((Path)RoleGroupRepoProc.QDO.groupCode, id);
    }

    public PagingVO<SysRoleGroupDO> pageMng(RoleGroupPageQueryVO queryVO, BelongType.Belonger belong) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andLike((StringExpression)RoleGroupRepoProc.QDO.groupCode, queryVO.getGroupCode()).andLike((StringExpression)RoleGroupRepoProc.QDO.groupName, queryVO.getGroupName()).andEq((SimpleExpression)RoleGroupRepoProc.QDO.enabled, (Object)queryVO.getEnabled()).andEq((SimpleExpression)RoleGroupRepoProc.QDO.type, (Object)belong.getBelongType().getValue()).andEq((SimpleExpression)RoleGroupRepoProc.QDO.typeId, (Object)belong.getBelongId()).andLike(new StringExpression[]{RoleGroupRepoProc.QDO.groupCode, RoleGroupRepoProc.QDO.groupName}, queryVO.getKeyword()).build();
        return super.queryByPage(predicate, queryVO.getPageRequest(), RoleGroupRepoProc.QDO.createTime.desc());
    }

    public List<IdCodeNameParam> listIdCodeName(BelongType.Belonger belonger, Boolean enabled) {
        BooleanExpression predicate;
        BooleanExpression booleanExpression = predicate = enabled == null ? null : RoleGroupRepoProc.QDO.enabled.eq(enabled);
        if (belonger != null) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)RoleGroupRepoProc.QDO.type.eq((Object)belonger.getBelongType().getValue()).and((Predicate)RoleGroupRepoProc.QDO.typeId.eq((Object)belonger.getBelongId())));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanIdCodeName()).from((EntityPath)QDO)).where((Predicate)predicate)).orderBy(RoleGroupRepoProc.QDO.createTime.desc())).fetch();
    }

    public List<IdCodeNameParam> listIdCodeName(Collection<Long> ids, BelongType.Belonger belonger, Boolean enabled) {
        BooleanExpression predicate;
        BooleanExpression booleanExpression = predicate = enabled == null ? null : RoleGroupRepoProc.QDO.enabled.eq(enabled);
        if (belonger != null) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)RoleGroupRepoProc.QDO.type.eq((Object)belonger.getBelongType().getValue()).and((Predicate)RoleGroupRepoProc.QDO.typeId.eq((Object)belonger.getBelongId())));
        }
        if (CollUtil.isNotEmpty(ids)) {
            predicate = super.andPredicate((Predicate)predicate, (Predicate)RoleGroupRepoProc.QDO.id.in(ids));
        }
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanIdCodeName()).from((EntityPath)QDO)).where((Predicate)predicate)).orderBy(RoleGroupRepoProc.QDO.createTime.desc())).fetch();
    }

    public List<IdCodeNameParam> queryByList(Collection<Long> ids) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.qBeanIdCodeName()).from((EntityPath)QDO)).where((Predicate)RoleGroupRepoProc.QDO.id.in(ids))).fetch();
    }

    private QBean<IdCodeNameParam> qBeanIdCodeName() {
        return Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{RoleGroupRepoProc.QDO.id, RoleGroupRepoProc.QDO.groupCode.as("code"), RoleGroupRepoProc.QDO.groupName.as("name")});
    }
}

