/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.boot.provider.TenantDataIsolateProvider;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.model.vo.query.extend.TmplImportQueryParam;
import com.elitescloud.cloudt.system.service.model.entity.QSysTmplDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTmplImportRecordDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTmplImportRecordDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.TemporalExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class SysTmplImportRecordRepoProc
extends BaseRepoProc<SysTmplImportRecordDO> {
    private static final QSysTmplImportRecordDO QDO = QSysTmplImportRecordDO.sysTmplImportRecordDO;
    private static final QSysTmplDO QDO_TMPL = QSysTmplDO.sysTmplDO;
    @Autowired
    private TenantDataIsolateProvider tenantDataIsolateProvider;

    public SysTmplImportRecordRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateNumTotal(long id, Long numTotal) {
        super.updateValue((Path)SysTmplImportRecordRepoProc.QDO.numTotal, (Object)numTotal, id);
    }

    public void updateImportResult(Long id, Boolean suc, String failReason, String customTipMsg, Long numSuc, String fileCode, String costTimeInfo) {
        JPAUpdateClause jpaUpdate = this.jpaQueryFactory.update((EntityPath)QDO).set((Path)SysTmplImportRecordRepoProc.QDO.finish, (Object)true).set((Path)SysTmplImportRecordRepoProc.QDO.succ, (Object)suc).set((Path)SysTmplImportRecordRepoProc.QDO.timeFinish, (Object)LocalDateTime.now()).set((Path)SysTmplImportRecordRepoProc.QDO.numSuc, (Object)numSuc).set((Path)SysTmplImportRecordRepoProc.QDO.failReason, (Object)failReason).set((Path)SysTmplImportRecordRepoProc.QDO.customTipMsg, (Object)customTipMsg).set((Path)SysTmplImportRecordRepoProc.QDO.costTimeInfo, (Object)costTimeInfo);
        if (StringUtils.hasText((String)fileCode)) {
            jpaUpdate.set((Path)SysTmplImportRecordRepoProc.QDO.fileCode, (Object)fileCode);
        }
        jpaUpdate.where(new Predicate[]{SysTmplImportRecordRepoProc.QDO.id.eq((Object)id).and((Predicate)SysTmplImportRecordRepoProc.QDO.finish.eq(Boolean.valueOf(false)))}).execute();
    }

    public void updateFailFileCode(long id, String failFileCode) {
        super.updateValue((Path)SysTmplImportRecordRepoProc.QDO.failFileCode, (Object)failFileCode, id);
    }

    public void updateResultForError(@NotEmpty Collection<Long> ids, String msg) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)SysTmplImportRecordRepoProc.QDO.succ, (Object)false).set((Path)SysTmplImportRecordRepoProc.QDO.finish, (Object)true).set((Path)SysTmplImportRecordRepoProc.QDO.timeFinish, (Object)LocalDateTime.now()).set((Path)SysTmplImportRecordRepoProc.QDO.failReason, (Object)msg).where(new Predicate[]{SysTmplImportRecordRepoProc.QDO.id.in(ids)}).execute();
    }

    public List<Long> getUnfinished(String appCode) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().and(StringUtils.hasText((String)appCode), () -> SysTmplImportRecordRepoProc.QDO.tmplId.in((SubQueryExpression)JPAExpressions.select((Expression)SysTmplImportRecordRepoProc.QDO_TMPL.id).from(new EntityPath[]{QDO_TMPL}).where(new Predicate[]{SysTmplImportRecordRepoProc.QDO_TMPL.appCode.eq((Object)appCode)}))).andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.finish, (Object)false).build();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysTmplImportRecordRepoProc.QDO.id).from((EntityPath)QDO)).where(predicate)).fetch();
    }

    public String getFileCode(long id) {
        return (String)super.getValue((Path)SysTmplImportRecordRepoProc.QDO.fileCode, id);
    }

    public Long getTmplId(long id) {
        return (Long)super.getValue((Path)SysTmplImportRecordRepoProc.QDO.tmplId, id);
    }

    public Long getNumTotal(long id) {
        return (Long)super.getValue((Path)SysTmplImportRecordRepoProc.QDO.numTotal, id);
    }

    public PagingVO<SysTmplImportRecordDO> pageMng(Long tmplId, TmplImportQueryParam queryParam) {
        List tmplIds = null;
        if (tmplId == null && StrUtil.isBlank((CharSequence)queryParam.getTmplCode()) && StrUtil.isNotBlank((CharSequence)queryParam.getAppCode()) && (tmplIds = (List)this.tenantDataIsolateProvider.byDefaultDirectly(() -> ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysTmplImportRecordRepoProc.QDO_TMPL.id).from((EntityPath)QDO_TMPL)).where((Predicate)SysTmplImportRecordRepoProc.QDO_TMPL.appCode.eq((Object)queryParam.getAppCode()))).fetch())).isEmpty()) {
            return PagingVO.empty();
        }
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.tmplId, (Object)tmplId).andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.userId, (Object)queryParam.getUserId()).andIn((SimpleExpression)SysTmplImportRecordRepoProc.QDO.tmplId, tmplIds).andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.tmplCode, (Object)queryParam.getTmplCode()).andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.export, (Object)queryParam.getExport()).andBetween((TemporalExpression)SysTmplImportRecordRepoProc.QDO.timeImport, (Comparable)queryParam.getStartTime(), (Comparable)queryParam.getEndTime()).andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.finish, (Object)queryParam.getFinish()).andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.succ, (Object)queryParam.getSucc()).build();
        PageRequest pageRequest = queryParam.getPageRequest();
        Sort sort = pageRequest.getSort();
        if (sort.isUnsorted()) {
            sort = Sort.by((Sort.Direction)Sort.Direction.DESC, (String[])new String[]{SysTmplImportRecordRepoProc.QDO.timeImport.getMetadata().getName()});
            pageRequest = PageRequest.of((int)pageRequest.getPageNumber(), (int)pageRequest.getPageSize(), (Sort)sort);
        }
        return super.queryByPage(predicate, pageRequest);
    }

    public List<SysTmplImportRecordDO> queryRecentlyList(Long tmplId, Integer hoursRecently, Long userId) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.tmplId, (Object)tmplId).andAfter(hoursRecently != null, (TemporalExpression)SysTmplImportRecordRepoProc.QDO.timeImport, (Comparable)LocalDateTime.now().minusHours(hoursRecently.intValue())).andEq((SimpleExpression)SysTmplImportRecordRepoProc.QDO.userId, (Object)userId).build();
        return ((JPAQuery)this.jpaQueryFactory.selectFrom((EntityPath)QDO).where(predicate)).fetch();
    }
}

