/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantAppDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantAppDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class TenantAppRepoProc
extends BaseRepoProc<SysTenantAppDO> {
    private static final QSysTenantAppDO QDO = QSysTenantAppDO.sysTenantAppDO;

    public TenantAppRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void deleteByTenantAndAppCode(Long sysTenantId, Set<String> appCodes) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{TenantAppRepoProc.QDO.sysTenantId.eq((Object)sysTenantId).and((Predicate)TenantAppRepoProc.QDO.appCode.in(appCodes))}).execute();
    }

    public Set<String> getAppCode(Long sysTenantId) {
        return new HashSet<String>(((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)TenantAppRepoProc.QDO.appCode).from((EntityPath)QDO)).where((Predicate)TenantAppRepoProc.QDO.sysTenantId.eq((Object)sysTenantId))).fetch());
    }

    public Map<Long, Set<String>> getAppCodes(Collection<Long> tenantIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{TenantAppRepoProc.QDO.sysTenantId, TenantAppRepoProc.QDO.appCode}).from((EntityPath)QDO)).where(CollectionUtils.isEmpty(tenantIds) ? null : TenantAppRepoProc.QDO.sysTenantId.in(tenantIds))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)TenantAppRepoProc.QDO.sysTenantId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (String)tt.get((Expression)TenantAppRepoProc.QDO.appCode)).collect(Collectors.toSet()))));
    }

    public Map<Long, Set<String>> getAppCodeAll() {
        return ((JPAQuery)this.jpaQueryFactory.select(new Expression[]{TenantAppRepoProc.QDO.sysTenantId, TenantAppRepoProc.QDO.appCode}).from((EntityPath)QDO)).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)TenantAppRepoProc.QDO.sysTenantId), Collectors.collectingAndThen(Collectors.toList(), t -> t.stream().map(tt -> (String)tt.get((Expression)TenantAppRepoProc.QDO.appCode)).collect(Collectors.toSet()))));
    }
}

