/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.model.bo.TenantMenuBO;
import com.elitescloud.cloudt.system.model.vo.resp.menu.CustomMenuNodeDetailRespVO;
import com.elitescloud.cloudt.system.service.common.constant.MenuTreeNodeType;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantMenuTreeDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantMenuTreeDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.JPQLQuery;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;

@Repository
public class TenantMenuTreeRepoProc
extends BaseRepoProc<SysTenantMenuTreeDO> {
    private static final QSysTenantMenuTreeDO QDO = QSysTenantMenuTreeDO.sysTenantMenuTreeDO;

    public TenantMenuTreeRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateEnabled(long id, Boolean enabled) {
        super.updateValue((Path)TenantMenuTreeRepoProc.QDO.enabled, (Object)enabled, id);
    }

    public void deleteAll() {
        this.jpaQueryFactory.delete((EntityPath)QDO).execute();
    }

    public void deleteByTenantId() {
        super.delete((Predicate)null);
    }

    public void deleteBoundMenuCodes(@NotBlank String parentMenuCode) {
        super.delete((Predicate)TenantMenuTreeRepoProc.QDO.parentMenuCode.eq((Object)parentMenuCode).and((Predicate)TenantMenuTreeRepoProc.QDO.nodeType.eq((Object)MenuTreeNodeType.MENU.getValue())));
    }

    public void updateMenuName(long id, String menuName) {
        super.updateValue((Path)TenantMenuTreeRepoProc.QDO.menuName, (Object)menuName, id);
    }

    public void updateParent(long id, String parentCode, Integer sortNo) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)TenantMenuTreeRepoProc.QDO.parentMenuCode, (Object)parentCode).set((Path)TenantMenuTreeRepoProc.QDO.sortNo, (Object)sortNo).where(new Predicate[]{TenantMenuTreeRepoProc.QDO.id.eq((Object)id)}).execute();
    }

    public boolean existsCustomMenuCode(@NotBlank String menuCode, Long id) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)TenantMenuTreeRepoProc.QDO.menuCode, (Object)menuCode).andEq((SimpleExpression)TenantMenuTreeRepoProc.QDO.custom, (Object)true).andNe((SimpleExpression)TenantMenuTreeRepoProc.QDO.id, (Object)id).build();
        return super.exists(predicate);
    }

    public List<String> existsChildren(@NotEmpty Collection<Long> ids) {
        QSysTenantMenuTreeDO CHILD = new QSysTenantMenuTreeDO("child");
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)TenantMenuTreeRepoProc.QDO.menuName).from((EntityPath)QDO)).where((Predicate)TenantMenuTreeRepoProc.QDO.id.in(ids).and((Predicate)((JPQLQuery)JPAExpressions.select((Expression)CHILD.id).from(new EntityPath[]{CHILD}).where(new Predicate[]{CHILD.parentMenuCode.eq((Expression)TenantMenuTreeRepoProc.QDO.menuCode)})).exists()))).fetch();
    }

    public List<Long> listChildrenIds(@NotEmpty Collection<Long> ids) {
        QSysTenantMenuTreeDO CHILD = new QSysTenantMenuTreeDO("child");
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)CHILD.id).from((EntityPath)CHILD)).where((Predicate)CHILD.parentMenuCode.in((SubQueryExpression)JPAExpressions.select((Expression)TenantMenuTreeRepoProc.QDO.menuCode).from(new EntityPath[]{QDO}).where(new Predicate[]{TenantMenuTreeRepoProc.QDO.id.in(ids)})))).fetch();
    }

    public List<CustomMenuNodeDetailRespVO> queryByParentMenuCode(@NotBlank String parentMenuCode) {
        QSysTenantMenuTreeDO CHILD = new QSysTenantMenuTreeDO("child");
        JPQLQuery countExp = (JPQLQuery)JPAExpressions.select((Expression)CHILD.count().as("childrenNum")).from(new EntityPath[]{CHILD}).where(new Predicate[]{CHILD.parentMenuCode.eq((Expression)TenantMenuTreeRepoProc.QDO.menuCode)});
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{TenantMenuTreeRepoProc.QDO.id, TenantMenuTreeRepoProc.QDO.nodeType, TenantMenuTreeRepoProc.QDO.parentMenuCode, TenantMenuTreeRepoProc.QDO.menuCode, TenantMenuTreeRepoProc.QDO.menuName, TenantMenuTreeRepoProc.QDO.enabled, TenantMenuTreeRepoProc.QDO.sortNo, TenantMenuTreeRepoProc.QDO.icon, countExp}).from((EntityPath)QDO)).where((Predicate)TenantMenuTreeRepoProc.QDO.parentMenuCode.eq((Object)parentMenuCode))).fetch().stream().map(t -> {
            CustomMenuNodeDetailRespVO respVO = new CustomMenuNodeDetailRespVO();
            respVO.setId((Long)t.get((Expression)TenantMenuTreeRepoProc.QDO.id));
            respVO.setNodeType((String)t.get((Expression)TenantMenuTreeRepoProc.QDO.nodeType));
            respVO.setParentMenuCode((String)t.get((Expression)TenantMenuTreeRepoProc.QDO.parentMenuCode));
            respVO.setMenuCode((String)t.get((Expression)TenantMenuTreeRepoProc.QDO.menuCode));
            respVO.setMenuName((String)t.get((Expression)TenantMenuTreeRepoProc.QDO.menuName));
            respVO.setEnabled((Boolean)t.get((Expression)TenantMenuTreeRepoProc.QDO.enabled));
            respVO.setSortNo((Integer)ObjectUtil.defaultIfNull((Object)((Integer)t.get((Expression)TenantMenuTreeRepoProc.QDO.sortNo)), (Object)0));
            respVO.setIcon((String)t.get((Expression)TenantMenuTreeRepoProc.QDO.icon));
            respVO.setChildrenNum((Long)t.get((Expression)countExp));
            return respVO;
        }).sorted(Comparator.comparingInt(CustomMenuNodeDetailRespVO::getSortNo)).collect(Collectors.toList());
    }

    public List<IdCodeNameParam> listGroup() {
        QBean qBean = Projections.bean(IdCodeNameParam.class, (Expression[])new Expression[]{TenantMenuTreeRepoProc.QDO.id, TenantMenuTreeRepoProc.QDO.menuCode.as("code"), TenantMenuTreeRepoProc.QDO.menuName.as("name")});
        return super.getList(qBean, (Predicate)TenantMenuTreeRepoProc.QDO.nodeType.eq((Object)MenuTreeNodeType.MENU_GROUP.getValue()).and((Predicate)TenantMenuTreeRepoProc.QDO.parentMenuCode.isNull().or((Predicate)TenantMenuTreeRepoProc.QDO.parentMenuCode.isEmpty())), new OrderSpecifier[]{TenantMenuTreeRepoProc.QDO.sortNo.asc()});
    }

    public List<CodeNameParam> getBoundMenu(@NotBlank String parentMenuCode) {
        QBean qBean = Projections.bean(CodeNameParam.class, (Expression[])new Expression[]{TenantMenuTreeRepoProc.QDO.menuCode.as("code"), TenantMenuTreeRepoProc.QDO.menuName.as("name")});
        return super.getList(qBean, (Predicate)TenantMenuTreeRepoProc.QDO.parentMenuCode.eq((Object)parentMenuCode).and((Predicate)TenantMenuTreeRepoProc.QDO.nodeType.eq((Object)MenuTreeNodeType.MENU.getValue())), new OrderSpecifier[0]);
    }

    public List<String> getBoundMenuCodes(@NotBlank String parentMenuCode) {
        return super.getValueList((Path)TenantMenuTreeRepoProc.QDO.menuCode, (Predicate)TenantMenuTreeRepoProc.QDO.parentMenuCode.eq((Object)parentMenuCode).and((Predicate)TenantMenuTreeRepoProc.QDO.nodeType.eq((Object)MenuTreeNodeType.MENU.getValue())), new OrderSpecifier[0]);
    }

    public List<String> queryMenuCodeByMenuNameLike(@NotBlank String menuNameLike) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)TenantMenuTreeRepoProc.QDO.menuCode).from((EntityPath)QDO)).where((Predicate)TenantMenuTreeRepoProc.QDO.menuName.like("%" + menuNameLike + "%"))).fetch();
    }

    public Map<String, String> getMenuNameByMenuCode(@NotEmpty Collection<String> menuCodes) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{TenantMenuTreeRepoProc.QDO.menuName, TenantMenuTreeRepoProc.QDO.menuCode}).from((EntityPath)QDO)).where((Predicate)TenantMenuTreeRepoProc.QDO.menuCode.in(menuCodes))).fetch().stream().collect(Collectors.toMap(t -> (String)t.get((Expression)TenantMenuTreeRepoProc.QDO.menuCode), t -> (String)t.get((Expression)TenantMenuTreeRepoProc.QDO.menuName), (t1, t2) -> t1));
    }

    public String getMenuNameByMenuCode(@NotBlank String menuCode) {
        return (String)super.getValueByValue((Path)TenantMenuTreeRepoProc.QDO.menuName, (Path)TenantMenuTreeRepoProc.QDO.menuCode, (Object)menuCode);
    }

    public String getNodeType(long id) {
        return (String)super.getValue((Path)TenantMenuTreeRepoProc.QDO.nodeType, id);
    }

    public String getMenuCode(long id) {
        return (String)super.getValue((Path)TenantMenuTreeRepoProc.QDO.menuCode, id);
    }

    public List<SysTenantMenuTreeDO> queryByTenantId() {
        return ((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).fetch();
    }

    public SysTenantMenuTreeDO getByMenuCode(@NotBlank String menuCode) {
        return (SysTenantMenuTreeDO)super.getOneByValue((Path)TenantMenuTreeRepoProc.QDO.menuCode, (Object)menuCode);
    }

    public List<TenantMenuBO> queryMenuBos() {
        QBean<TenantMenuBO> qBean = this.qBeanTenantMenu();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().build();
        return super.getList(qBean, predicate, new OrderSpecifier[0]).stream().filter(t -> t.getNodeType().equals(MenuTreeNodeType.MENU_GROUP.getValue()) || t.getNodeType().equals(MenuTreeNodeType.MENU.getValue())).collect(Collectors.toList());
    }

    public List<String> allMenuCodes() {
        return super.getValueList((Path)TenantMenuTreeRepoProc.QDO.menuCode, new OrderSpecifier[0]);
    }

    private QBean<TenantMenuBO> qBeanTenantMenu() {
        return Projections.bean(TenantMenuBO.class, (Expression[])new Expression[]{TenantMenuTreeRepoProc.QDO.id, TenantMenuTreeRepoProc.QDO.menuCode, TenantMenuTreeRepoProc.QDO.menuName, TenantMenuTreeRepoProc.QDO.nodeType, TenantMenuTreeRepoProc.QDO.sortNo, TenantMenuTreeRepoProc.QDO.enabled, TenantMenuTreeRepoProc.QDO.parentMenuCode, TenantMenuTreeRepoProc.QDO.icon});
    }
}

