/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.common.param.IdCodeNameParam;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysTenantUserDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserDO;
import com.elitescloud.cloudt.system.service.model.entity.SysTenantUserDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.JPAExpressions;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import org.springframework.stereotype.Repository;

@Repository
public class TenantUserRepoProc
extends BaseRepoProc<SysTenantUserDO> {
    private static final QSysTenantUserDO QDO = QSysTenantUserDO.sysTenantUserDO;
    private static final QSysTenantDO QDO_TENANT = QSysTenantDO.sysTenantDO;
    private static final QSysUserDO QDO_USER = QSysUserDO.sysUserDO;

    public TenantUserRepoProc() {
        super((EntityPathBase)QDO);
    }

    public void updateEnabled(long tenantId, long userId, Boolean enabled) {
        this.jpaQueryFactory.update((EntityPath)QDO).set((Path)TenantUserRepoProc.QDO.enabled, (Object)enabled).where(new Predicate[]{TenantUserRepoProc.QDO.sysUserId.eq((Object)userId).and((Predicate)TenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId))});
    }

    public void updateLoginTime(long id, long tenantId, LocalDateTime loginTime) {
        super.updateValue((Path)TenantUserRepoProc.QDO.lastLoginTime, (Object)loginTime, (Predicate)TenantUserRepoProc.QDO.sysUserId.eq((Object)id).and((Predicate)TenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId)));
    }

    public void delete(long tenantId, long userId) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{TenantUserRepoProc.QDO.sysUserId.eq((Object)userId).and((Predicate)TenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId))}).execute();
    }

    public void deleteByUserId(long userId) {
        this.jpaQueryFactory.delete((EntityPath)QDO).where(new Predicate[]{TenantUserRepoProc.QDO.sysUserId.eq((Object)userId)}).execute();
    }

    public Boolean getEnabled(long tenantId, long userId) {
        return (Boolean)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)TenantUserRepoProc.QDO.enabled).from((EntityPath)QDO)).where((Predicate)TenantUserRepoProc.QDO.sysUserId.eq((Object)userId).and((Predicate)TenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId)))).limit(1L)).fetchOne();
    }

    public Map<Long, Boolean> getEnabled(long tenantId, @NotEmpty Collection<Long> userIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{TenantUserRepoProc.QDO.sysUserId, TenantUserRepoProc.QDO.enabled}).from((EntityPath)QDO)).where((Predicate)TenantUserRepoProc.QDO.sysUserId.in(userIds).and((Predicate)TenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId)))).fetch().stream().collect(Collectors.toMap(t -> (Long)t.get((Expression)TenantUserRepoProc.QDO.sysUserId), t -> (Boolean)ObjectUtil.defaultIfNull((Object)((Boolean)t.get((Expression)TenantUserRepoProc.QDO.enabled)), (Object)false), (t1, t2) -> t1));
    }

    public long countByUserId(long userId) {
        return super.count((Path)TenantUserRepoProc.QDO.sysUserId, (Object)userId);
    }

    public List<Long> listTenantIdByUserID(long sysUserId, Boolean enabled) {
        BooleanExpression predicate = TenantUserRepoProc.QDO.sysUserId.eq((Object)sysUserId);
        if (enabled != null) {
            predicate = predicate.and((Predicate)TenantUserRepoProc.QDO.enabled.eq(enabled));
        }
        return super.getValueList((Path)TenantUserRepoProc.QDO.sysTenantId, (Predicate)predicate, new OrderSpecifier[0]);
    }

    public List<SysTenantUserDO> listByUserIds(long tenantId, @NotEmpty Collection<Long> userIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)QDO).from((EntityPath)QDO)).where((Predicate)TenantUserRepoProc.QDO.sysUserId.in(userIds).and((Predicate)TenantUserRepoProc.QDO.sysTenantId.eq((Object)tenantId)))).fetch();
    }

    public Map<Long, List<IdCodeNameParam>> getTenantsOfUser(@NotEmpty Collection<Long> userIds) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{TenantUserRepoProc.QDO.sysUserId, TenantUserRepoProc.QDO_TENANT.id, TenantUserRepoProc.QDO_TENANT.tenantName, TenantUserRepoProc.QDO_TENANT.tenantCode}).from((EntityPath)QDO)).leftJoin((EntityPath)QDO_TENANT)).on((Predicate)TenantUserRepoProc.QDO_TENANT.id.eq((Expression)TenantUserRepoProc.QDO.sysTenantId))).where((Predicate)TenantUserRepoProc.QDO.sysUserId.in(userIds).and((Predicate)TenantUserRepoProc.QDO_TENANT.id.isNotNull()))).fetch().stream().collect(Collectors.groupingBy(t -> (Long)t.get((Expression)TenantUserRepoProc.QDO.sysUserId), Collectors.mapping(t -> new IdCodeNameParam((Long)t.get((Expression)TenantUserRepoProc.QDO_TENANT.id), (String)t.get((Expression)TenantUserRepoProc.QDO_TENANT.tenantCode), (String)t.get((Expression)TenantUserRepoProc.QDO_TENANT.tenantName)), Collectors.toList())));
    }

    public List<Long> queryUserIdByLastname(long tenantId, String lastname, Boolean enabled) {
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)TenantUserRepoProc.QDO.sysTenantId, (Object)tenantId).andIn(StrUtil.isNotBlank((CharSequence)lastname), (SimpleExpression)TenantUserRepoProc.QDO.sysUserId, () -> {
            BooleanExpression predicateEnabled = null;
            if (enabled != null) {
                predicateEnabled = TenantUserRepoProc.QDO_USER.enabled.eq(enabled);
            }
            return (SubQueryExpression)JPAExpressions.select((Expression)TenantUserRepoProc.QDO_USER.id).from(new EntityPath[]{QDO_USER}).where(new Predicate[]{TenantUserRepoProc.QDO_USER.lastName.like("%" + lastname + "%").and((Predicate)predicateEnabled)});
        }).andEq((SimpleExpression)TenantUserRepoProc.QDO.enabled, (Object)enabled).build();
        return super.getValueList((Path)TenantUserRepoProc.QDO.sysUserId, predicate, new OrderSpecifier[0]);
    }
}

