/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.service.repo.old;

import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.constant.AccountType;
import com.elitescloud.cloudt.context.spi.ServiceProviderLoader;
import com.elitescloud.cloudt.system.component.param.SysUserComponentPagingParam;
import com.elitescloud.cloudt.system.config.SystemProperties;
import com.elitescloud.cloudt.system.param.SysUserBatchSwitchParam;
import com.elitescloud.cloudt.system.param.SysUserQueryParam;
import com.elitescloud.cloudt.system.provider.dto.SysUserRpcDTO;
import com.elitescloud.cloudt.system.provider.param.SysUserRpcDtoParam;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserDO;
import com.elitescloud.cloudt.system.service.model.entity.QSysUserRoleDO;
import com.elitescloud.cloudt.system.service.model.entity.SysUserDO;
import com.elitescloud.cloudt.system.service.vo.component.SysUserComponentPagingVO;
import com.elitescloud.cloudt.system.spi.SysUserQuerySpi;
import com.elitescloud.cloudt.system.vo.SysUserDetailsVO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Repository;

@Repository
public class SysUserRepoProc
extends BaseRepoProc<SysUserDO> {
    private static final Logger log = LogManager.getLogger(SysUserRepoProc.class);
    private static final QSysUserDO SYS_USER = QSysUserDO.sysUserDO;
    private final QSysUserRoleDO sysUserRoleDO = QSysUserRoleDO.sysUserRoleDO;
    @Autowired
    private SystemProperties systemProperties;
    private final AtomicBoolean spiLoaded = new AtomicBoolean(false);
    private SysUserQuerySpi userQuerySpi;

    public SysUserRepoProc() {
        super((EntityPathBase)SYS_USER);
    }

    public PagingVO<SysUserDO> selectSysUser(SysUserQueryParam param) {
        SysUserQuerySpi spi = this.getUserQuerySpi();
        JPAQuery query = null;
        if (spi != null) {
            query = spi.selectSysUserForJpaQuery();
        }
        if (query == null) {
            query = (JPAQuery)this.jpaQueryFactory.select((Expression)SYS_USER).from((EntityPath)SYS_USER);
        }
        Predicate predicate = this.where(param);
        if (spi != null) {
            predicate = this.andPredicate(predicate, spi.selectSysUserForPredicate());
        }
        query.where(predicate);
        param.fillOrders(query, (EntityPathBase)SYS_USER);
        param.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public PagingVO<SysUserComponentPagingVO> findSysUserComPagingByParam(SysUserComponentPagingParam param) {
        Predicate predicate;
        String likeStr;
        SysUserQuerySpi spi = this.getUserQuerySpi();
        JPAQuery query = null;
        if (spi != null) {
            query = spi.findSysUserComPagingByParamForJpaQuery();
        }
        if (query == null) {
            query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserComponentPagingVO.class, (Expression[])new Expression[]{SysUserRepoProc.SYS_USER.id, SysUserRepoProc.SYS_USER.username, SysUserRepoProc.SYS_USER.lastName, SysUserRepoProc.SYS_USER.firstName, SysUserRepoProc.SYS_USER.mobile, SysUserRepoProc.SYS_USER.email})).from((EntityPath)SYS_USER);
        }
        ArrayList<Object> predicates = new ArrayList<Object>();
        if (StringUtils.isNotBlank((CharSequence)param.getUsername())) {
            likeStr = "%" + param.getUsername() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.username.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getFirstName())) {
            likeStr = "%" + param.getFirstName() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.firstName.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getLastName())) {
            likeStr = "%" + param.getLastName() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.lastName.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getMobile())) {
            likeStr = "%" + param.getMobile() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.mobile.like(likeStr));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getEmail())) {
            likeStr = "%" + param.getEmail() + "%";
            predicates.add(SysUserRepoProc.SYS_USER.email.like(likeStr));
        }
        predicates.add(SysUserRepoProc.SYS_USER.enabled.eq(Boolean.valueOf(true)));
        predicates.add(SysUserRepoProc.SYS_USER.deleteFlag.isNull().or((Predicate)SysUserRepoProc.SYS_USER.deleteFlag.eq((Object)0)));
        if (spi != null && (predicate = spi.findSysUserComPagingByParamForPredicate()) != null) {
            predicates.add(predicate);
        }
        query.where(ExpressionUtils.allOf(predicates));
        param.fillOrders(query, (EntityPathBase)SYS_USER);
        param.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    public Predicate where(SysUserQueryParam param) {
        BooleanExpression predicate = SYS_USER.isNotNull().or((Predicate)SYS_USER.isNull());
        predicate = StringUtils.isBlank((CharSequence)param.getKeyword()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.username.like("%" + param.getKeyword() + "%").or((Predicate)SysUserRepoProc.SYS_USER.firstName.like("%" + param.getKeyword() + "%")).or((Predicate)SysUserRepoProc.SYS_USER.lastName.like("%" + param.getKeyword() + "%")).or((Predicate)SysUserRepoProc.SYS_USER.mobile.like("%" + param.getKeyword() + "%")).or((Predicate)SysUserRepoProc.SYS_USER.email.like("%" + param.getKeyword() + "%")));
        predicate = StringUtils.isBlank((CharSequence)param.getUsername()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.username.like("%" + param.getUsername() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getName()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.firstName.like("%" + param.getName() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getMobile()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.mobile.like("%" + param.getMobile() + "%"));
        predicate = StringUtils.isBlank((CharSequence)param.getEmail()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.email.like("%" + param.getEmail() + "%"));
        predicate = ObjectUtils.isEmpty((Object)param.getEnabled()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.enabled.eq(param.getEnabled()));
        predicate = ObjectUtils.isEmpty((Object)param.getSourceType()) ? predicate : ExpressionUtils.and((Predicate)predicate, (Predicate)SysUserRepoProc.SYS_USER.sourceType.eq((Object)param.getSourceType()));
        return predicate;
    }

    public void updateStatusByIds(SysUserBatchSwitchParam param) {
        this.jpaQueryFactory.update((EntityPath)SYS_USER).set((Path)SysUserRepoProc.SYS_USER.enabled, (Object)param.isEnable()).where(new Predicate[]{SysUserRepoProc.SYS_USER.id.in((Collection)param.getUserIds())}).execute();
    }

    public SysUserDetailsVO findDetailsById(Long id) {
        return (SysUserDetailsVO)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserDetailsVO.class, (Expression[])new Expression[]{SysUserRepoProc.SYS_USER.id, SysUserRepoProc.SYS_USER.lastName, SysUserRepoProc.SYS_USER.firstName, SysUserRepoProc.SYS_USER.mobile, SysUserRepoProc.SYS_USER.email, SysUserRepoProc.SYS_USER.enabled, SysUserRepoProc.SYS_USER.avatarUrl, SysUserRepoProc.SYS_USER.avatarCode})).from((EntityPath)SYS_USER)).where((Predicate)SysUserRepoProc.SYS_USER.id.eq((Object)id))).fetchOne();
    }

    public Long getIdByUsername(String username) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SysUserRepoProc.SYS_USER.id).from((EntityPath)SYS_USER)).where((Predicate)SysUserRepoProc.SYS_USER.username.eq((Object)username))).limit(1L)).fetchOne();
    }

    public List<SysUserDO> queryByAccount(@NonNull String account) {
        if (this.systemProperties.getAccountTypes().isEmpty()) {
            log.error("\u672a\u914d\u7f6e\u8d26\u53f7\u7c7b\u578b");
            return Collections.emptyList();
        }
        List accountTypes = this.systemProperties.getAccountTypes();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq(accountTypes.contains(AccountType.USERNAME), (SimpleExpression)SysUserRepoProc.SYS_USER.username, (Object)account).andEq(accountTypes.contains(AccountType.MOBILE), (SimpleExpression)SysUserRepoProc.SYS_USER.mobile, (Object)account).andEq(accountTypes.contains(AccountType.EMAIL), (SimpleExpression)SysUserRepoProc.SYS_USER.email, (Object)account).buildOr();
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SYS_USER).from((EntityPath)SYS_USER)).where(predicate)).fetch();
    }

    public List<SysUserDO> queryByEmail(@NonNull String email) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)SYS_USER).from((EntityPath)SYS_USER)).where((Predicate)SysUserRepoProc.SYS_USER.email.eq((Object)email))).fetch();
    }

    public List<SysUserRpcDTO> findRpcDtoByParam(SysUserRpcDtoParam param) {
        List sourceTypes;
        List mobiles;
        List emails;
        List usernames;
        List userIds;
        JPAQuery query = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(SysUserRpcDTO.class, (Expression[])new Expression[]{SysUserRepoProc.SYS_USER.id, SysUserRepoProc.SYS_USER.username, SysUserRepoProc.SYS_USER.lastName, SysUserRepoProc.SYS_USER.firstName, SysUserRepoProc.SYS_USER.mobile, SysUserRepoProc.SYS_USER.email, SysUserRepoProc.SYS_USER.sourceType, SysUserRepoProc.SYS_USER.enabled, SysUserRepoProc.SYS_USER.needReset, SysUserRepoProc.SYS_USER.avatarUrl, SysUserRepoProc.SYS_USER.avatarCode})).from((EntityPath)SYS_USER);
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (CollectionUtils.isNotEmpty((Collection)param.getUserIds()) && CollectionUtils.isNotEmpty(userIds = this.filterList(param.getUserIds()))) {
            predicates.add(SysUserRepoProc.SYS_USER.id.in(userIds));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getUsernames()) && CollectionUtils.isNotEmpty(usernames = this.filterList(param.getUsernames()))) {
            predicates.add(SysUserRepoProc.SYS_USER.username.in(usernames));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getEmails()) && CollectionUtils.isNotEmpty(emails = this.filterList(param.getEmails()))) {
            predicates.add(SysUserRepoProc.SYS_USER.email.in(emails));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getMobiles()) && CollectionUtils.isNotEmpty(mobiles = this.filterList(param.getMobiles()))) {
            predicates.add(SysUserRepoProc.SYS_USER.mobile.in(mobiles));
        }
        if (CollectionUtils.isNotEmpty((Collection)param.getSourceTypes()) && CollectionUtils.isNotEmpty(sourceTypes = this.filterList(param.getSourceTypes()))) {
            predicates.add(SysUserRepoProc.SYS_USER.sourceType.in(sourceTypes));
        }
        if (param.getEnabled() != null) {
            predicates.add(SysUserRepoProc.SYS_USER.enabled.eq(param.getEnabled()));
        }
        if (CollectionUtils.isEmpty(predicates)) {
            return Collections.emptyList();
        }
        query.where(ExpressionUtils.allOf(predicates));
        return query.fetch();
    }

    public List<Long> findUserIdsByRoleIds(List<Long> roleIds) {
        return ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.sysUserRoleDO.userId).from((EntityPath)this.sysUserRoleDO)).where((Predicate)this.sysUserRoleDO.roleId.in(roleIds))).fetch();
    }

    private <T> List<T> filterList(List<T> list) {
        return list.stream().distinct().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private SysUserQuerySpi getUserQuerySpi() {
        if (this.spiLoaded.compareAndSet(false, true)) {
            this.userQuerySpi = ServiceProviderLoader.loadProviderInstanceOne(SysUserQuerySpi.class).orElse(null);
            if (this.userQuerySpi != null) {
                log.info("\u52a0\u8f7d\u7528\u6237\u67e5\u8be2SPI\uff1a{}", (Object)this.userQuerySpi.getServiceName());
            }
        }
        return this.userQuerySpi;
    }
}

