/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.system.util;

import cn.hutool.core.util.StrUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class SqlUtil {
    public static final String SQL_EMPTY_SET = "(NULL)";
    private static final Pattern RE_WORD = Pattern.compile("^\\w+$");
    private static final Map<Character, String> SQL_ESC = new HashMap<Character, String>();

    public static String toSqlString(CharSequence val) {
        if (StrUtil.isEmpty((CharSequence)val)) {
            throw new IllegalArgumentException("[EDP-SQL] Parameter(val) is null or empty");
        }
        return SqlUtil.escapeString(new StringBuilder(), val).toString();
    }

    private static StringBuilder escapeString(StringBuilder sb, CharSequence input) {
        sb.append('\'');
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char ch = input.charAt(i);
            sb = ch == '\'' ? sb.append("''") : sb.append(ch);
        }
        sb.append('\'');
        return sb;
    }

    public static String toSqlLikeString(CharSequence val, SqlLikeOption option) {
        if (StrUtil.isEmpty((CharSequence)val)) {
            throw new IllegalArgumentException("[EDP-SQL] Parameter(val) is null or empty");
        }
        return SqlUtil.escapeLikeString(new StringBuilder(), val, option).toString();
    }

    private static StringBuilder escapeLikeString(StringBuilder sb, CharSequence input, SqlLikeOption option) {
        Map<Character, String> escapeTable = SqlUtil.escapeTable();
        sb.append(option != SqlLikeOption.RIGHT_SIDE ? "%" : "");
        int n = input.length();
        for (int i = 0; i < n; ++i) {
            char ch = input.charAt(i);
            String escaped = escapeTable.get(Character.valueOf(ch));
            sb = escaped != null ? sb.append(escaped) : sb.append(ch);
        }
        sb.append(option != SqlLikeOption.LEFT_SIDE ? "%" : "");
        return sb;
    }

    public static String toSqlLikeString(String val) {
        return SqlUtil.toSqlLikeString(val, SqlLikeOption.BOTH_SIDES);
    }

    public static String toSqlStringSet(Collection<? extends CharSequence> vals) {
        List nonNullVals = vals.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return nonNullVals.isEmpty() ? SQL_EMPTY_SET : nonNullVals.stream().map(SqlUtil::toSqlString).collect(Collectors.joining(",", "(", ")"));
    }

    public static String toSqlNumberSet(Collection<? extends Number> vals) {
        List nonNullVals = vals.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return nonNullVals.isEmpty() ? SQL_EMPTY_SET : nonNullVals.stream().map(String::valueOf).collect(Collectors.joining(",", "(", ")"));
    }

    public static String toSqlWord(String input) {
        if (!RE_WORD.matcher(input).matches()) {
            throw new IllegalArgumentException("[CORE-JDBC] Illegal inputted sql word: " + input);
        }
        return input;
    }

    public static Map<Character, String> escapeTable() {
        return SQL_ESC;
    }

    public static String escapeClause() {
        return " escape '\\'";
    }

    static {
        SQL_ESC.put(Character.valueOf('\''), "''");
        SQL_ESC.put(Character.valueOf('%'), "\\%");
        SQL_ESC.put(Character.valueOf('_'), "\\_");
        SQL_ESC.put(Character.valueOf('&'), "\\&");
    }

    public static enum SqlLikeOption {
        BOTH_SIDES,
        LEFT_SIDE,
        RIGHT_SIDE;

    }
}

