/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.repo;

import cn.hutool.core.util.StrUtil;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.AdInfoDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoPagingParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.AdInfoQueryParam;
import com.elitescloud.cloudt.ucenter.entity.AdInfoDO;
import com.elitescloud.cloudt.ucenter.entity.QAdInfoDO;
import com.elitescloud.cloudt.ucenter.entity.QAdSpaceDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.EntityPathBase;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class AdInfoRepoProc
extends BaseRepoProc<AdInfoDO> {
    private static final QAdInfoDO Q_DO = QAdInfoDO.adInfoDO;
    private static final QAdSpaceDO Q_AD_SPACE_DO = QAdSpaceDO.adSpaceDO;

    protected AdInfoRepoProc() {
        super((EntityPathBase)Q_DO);
    }

    public PagingVO<AdInfoDTO> findAdInfoPagingResults(AdInfoPagingParam param) {
        JPAQuery query = (JPAQuery)((JPAQuery)this.select(AdInfoDTO.class).leftJoin((EntityPath)Q_AD_SPACE_DO)).on((Predicate)AdInfoRepoProc.Q_DO.adSpaceId.eq(AdInfoRepoProc.Q_AD_SPACE_DO.id));
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        if (StrUtil.isNotEmpty((CharSequence)param.getAdInfoCodeTitle())) {
            String likeStr = "%" + param.getAdInfoCodeTitle() + "%";
            predicates.add(AdInfoRepoProc.Q_DO.adTitle.like(likeStr).or((Predicate)AdInfoRepoProc.Q_DO.adCode.like(likeStr)));
        }
        if (StrUtil.isNotEmpty((CharSequence)param.getShowFlag())) {
            predicates.add(AdInfoRepoProc.Q_DO.showFlag.eq((Object)param.getShowFlag()));
        }
        if (StrUtil.isNotEmpty((CharSequence)param.getAdLinkType())) {
            predicates.add(AdInfoRepoProc.Q_DO.adLinkType.eq((Object)param.getAdLinkType()));
        }
        if (StrUtil.isNotEmpty((CharSequence)param.getAdSpaceCode())) {
            predicates.add(AdInfoRepoProc.Q_DO.adSpaceCode.eq((Object)param.getAdSpaceCode()));
        }
        predicates.add(AdInfoRepoProc.Q_DO.deleteFlag.eq((Object)0).or((Predicate)AdInfoRepoProc.Q_DO.deleteFlag.isNull()));
        ((JPAQuery)((JPAQuery)query.where(ExpressionUtils.allOf(predicates))).orderBy(AdInfoRepoProc.Q_DO.showFlag.asc())).orderBy(AdInfoRepoProc.Q_DO.sortNo.desc());
        param.fillOrders(query, Q_DO);
        param.setPaging(query);
        return PagingVO.builder().total(query.fetchCount()).records(query.fetch()).build();
    }

    private <T> JPAQuery<T> select(Class<T> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{AdInfoRepoProc.Q_DO.id, AdInfoRepoProc.Q_DO.adCode, AdInfoRepoProc.Q_DO.adTitle, AdInfoRepoProc.Q_DO.adSpaceId, AdInfoRepoProc.Q_AD_SPACE_DO.adSpaceCode, AdInfoRepoProc.Q_AD_SPACE_DO.adSpaceName, AdInfoRepoProc.Q_AD_SPACE_DO.adSpaceDesc, AdInfoRepoProc.Q_DO.adLinkType, AdInfoRepoProc.Q_DO.showFlag, AdInfoRepoProc.Q_DO.sortNo, AdInfoRepoProc.Q_DO.showBeginTime, AdInfoRepoProc.Q_DO.showEndTime, AdInfoRepoProc.Q_DO.targetType, AdInfoRepoProc.Q_DO.linkAddress, AdInfoRepoProc.Q_DO.imgFileCode, AdInfoRepoProc.Q_DO.videoFileCode, AdInfoRepoProc.Q_DO.sourceType, AdInfoRepoProc.Q_DO.linkSource})).from((EntityPath)Q_DO);
    }

    public List<AdInfoDO> queryList(AdInfoQueryParam queryParam) {
        LocalDateTime now = LocalDateTime.now();
        Predicate predicate = BaseRepoProc.PredicateBuilder.builder().andEq((SimpleExpression)AdInfoRepoProc.Q_DO.adSpaceCode, (Object)queryParam.getAdSpaceCode()).andEq((SimpleExpression)AdInfoRepoProc.Q_DO.adLinkType, (Object)queryParam.getAdLinkType()).andEq((SimpleExpression)AdInfoRepoProc.Q_DO.showFlag, (Object)queryParam.getShowFlag()).andLoe(Boolean.TRUE.equals(queryParam.getAvailable()), AdInfoRepoProc.Q_DO.showBeginTime, (Comparable)now).andGoe(Boolean.TRUE.equals(queryParam.getAvailable()), AdInfoRepoProc.Q_DO.showEndTime, (Comparable)now).andEq((SimpleExpression)AdInfoRepoProc.Q_DO.targetType, (Object)queryParam.getTargetType()).andEq((SimpleExpression)AdInfoRepoProc.Q_DO.linkSource, (Object)queryParam.getLinkSource()).build();
        return super.getList(predicate, new OrderSpecifier[]{AdInfoRepoProc.Q_DO.sortNo.asc()});
    }
}

