/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.repo;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.ucenter.api.dto.CommonSearchDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.CommonSearchParam;
import com.elitescloud.cloudt.ucenter.entity.QCommonSearchDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class CommonSearchRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private final QCommonSearchDO qCommonSearchDO = QCommonSearchDO.commonSearchDO;

    private JPAQuery<CommonSearchDTO> select(Class<CommonSearchDTO> cls) {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(cls, (Expression[])new Expression[]{this.qCommonSearchDO.id, this.qCommonSearchDO.commonSearchId, this.qCommonSearchDO.commonSearchName, this.qCommonSearchDO.commonSearchContent, this.qCommonSearchDO.commonSearchParam, this.qCommonSearchDO.connectionName, this.qCommonSearchDO.databaseType, this.qCommonSearchDO.cacheFlag, this.qCommonSearchDO.cacheLiveTime, this.qCommonSearchDO.subSearch, this.qCommonSearchDO.userName, this.qCommonSearchDO.password})).from((EntityPath)this.qCommonSearchDO);
    }

    public List<CommonSearchDTO> query(CommonSearchParam commonSearchParam) {
        JPAQuery<CommonSearchDTO> jpaQuery = this.buildJpaQuery(commonSearchParam);
        return jpaQuery.fetch();
    }

    private JPAQuery<CommonSearchDTO> buildJpaQuery(CommonSearchParam commonSearchParam) {
        JPAQuery<CommonSearchDTO> jpaQuery = this.select(CommonSearchDTO.class);
        if (commonSearchParam.getId() != null) {
            jpaQuery.where((Predicate)this.qCommonSearchDO.id.eq((Object)commonSearchParam.getId()));
        }
        if (StringUtils.isNotEmpty((CharSequence)commonSearchParam.getCommonSearchName())) {
            jpaQuery.where((Predicate)this.qCommonSearchDO.commonSearchName.like(this.buildLikeCondition(commonSearchParam.getCommonSearchName())));
        }
        if (StringUtils.isNotEmpty((CharSequence)commonSearchParam.getCommonSearchId())) {
            jpaQuery.where((Predicate)this.qCommonSearchDO.commonSearchId.like(this.buildLikeCondition(commonSearchParam.getCommonSearchId())));
        }
        if (StringUtils.isNotEmpty((CharSequence)commonSearchParam.getCommonSearchContent())) {
            jpaQuery.where((Predicate)this.qCommonSearchDO.commonSearchContent.like(this.buildLikeCondition(commonSearchParam.getCommonSearchContent())));
        }
        return jpaQuery;
    }

    private String buildLikeCondition(String condition) {
        return "%".concat(condition).concat("%");
    }

    public PagingVO<CommonSearchDTO> page(CommonSearchParam commonSearchParam) {
        JPAQuery<CommonSearchDTO> jpaQuery = this.buildJpaQuery(commonSearchParam);
        int size = jpaQuery.fetch().size();
        commonSearchParam.fillOrders(jpaQuery, this.qCommonSearchDO);
        commonSearchParam.setPaging(jpaQuery);
        return PagingVO.builder().total((long)size).records(jpaQuery.fetch()).build();
    }

    public CommonSearchRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

