/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.ucenter.service.impl;

import cn.hutool.core.lang.Assert;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.udc.UdcProvider;
import com.elitescloud.cloudt.ucenter.api.dto.CommonSearchDTO;
import com.elitescloud.cloudt.ucenter.api.vo.param.CommonSearchFieldParam;
import com.elitescloud.cloudt.ucenter.api.vo.param.CommonSearchParam;
import com.elitescloud.cloudt.ucenter.common.constant.UdcEnum;
import com.elitescloud.cloudt.ucenter.convert.CommonSearchConvert;
import com.elitescloud.cloudt.ucenter.entity.CommonSearchDO;
import com.elitescloud.cloudt.ucenter.repo.CommonSearchRepo;
import com.elitescloud.cloudt.ucenter.repo.CommonSearchRepoProc;
import com.elitescloud.cloudt.ucenter.rmi.RmiSysUDCService;
import com.elitescloud.cloudt.ucenter.service.CommonSearchService;
import com.google.common.collect.ImmutableMap;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonSearchServiceImpl
implements CommonSearchService {
    private static final Logger log = LoggerFactory.getLogger(CommonSearchServiceImpl.class);
    private final CommonSearchRepo commonSearchRepo;
    private final CommonSearchRepoProc commonSearchRepoProc;
    private final UdcProvider udcProvider;
    private final RedisUtils redisUtils;
    private final RmiSysUDCService rmiSysUDCService;
    public static final String SELECT = "select";
    public static final String STRING = "STRING";
    public static final String NUMBER = "NUMBER";
    private static final Map<String, String> DATABASE_DRIVEN_MAP = ImmutableMap.builder().put((Object)UdcEnum.DATABASE_TYPE_MYSQL.getValueCode(), (Object)"com.mysql.cj.jdbc.Driver").put((Object)UdcEnum.DATABASE_TYPE_ORACLE.getValueCode(), (Object)"").build();

    @Override
    public void insertOrUpdate(CommonSearchParam commonSearchParam) {
        this.checkInsertOrUpdateParam(commonSearchParam);
        this.checkExist(commonSearchParam);
        if (commonSearchParam.getId() == null) {
            this.commonSearchRepo.save(CommonSearchConvert.INSTANCE.commonSearchParam2CommonSearchDO(commonSearchParam));
        } else {
            List<CommonSearchDO> commonSearchDOList = this.commonSearchRepo.findAllById(commonSearchParam.getId());
            Assert.isTrue((commonSearchDOList.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636eid\u67e5\u8be2\u4e0d\u5230/\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e", (Object[])new Object[0]);
            this.commonSearchRepo.save(CommonSearchConvert.INSTANCE.commonSearchParam2CommonSearchDO(commonSearchParam, commonSearchDOList.get(0)));
        }
    }

    private void checkInsertOrUpdateParam(CommonSearchParam param) {
        List commonSearchFieldParams;
        Assert.notEmpty((CharSequence)param.getCommonSearchId(), (String)"\u901a\u67e5ID\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getCommonSearchName(), (String)"\u901a\u67e5\u540d\u79f0\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getCommonSearchContent(), (String)"\u901a\u67e5\u5185\u5bb9\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getCommonSearchParam(), (String)"\u901a\u67e5\u53c2\u6570\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getConnectionName(), (String)"\u8fde\u63a5\u540d\u5b57\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getDatabaseType(), (String)"\u6570\u636e\u5e93\u7c7b\u578b\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getUserName(), (String)"\u6570\u636e\u5e93\u7528\u6237\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getPassword(), (String)"\u6570\u636e\u5e93\u5bc6\u7801\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notNull((Object)param.getCacheFlag(), (String)"\u662f\u5426\u7f13\u5b58\u5fc5\u586b", (Object[])new Object[0]);
        if (param.getCacheFlag().booleanValue()) {
            Assert.notNull((Object)param.getCacheLiveTime(), (String)"\u7f13\u5b58\u5b58\u6d3b\u65f6\u95f4\u5fc5\u586b", (Object[])new Object[0]);
        }
        String commonSearchContent = param.getCommonSearchContent();
        Assert.isTrue((boolean)commonSearchContent.startsWith(SELECT), (String)"\u901a\u67e5\u5185\u5bb9\u53ea\u80fd\u662fselect\u8bed\u53e5", (Object[])new Object[0]);
        try {
            String commonSearchParam = param.getCommonSearchParam();
            commonSearchFieldParams = JSONObject.parseArray((String)commonSearchParam, CommonSearchFieldParam.class);
        }
        catch (Exception e) {
            throw new BusinessException("\u901a\u67e5\u53c2\u6570\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        if (CollectionUtils.isNotEmpty((Collection)commonSearchFieldParams)) {
            commonSearchFieldParams.stream().forEach(item -> Assert.isTrue((boolean)commonSearchContent.contains(item.getName()), (String)"\u901a\u67e5\u5185\u5bb9\u548c\u901a\u67e5\u53c2\u6570\u540d\u4e0d\u5339\u914d", (Object[])new Object[0]));
        }
        int count = 0;
        int index = commonSearchContent.indexOf("?");
        while (index != -1) {
            ++count;
            index = commonSearchContent.indexOf("?", index + 1);
        }
        Assert.equals((Object)count, (Object)commonSearchFieldParams.size(), (String)"\u901a\u67e5\u5185\u5bb9\u548c\u901a\u67e5\u53c2\u6570\u4e2a\u6570\u4e0d\u5339\u914d", (Object[])new Object[0]);
    }

    private void checkExist(CommonSearchParam commonSearchParam) {
        CommonSearchParam queryCommonSearchParam = new CommonSearchParam();
        queryCommonSearchParam.setCommonSearchId(commonSearchParam.getCommonSearchId());
        List<CommonSearchDTO> itmItemUomConvDTOList = this.commonSearchRepoProc.query(queryCommonSearchParam);
        CommonSearchDTO commonSearchDTO = itmItemUomConvDTOList.stream().filter(item -> commonSearchParam.getCommonSearchId().equals(item.getCommonSearchId())).findFirst().orElse(null);
        if (commonSearchDTO != null) {
            Assert.equals((Object)commonSearchParam.getId(), (Object)commonSearchDTO.getId(), (String)"\u901a\u67e5ID\u5728\u7cfb\u7edf\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        }
    }

    @Override
    public void delete(Long id) {
        Assert.notNull((Object)id, (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        this.commonSearchRepo.deleteById(id);
    }

    @Override
    @SysCodeProc
    public PagingVO<CommonSearchDTO> page(CommonSearchParam commonSearchParam) {
        return this.commonSearchRepoProc.page(commonSearchParam);
    }

    @Override
    public void clearCache(String commonSearchId) {
        Assert.notEmpty((CharSequence)commonSearchId, (String)"\u901a\u67e5ID\u5fc5\u586b", (Object[])new Object[0]);
        this.redisUtils.del(new String[]{commonSearchId});
    }

    @Override
    public List<Map> testInterface(CommonSearchParam param) {
        JSONObject jsonObject;
        Assert.notNull((Object)param.getId(), (String)"id\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notEmpty((CharSequence)param.getTestContent(), (String)"\u6d4b\u8bd5\u5185\u5bb9\u5fc5\u586b", (Object[])new Object[0]);
        List<CommonSearchDO> commonSearchDOList = this.commonSearchRepo.findAllById(param.getId());
        Assert.isTrue((commonSearchDOList.size() == 1 ? 1 : 0) != 0, (String)"\u6839\u636eid\u67e5\u8be2\u4e0d\u5230/\u67e5\u8be2\u5230\u591a\u6761\u6570\u636e", (Object[])new Object[0]);
        CommonSearchDO commonSearchDO = commonSearchDOList.get(0);
        String commonSearchParam = commonSearchDO.getCommonSearchParam();
        List commonSearchFieldParamList = JSONObject.parseArray((String)commonSearchParam, CommonSearchFieldParam.class);
        String testContent = param.getTestContent();
        try {
            jsonObject = JSONObject.parseObject((String)testContent);
        }
        catch (Exception e) {
            throw new BusinessException("\u6d4b\u8bd5\u5185\u5bb9\u89e3\u6790\u5931\u8d25", (Throwable)e);
        }
        if (CollectionUtils.isNotEmpty((Collection)commonSearchFieldParamList)) {
            commonSearchFieldParamList.stream().forEach(item -> {
                if (item.getMustHave().booleanValue()) {
                    Assert.notNull((Object)jsonObject.get((Object)item.getName()), (String)item.getName().concat("\u5fc5\u586b"), (Object[])new Object[0]);
                }
            });
        }
        return this.query(commonSearchDO, commonSearchFieldParamList, jsonObject);
    }

    private List<Map> query(CommonSearchDO commonSearchDO, List<CommonSearchFieldParam> commonSearchFieldParamList, JSONObject jsonObject) {
        ResultSet resultSet = null;
        Connection connection = null;
        Statement preparedStatement = null;
        ArrayList<Map> mapList = new ArrayList<Map>();
        try {
            String drivenName = DATABASE_DRIVEN_MAP.get(commonSearchDO.getDatabaseType());
            Assert.notEmpty((CharSequence)drivenName, (String)"\u6570\u636e\u5e93\u9a71\u52a8\u540d\u5b57\u4e3a\u7a7a", (Object[])new Object[0]);
            Class.forName(drivenName);
            connection = DriverManager.getConnection(commonSearchDO.getConnectionName(), commonSearchDO.getUserName(), commonSearchDO.getPassword());
            String sql = commonSearchDO.getCommonSearchContent();
            preparedStatement = connection.prepareStatement(sql);
            int index = 1;
            for (Map.Entry entry : jsonObject.entrySet()) {
                CommonSearchFieldParam commonSearchFieldParamResult;
                if (CollectionUtils.isNotEmpty(commonSearchFieldParamList) && (commonSearchFieldParamResult = (CommonSearchFieldParam)commonSearchFieldParamList.stream().filter(commonSearchFieldParam -> ((String)entry.getKey()).equals(commonSearchFieldParam.getName())).findFirst().orElse(null)) != null) {
                    if (STRING.equals(commonSearchFieldParamResult.getType())) {
                        preparedStatement.setString(index, entry.getValue().toString());
                    }
                    if (NUMBER.equals(commonSearchFieldParamResult.getType())) {
                        preparedStatement.setLong(index, Long.valueOf(entry.getValue().toString()));
                    }
                }
                ++index;
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int columnCount = resultSet.getMetaData().getColumnCount();
                for (int i = 1; i <= columnCount; ++i) {
                    map.put(resultSet.getMetaData().getColumnName(i), resultSet.getObject(resultSet.getMetaData().getColumnName(i)));
                }
                mapList.add(map);
            }
        }
        catch (Exception e) {
            throw new BusinessException("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
        return mapList;
    }

    public CommonSearchServiceImpl(CommonSearchRepo commonSearchRepo, CommonSearchRepoProc commonSearchRepoProc, UdcProvider udcProvider, RedisUtils redisUtils, RmiSysUDCService rmiSysUDCService) {
        this.commonSearchRepo = commonSearchRepo;
        this.commonSearchRepoProc = commonSearchRepoProc;
        this.udcProvider = udcProvider;
        this.redisUtils = redisUtils;
        this.rmiSysUDCService = rmiSysUDCService;
    }
}

