CREATE TABLE `sys_platform_database_source`
(
    `id`                    bigint       NOT NULL COMMENT '记录唯一ID',
    `dbs_code`              varchar(255) NOT NULL COMMENT '数据源标识',
    `dbs_type`              varchar(255) NOT NULL COMMENT '数据源名称',
    `dbs_name`              varchar(255) NOT NULL COMMENT '数据源名称',
    `dbs_description`       varchar(255) NOT NULL COMMENT '描述',
    `dbs_hostname`          varchar(255) NOT NULL COMMENT 'IP/主机名',
    `dbs_db_port`           varchar(255) NOT NULL COMMENT '数据库端口',
    `jdbc_extra_parameters` varchar(255) NOT NULL COMMENT 'jdbc额外参数',
    `dbs_url`               varchar(255) NOT NULL COMMENT 'URL',
    `dbs_db_name`           varchar(255) NOT NULL COMMENT '默认数据库名',
    `dbs_driver_class`      varchar(255) NOT NULL COMMENT '驱动类',
    `dbs_username`          varchar(255) NOT NULL COMMENT '账号名称',
    `dbs_password`          varchar(255) NOT NULL COMMENT '数据库密码',
    `dbs_schema`            varchar(255) NOT NULL COMMENT 'Schema',
    `dbs_link_mode`         varchar(255) NOT NULL COMMENT '链接方式 如oracle SID/服务名',
    `tenant_id`             bigint       DEFAULT '-1' COMMENT '所属租户ID',
    `belong_org_id`         bigint       DEFAULT NULL COMMENT '所属组织ID',
    `tenant_org_id`         bigint       DEFAULT NULL COMMENT '租户组织ID',
    `remark`                varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`        bigint       DEFAULT NULL COMMENT '记录创建者ID',
    `creator`               varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`           datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`        bigint       DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`               varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`           datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`           int          DEFAULT '0' COMMENT '删除标记',
    `audit_data_version`    int          DEFAULT NULL COMMENT '锁版本',
    `sec_bu_id`             bigint       DEFAULT NULL COMMENT '数据归属组织id',
    `sec_user_id`           bigint       DEFAULT NULL COMMENT '数据归属雇员id',
    `sec_ou_id`             bigint       DEFAULT NULL COMMENT '数据归属公司id',
    PRIMARY KEY (`id`)
)   COMMENT ='数据源表'