package com.elitescloud.cloudt.comm.repo;


import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.elitescloud.cloudt.comm.consumer.dto.ComPaymentTermRpcDTO;
import com.elitescloud.cloudt.comm.consumer.param.ComPaymentTermRpcDtoParam;
import com.elitescloud.cloudt.comm.entity.ComPaymentTermDO;
import com.elitescloud.cloudt.comm.entity.QComPaymentTermDO;
import com.elitescloud.cloudt.comm.vo.param.ComPaymentTermQueryParamVO;
import com.elitescloud.cloudt.comm.vo.resp.ComPaymentTermRespVO;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import lombok.extern.slf4j.Slf4j;
import lombok.val;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Repository;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * <p>
 * 功能说明
 * </p>
 *
 * @author shihao.ma
 * 2020/7/2
 */
@Slf4j
@Repository
public class ComPaymentTermRepoProc extends BaseRepoProc<ComPaymentTermDO> {

    private static final QComPaymentTermDO QDO = QComPaymentTermDO.comPaymentTermDO;
    public ComPaymentTermRepoProc() {
        super(QDO);
    }

    public JPAQuery<ComPaymentTermRespVO> select() {
        QComPaymentTermDO qComPaymentTermDO = QComPaymentTermDO.comPaymentTermDO;
        JPAQuery<ComPaymentTermRespVO> query = jpaQueryFactory.select(Projections.bean(
                ComPaymentTermRespVO.class,
                qComPaymentTermDO.id,
                qComPaymentTermDO.remark,
                qComPaymentTermDO.createTime,
                qComPaymentTermDO.createUserId,
                qComPaymentTermDO.modifyUserId,
                qComPaymentTermDO.modifyTime,
                qComPaymentTermDO.auditDataVersion,
                qComPaymentTermDO.tenantId,
                qComPaymentTermDO.days,
                qComPaymentTermDO.ptCode,
                qComPaymentTermDO.ptName,
                qComPaymentTermDO.validFrom,
                qComPaymentTermDO.validTo,
                qComPaymentTermDO.enableFlag,
                qComPaymentTermDO.baseDayType,
                qComPaymentTermDO.dayCalcMethod,
                qComPaymentTermDO.accountCode
        ))
                .from(qComPaymentTermDO)
                .where(qComPaymentTermDO.deleteFlag.isNull().or(qComPaymentTermDO.deleteFlag.eq(0)));
        return query;
    }

    public PagingVO<ComPaymentTermRespVO> pageForMng(ComPaymentTermQueryParamVO queryParam) {
        var jpaQuery = select()
                .where(where(queryParam));

        return super.queryByPage(jpaQuery, queryParam.getPageRequest(), QDO.createTime.desc());
    }

    public Predicate where(ComPaymentTermQueryParamVO queryParam) {
        QComPaymentTermDO qComPaymentTermDO = QComPaymentTermDO.comPaymentTermDO;
        Predicate predicate = qComPaymentTermDO.isNotNull();
        // 根据ID查询
        if (!ObjectUtils.isEmpty(queryParam.getId())) {
            predicate = ExpressionUtils.and(predicate, qComPaymentTermDO.id.eq(queryParam.getId()));
        }
        // 根据CODE查询
        if (!ObjectUtils.isEmpty(queryParam.getPtCode())) {
            predicate = ExpressionUtils.and(predicate, qComPaymentTermDO.ptCode.like("%" + queryParam.getPtCode() + "%"));
        }
        // 根据名称查询
        if (!ObjectUtils.isEmpty(queryParam.getPtName())) {
            predicate = ExpressionUtils.and(predicate, qComPaymentTermDO.ptName.like("%" + queryParam.getPtName() + "%"));
        }
        // 根据支付条款说明查询
        if (!ObjectUtils.isEmpty(queryParam.getRemark())) {
            predicate = ExpressionUtils.and(predicate, qComPaymentTermDO.remark.like("%" + queryParam.getRemark() + "%"));
        }
        // 根据支付净天数查询
        if (!ObjectUtils.isEmpty(queryParam.getDays())) {
            predicate = ExpressionUtils.and(predicate, qComPaymentTermDO.days.eq(queryParam.getDays()));
        }
        return predicate;
    }



    /**
     * 获取 rpc dto
     * @param param 查询条件
     * @return 结果
     */
    public List<ComPaymentTermRpcDTO> findRpcDtoByParam(ComPaymentTermRpcDtoParam param) {
        List<Predicate> predicates = new ArrayList<>();

        if (CollectionUtils.isNotEmpty(param.getPtCodes())) {
            var ptCodes = param.getPtCodes().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ptCodes)) {
                predicates.add(QDO.ptCode.in(ptCodes));
            }
        }
        if (CollectionUtils.isNotEmpty(param.getPtNames())) {
            var ptNames = param.getPtNames().stream().filter(Objects::nonNull).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(ptNames)) {
                predicates.add(QDO.ptName.in(ptNames));
            }
        }
        if (param.getEnableFlag() != null) {
            predicates.add(QDO.enableFlag.eq(param.getEnableFlag()));
        }
        // 查询条件为空则返回空数据，防止获取全部数据
        if (CollectionUtils.isEmpty(predicates)) {
            return Collections.emptyList();
        }
        predicates.add(QDO.deleteFlag.isNull().or(QDO.deleteFlag.eq(0)));

        return jpaQueryFactory
                .select(Projections.bean(
                        ComPaymentTermRpcDTO.class,
                        QDO.id,
                        QDO.ptCode,
                        QDO.ptName,
                        QDO.days,
                        QDO.baseDayType,
                        QDO.dayCalcMethod,
                        QDO.validFrom,
                        QDO.validTo,
                        QDO.enableFlag,
                        QDO.accountCode
                ))
                .from(QDO)
                .where(ExpressionUtils.allOf(predicates))
                .fetch();

    }

}
