package com.elitescloud.cloudt.customfield.sbean;

import cn.zhxu.bs.bean.DbField;
import cn.zhxu.bs.bean.DbIgnore;
import cn.zhxu.bs.bean.SearchBean;
import com.elitescloud.boot.core.support.customfield.enums.CustomFieldTypeEnum;
import com.elitescloud.cloudt.platform.model.entity.SysPlatformApiManageDO;
import com.elitescloud.cloudt.platform.model.vo.SysPlatformApiParameterVO;
import com.elitescloud.cloudt.system.service.common.constant.TableNameConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
@SearchBean(
        tables = TableNameConstant.SYS_CUSTOM_FIELD_DEFINITION+ " field",       // 两表关联
//        where = "u.delete_flag = 0"   ,
        autoMapTo="field"
)
@ApiModel(description = "自定义字段定义查询")
public class CustomFieldDefinitionQueryBean implements Serializable {
    private Long id;
    // 基础属性
    @ApiModelProperty("标识此字段所属的业务对象编码")
    private String businessObjectCode; // 标识此字段所属的模块或实体。

    @ApiModelProperty("标识此字段所属的模块或实体")
    private String basicModuleCode; // 标识此字段所属的模块或实体。

    @ApiModelProperty("用户界面显示的字段名")
    private String basicName;

    @ApiModelProperty("支持多语言环境下的字段名称")
    private String basicLocalizedName;

    @ApiModelProperty("数据库和API中使用的唯一键名")
    private String basicKey;

    @ApiModelProperty("字段的数据类型")
    private String basicType;

    @ApiModelProperty("字段用途或输入要求的描述信息。")
    private String basicDescription;

    @ApiModelProperty("创建实体时的默认值")
    private String basicDefaultValue;

    @ApiModelProperty("指示字段在创建或更新实体时是否必填")
    private Boolean basicRequired;

    @ApiModelProperty("前端显示的排序顺序")
    private Integer basicDisplayOrder;

    @ApiModelProperty("字段是否启用")
    private String basicStatus;

    // 展示和交互属性
    @ApiModelProperty("重要：展示类型指明了字段在前端UI中的展示方式")
    private String displayType;

    @ApiModelProperty("选项值，仅对枚举类型的字段适用，存储为JSON字符串")
    private String displayOptionsJson;

    @ApiModelProperty("指示字段是否可以包含多个值")
    private Boolean displayMultivalue;

    @ApiModelProperty("字段分组名称，用于在UI中将相关字段组织在一起展示，以提高表单的可用性和逻辑性")
    private String displayGroup;

    @ApiModelProperty("只读属性指示字段在UI中是否只能被显示而不能被修改")
    private Boolean displayReadonly;

    @ApiModelProperty("控制字段在UI中的可见性的条件，存储为JSON字符串")
    private String displayVisibilityConditionJson;

    @ApiModelProperty(" UI组件属性，提供额外的配置以支持更复杂的前端UI控件，如指定日期选择器的格式，存储为JSON字符串")
    private String displayUiAttributesJson;

//    @ApiModelProperty("关联实体类型和关系。如果字段值指向另一个实体，该属性定义了所关联的实体类型。")
//    private String displayLinkedEntity;

    @ApiModelProperty("动态属性，用于存储与字段类型相关的其他属性，如数值字段的最大值和最小值，存储为JSON字符串")
    private String displayDynamicAttributesJson;

    @ApiModelProperty("依赖字段，存储为JSON字符串。当前字段的展示或值可能依赖于其他字段的状态或值。")
    private String displayDependentFieldsJson;

    // 高级配置属性
    @ApiModelProperty("前端校验模式数据存储")
    private String configWebValidationPattern;

    @ApiModelProperty("前端扩展数据存储")
    private String configWebExtendedData;

    @ApiModelProperty("前端函数存储")
    private String configWebFunction;

    @ApiModelProperty("可搜索属性标记字段是否可以被用作搜索条件")
    private Boolean configSearchable;

    @ApiModelProperty("可排序属性指示字段是否可以用作列表排序的依据")
    private Boolean configSortable;

    @ApiModelProperty("导入导出属性标记字段是否应包含在数据导入导出操作中")
    private Boolean configImportExport;

//    @ApiModelProperty("权限控制，存储为JSON字符串")
//    private String configAccessControlJson;

//    @ApiModelProperty("历史记录属性指示是否追踪字段值的变更历史")
//    private boolean configTrackHistory = false;

    @ApiModelProperty("数据加密属性标记")
    private Boolean configEncrypted = false;

    @ApiModelProperty("敏感数据标记")
    private Boolean configSensitive = false;

    @ApiModelProperty("自动填充建议属性")
    private String configAutocompleteSuggestionsJson;

}
