package com.elitescloud.cloudt.customfield.service.impl;

/**
 * @author : chen.niu
 * @description :
 * @date : 2024-03-18 16:35
 */


import com.elitescloud.boot.jpa.common.JpaPredicateBuilder;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;

import com.elitescloud.cloudt.customfield.entity.CustomFieldDefinitionDo;
import com.elitescloud.cloudt.customfield.entity.QCustomFieldDefinitionDo;
import com.elitescloud.cloudt.customfield.model.CustomFieldDefinitionSaveParam;
import com.elitescloud.cloudt.customfield.model.CustomFieldDefinitionUpdateParam;
import com.elitescloud.cloudt.customfield.model.CustomFieldQueryParam;
import com.elitescloud.cloudt.customfield.repositiory.CustomFieldDefinitionRepository;
import com.elitescloud.cloudt.customfield.service.CustomFieldDefinitionService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * CustomFieldService接口的实现。
 */
@Service
public class CustomFieldDefintionServiceImpl implements CustomFieldDefinitionService {

    @Autowired
    private CustomFieldDefinitionRepository customFieldDefinitionRepository;

    @Override
    @Transactional
    public ApiResult createCustomField(CustomFieldDefinitionSaveParam customFieldParam) {
        CustomFieldQueryParam customFieldQueryParam=new CustomFieldQueryParam();
        customFieldQueryParam.setBasicKey(customFieldParam.getBasicKey());
        customFieldQueryParam.setBasicModuleCode(customFieldParam.getBasicModuleCode());
        customFieldQueryParam.setBusinessObjectCode(customFieldParam.getBusinessObjectCode());
        var predicate =CustomFieldDefinitionService.getPredicateByCustomFieldQueryParam(customFieldQueryParam);
        boolean exists= customFieldDefinitionRepository.findBy(predicate, fetchableFluentQuery -> {
            return fetchableFluentQuery.exists();
        });
        if(exists){
            return ApiResult.fail("字段key不能重复");
        }

        CustomFieldDefinitionDo customFieldDefinitionEntity = new CustomFieldDefinitionDo();
        BeanUtils.copyProperties(customFieldParam, customFieldDefinitionEntity);
        customFieldDefinitionEntity.setBasicType(customFieldParam.getBasicType().name());
        // 将新的自定义字段保存到数据库
        customFieldDefinitionRepository.save(customFieldDefinitionEntity);

        return ApiResult.ok(customFieldDefinitionEntity.getId());
    }
    @Override
    @Transactional
    public ApiResult<Long> deleteAndCreateCustomField(String businessObjectCode, List<CustomFieldDefinitionSaveParam> param) {
        customFieldDefinitionRepository.deleteByBusinessObjectCode(businessObjectCode);
        if(param!=null){
            for (CustomFieldDefinitionSaveParam customFieldDefinitionSaveParam : param) {
                createCustomField(customFieldDefinitionSaveParam);
            }
            return ApiResult.ok((long) param.size());
        }
        return ApiResult.ok(0L);
    }

    @Override
    public CustomFieldDefinitionDo getCustomFieldById(Long id) {
        // 通过ID获取自定义字段
        return customFieldDefinitionRepository.findById(id)
                .orElseGet(() -> null);
    }
    @Override
    public CustomFieldDefinitionDo getCustomFieldByCode(String code) {
        var QDO = QCustomFieldDefinitionDo.customFieldDefinitionDo;
        var predicate = JpaPredicateBuilder.builder()
                .and(QDO.basicModuleCode::eq, code)
                .getPredicate();
        CustomFieldDefinitionDo page = customFieldDefinitionRepository.findOne(predicate).orElseGet(() -> null);
        return page;
    }


    @Override
    @Transactional
    public ApiResult updateCustomField(Long id, CustomFieldDefinitionUpdateParam customFieldDetails) {
        // 更新现有的自定义字段
        CustomFieldDefinitionDo customField = customFieldDefinitionRepository.findById(id)
                .orElseThrow(() -> new RuntimeException("未找到该ID的自定义字段 :: " + id));
         BeanUtils.copyProperties(customFieldDetails, customField);
        // 在这里更新字段
        customFieldDefinitionRepository.save(customField);
        return ApiResult.ok();
    }

    @Override
    @Transactional
    public void deleteCustomField(Long id) {
        // 通过ID删除自定义字段
        customFieldDefinitionRepository.deleteById(id);
    }

    @Override
    public PagingVO<CustomFieldDefinitionDo> searchCustomFields(CustomFieldQueryParam customFieldParam) {

        var predicate =CustomFieldDefinitionService.getPredicateByCustomFieldQueryParam(customFieldParam);
        Page<CustomFieldDefinitionDo> page = customFieldDefinitionRepository.findAll(predicate, customFieldParam.getPageRequest());
        var pagingVo = PagingVO.<CustomFieldDefinitionDo>builder()
                .total(page.getTotalElements())
                .setRecords(page.getContent());
        return pagingVo;
    }


}
