//package com.elitescloud.cloudt.datadiff;
//
//import cn.hutool.json.JSONArray;
//import cn.hutool.json.JSONObject;
//import cn.hutool.json.JSONUtil;
//
//import com.elitescloud.cloudt.datadiff.annotation.AuditField;
//import com.elitescloud.cloudt.datadiff.annotation.AuditIgnoreField;
//import com.elitescloud.cloudt.datadiff.annotation.AuditObject;
//import com.elitescloud.cloudt.datadiff.context.AuditLogContext;
//import com.elitescloud.cloudt.datadiff.vo.AuditDiffVO;
//import com.elitescloud.cloudt.datadiff.vo.AuditFieldVO;
//
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//
//import java.lang.reflect.Field;
//import java.util.*;
//
///**
// * @author eric.hao
// * @since 2023/08/29
// */
//@Slf4j
////@AuditMethod
////@ConditionalOnProperty(prefix = AuditLogAutoConfiguration.AUDIT_LOG_PREFIX, name = "enabled", havingValue = "true")
//public class CustomFunctionObjectDiff {
//
//    public static final String DEFAULT_DIFF_MSG_FORMAT = "【${_fieldName}】从【${_oldValue}】变成了【${_newValue}】";
//    public static final String DEFAULT_DIFF_MSG_SEPARATOR = " ";
//    public static final String DEFAULT_DIFF_NULL_TEXT = " ";
//
//    private static String DIFF_MSG_FORMAT;
//    private static String DIFF_MSG_SEPARATOR;
//
//    public CustomFunctionObjectDiff() {
////        DIFF_MSG_FORMAT = logRecordProperties.getDiffMsgFormat().equals(DEFAULT_DIFF_MSG_FORMAT) ? DEFAULT_DIFF_MSG_FORMAT : new String(logRecordProperties.getDiffMsgFormat().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
////        DIFF_MSG_SEPARATOR = logRecordProperties.getDiffMsgSeparator().equals(DEFAULT_DIFF_MSG_SEPARATOR) ? DEFAULT_DIFF_MSG_SEPARATOR : new String(logRecordProperties.getDiffMsgSeparator().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8);
//        DIFF_MSG_FORMAT = DEFAULT_DIFF_MSG_FORMAT;
//        DIFF_MSG_SEPARATOR = DEFAULT_DIFF_MSG_SEPARATOR;
//        log.info("[PHOENIX-AUDIT] CustomFunctionObjectDiff init diffMsgFormat [{}] diffMsgSeparator [{}]", DIFF_MSG_FORMAT, DIFF_MSG_SEPARATOR);
//    }
//
//    /**
//     * 默认的DIFF方法实现
//     *
//     * @return DIFF日志消息文案
//     */
////    @AuditMethod("_DIFF")
//    public static AuditDiffVO objectDiff(Object oldObject, Object newObject) {
//        StringBuilder msg = new StringBuilder();
//
//        // 若包含null对象，直接返回
//        if (oldObject == null || newObject == null) {
//            log.warn("[PHOENIX-AUDIT] null object found [{}] [{}]", oldObject, newObject);
//            return null;
//        }
//
//        // 类注解获取
//        String oldClassName = oldObject.getClass().getName();
//        String newClassName = newObject.getClass().getName();
//        AuditObject oldObjectLogRecordDiff = oldObject.getClass().getDeclaredAnnotation(AuditObject.class);
//        AuditObject newObjectLogRecordDiff = newObject.getClass().getDeclaredAnnotation(AuditObject.class);
//
//
//        // 类全部字段DIFF开关
//        boolean oldClassEnableAllFields = oldObjectLogRecordDiff != null && oldObjectLogRecordDiff.enableAllFields();
//        boolean newClassEnableAllFields = newObjectLogRecordDiff != null && newObjectLogRecordDiff.enableAllFields();
//        log.debug("[PHOENIX-AUDIT] OldClassEnableAllFields [{}] newClassEnableAllFields [{}]", oldClassEnableAllFields, newClassEnableAllFields);
//
//        // 类别名处理
//        String oldClassAlias = oldObjectLogRecordDiff != null && StringUtils.isNotBlank(oldObjectLogRecordDiff.alias()) ? oldObjectLogRecordDiff.alias() : null;
//        String newClassAlias = newObjectLogRecordDiff != null && StringUtils.isNotBlank(newObjectLogRecordDiff.alias()) ? newObjectLogRecordDiff.alias() : null;
//        log.debug("[PHOENIX-AUDIT] OldClassName [{}] oldClassAlias [{}] newClassName [{}] newClassAlias [{}]", oldClassName, oldClassAlias, newClassName, newClassAlias);
//
//        // 新旧字段Map和新旧字段别名Map
//        Map<String, String> oldFieldAliasMap = new LinkedHashMap<>();
//        Map<String, String> newFieldAliasMap = new LinkedHashMap<>();
//        Map<String, Object> oldValueMap = new LinkedHashMap<>();
//        Map<String, Object> newValueMap = new LinkedHashMap<>();
//
//        Map<String, String> oldFieldZhNameMap = new LinkedHashMap<>();
//        Map<String, String> newFieldZhNameMap = new LinkedHashMap<>();
//        // 遍历旧对象
//        Field[] fields = oldObject.getClass().getDeclaredFields();
//        for (Field oldField : fields) {
//            try {
//                AuditField oldFieldAuditField = oldField.getDeclaredAnnotation(AuditField.class);
//                AuditIgnoreField oldFieldLogRecordIgnoreField = oldField.getDeclaredAnnotation(AuditIgnoreField.class);
//                // 根据老字段判断是否需要进行diff
//                if (!judgeFieldDiffNeeded(oldClassEnableAllFields, oldFieldAuditField, oldFieldLogRecordIgnoreField)) {
//                    log.debug("[PHOENIX-AUDIT] OldField [{}] not need to diff, skip", oldField.getName());
//                    continue;
//                }
//                try {
//                    // 在新字段中寻找同名字段，若找不到则抛出NoSuchFieldException异常跳过本次遍历
//                    Field newField = newObject.getClass().getDeclaredField(oldField.getName());
//                    AuditField newFieldAuditField = newField.getDeclaredAnnotation(AuditField.class);
//                    AuditIgnoreField newFieldAuditIgnoreField = newField.getDeclaredAnnotation(AuditIgnoreField.class);
//
//                    // 根据新字段判断是否需要进行diff
//                    if (!judgeFieldDiffNeeded(newClassEnableAllFields, newFieldAuditField, newFieldAuditIgnoreField)) {
//                        log.debug("[PHOENIX-AUDIT] NewField [{}] not need to diff, skip", newField.getName());
//                        continue;
//                    }
//
//                    // 通过LogRecordDiffField获取字段别名
//                    if (oldFieldAuditField != null && newFieldAuditField != null) {
//                        String oldFieldAlias = StringUtils.isNotBlank(oldFieldAuditField.alias()) ? oldFieldAuditField.alias() : null;
//                        String newFieldAlias = StringUtils.isNotBlank(newFieldAuditField.alias()) ? newFieldAuditField.alias() : null;
//                        String oldFieldZhName = StringUtils.isNotBlank(oldFieldAuditField.fieldZhName()) ? oldFieldAuditField.fieldZhName() : null;
//                        String newFieldZhName  = StringUtils.isNotBlank(newFieldAuditField.fieldZhName()) ? newFieldAuditField.fieldZhName() : null;
//
//                        oldFieldAliasMap.put(oldField.getName(), oldFieldAlias);
//                        newFieldAliasMap.put(newField.getName(), newFieldAlias);
//                        oldFieldZhNameMap.put(oldField.getName(),oldFieldZhName);
//                        newFieldZhNameMap.put(newField.getName(),newFieldZhName);
//                        log.debug("[PHOENIX-AUDIT] Field [{}] has annotation oldField alias [{}] newField alias [{}]", oldField.getName(), oldFieldAlias, newFieldAlias);
//                    }
//
//                    // 对比新老字段值
//                    oldField.setAccessible(true);
//                    newField.setAccessible(true);
//                    Object oldValue = oldField.get(oldObject);
//                    Object newValue = newField.get(newObject);
//                    if (!fieldValueEquals(oldValue, newValue)) {
//                        log.debug("[PHOENIX-AUDIT] Field [{}] is different between oldObject [{}] newObject [{}]", oldField.getName(), oldValue, newValue);
//                        oldValueMap.put(oldField.getName(), oldValue);
//                        newValueMap.put(newField.getName(), newValue);
//                    }
//                } catch (NoSuchFieldException e) {
//                    log.info("[PHOENIX-AUDIT] No field named [{}] in newObject, skip", oldField.getName());
//                }
//            } catch (Exception e) {
//                log.error("[PHOENIX-AUDIT] ObjectDiff error", e);
//            }
//        }
//
//        // DIFF后组装 DiffVOList 和 msg
//        List<String> diffMsgList = new ArrayList<>();
//        log.debug("[PHOENIX-AUDIT] OldFieldAliasMap [{}]", oldFieldAliasMap);
//        log.debug("[PHOENIX-AUDIT] NewFieldAliasMap [{}]", newFieldAliasMap);
//        log.debug("[PHOENIX-AUDIT] OldValueMap [{}]", oldValueMap);
//        log.debug("[PHOENIX-AUDIT] NewValueMap [{}]", newValueMap);
//        AuditDiffVO auditDiffVO = new AuditDiffVO();
//        auditDiffVO.setOldClassName(oldClassName);
//        auditDiffVO.setOldClassAlias(oldClassAlias);
//        auditDiffVO.setNewClassName(newClassName);
//        auditDiffVO.setNewClassAlias(newClassAlias);
//        List<AuditFieldVO> auditFieldVOList = new ArrayList<>();
//        auditDiffVO.setAuditFieldVOList(auditFieldVOList);
//        for (Map.Entry<String, Object> entry : oldValueMap.entrySet()) {
//            String fieldName = entry.getKey();
//            Object oldValue = entry.getValue();
//            Object newValue = newValueMap.getOrDefault(entry.getKey(), null);
//            String oldFieldAlias = oldFieldAliasMap.getOrDefault(entry.getKey(), null);
//            String newFieldAlias = newFieldAliasMap.getOrDefault(entry.getKey(), null);
//            String oldFieldZhName = oldFieldZhNameMap.getOrDefault(entry.getKey(), null);
//            String newFieldZhName = newFieldZhNameMap.getOrDefault(entry.getKey(), null);
//
//            AuditFieldVO auditFieldVO = new AuditFieldVO();
//            auditFieldVO.setFieldName(fieldName);
//            auditFieldVO.setOldFieldAlias(oldFieldAlias);
//            auditFieldVO.setNewFieldAlias(newFieldAlias);
//            auditFieldVO.setOldFieldZhName(oldFieldZhName);
//            auditFieldVO.setNewFieldZhName(newFieldZhName);
//
//            auditFieldVO.setOldValue(oldValue);
//            auditFieldVO.setNewValue(newValue);
//            auditFieldVOList.add(auditFieldVO);
//            // 默认使用旧对象的字段名或别名
//            Map<String, Object> valuesMap = new HashMap<>(3);
//            valuesMap.put("_fieldName", StringUtils.isNotBlank(oldFieldAlias) ? oldFieldAlias : fieldName);
//            valuesMap.put("_oldValue", oldValue == null ? DEFAULT_DIFF_NULL_TEXT : oldValue.toString());
//            valuesMap.put("_newValue", newValue == null ? DEFAULT_DIFF_NULL_TEXT : newValue.toString());
////            StringSubstitutor sub = new StringSubstitutor(valuesMap);
////            diffMsgList.add(sub.replace(DIFF_MSG_FORMAT));
//            diffMsgList.add(String.format(DEFAULT_DIFF_MSG_FORMAT, valuesMap));
//        }
//
//        msg.append(String.join(DEFAULT_DIFF_MSG_SEPARATOR, diffMsgList));
//        AuditLogContext.addDiff(auditDiffVO);
//        return auditDiffVO;
//    }
//
//    /**
//     * 判断field是否需要进行DIFF
//     * 规则如下：
//     * 老类开启EnableAllFields并且老字段未开启LogRecordIgnoreField
//     * 或
//     * 老字段开启LogRecordDiffField并且老字段未开启LogRecordIgnoreField
//     */
//    private static boolean judgeFieldDiffNeeded(boolean classEnableAllFields, AuditField fieldAuditField,
//                                                AuditIgnoreField fieldLogRecordIgnoreField) {
//        return (classEnableAllFields && fieldLogRecordIgnoreField == null)
//                || (fieldAuditField != null && fieldLogRecordIgnoreField == null);
//    }
//
//    /**
//     * 判断新旧字段值是否相同
//     */
//    private static boolean fieldValueEquals(Object oldValue, Object newValue) {
//        try {
//            // 全为null返回相同
//            if (oldValue == null && newValue == null) {
//                return true;
//            }
//            // 有一个为null返回不相同
//            if (oldValue == null || newValue == null) {
//                return false;
//            }
//            // 全为非null
//            boolean isAllPrimitive = isWrapClassOrPrimitive(oldValue.getClass()) && isWrapClassOrPrimitive(newValue.getClass());
//            boolean isAllNotPrimitive = !isWrapClassOrPrimitive(oldValue.getClass()) && !isWrapClassOrPrimitive(newValue.getClass());
//            // 若为基本类型
//            // 旧值为空并且新值不为空
//            // 或
//            // 旧值不为空且新值为空
//            // 或
//            // 旧值和新值均不为空且equals不相等
//            if (isAllPrimitive) {
//                return oldValue.equals(newValue);
//            }
//
//            // 若为非基本类型：转化为JSONObject或者JSONArray进行比较
//            else if (isAllNotPrimitive) {
//                if (isJsonArray(oldValue) && isJsonArray(newValue)) {
//                    JSONArray oldJsonArray = JSONUtil.parseArray(oldValue);
//                    JSONArray newJsonArray = JSONUtil.parseArray(newValue);
//                    return oldJsonArray.equals(newJsonArray);
//                } else if (!isJsonArray(oldValue.getClass()) && !isJsonArray(newValue.getClass())) {
//                    // 尝试转化为JSONObject进行比较，若强转失败则使用equals，依赖于类的equals实现
//                    try {
//                        JSONObject oldJsonObject = JSONUtil.parseObj(oldValue);
//                        JSONObject newJsonObject = JSONUtil.parseObj(newValue);
//                        return oldJsonObject.equals(newJsonObject);
//                    } catch (ClassCastException e) {
//                        return oldValue.equals(newValue);
//                    }
//                } else {
//                    return false;
//                }
//            }
//            // 若一个基本类型一个非基本类型返回不相等
//            else {
//                return false;
//            }
//        } catch (Exception e) {
//            throw new RuntimeException(e);
//        }
//    }
//
//    /**
//     * 是否为基础类型或者其包装类
//     */
//    private static boolean isWrapClassOrPrimitive(Class clz) {
//        return clz.isPrimitive() || clz == Integer.class || clz == Long.class || clz == Short.class
//                || clz == Boolean.class || clz == Byte.class || clz == Float.class || clz == Double.class
//                || clz == String.class;
//    }
//
//    /**
//     * 是否为数组类型（可解析为JSONArray）
//     */
//    private static boolean isJsonArray(Object obj) {
//        return obj.getClass().isArray() || obj instanceof Collection;
//    }
//
//}
