package com.elitescloud.cloudt.datadiff.log.request;

import java.io.Serializable;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;


/**
 * <p>
 * 数据变更日志
 * </p>
 *
 * @author nc
 * @since 2025-08-21
 */
@Data
@ApiModel
public class SysDataModifyLogParamVO implements Serializable {

	private static final long serialVersionUID = 1L;


	/**
	 * 业务数据编码
	 */
	@ApiModelProperty(value = "业务数据编码")
	private String dataCode;

	/**
	 * 业务数据ID
	 */
	@ApiModelProperty(value = "业务数据ID")
	private Long dataId;

	/**
	 * 记录唯一ID
	 */
	@ApiModelProperty(value = "记录唯一ID")
	private Long id;

	/**
	 * 业务单据ID
	 */
	@ApiModelProperty(value = "业务单据ID")
	private Long masId;

	/**
	 * 业务单据类型(供应商变更,商品变更,客户变更)
	 */
	@ApiModelProperty(value = "业务单据类型(供应商变更,商品变更,客户变更)")
	private String masType;

	@ApiModelProperty("变更人id")
	private Long modifyPersonId;

	@ApiModelProperty("变更人")
	private String modifyPerson;

}