package com.elitescloud.cloudt.datadiff.log.resp;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.persistence.Column;
import javax.persistence.Lob;
import java.time.LocalDateTime;


/**
 * <p>
 * 数据变更日志
 * </p>
 *
 * @author nc
 * @since 2025-08-21
 */
@Data
@ApiModel
public class SysDataModifyLogPageRespVO extends BaseViewModel {

	private static final long serialVersionUID = 1L;


	@ApiModelProperty("业务单据类型(供应商变更,商品变更,客户变更)")
	private String masType;

	@ApiModelProperty("业务单据ID")
	private Long masId;

	@ApiModelProperty("业务数据ID")
	private Long dataId;

	@ApiModelProperty("业务数据编码")
	private String dataCode;

	@ApiModelProperty("变更人id")
	private Long modifyPersonId;

	@ApiModelProperty("变更人")
	private String modifyPerson;

	@ApiModelProperty("变更时间")
	private LocalDateTime modifyDate;

	@ApiModelProperty("变更内容Json")
	private String modifyContentJson;
}