package com.elitescloud.cloudt.datadiff.log.service;

import cn.hutool.core.bean.BeanUtil;
import com.elitescloud.cloudt.Application;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import com.elitescloud.cloudt.datadiff.log.request.SysDataModifyLogSaveVO;
import com.elitescloud.cloudt.system.dto.SysDataModifyLogDTO;
import com.elitescloud.cloudt.system.service.SysDataModifyLogRpcService;
import com.elitescloud.cloudt.system.service.SysMsgCustomSendRpcService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@RestController
@RequestMapping(value = SysDataModifyLogRpcService.URI, produces = MediaType.APPLICATION_JSON_VALUE)
@TenantOrgTransaction(useTenantOrg = false)
@Slf4j
public class SysDataModifyLogRpcServiceImpl implements SysDataModifyLogRpcService {

    private final SysDataModifyLogService sysDataModifyLogService;

    public SysDataModifyLogRpcServiceImpl(SysDataModifyLogService sysDataModifyLogService) {
        this.sysDataModifyLogService = sysDataModifyLogService;
    }

    @Override
    public ApiResult<String> sysDataModifyLogSave(SysDataModifyLogDTO param) {
        SysDataModifyLogSaveVO saveVO=new  SysDataModifyLogSaveVO();
        BeanUtil.copyProperties(param, saveVO);
        sysDataModifyLogService.save(saveVO);
        return ApiResult.ok();
    }
}