package com.elitescloud.cloudt.groupitem;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitescloud.cloudt.system.dto.SysEmployeeGroupItemDTO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;
import com.elitescloud.cloudt.system.model.entity.SysEmployeeGroupItemDO;
import org.mapstruct.BeanMapping;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.NullValuePropertyMappingStrategy;
import org.mapstruct.factory.Mappers;


import java.util.List;

/**
 *
 * @author nc
 * @since 2025-09-09
 */
@Mapper(config = BaseMapperConfig.class)
public interface SysEmployeeGroupItemConvert{
   SysEmployeeGroupItemConvert INSTANCE = Mappers.getMapper(SysEmployeeGroupItemConvert.class);

   SysEmployeeGroupItemRespVO dtoToRespVO(SysEmployeeGroupItemDTO dto);

   List<SysEmployeeGroupItemRespVO> dosToRespVOS(List<SysEmployeeGroupItemDO> dos);

   SysEmployeeGroupItemDTO doToDto(SysEmployeeGroupItemDO domain);

   List<SysEmployeeGroupItemDTO> dosToDtos(List<SysEmployeeGroupItemDTO> dos);

   SysEmployeeGroupItemDO saveVoToDO(SysEmployeeGroupItemSaveVO saveVO);

   List<SysEmployeeGroupItemDO> saveVosToDOS(List<SysEmployeeGroupItemSaveVO> saveVOS);

   @BeanMapping(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
   void copySaveParamToDo(SysEmployeeGroupItemSaveVO saveVO, @MappingTarget SysEmployeeGroupItemDO topicDO);

}