package com.elitescloud.cloudt.groupitem;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.system.dto.SysEmployeeGroupItemDTO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemPageParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemParamVO;
import com.elitescloud.cloudt.system.dto.req.SysEmployeeGroupItemSaveVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemPageRespVO;
import com.elitescloud.cloudt.system.dto.resp.SysEmployeeGroupItemRespVO;

import java.util.List;
import java.util.Optional;

/**
 * @author nc
 * @since 2025-09-09
 */
public interface SysEmployeeGroupItemDomainService{

	/**
	 * 分页查询
	 *
	 * @param paramVO
	 * @return
	 */
	PagingVO<SysEmployeeGroupItemPageRespVO> queryList(SysEmployeeGroupItemPageParamVO paramVO);

	/**
	 * 详情查询
	 *
	 * @param id
	 * @return
	 */
	Optional<SysEmployeeGroupItemDTO> findById(Long id);

	/**
	 *
	 * 保存
	 *
	 * @param saveVO 保存值对象
	 * @return 返回保存后的ID
	 */
	Long save(SysEmployeeGroupItemSaveVO saveVO);

	/**
	 * 删除
	 *
	 * @param ids
	 */
	void deleteByIds(List<Long> ids);

	/**
	 * 根据参数查询
	 *
	 * @param paramVO
	 * @return
	 */
	List<SysEmployeeGroupItemRespVO> findByParam(SysEmployeeGroupItemParamVO paramVO);

}
