package com.elitescloud.cloudt.system.common;

import lombok.Getter;

/**
 * @Auther: Mark
 * @Date: 2024/12/17 17:37
 * @Description:
 */
@Getter
public enum ConsumerPipeline {

    /**
     * 消费方式
     */
    CONSOLE("本地控制台"),
    MYSQL("MySQL数据库"),
    ORACLE("Oracle数据库"),
    MONGO("MongoDB"),
    ES("Elasticsearch"),
    ROCKET_MQ("RocketMQ"),
    DISRUPTOR("内存队列"),
    STREAM("SpringCloud Stream"),
    CLOUDT("云梯架构解决方案"),
    ;

    private final String name;

    ConsumerPipeline(String name) {
        this.name = name;
    }

    public String getCode() {
        return name();
    }
}
