package com.elitescloud.cloudt.system.common;

import cn.hutool.core.util.ObjectUtil;
import lombok.Getter;

/**
 * @Auther: Mark
 * @Date: 2024/12/13 16:17
 * @Description:
 */
@Getter
public enum DataType {


    Object("object"),

    Array("array"),

    Any("object"),

    Boolean("boolean"),

    String("string"),

    Date("date"),

    Number("number"),
    ;

    private final String desc;

    public String getCode() {
        return this.name().toLowerCase();
    }

    DataType(String desc) {
        this.desc = desc;
    }

    public static String fromCode(String code) {
        if (ObjectUtil.isNull(code)) return null;
        for (DataType status : DataType.values()) {
            if (status.getCode().equals(code)) {
                return status.getDesc();
            }
        }
        return "";
    }
}
